/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.debug.core;

import java.util.logging.Level;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.debug.core.AtlStackFrame;

public class AtlWatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        AtlStackFrame frame = null;
        if (context instanceof AtlStackFrame) {
            frame = (AtlStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = (AtlStackFrame)((IThread)context).getTopStackFrame();
            }
            catch (DebugException e) {
                ATLLogger.log((Level)Level.INFO, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (frame == null) {
            listener.watchEvaluationFinished(null);
        } else {
            AtlWatchExpressionResult atlwe = this.doEvaluation(frame, expression);
            listener.watchEvaluationFinished((IWatchExpressionResult)atlwe);
        }
    }

    private AtlWatchExpressionResult doEvaluation(AtlStackFrame frame, String expression) {
        DebugException de = null;
        String[] errorMessages = null;
        IValue value = null;
        return new AtlWatchExpressionResult(de, errorMessages, value);
    }

    class AtlWatchExpressionResult
    implements IWatchExpressionResult {
        String[] errorMessages;
        IValue value;
        DebugException de;

        public AtlWatchExpressionResult(DebugException de, String[] errorMessages, IValue value) {
            this.errorMessages = errorMessages;
            this.value = value;
        }

        public IValue getValue() {
            return this.value;
        }

        public boolean hasErrors() {
            return this.errorMessages != null && this.errorMessages.length > 0;
        }

        public String[] getErrorMessages() {
            return this.errorMessages;
        }

        public String getExpressionText() {
            try {
                return this.value.getValueString();
            }
            catch (DebugException e) {
                return null;
            }
        }

        public DebugException getException() {
            return this.de;
        }
    }
}

