/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentImportDataModelProperties;
import org.eclipse.jst.j2ee.internal.archive.ArchiveWrapper;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.jst.jee.archive.internal.ZipFileArchiveLoadAdapterImpl;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public abstract class J2EEArtifactImportDataModelProvider
extends AbstractDataModelProvider
implements IJ2EEComponentImportDataModelProperties,
IDataModelListener {
    private static final String USE_DEFAULT_PROJECT_NAME = "J2EEArtifactImportDataModelProvider.USE_DEFAULT_PROJECT_NAME";
    public static final String FACET_RUNTIME = "IJ2EEArtifactImportDataModelProperties.FACET_RUNTIME";
    private IDataModel componentCreationDM;
    private Throwable archiveOpenFailure = null;
    private boolean settingFileName = false;
    private boolean doingComponentUpdate;

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose");
        propertyNames.add(USE_DEFAULT_PROJECT_NAME);
        propertyNames.add("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
        propertyNames.add("IJ2EEComponentImportDataModelProperties.COMPONENT");
        propertyNames.add(FACET_RUNTIME);
        propertyNames.add("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
        return propertyNames;
    }

    public void init() {
        super.init();
        this.componentCreationDM = this.createJ2EEComponentCreationDataModel();
        this.componentCreationDM.setBooleanProperty("FacetProjectCreationDataModelProvider.FORCE_VERSION_COMPLIANCE", false);
        this.componentCreationDM.addListener((IDataModelListener)this);
        this.model.addNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION", this.componentCreationDM);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(USE_DEFAULT_PROJECT_NAME)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJ2EEComponentImportDataModelProperties.COMPONENT")) {
            String projectName = this.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
            IProject project = ProjectUtilities.getProject((String)projectName);
            return ComponentCore.createComponent((IProject)project);
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER")) {
            if (propertyValue != null) {
                if (!this.settingFileName) {
                    this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", null);
                }
                this.updateDefaultComponentName();
            }
            return true;
        }
        if ("IJ2EEArtifactImportDataModelProperties.FILE_NAME".equals(propertyName)) {
            try {
                this.archiveOpenFailure = null;
                this.handleArchiveSetup((String)propertyValue);
            }
            catch (ArchiveOpenFailureException e) {
                this.archiveOpenFailure = e;
            }
        } else {
            if ("IJ2EEComponentImportDataModelProperties.COMPONENT".equals(propertyName)) {
                throw new RuntimeException(String.valueOf(propertyName) + " should not be set.");
            }
            if ("IJ2EEComponentImportDataModelProperties.PROJECT_NAME".equals(propertyName)) {
                ArrayList nestedModels = new ArrayList(this.model.getNestedModels());
                IDataModel nestedModel = null;
                int i = 0;
                while (i < nestedModels.size()) {
                    nestedModel = (IDataModel)nestedModels.get(i);
                    try {
                        nestedModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
                        IFacetedProjectWorkingCopy fpwc = (IFacetedProjectWorkingCopy)nestedModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
                        fpwc.setProjectName((String)propertyValue);
                    }
                    catch (Exception e) {
                        J2EEPlugin.logError(e);
                    }
                    ++i;
                }
            } else if (FACET_RUNTIME.equals(propertyName)) {
                throw new RuntimeException(String.valueOf(propertyName) + " should not be set.");
            }
        }
        return true;
    }

    private void updateDefaultComponentName() {
        ArchiveWrapper wrapper = this.getArchiveWrapper();
        if (wrapper != null && this.getBooleanProperty(USE_DEFAULT_PROJECT_NAME)) {
            try {
                this.doingComponentUpdate = true;
                IPath path = wrapper.getPath();
                String defaultProjectName = path.segment(path.segmentCount() - 1);
                if (defaultProjectName.indexOf(46) > 0) {
                    defaultProjectName = defaultProjectName.substring(0, defaultProjectName.lastIndexOf(46));
                }
                this.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", defaultProjectName);
            }
            finally {
                this.doingComponentUpdate = false;
            }
        }
    }

    private boolean handleArchiveSetup(String fileName) throws ArchiveOpenFailureException {
        try {
            this.settingFileName = true;
            ArchiveWrapper wrapper = this.getArchiveWrapper();
            if (wrapper != null) {
                wrapper.close();
                this.setProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER", null);
            }
            String uri = this.getStringProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
            if (!this.archiveExistsOnFile()) {
                return false;
            }
            wrapper = this.openArchiveWrapper(uri);
            if (wrapper != null) {
                this.setProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER", wrapper);
            }
            boolean bl = wrapper != null;
            return bl;
        }
        finally {
            this.settingFileName = false;
        }
    }

    protected ArchiveOptions getArchiveOptions(IPath archivePath) throws ArchiveOpenFailureException {
        ZipFile zipFile;
        File file = new File(archivePath.toOSString());
        try {
            zipFile = ArchiveUtil.newZipFile((File)file);
        }
        catch (ZipException e) {
            ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException((Throwable)e);
            throw openFailureException;
        }
        catch (IOException e) {
            ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException((Throwable)e);
            throw openFailureException;
        }
        ZipFileArchiveLoadAdapterImpl loadAdapter = new ZipFileArchiveLoadAdapterImpl(zipFile);
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setOption((Object)"LOAD_ADAPTER", (Object)loadAdapter);
        archiveOptions.setOption((Object)"ARCHIVE_PATH", (Object)archivePath);
        archiveOptions.setOption((Object)"DISCRIMINATE_EJB_ANNOTATIONS", (Object)Boolean.TRUE);
        return archiveOptions;
    }

    protected ArchiveWrapper openArchiveWrapper(String uri) throws ArchiveOpenFailureException {
        IArchive archive = null;
        Path path = new Path(uri);
        ArchiveOptions archiveOptions = this.getArchiveOptions((IPath)path);
        archive = JavaEEArchiveUtilities.INSTANCE.openArchive(archiveOptions);
        archive.setPath((IPath)path);
        JavaEEQuickPeek jqp = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archive);
        if (jqp.getJavaEEVersion() == -1 && jqp.getType() == -1) {
            this.handleUnknownType(jqp);
        }
        return new ArchiveWrapper(archive);
    }

    protected void handleUnknownType(JavaEEQuickPeek jqp) {
    }

    private boolean closeArchive() {
        if (this.getArchiveWrapper() != null) {
            this.getArchiveWrapper().close();
        }
        return true;
    }

    public IStatus validate(String propertyName) {
        if ("IJ2EEArtifactImportDataModelProperties.FILE_NAME".equals(propertyName) && !this.isPropertySet("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER")) {
            String fileName = this.getStringProperty(propertyName);
            if (fileName == null || fileName.length() == 0) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"5", (Object[])new Object[]{org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil.getModuleFileTypeName((int)this.getType())}));
            }
            if (this.archiveOpenFailure != null) {
                return WTPCommonPlugin.createErrorStatus((String)this.archiveOpenFailure.getMessage());
            }
            if (!this.archiveExistsOnFile()) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"6", (Object[])new Object[]{org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil.getModuleFileTypeName((int)this.getType())}));
            }
        } else {
            if ("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION".equals(propertyName)) {
                return this.getDataModel().getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION").validate(true);
            }
            if (FACET_RUNTIME.equals(propertyName)) {
                return this.validateVersionSupportedByServer();
            }
        }
        return OK_STATUS;
    }

    protected int getJ2EEVersion() {
        return 0;
    }

    protected abstract IDataModel createJ2EEComponentCreationDataModel();

    protected abstract int getType();

    private boolean archiveExistsOnFile() {
        String jarName = (String)this.getProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        if (jarName != null && jarName.length() > 0) {
            File file = new File(jarName);
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    public void dispose() {
        if (this.getBooleanProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose")) {
            this.closeArchive();
        }
        super.dispose();
    }

    protected final ArchiveWrapper getArchiveWrapper() {
        return (ArchiveWrapper)this.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        return super.getValidPropertyDescriptors(propertyName);
    }

    public void propertyChanged(DataModelEvent event) {
        if (!this.doingComponentUpdate && event.getDataModel() == this.componentCreationDM && event.getPropertyName().equals("IJ2EEComponentImportDataModelProperties.PROJECT_NAME") && this.getBooleanProperty(USE_DEFAULT_PROJECT_NAME)) {
            this.setBooleanProperty(USE_DEFAULT_PROJECT_NAME, false);
        }
        if (event.getDataModel() == this.componentCreationDM && event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            this.model.notifyPropertyChange(FACET_RUNTIME, 2);
            if (this.isPropertySet("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER")) {
                this.refreshInterpretedSpecVersion();
            }
        }
    }

    protected void refreshInterpretedSpecVersion() {
    }

    protected void updateJavaFacetVersion() {
        IProjectFacetVersion javaFacetVersion = null;
        IRuntime runtime = (IRuntime)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        if (runtime != null) {
            javaFacetVersion = runtime.supports(JavaFacet.VERSION_11) ? JavaFacet.VERSION_11 : (runtime.supports(JavaFacet.VERSION_1_8) ? JavaFacet.VERSION_1_8 : (runtime.supports(JavaFacet.VERSION_1_7) ? JavaFacet.VERSION_1_7 : (runtime.supports(JavaFacet.VERSION_1_6) ? JavaFacet.VERSION_1_6 : (runtime.supports(JavaFacet.VERSION_1_5) ? JavaFacet.VERSION_1_5 : JavaFacet.VERSION_1_4))));
        } else {
            JavaEEQuickPeek jqp = this.getInterpretedSpecVersion(this.getArchiveWrapper());
            int javaEEVersion = jqp.getJavaEEVersion();
            switch (javaEEVersion) {
                case 12: 
                case 13: 
                case 14: {
                    javaFacetVersion = JavaFacet.VERSION_1_4;
                    break;
                }
                case 50: {
                    javaFacetVersion = JavaFacet.VERSION_1_5;
                    break;
                }
                case 60: {
                    javaFacetVersion = JavaFacet.VERSION_1_6;
                    break;
                }
                case 70: {
                    javaFacetVersion = JavaFacet.VERSION_1_7;
                    break;
                }
                case 80: {
                    javaFacetVersion = JavaFacet.VERSION_1_8;
                    break;
                }
                case 90: {
                    javaFacetVersion = JavaFacet.VERSION_1_8;
                    break;
                }
                case 100: {
                    javaFacetVersion = JavaFacet.VERSION_11;
                }
            }
        }
        if (javaFacetVersion != null) {
            IDataModel moduleDM = this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)moduleDM.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel javaFacetDataModel = map.getFacetDataModel("jst.java");
            javaFacetDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)javaFacetVersion);
            this.updateWorkingCopyFacetVersion(moduleDM, javaFacetDataModel);
        }
    }

    protected void updateWorkingCopyFacetVersion(IDataModel moduleDM, IDataModel facetDM) {
        IProjectFacetVersion facetVersion = (IProjectFacetVersion)facetDM.getProperty("IFacetDataModelPropeties.FACET_VERSION");
        IFacetedProjectWorkingCopy fpwc = (IFacetedProjectWorkingCopy)moduleDM.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        fpwc.changeProjectFacetVersion(facetVersion);
    }

    protected IStatus validateVersionSupportedByServer() {
        if (this.model.isPropertySet("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER") && this.model.isPropertySet("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            IDataModel projectModel = this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)projectModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            Collection projectFacets = (Collection)this.getProperty("FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION");
            IRuntime runtime = (IRuntime)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (runtime != null) {
                Iterator iterator = projectFacets.iterator();
                while (iterator.hasNext()) {
                    IDataModel facetDataModel = map.getFacetDataModel(((IProjectFacet)iterator.next()).getId());
                    IProjectFacetVersion facetVersion = (IProjectFacetVersion)facetDataModel.getProperty("IFacetDataModelPropeties.FACET_VERSION");
                    if (facetVersion.getProjectFacet().equals(JavaFacet.FACET)) {
                        Set<IProjectFacet> set = Collections.singleton(facetVersion.getProjectFacet());
                        try {
                            Set correctSet = runtime.getDefaultFacets(set);
                            IProjectFacetVersion correctVersion = null;
                            Iterator correctVersions = correctSet.iterator();
                            while (correctVersions.hasNext() && correctVersion == null) {
                                IProjectFacetVersion version = (IProjectFacetVersion)correctVersions.next();
                                if (!version.getProjectFacet().equals(JavaFacet.FACET)) continue;
                                correctVersion = version;
                            }
                            if (correctVersion != null && !facetVersion.equals(correctVersion)) {
                                facetDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", correctVersion);
                                facetVersion = correctVersion;
                            }
                        }
                        catch (CoreException e) {
                            J2EEPlugin.logError(e);
                        }
                    }
                    if (runtime.supports(facetVersion)) continue;
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.VERSION_NOT_SUPPORTED);
                }
            }
        }
        return OK_STATUS;
    }

    protected JavaEEQuickPeek getInterpretedSpecVersion(ArchiveWrapper wrapper) {
        JavaEEQuickPeek jqp = wrapper.getJavaEEQuickPeek();
        IArchive archive = wrapper.getIArchive();
        if (!archive.isOpen()) {
            return jqp;
        }
        int archiveType = jqp.getType();
        String ddURI = null;
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] highestJQPVersion = nArray;
        IProjectFacetVersion[] highestProjectFacetVersion = new IProjectFacetVersion[highestJQPVersion.length];
        switch (archiveType) {
            case 1: {
                ddURI = "META-INF/application.xml";
                highestProjectFacetVersion[0] = IJ2EEFacetConstants.ENTERPRISE_APPLICATION_60;
                highestProjectFacetVersion[1] = IJ2EEFacetConstants.ENTERPRISE_APPLICATION_50;
                highestProjectFacetVersion[2] = IJ2EEFacetConstants.ENTERPRISE_APPLICATION_70;
                highestProjectFacetVersion[3] = IJ2EEFacetConstants.ENTERPRISE_APPLICATION_80;
                highestProjectFacetVersion[4] = IJ2EEFacetConstants.ENTERPRISE_APPLICATION_90;
                highestProjectFacetVersion[5] = IJ2EEFacetConstants.ENTERPRISE_APPLICATION_100;
                highestJQPVersion[0] = 60;
                highestJQPVersion[1] = 50;
                highestJQPVersion[2] = 70;
                highestJQPVersion[3] = 80;
                highestJQPVersion[4] = 90;
                highestJQPVersion[5] = 100;
                break;
            }
            case 3: {
                ddURI = "META-INF/application-client.xml";
                highestProjectFacetVersion[0] = IJ2EEFacetConstants.APPLICATION_CLIENT_60;
                highestProjectFacetVersion[1] = IJ2EEFacetConstants.APPLICATION_CLIENT_50;
                highestProjectFacetVersion[2] = IJ2EEFacetConstants.APPLICATION_CLIENT_70;
                highestProjectFacetVersion[3] = IJ2EEFacetConstants.APPLICATION_CLIENT_80;
                highestProjectFacetVersion[4] = IJ2EEFacetConstants.APPLICATION_CLIENT_90;
                highestProjectFacetVersion[5] = IJ2EEFacetConstants.APPLICATION_CLIENT_100;
                highestJQPVersion[0] = 60;
                highestJQPVersion[1] = 50;
                highestJQPVersion[2] = 70;
                highestJQPVersion[3] = 80;
                highestJQPVersion[4] = 90;
                highestJQPVersion[5] = 100;
                break;
            }
            case 0: {
                ddURI = "META-INF/ejb-jar.xml";
                highestProjectFacetVersion[0] = IJ2EEFacetConstants.EJB_31;
                highestProjectFacetVersion[1] = IJ2EEFacetConstants.EJB_30;
                highestProjectFacetVersion[2] = IJ2EEFacetConstants.EJB_32;
                highestProjectFacetVersion[3] = IJ2EEFacetConstants.EJB_32;
                highestProjectFacetVersion[4] = IJ2EEFacetConstants.EJB_32;
                highestProjectFacetVersion[5] = IJ2EEFacetConstants.EJB_40;
                highestJQPVersion[0] = 31;
                highestJQPVersion[1] = 30;
                highestJQPVersion[2] = 32;
                highestJQPVersion[3] = 32;
                highestJQPVersion[4] = 32;
                highestJQPVersion[5] = 40;
                break;
            }
            case 4: {
                ddURI = "WEB-INF/web.xml";
                highestProjectFacetVersion[0] = IJ2EEFacetConstants.DYNAMIC_WEB_30;
                highestProjectFacetVersion[1] = IJ2EEFacetConstants.DYNAMIC_WEB_25;
                highestProjectFacetVersion[2] = IJ2EEFacetConstants.DYNAMIC_WEB_31;
                highestProjectFacetVersion[3] = IJ2EEFacetConstants.DYNAMIC_WEB_40;
                highestProjectFacetVersion[4] = IJ2EEFacetConstants.DYNAMIC_WEB_50;
                highestProjectFacetVersion[5] = IJ2EEFacetConstants.DYNAMIC_WEB_60;
                highestJQPVersion[1] = 25;
                highestJQPVersion[0] = 30;
                highestJQPVersion[2] = 31;
                highestJQPVersion[3] = 40;
                highestJQPVersion[4] = 50;
                highestJQPVersion[5] = 60;
                break;
            }
            case 2: {
                ddURI = "META-INF/ra.xml";
                highestProjectFacetVersion[1] = IJ2EEFacetConstants.JCA_15;
                highestProjectFacetVersion[0] = IJ2EEFacetConstants.JCA_16;
                highestProjectFacetVersion[2] = IJ2EEFacetConstants.JCA_17;
                highestProjectFacetVersion[3] = IJ2EEFacetConstants.JCA_17;
                highestProjectFacetVersion[4] = IJ2EEFacetConstants.JCA_17;
                highestProjectFacetVersion[5] = IJ2EEFacetConstants.JCA_21;
                highestJQPVersion[1] = 15;
                highestJQPVersion[0] = 16;
                highestJQPVersion[2] = 17;
                highestJQPVersion[3] = 17;
                highestJQPVersion[4] = 17;
                highestJQPVersion[5] = 21;
                break;
            }
            default: {
                return jqp;
            }
        }
        Path ddPath = new Path(ddURI);
        if (archive.containsArchiveResource((IPath)ddPath)) {
            return jqp;
        }
        IRuntime runtime = (IRuntime)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        if (archiveType == 2 || runtime == null || runtime.supports(highestProjectFacetVersion[3])) {
            return new JavaEEQuickPeek(jqp.getType(), highestJQPVersion[3]);
        }
        if (runtime.supports(highestProjectFacetVersion[5])) {
            return new JavaEEQuickPeek(jqp.getType(), highestJQPVersion[5]);
        }
        if (runtime.supports(highestProjectFacetVersion[4])) {
            return new JavaEEQuickPeek(jqp.getType(), highestJQPVersion[4]);
        }
        if (runtime.supports(highestProjectFacetVersion[3])) {
            return new JavaEEQuickPeek(jqp.getType(), highestJQPVersion[3]);
        }
        if (runtime.supports(highestProjectFacetVersion[2])) {
            return new JavaEEQuickPeek(jqp.getType(), highestJQPVersion[2]);
        }
        if (runtime.supports(highestProjectFacetVersion[0])) {
            return new JavaEEQuickPeek(jqp.getType(), highestJQPVersion[0]);
        }
        if (runtime.supports(highestProjectFacetVersion[1])) {
            return new JavaEEQuickPeek(jqp.getType(), highestJQPVersion[1]);
        }
        return jqp;
    }
}

