/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class OverrideValidator
implements JpaValidator {
    protected final PersistentAttribute persistentAttribute;
    protected final Override_ override;
    protected final OverrideContainer container;
    protected final OverrideDescriptionProvider overrideDescriptionProvider;

    protected OverrideValidator(Override_ override, OverrideContainer container, OverrideDescriptionProvider overrideDescriptionProvider) {
        this(null, override, container, overrideDescriptionProvider);
    }

    protected OverrideValidator(PersistentAttribute persistentAttribute, Override_ override, OverrideContainer container, OverrideDescriptionProvider overrideDescriptionProvider) {
        this.persistentAttribute = persistentAttribute;
        this.override = override;
        this.container = container;
        this.overrideDescriptionProvider = overrideDescriptionProvider;
    }

    protected String getOverrideDescriptionMessage() {
        return this.overrideDescriptionProvider.getOverrideDescriptionMessage();
    }

    @Override
    public boolean validate(List<IMessage> messages, IReporter reporter) {
        if (this.validateType(messages)) {
            return this.validateName(messages);
        }
        return false;
    }

    protected boolean validateType(List<IMessage> messages) {
        if (this.container.getOverridableTypeMapping() == null) {
            messages.add(this.buildUnresolvedOverrideTypeMessage());
            return false;
        }
        return true;
    }

    protected IMessage buildUnresolvedOverrideTypeMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)this.override.getResource(), (TextRange)this.override.getNameTextRange(), (ValidationMessage)this.getUnresolvedOverrideTypeMessage(), (Object[])new Object[]{this.override.getName()});
    }

    protected ValidationMessage getUnresolvedOverrideTypeMessage() {
        return this.override.isVirtual() ? JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_OVERRIDE_INVALID_TYPE : JptJpaCoreValidationMessages.ATTRIBUTE_OVERRIDE_INVALID_TYPE;
    }

    protected boolean validateName(List<IMessage> messages) {
        if (!IterableTools.contains(this.container.getAllOverridableNames(), (Object)this.override.getName())) {
            messages.add(this.buildUnresolvedNameMessage());
            return false;
        }
        return true;
    }

    protected IMessage buildUnresolvedNameMessage() {
        if (this.override.isVirtual()) {
            return this.buildVirtualUnresolvedNameMessage();
        }
        if (this.overrideIsPartOfVirtualAttribute()) {
            return this.buildVirtualAttributeUnresolvedNameMessage();
        }
        return this.buildUnresolvedNameMessage(this.getUnresolvedNameMessage());
    }

    protected IMessage buildVirtualUnresolvedNameMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)this.override.getResource(), (TextRange)this.override.getNameTextRange(), (ValidationMessage)this.getVirtualOverrideUnresolvedNameMessage(), (Object[])new Object[]{this.override.getName(), this.getOverrideDescriptionMessage(), this.container.getOverridableTypeMapping().getName()});
    }

    protected abstract ValidationMessage getVirtualOverrideUnresolvedNameMessage();

    protected IMessage buildUnresolvedNameMessage(ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)this.override.getResource(), (TextRange)this.override.getNameTextRange(), (ValidationMessage)message, (Object[])new Object[]{this.override.getName(), this.getOverrideDescriptionMessage(), this.container.getOverridableTypeMapping().getName()});
    }

    protected abstract ValidationMessage getUnresolvedNameMessage();

    protected IMessage buildVirtualAttributeUnresolvedNameMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)this.override.getResource(), (TextRange)this.persistentAttribute.getValidationTextRange(), (ValidationMessage)this.getVirtualAttributeUnresolvedNameMessage(), (Object[])new Object[]{this.persistentAttribute.getName(), this.override.getName(), this.getOverrideDescriptionMessage(), this.container.getOverridableTypeMapping().getName()});
    }

    protected abstract ValidationMessage getVirtualAttributeUnresolvedNameMessage();

    protected boolean overrideIsPartOfVirtualAttribute() {
        return this.persistentAttribute != null && this.persistentAttribute.isVirtual();
    }

    public static interface OverrideDescriptionProvider {
        public String getOverrideDescriptionMessage();
    }
}

