package org.eclipse.gef.dot.internal.ide.language.contentassist.antlr.internal;
import java.util.Map;
import java.util.HashMap;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.gef.dot.internal.language.services.DotGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
@SuppressWarnings("all")
public class InternalDotParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "Subgraph", "Digraph", "Strict", "Graph", "Edge", "Node", "HyphenMinusHyphenMinus", "HyphenMinusGreaterThanSign", "Comma", "Colon", "Semicolon", "EqualsSign", "LeftSquareBracket", "RightSquareBracket", "LeftCurlyBracket", "RightCurlyBracket", "RULE_NUMERAL", "RULE_COMPASS_PT", "RULE_STRING", "RULE_QUOTED_STRING", "RULE_HTML_TAG_OPEN", "RULE_HTML_TAG_CLOSE", "RULE_HTML_CHARS", "RULE_HTML_STRING", "RULE_ML_COMMENT", "RULE_SL_COMMENT", "RULE_WS", "RULE_ANY_OTHER"
    };
    public static final int HyphenMinusHyphenMinus=10;
    public static final int Node=9;
    public static final int RULE_STRING=22;
    public static final int RULE_NUMERAL=20;
    public static final int RULE_SL_COMMENT=29;
    public static final int Comma=12;
    public static final int EqualsSign=15;
    public static final int RULE_QUOTED_STRING=23;
    public static final int Strict=6;
    public static final int Colon=13;
    public static final int RightCurlyBracket=19;
    public static final int EOF=-1;
    public static final int RightSquareBracket=17;
    public static final int RULE_HTML_TAG_OPEN=24;
    public static final int RULE_WS=30;
    public static final int LeftCurlyBracket=18;
    public static final int RULE_ANY_OTHER=31;
    public static final int RULE_COMPASS_PT=21;
    public static final int RULE_HTML_TAG_CLOSE=25;
    public static final int Semicolon=14;
    public static final int Graph=7;
    public static final int Subgraph=4;
    public static final int RULE_HTML_STRING=27;
    public static final int RULE_ML_COMMENT=28;
    public static final int LeftSquareBracket=16;
    public static final int Digraph=5;
    public static final int HyphenMinusGreaterThanSign=11;
    public static final int RULE_HTML_CHARS=26;
    public static final int Edge=8;

    // delegates
    // delegators


        public InternalDotParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalDotParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalDotParser.tokenNames; }
    public String getGrammarFileName() { return "InternalDotParser.g"; }


    	private DotGrammarAccess grammarAccess;
    	private final Map<String, String> tokenNameToValue = new HashMap<String, String>();
    	
    	{
    		tokenNameToValue.put("Comma", "','");
    		tokenNameToValue.put("Colon", "':'");
    		tokenNameToValue.put("Semicolon", "';'");
    		tokenNameToValue.put("EqualsSign", "'='");
    		tokenNameToValue.put("LeftSquareBracket", "'['");
    		tokenNameToValue.put("RightSquareBracket", "']'");
    		tokenNameToValue.put("LeftCurlyBracket", "'{'");
    		tokenNameToValue.put("RightCurlyBracket", "'}'");
    		tokenNameToValue.put("HyphenMinusHyphenMinus", "'--'");
    		tokenNameToValue.put("HyphenMinusGreaterThanSign", "'->'");
    		tokenNameToValue.put("Edge", "'edge'");
    		tokenNameToValue.put("Node", "'node'");
    		tokenNameToValue.put("Graph", "'graph'");
    		tokenNameToValue.put("Strict", "'strict'");
    		tokenNameToValue.put("Digraph", "'digraph'");
    		tokenNameToValue.put("Subgraph", "'subgraph'");
    	}

    	public void setGrammarAccess(DotGrammarAccess grammarAccess) {
    		this.grammarAccess = grammarAccess;
    	}

    	@Override
    	protected Grammar getGrammar() {
    		return grammarAccess.getGrammar();
    	}

    	@Override
    	protected String getValueForTokenName(String tokenName) {
    		String result = tokenNameToValue.get(tokenName);
    		if (result == null)
    			result = tokenName;
    		return result;
    	}



    // $ANTLR start "entryRuleDotAst"
    // InternalDotParser.g:72:1: entryRuleDotAst : ruleDotAst EOF ;
    public final void entryRuleDotAst() throws RecognitionException {
        try {
            // InternalDotParser.g:73:1: ( ruleDotAst EOF )
            // InternalDotParser.g:74:1: ruleDotAst EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotAstRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleDotAst();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotAstRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleDotAst"


    // $ANTLR start "ruleDotAst"
    // InternalDotParser.g:81:1: ruleDotAst : ( ( rule__DotAst__GraphsAssignment )* ) ;
    public final void ruleDotAst() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:85:2: ( ( ( rule__DotAst__GraphsAssignment )* ) )
            // InternalDotParser.g:86:2: ( ( rule__DotAst__GraphsAssignment )* )
            {
            // InternalDotParser.g:86:2: ( ( rule__DotAst__GraphsAssignment )* )
            // InternalDotParser.g:87:3: ( rule__DotAst__GraphsAssignment )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotAstAccess().getGraphsAssignment()); 
            }
            // InternalDotParser.g:88:3: ( rule__DotAst__GraphsAssignment )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( ((LA1_0>=Digraph && LA1_0<=Graph)) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // InternalDotParser.g:88:4: rule__DotAst__GraphsAssignment
            	    {
            	    pushFollow(FOLLOW_3);
            	    rule__DotAst__GraphsAssignment();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotAstAccess().getGraphsAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleDotAst"


    // $ANTLR start "entryRuleDotGraph"
    // InternalDotParser.g:97:1: entryRuleDotGraph : ruleDotGraph EOF ;
    public final void entryRuleDotGraph() throws RecognitionException {
        try {
            // InternalDotParser.g:98:1: ( ruleDotGraph EOF )
            // InternalDotParser.g:99:1: ruleDotGraph EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleDotGraph();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleDotGraph"


    // $ANTLR start "ruleDotGraph"
    // InternalDotParser.g:106:1: ruleDotGraph : ( ( rule__DotGraph__Group__0 ) ) ;
    public final void ruleDotGraph() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:110:2: ( ( ( rule__DotGraph__Group__0 ) ) )
            // InternalDotParser.g:111:2: ( ( rule__DotGraph__Group__0 ) )
            {
            // InternalDotParser.g:111:2: ( ( rule__DotGraph__Group__0 ) )
            // InternalDotParser.g:112:3: ( rule__DotGraph__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getGroup()); 
            }
            // InternalDotParser.g:113:3: ( rule__DotGraph__Group__0 )
            // InternalDotParser.g:113:4: rule__DotGraph__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__DotGraph__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleDotGraph"


    // $ANTLR start "entryRuleStmt"
    // InternalDotParser.g:122:1: entryRuleStmt : ruleStmt EOF ;
    public final void entryRuleStmt() throws RecognitionException {
        try {
            // InternalDotParser.g:123:1: ( ruleStmt EOF )
            // InternalDotParser.g:124:1: ruleStmt EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStmtRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleStmt();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getStmtRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleStmt"


    // $ANTLR start "ruleStmt"
    // InternalDotParser.g:131:1: ruleStmt : ( ( rule__Stmt__Group__0 ) ) ;
    public final void ruleStmt() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:135:2: ( ( ( rule__Stmt__Group__0 ) ) )
            // InternalDotParser.g:136:2: ( ( rule__Stmt__Group__0 ) )
            {
            // InternalDotParser.g:136:2: ( ( rule__Stmt__Group__0 ) )
            // InternalDotParser.g:137:3: ( rule__Stmt__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStmtAccess().getGroup()); 
            }
            // InternalDotParser.g:138:3: ( rule__Stmt__Group__0 )
            // InternalDotParser.g:138:4: rule__Stmt__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Stmt__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getStmtAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleStmt"


    // $ANTLR start "entryRuleEdgeStmtNode"
    // InternalDotParser.g:147:1: entryRuleEdgeStmtNode : ruleEdgeStmtNode EOF ;
    public final void entryRuleEdgeStmtNode() throws RecognitionException {
        try {
            // InternalDotParser.g:148:1: ( ruleEdgeStmtNode EOF )
            // InternalDotParser.g:149:1: ruleEdgeStmtNode EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeStmtNodeRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleEdgeStmtNode();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeStmtNodeRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleEdgeStmtNode"


    // $ANTLR start "ruleEdgeStmtNode"
    // InternalDotParser.g:156:1: ruleEdgeStmtNode : ( ( rule__EdgeStmtNode__Group__0 ) ) ;
    public final void ruleEdgeStmtNode() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:160:2: ( ( ( rule__EdgeStmtNode__Group__0 ) ) )
            // InternalDotParser.g:161:2: ( ( rule__EdgeStmtNode__Group__0 ) )
            {
            // InternalDotParser.g:161:2: ( ( rule__EdgeStmtNode__Group__0 ) )
            // InternalDotParser.g:162:3: ( rule__EdgeStmtNode__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeStmtNodeAccess().getGroup()); 
            }
            // InternalDotParser.g:163:3: ( rule__EdgeStmtNode__Group__0 )
            // InternalDotParser.g:163:4: rule__EdgeStmtNode__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__EdgeStmtNode__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeStmtNodeAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleEdgeStmtNode"


    // $ANTLR start "entryRuleNodeStmt"
    // InternalDotParser.g:172:1: entryRuleNodeStmt : ruleNodeStmt EOF ;
    public final void entryRuleNodeStmt() throws RecognitionException {
        try {
            // InternalDotParser.g:173:1: ( ruleNodeStmt EOF )
            // InternalDotParser.g:174:1: ruleNodeStmt EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeStmtRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleNodeStmt();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeStmtRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleNodeStmt"


    // $ANTLR start "ruleNodeStmt"
    // InternalDotParser.g:181:1: ruleNodeStmt : ( ( rule__NodeStmt__Group__0 ) ) ;
    public final void ruleNodeStmt() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:185:2: ( ( ( rule__NodeStmt__Group__0 ) ) )
            // InternalDotParser.g:186:2: ( ( rule__NodeStmt__Group__0 ) )
            {
            // InternalDotParser.g:186:2: ( ( rule__NodeStmt__Group__0 ) )
            // InternalDotParser.g:187:3: ( rule__NodeStmt__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeStmtAccess().getGroup()); 
            }
            // InternalDotParser.g:188:3: ( rule__NodeStmt__Group__0 )
            // InternalDotParser.g:188:4: rule__NodeStmt__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__NodeStmt__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeStmtAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleNodeStmt"


    // $ANTLR start "entryRuleAttrStmt"
    // InternalDotParser.g:197:1: entryRuleAttrStmt : ruleAttrStmt EOF ;
    public final void entryRuleAttrStmt() throws RecognitionException {
        try {
            // InternalDotParser.g:198:1: ( ruleAttrStmt EOF )
            // InternalDotParser.g:199:1: ruleAttrStmt EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrStmtRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAttrStmt();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrStmtRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleAttrStmt"


    // $ANTLR start "ruleAttrStmt"
    // InternalDotParser.g:206:1: ruleAttrStmt : ( ( rule__AttrStmt__Group__0 ) ) ;
    public final void ruleAttrStmt() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:210:2: ( ( ( rule__AttrStmt__Group__0 ) ) )
            // InternalDotParser.g:211:2: ( ( rule__AttrStmt__Group__0 ) )
            {
            // InternalDotParser.g:211:2: ( ( rule__AttrStmt__Group__0 ) )
            // InternalDotParser.g:212:3: ( rule__AttrStmt__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrStmtAccess().getGroup()); 
            }
            // InternalDotParser.g:213:3: ( rule__AttrStmt__Group__0 )
            // InternalDotParser.g:213:4: rule__AttrStmt__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__AttrStmt__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrStmtAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleAttrStmt"


    // $ANTLR start "entryRuleAttrList"
    // InternalDotParser.g:222:1: entryRuleAttrList : ruleAttrList EOF ;
    public final void entryRuleAttrList() throws RecognitionException {
        try {
            // InternalDotParser.g:223:1: ( ruleAttrList EOF )
            // InternalDotParser.g:224:1: ruleAttrList EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrListRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAttrList();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrListRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleAttrList"


    // $ANTLR start "ruleAttrList"
    // InternalDotParser.g:231:1: ruleAttrList : ( ( rule__AttrList__Group__0 ) ) ;
    public final void ruleAttrList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:235:2: ( ( ( rule__AttrList__Group__0 ) ) )
            // InternalDotParser.g:236:2: ( ( rule__AttrList__Group__0 ) )
            {
            // InternalDotParser.g:236:2: ( ( rule__AttrList__Group__0 ) )
            // InternalDotParser.g:237:3: ( rule__AttrList__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrListAccess().getGroup()); 
            }
            // InternalDotParser.g:238:3: ( rule__AttrList__Group__0 )
            // InternalDotParser.g:238:4: rule__AttrList__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__AttrList__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrListAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleAttrList"


    // $ANTLR start "entryRuleAttribute"
    // InternalDotParser.g:247:1: entryRuleAttribute : ruleAttribute EOF ;
    public final void entryRuleAttribute() throws RecognitionException {
        try {
            // InternalDotParser.g:248:1: ( ruleAttribute EOF )
            // InternalDotParser.g:249:1: ruleAttribute EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttributeRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAttribute();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttributeRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleAttribute"


    // $ANTLR start "ruleAttribute"
    // InternalDotParser.g:256:1: ruleAttribute : ( ( rule__Attribute__Group__0 ) ) ;
    public final void ruleAttribute() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:260:2: ( ( ( rule__Attribute__Group__0 ) ) )
            // InternalDotParser.g:261:2: ( ( rule__Attribute__Group__0 ) )
            {
            // InternalDotParser.g:261:2: ( ( rule__Attribute__Group__0 ) )
            // InternalDotParser.g:262:3: ( rule__Attribute__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttributeAccess().getGroup()); 
            }
            // InternalDotParser.g:263:3: ( rule__Attribute__Group__0 )
            // InternalDotParser.g:263:4: rule__Attribute__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Attribute__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttributeAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleAttribute"


    // $ANTLR start "entryRuleSubgraphOrEdgeStmtSubgraph"
    // InternalDotParser.g:272:1: entryRuleSubgraphOrEdgeStmtSubgraph : ruleSubgraphOrEdgeStmtSubgraph EOF ;
    public final void entryRuleSubgraphOrEdgeStmtSubgraph() throws RecognitionException {
        try {
            // InternalDotParser.g:273:1: ( ruleSubgraphOrEdgeStmtSubgraph EOF )
            // InternalDotParser.g:274:1: ruleSubgraphOrEdgeStmtSubgraph EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleSubgraphOrEdgeStmtSubgraph();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleSubgraphOrEdgeStmtSubgraph"


    // $ANTLR start "ruleSubgraphOrEdgeStmtSubgraph"
    // InternalDotParser.g:281:1: ruleSubgraphOrEdgeStmtSubgraph : ( ( rule__SubgraphOrEdgeStmtSubgraph__Group__0 ) ) ;
    public final void ruleSubgraphOrEdgeStmtSubgraph() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:285:2: ( ( ( rule__SubgraphOrEdgeStmtSubgraph__Group__0 ) ) )
            // InternalDotParser.g:286:2: ( ( rule__SubgraphOrEdgeStmtSubgraph__Group__0 ) )
            {
            // InternalDotParser.g:286:2: ( ( rule__SubgraphOrEdgeStmtSubgraph__Group__0 ) )
            // InternalDotParser.g:287:3: ( rule__SubgraphOrEdgeStmtSubgraph__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getGroup()); 
            }
            // InternalDotParser.g:288:3: ( rule__SubgraphOrEdgeStmtSubgraph__Group__0 )
            // InternalDotParser.g:288:4: rule__SubgraphOrEdgeStmtSubgraph__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__SubgraphOrEdgeStmtSubgraph__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleSubgraphOrEdgeStmtSubgraph"


    // $ANTLR start "entryRuleSubgraph"
    // InternalDotParser.g:297:1: entryRuleSubgraph : ruleSubgraph EOF ;
    public final void entryRuleSubgraph() throws RecognitionException {
        try {
            // InternalDotParser.g:298:1: ( ruleSubgraph EOF )
            // InternalDotParser.g:299:1: ruleSubgraph EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleSubgraph();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleSubgraph"


    // $ANTLR start "ruleSubgraph"
    // InternalDotParser.g:306:1: ruleSubgraph : ( ( rule__Subgraph__Group__0 ) ) ;
    public final void ruleSubgraph() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:310:2: ( ( ( rule__Subgraph__Group__0 ) ) )
            // InternalDotParser.g:311:2: ( ( rule__Subgraph__Group__0 ) )
            {
            // InternalDotParser.g:311:2: ( ( rule__Subgraph__Group__0 ) )
            // InternalDotParser.g:312:3: ( rule__Subgraph__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getGroup()); 
            }
            // InternalDotParser.g:313:3: ( rule__Subgraph__Group__0 )
            // InternalDotParser.g:313:4: rule__Subgraph__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Subgraph__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleSubgraph"


    // $ANTLR start "entryRulePort"
    // InternalDotParser.g:322:1: entryRulePort : rulePort EOF ;
    public final void entryRulePort() throws RecognitionException {
        try {
            // InternalDotParser.g:323:1: ( rulePort EOF )
            // InternalDotParser.g:324:1: rulePort EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePort();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRulePort"


    // $ANTLR start "rulePort"
    // InternalDotParser.g:331:1: rulePort : ( ( rule__Port__Group__0 ) ) ;
    public final void rulePort() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:335:2: ( ( ( rule__Port__Group__0 ) ) )
            // InternalDotParser.g:336:2: ( ( rule__Port__Group__0 ) )
            {
            // InternalDotParser.g:336:2: ( ( rule__Port__Group__0 ) )
            // InternalDotParser.g:337:3: ( rule__Port__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getGroup()); 
            }
            // InternalDotParser.g:338:3: ( rule__Port__Group__0 )
            // InternalDotParser.g:338:4: rule__Port__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Port__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rulePort"


    // $ANTLR start "entryRuleEdgeRhs"
    // InternalDotParser.g:347:1: entryRuleEdgeRhs : ruleEdgeRhs EOF ;
    public final void entryRuleEdgeRhs() throws RecognitionException {
        try {
            // InternalDotParser.g:348:1: ( ruleEdgeRhs EOF )
            // InternalDotParser.g:349:1: ruleEdgeRhs EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleEdgeRhs();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleEdgeRhs"


    // $ANTLR start "ruleEdgeRhs"
    // InternalDotParser.g:356:1: ruleEdgeRhs : ( ( rule__EdgeRhs__Alternatives ) ) ;
    public final void ruleEdgeRhs() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:360:2: ( ( ( rule__EdgeRhs__Alternatives ) ) )
            // InternalDotParser.g:361:2: ( ( rule__EdgeRhs__Alternatives ) )
            {
            // InternalDotParser.g:361:2: ( ( rule__EdgeRhs__Alternatives ) )
            // InternalDotParser.g:362:3: ( rule__EdgeRhs__Alternatives )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsAccess().getAlternatives()); 
            }
            // InternalDotParser.g:363:3: ( rule__EdgeRhs__Alternatives )
            // InternalDotParser.g:363:4: rule__EdgeRhs__Alternatives
            {
            pushFollow(FOLLOW_2);
            rule__EdgeRhs__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleEdgeRhs"


    // $ANTLR start "entryRuleEdgeRhsNode"
    // InternalDotParser.g:372:1: entryRuleEdgeRhsNode : ruleEdgeRhsNode EOF ;
    public final void entryRuleEdgeRhsNode() throws RecognitionException {
        try {
            // InternalDotParser.g:373:1: ( ruleEdgeRhsNode EOF )
            // InternalDotParser.g:374:1: ruleEdgeRhsNode EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsNodeRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleEdgeRhsNode();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsNodeRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleEdgeRhsNode"


    // $ANTLR start "ruleEdgeRhsNode"
    // InternalDotParser.g:381:1: ruleEdgeRhsNode : ( ( rule__EdgeRhsNode__Group__0 ) ) ;
    public final void ruleEdgeRhsNode() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:385:2: ( ( ( rule__EdgeRhsNode__Group__0 ) ) )
            // InternalDotParser.g:386:2: ( ( rule__EdgeRhsNode__Group__0 ) )
            {
            // InternalDotParser.g:386:2: ( ( rule__EdgeRhsNode__Group__0 ) )
            // InternalDotParser.g:387:3: ( rule__EdgeRhsNode__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsNodeAccess().getGroup()); 
            }
            // InternalDotParser.g:388:3: ( rule__EdgeRhsNode__Group__0 )
            // InternalDotParser.g:388:4: rule__EdgeRhsNode__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__EdgeRhsNode__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsNodeAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleEdgeRhsNode"


    // $ANTLR start "entryRuleEdgeRhsSubgraph"
    // InternalDotParser.g:397:1: entryRuleEdgeRhsSubgraph : ruleEdgeRhsSubgraph EOF ;
    public final void entryRuleEdgeRhsSubgraph() throws RecognitionException {
        try {
            // InternalDotParser.g:398:1: ( ruleEdgeRhsSubgraph EOF )
            // InternalDotParser.g:399:1: ruleEdgeRhsSubgraph EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsSubgraphRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleEdgeRhsSubgraph();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsSubgraphRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleEdgeRhsSubgraph"


    // $ANTLR start "ruleEdgeRhsSubgraph"
    // InternalDotParser.g:406:1: ruleEdgeRhsSubgraph : ( ( rule__EdgeRhsSubgraph__Group__0 ) ) ;
    public final void ruleEdgeRhsSubgraph() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:410:2: ( ( ( rule__EdgeRhsSubgraph__Group__0 ) ) )
            // InternalDotParser.g:411:2: ( ( rule__EdgeRhsSubgraph__Group__0 ) )
            {
            // InternalDotParser.g:411:2: ( ( rule__EdgeRhsSubgraph__Group__0 ) )
            // InternalDotParser.g:412:3: ( rule__EdgeRhsSubgraph__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsSubgraphAccess().getGroup()); 
            }
            // InternalDotParser.g:413:3: ( rule__EdgeRhsSubgraph__Group__0 )
            // InternalDotParser.g:413:4: rule__EdgeRhsSubgraph__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__EdgeRhsSubgraph__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsSubgraphAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleEdgeRhsSubgraph"


    // $ANTLR start "entryRuleNodeId"
    // InternalDotParser.g:422:1: entryRuleNodeId : ruleNodeId EOF ;
    public final void entryRuleNodeId() throws RecognitionException {
        try {
            // InternalDotParser.g:423:1: ( ruleNodeId EOF )
            // InternalDotParser.g:424:1: ruleNodeId EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeIdRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleNodeId();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeIdRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleNodeId"


    // $ANTLR start "ruleNodeId"
    // InternalDotParser.g:431:1: ruleNodeId : ( ( rule__NodeId__Group__0 ) ) ;
    public final void ruleNodeId() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:435:2: ( ( ( rule__NodeId__Group__0 ) ) )
            // InternalDotParser.g:436:2: ( ( rule__NodeId__Group__0 ) )
            {
            // InternalDotParser.g:436:2: ( ( rule__NodeId__Group__0 ) )
            // InternalDotParser.g:437:3: ( rule__NodeId__Group__0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeIdAccess().getGroup()); 
            }
            // InternalDotParser.g:438:3: ( rule__NodeId__Group__0 )
            // InternalDotParser.g:438:4: rule__NodeId__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__NodeId__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeIdAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleNodeId"


    // $ANTLR start "entryRuleID"
    // InternalDotParser.g:447:1: entryRuleID : ruleID EOF ;
    public final void entryRuleID() throws RecognitionException {
        try {
            // InternalDotParser.g:448:1: ( ruleID EOF )
            // InternalDotParser.g:449:1: ruleID EOF
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIDRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleID();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getIDRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleID"


    // $ANTLR start "ruleID"
    // InternalDotParser.g:456:1: ruleID : ( ( rule__ID__Alternatives ) ) ;
    public final void ruleID() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:460:2: ( ( ( rule__ID__Alternatives ) ) )
            // InternalDotParser.g:461:2: ( ( rule__ID__Alternatives ) )
            {
            // InternalDotParser.g:461:2: ( ( rule__ID__Alternatives ) )
            // InternalDotParser.g:462:3: ( rule__ID__Alternatives )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIDAccess().getAlternatives()); 
            }
            // InternalDotParser.g:463:3: ( rule__ID__Alternatives )
            // InternalDotParser.g:463:4: rule__ID__Alternatives
            {
            pushFollow(FOLLOW_2);
            rule__ID__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIDAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleID"


    // $ANTLR start "ruleEdgeOp"
    // InternalDotParser.g:472:1: ruleEdgeOp : ( ( rule__EdgeOp__Alternatives ) ) ;
    public final void ruleEdgeOp() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:476:1: ( ( ( rule__EdgeOp__Alternatives ) ) )
            // InternalDotParser.g:477:2: ( ( rule__EdgeOp__Alternatives ) )
            {
            // InternalDotParser.g:477:2: ( ( rule__EdgeOp__Alternatives ) )
            // InternalDotParser.g:478:3: ( rule__EdgeOp__Alternatives )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeOpAccess().getAlternatives()); 
            }
            // InternalDotParser.g:479:3: ( rule__EdgeOp__Alternatives )
            // InternalDotParser.g:479:4: rule__EdgeOp__Alternatives
            {
            pushFollow(FOLLOW_2);
            rule__EdgeOp__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeOpAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleEdgeOp"


    // $ANTLR start "ruleGraphType"
    // InternalDotParser.g:488:1: ruleGraphType : ( ( rule__GraphType__Alternatives ) ) ;
    public final void ruleGraphType() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:492:1: ( ( ( rule__GraphType__Alternatives ) ) )
            // InternalDotParser.g:493:2: ( ( rule__GraphType__Alternatives ) )
            {
            // InternalDotParser.g:493:2: ( ( rule__GraphType__Alternatives ) )
            // InternalDotParser.g:494:3: ( rule__GraphType__Alternatives )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getGraphTypeAccess().getAlternatives()); 
            }
            // InternalDotParser.g:495:3: ( rule__GraphType__Alternatives )
            // InternalDotParser.g:495:4: rule__GraphType__Alternatives
            {
            pushFollow(FOLLOW_2);
            rule__GraphType__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getGraphTypeAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleGraphType"


    // $ANTLR start "ruleAttributeType"
    // InternalDotParser.g:504:1: ruleAttributeType : ( ( rule__AttributeType__Alternatives ) ) ;
    public final void ruleAttributeType() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:508:1: ( ( ( rule__AttributeType__Alternatives ) ) )
            // InternalDotParser.g:509:2: ( ( rule__AttributeType__Alternatives ) )
            {
            // InternalDotParser.g:509:2: ( ( rule__AttributeType__Alternatives ) )
            // InternalDotParser.g:510:3: ( rule__AttributeType__Alternatives )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttributeTypeAccess().getAlternatives()); 
            }
            // InternalDotParser.g:511:3: ( rule__AttributeType__Alternatives )
            // InternalDotParser.g:511:4: rule__AttributeType__Alternatives
            {
            pushFollow(FOLLOW_2);
            rule__AttributeType__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttributeTypeAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleAttributeType"


    // $ANTLR start "rule__Stmt__Alternatives_0"
    // InternalDotParser.g:519:1: rule__Stmt__Alternatives_0 : ( ( ruleNodeStmt ) | ( ruleEdgeStmtNode ) | ( ruleAttrStmt ) | ( ruleAttribute ) | ( ruleSubgraphOrEdgeStmtSubgraph ) );
    public final void rule__Stmt__Alternatives_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:523:1: ( ( ruleNodeStmt ) | ( ruleEdgeStmtNode ) | ( ruleAttrStmt ) | ( ruleAttribute ) | ( ruleSubgraphOrEdgeStmtSubgraph ) )
            int alt2=5;
            alt2 = dfa2.predict(input);
            switch (alt2) {
                case 1 :
                    // InternalDotParser.g:524:2: ( ruleNodeStmt )
                    {
                    // InternalDotParser.g:524:2: ( ruleNodeStmt )
                    // InternalDotParser.g:525:3: ruleNodeStmt
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getStmtAccess().getNodeStmtParserRuleCall_0_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleNodeStmt();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getStmtAccess().getNodeStmtParserRuleCall_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalDotParser.g:530:2: ( ruleEdgeStmtNode )
                    {
                    // InternalDotParser.g:530:2: ( ruleEdgeStmtNode )
                    // InternalDotParser.g:531:3: ruleEdgeStmtNode
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getStmtAccess().getEdgeStmtNodeParserRuleCall_0_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleEdgeStmtNode();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getStmtAccess().getEdgeStmtNodeParserRuleCall_0_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    // InternalDotParser.g:536:2: ( ruleAttrStmt )
                    {
                    // InternalDotParser.g:536:2: ( ruleAttrStmt )
                    // InternalDotParser.g:537:3: ruleAttrStmt
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getStmtAccess().getAttrStmtParserRuleCall_0_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleAttrStmt();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getStmtAccess().getAttrStmtParserRuleCall_0_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    // InternalDotParser.g:542:2: ( ruleAttribute )
                    {
                    // InternalDotParser.g:542:2: ( ruleAttribute )
                    // InternalDotParser.g:543:3: ruleAttribute
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getStmtAccess().getAttributeParserRuleCall_0_3()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleAttribute();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getStmtAccess().getAttributeParserRuleCall_0_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    // InternalDotParser.g:548:2: ( ruleSubgraphOrEdgeStmtSubgraph )
                    {
                    // InternalDotParser.g:548:2: ( ruleSubgraphOrEdgeStmtSubgraph )
                    // InternalDotParser.g:549:3: ruleSubgraphOrEdgeStmtSubgraph
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getStmtAccess().getSubgraphOrEdgeStmtSubgraphParserRuleCall_0_4()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleSubgraphOrEdgeStmtSubgraph();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getStmtAccess().getSubgraphOrEdgeStmtSubgraphParserRuleCall_0_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Stmt__Alternatives_0"


    // $ANTLR start "rule__AttrList__Alternatives_2_1"
    // InternalDotParser.g:558:1: rule__AttrList__Alternatives_2_1 : ( ( Comma ) | ( Semicolon ) );
    public final void rule__AttrList__Alternatives_2_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:562:1: ( ( Comma ) | ( Semicolon ) )
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( (LA3_0==Comma) ) {
                alt3=1;
            }
            else if ( (LA3_0==Semicolon) ) {
                alt3=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;
            }
            switch (alt3) {
                case 1 :
                    // InternalDotParser.g:563:2: ( Comma )
                    {
                    // InternalDotParser.g:563:2: ( Comma )
                    // InternalDotParser.g:564:3: Comma
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAttrListAccess().getCommaKeyword_2_1_0()); 
                    }
                    match(input,Comma,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAttrListAccess().getCommaKeyword_2_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalDotParser.g:569:2: ( Semicolon )
                    {
                    // InternalDotParser.g:569:2: ( Semicolon )
                    // InternalDotParser.g:570:3: Semicolon
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAttrListAccess().getSemicolonKeyword_2_1_1()); 
                    }
                    match(input,Semicolon,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAttrListAccess().getSemicolonKeyword_2_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Alternatives_2_1"


    // $ANTLR start "rule__Port__Alternatives_1"
    // InternalDotParser.g:579:1: rule__Port__Alternatives_1 : ( ( ( rule__Port__Compass_ptAssignment_1_0 ) ) | ( ( rule__Port__NameAssignment_1_1 ) ) | ( ( rule__Port__Group_1_2__0 ) ) );
    public final void rule__Port__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:583:1: ( ( ( rule__Port__Compass_ptAssignment_1_0 ) ) | ( ( rule__Port__NameAssignment_1_1 ) ) | ( ( rule__Port__Group_1_2__0 ) ) )
            int alt4=3;
            switch ( input.LA(1) ) {
            case RULE_COMPASS_PT:
                {
                int LA4_1 = input.LA(2);

                if ( (LA4_1==Colon) ) {
                    alt4=3;
                }
                else if ( (synpred7_InternalDotParser()) ) {
                    alt4=1;
                }
                else if ( (synpred8_InternalDotParser()) ) {
                    alt4=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 1, input);

                    throw nvae;
                }
                }
                break;
            case RULE_NUMERAL:
                {
                int LA4_2 = input.LA(2);

                if ( (LA4_2==Colon) ) {
                    alt4=3;
                }
                else if ( (LA4_2==EOF||LA4_2==Subgraph||(LA4_2>=Graph && LA4_2<=HyphenMinusGreaterThanSign)||LA4_2==Semicolon||LA4_2==LeftSquareBracket||(LA4_2>=LeftCurlyBracket && LA4_2<=RULE_QUOTED_STRING)||LA4_2==RULE_HTML_STRING) ) {
                    alt4=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 2, input);

                    throw nvae;
                }
                }
                break;
            case RULE_STRING:
                {
                int LA4_3 = input.LA(2);

                if ( (LA4_3==Colon) ) {
                    alt4=3;
                }
                else if ( (LA4_3==EOF||LA4_3==Subgraph||(LA4_3>=Graph && LA4_3<=HyphenMinusGreaterThanSign)||LA4_3==Semicolon||LA4_3==LeftSquareBracket||(LA4_3>=LeftCurlyBracket && LA4_3<=RULE_QUOTED_STRING)||LA4_3==RULE_HTML_STRING) ) {
                    alt4=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 3, input);

                    throw nvae;
                }
                }
                break;
            case RULE_QUOTED_STRING:
                {
                int LA4_4 = input.LA(2);

                if ( (LA4_4==EOF||LA4_4==Subgraph||(LA4_4>=Graph && LA4_4<=HyphenMinusGreaterThanSign)||LA4_4==Semicolon||LA4_4==LeftSquareBracket||(LA4_4>=LeftCurlyBracket && LA4_4<=RULE_QUOTED_STRING)||LA4_4==RULE_HTML_STRING) ) {
                    alt4=2;
                }
                else if ( (LA4_4==Colon) ) {
                    alt4=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 4, input);

                    throw nvae;
                }
                }
                break;
            case RULE_HTML_STRING:
                {
                int LA4_5 = input.LA(2);

                if ( (LA4_5==Colon) ) {
                    alt4=3;
                }
                else if ( (LA4_5==EOF||LA4_5==Subgraph||(LA4_5>=Graph && LA4_5<=HyphenMinusGreaterThanSign)||LA4_5==Semicolon||LA4_5==LeftSquareBracket||(LA4_5>=LeftCurlyBracket && LA4_5<=RULE_QUOTED_STRING)||LA4_5==RULE_HTML_STRING) ) {
                    alt4=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 5, input);

                    throw nvae;
                }
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;
            }

            switch (alt4) {
                case 1 :
                    // InternalDotParser.g:584:2: ( ( rule__Port__Compass_ptAssignment_1_0 ) )
                    {
                    // InternalDotParser.g:584:2: ( ( rule__Port__Compass_ptAssignment_1_0 ) )
                    // InternalDotParser.g:585:3: ( rule__Port__Compass_ptAssignment_1_0 )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPortAccess().getCompass_ptAssignment_1_0()); 
                    }
                    // InternalDotParser.g:586:3: ( rule__Port__Compass_ptAssignment_1_0 )
                    // InternalDotParser.g:586:4: rule__Port__Compass_ptAssignment_1_0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Port__Compass_ptAssignment_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPortAccess().getCompass_ptAssignment_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalDotParser.g:590:2: ( ( rule__Port__NameAssignment_1_1 ) )
                    {
                    // InternalDotParser.g:590:2: ( ( rule__Port__NameAssignment_1_1 ) )
                    // InternalDotParser.g:591:3: ( rule__Port__NameAssignment_1_1 )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPortAccess().getNameAssignment_1_1()); 
                    }
                    // InternalDotParser.g:592:3: ( rule__Port__NameAssignment_1_1 )
                    // InternalDotParser.g:592:4: rule__Port__NameAssignment_1_1
                    {
                    pushFollow(FOLLOW_2);
                    rule__Port__NameAssignment_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPortAccess().getNameAssignment_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    // InternalDotParser.g:596:2: ( ( rule__Port__Group_1_2__0 ) )
                    {
                    // InternalDotParser.g:596:2: ( ( rule__Port__Group_1_2__0 ) )
                    // InternalDotParser.g:597:3: ( rule__Port__Group_1_2__0 )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPortAccess().getGroup_1_2()); 
                    }
                    // InternalDotParser.g:598:3: ( rule__Port__Group_1_2__0 )
                    // InternalDotParser.g:598:4: rule__Port__Group_1_2__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Port__Group_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPortAccess().getGroup_1_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Alternatives_1"


    // $ANTLR start "rule__EdgeRhs__Alternatives"
    // InternalDotParser.g:606:1: rule__EdgeRhs__Alternatives : ( ( ruleEdgeRhsNode ) | ( ruleEdgeRhsSubgraph ) );
    public final void rule__EdgeRhs__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:610:1: ( ( ruleEdgeRhsNode ) | ( ruleEdgeRhsSubgraph ) )
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==HyphenMinusGreaterThanSign) ) {
                int LA5_1 = input.LA(2);

                if ( ((LA5_1>=RULE_NUMERAL && LA5_1<=RULE_QUOTED_STRING)||LA5_1==RULE_HTML_STRING) ) {
                    alt5=1;
                }
                else if ( (LA5_1==Subgraph||LA5_1==LeftCurlyBracket) ) {
                    alt5=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 5, 1, input);

                    throw nvae;
                }
            }
            else if ( (LA5_0==HyphenMinusHyphenMinus) ) {
                int LA5_2 = input.LA(2);

                if ( ((LA5_2>=RULE_NUMERAL && LA5_2<=RULE_QUOTED_STRING)||LA5_2==RULE_HTML_STRING) ) {
                    alt5=1;
                }
                else if ( (LA5_2==Subgraph||LA5_2==LeftCurlyBracket) ) {
                    alt5=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 5, 2, input);

                    throw nvae;
                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;
            }
            switch (alt5) {
                case 1 :
                    // InternalDotParser.g:611:2: ( ruleEdgeRhsNode )
                    {
                    // InternalDotParser.g:611:2: ( ruleEdgeRhsNode )
                    // InternalDotParser.g:612:3: ruleEdgeRhsNode
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getEdgeRhsAccess().getEdgeRhsNodeParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleEdgeRhsNode();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getEdgeRhsAccess().getEdgeRhsNodeParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalDotParser.g:617:2: ( ruleEdgeRhsSubgraph )
                    {
                    // InternalDotParser.g:617:2: ( ruleEdgeRhsSubgraph )
                    // InternalDotParser.g:618:3: ruleEdgeRhsSubgraph
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getEdgeRhsAccess().getEdgeRhsSubgraphParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleEdgeRhsSubgraph();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getEdgeRhsAccess().getEdgeRhsSubgraphParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhs__Alternatives"


    // $ANTLR start "rule__ID__Alternatives"
    // InternalDotParser.g:627:1: rule__ID__Alternatives : ( ( RULE_NUMERAL ) | ( RULE_COMPASS_PT ) | ( RULE_STRING ) | ( RULE_QUOTED_STRING ) | ( RULE_HTML_STRING ) );
    public final void rule__ID__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:631:1: ( ( RULE_NUMERAL ) | ( RULE_COMPASS_PT ) | ( RULE_STRING ) | ( RULE_QUOTED_STRING ) | ( RULE_HTML_STRING ) )
            int alt6=5;
            switch ( input.LA(1) ) {
            case RULE_NUMERAL:
                {
                alt6=1;
                }
                break;
            case RULE_COMPASS_PT:
                {
                alt6=2;
                }
                break;
            case RULE_STRING:
                {
                alt6=3;
                }
                break;
            case RULE_QUOTED_STRING:
                {
                alt6=4;
                }
                break;
            case RULE_HTML_STRING:
                {
                alt6=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }

            switch (alt6) {
                case 1 :
                    // InternalDotParser.g:632:2: ( RULE_NUMERAL )
                    {
                    // InternalDotParser.g:632:2: ( RULE_NUMERAL )
                    // InternalDotParser.g:633:3: RULE_NUMERAL
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIDAccess().getNUMERALTerminalRuleCall_0()); 
                    }
                    match(input,RULE_NUMERAL,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIDAccess().getNUMERALTerminalRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalDotParser.g:638:2: ( RULE_COMPASS_PT )
                    {
                    // InternalDotParser.g:638:2: ( RULE_COMPASS_PT )
                    // InternalDotParser.g:639:3: RULE_COMPASS_PT
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIDAccess().getCOMPASS_PTTerminalRuleCall_1()); 
                    }
                    match(input,RULE_COMPASS_PT,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIDAccess().getCOMPASS_PTTerminalRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    // InternalDotParser.g:644:2: ( RULE_STRING )
                    {
                    // InternalDotParser.g:644:2: ( RULE_STRING )
                    // InternalDotParser.g:645:3: RULE_STRING
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIDAccess().getSTRINGTerminalRuleCall_2()); 
                    }
                    match(input,RULE_STRING,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIDAccess().getSTRINGTerminalRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    // InternalDotParser.g:650:2: ( RULE_QUOTED_STRING )
                    {
                    // InternalDotParser.g:650:2: ( RULE_QUOTED_STRING )
                    // InternalDotParser.g:651:3: RULE_QUOTED_STRING
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIDAccess().getQUOTED_STRINGTerminalRuleCall_3()); 
                    }
                    match(input,RULE_QUOTED_STRING,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIDAccess().getQUOTED_STRINGTerminalRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    // InternalDotParser.g:656:2: ( RULE_HTML_STRING )
                    {
                    // InternalDotParser.g:656:2: ( RULE_HTML_STRING )
                    // InternalDotParser.g:657:3: RULE_HTML_STRING
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIDAccess().getHTML_STRINGTerminalRuleCall_4()); 
                    }
                    match(input,RULE_HTML_STRING,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIDAccess().getHTML_STRINGTerminalRuleCall_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ID__Alternatives"


    // $ANTLR start "rule__EdgeOp__Alternatives"
    // InternalDotParser.g:666:1: rule__EdgeOp__Alternatives : ( ( ( HyphenMinusGreaterThanSign ) ) | ( ( HyphenMinusHyphenMinus ) ) );
    public final void rule__EdgeOp__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:670:1: ( ( ( HyphenMinusGreaterThanSign ) ) | ( ( HyphenMinusHyphenMinus ) ) )
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==HyphenMinusGreaterThanSign) ) {
                alt7=1;
            }
            else if ( (LA7_0==HyphenMinusHyphenMinus) ) {
                alt7=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }
            switch (alt7) {
                case 1 :
                    // InternalDotParser.g:671:2: ( ( HyphenMinusGreaterThanSign ) )
                    {
                    // InternalDotParser.g:671:2: ( ( HyphenMinusGreaterThanSign ) )
                    // InternalDotParser.g:672:3: ( HyphenMinusGreaterThanSign )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getEdgeOpAccess().getDirectedEnumLiteralDeclaration_0()); 
                    }
                    // InternalDotParser.g:673:3: ( HyphenMinusGreaterThanSign )
                    // InternalDotParser.g:673:4: HyphenMinusGreaterThanSign
                    {
                    match(input,HyphenMinusGreaterThanSign,FOLLOW_2); if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getEdgeOpAccess().getDirectedEnumLiteralDeclaration_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalDotParser.g:677:2: ( ( HyphenMinusHyphenMinus ) )
                    {
                    // InternalDotParser.g:677:2: ( ( HyphenMinusHyphenMinus ) )
                    // InternalDotParser.g:678:3: ( HyphenMinusHyphenMinus )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getEdgeOpAccess().getUndirectedEnumLiteralDeclaration_1()); 
                    }
                    // InternalDotParser.g:679:3: ( HyphenMinusHyphenMinus )
                    // InternalDotParser.g:679:4: HyphenMinusHyphenMinus
                    {
                    match(input,HyphenMinusHyphenMinus,FOLLOW_2); if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getEdgeOpAccess().getUndirectedEnumLiteralDeclaration_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeOp__Alternatives"


    // $ANTLR start "rule__GraphType__Alternatives"
    // InternalDotParser.g:687:1: rule__GraphType__Alternatives : ( ( ( Graph ) ) | ( ( Digraph ) ) );
    public final void rule__GraphType__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:691:1: ( ( ( Graph ) ) | ( ( Digraph ) ) )
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==Graph) ) {
                alt8=1;
            }
            else if ( (LA8_0==Digraph) ) {
                alt8=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 8, 0, input);

                throw nvae;
            }
            switch (alt8) {
                case 1 :
                    // InternalDotParser.g:692:2: ( ( Graph ) )
                    {
                    // InternalDotParser.g:692:2: ( ( Graph ) )
                    // InternalDotParser.g:693:3: ( Graph )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getGraphTypeAccess().getGraphEnumLiteralDeclaration_0()); 
                    }
                    // InternalDotParser.g:694:3: ( Graph )
                    // InternalDotParser.g:694:4: Graph
                    {
                    match(input,Graph,FOLLOW_2); if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getGraphTypeAccess().getGraphEnumLiteralDeclaration_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalDotParser.g:698:2: ( ( Digraph ) )
                    {
                    // InternalDotParser.g:698:2: ( ( Digraph ) )
                    // InternalDotParser.g:699:3: ( Digraph )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getGraphTypeAccess().getDigraphEnumLiteralDeclaration_1()); 
                    }
                    // InternalDotParser.g:700:3: ( Digraph )
                    // InternalDotParser.g:700:4: Digraph
                    {
                    match(input,Digraph,FOLLOW_2); if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getGraphTypeAccess().getDigraphEnumLiteralDeclaration_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__GraphType__Alternatives"


    // $ANTLR start "rule__AttributeType__Alternatives"
    // InternalDotParser.g:708:1: rule__AttributeType__Alternatives : ( ( ( Graph ) ) | ( ( Node ) ) | ( ( Edge ) ) );
    public final void rule__AttributeType__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:712:1: ( ( ( Graph ) ) | ( ( Node ) ) | ( ( Edge ) ) )
            int alt9=3;
            switch ( input.LA(1) ) {
            case Graph:
                {
                alt9=1;
                }
                break;
            case Node:
                {
                alt9=2;
                }
                break;
            case Edge:
                {
                alt9=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;
            }

            switch (alt9) {
                case 1 :
                    // InternalDotParser.g:713:2: ( ( Graph ) )
                    {
                    // InternalDotParser.g:713:2: ( ( Graph ) )
                    // InternalDotParser.g:714:3: ( Graph )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAttributeTypeAccess().getGraphEnumLiteralDeclaration_0()); 
                    }
                    // InternalDotParser.g:715:3: ( Graph )
                    // InternalDotParser.g:715:4: Graph
                    {
                    match(input,Graph,FOLLOW_2); if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAttributeTypeAccess().getGraphEnumLiteralDeclaration_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalDotParser.g:719:2: ( ( Node ) )
                    {
                    // InternalDotParser.g:719:2: ( ( Node ) )
                    // InternalDotParser.g:720:3: ( Node )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAttributeTypeAccess().getNodeEnumLiteralDeclaration_1()); 
                    }
                    // InternalDotParser.g:721:3: ( Node )
                    // InternalDotParser.g:721:4: Node
                    {
                    match(input,Node,FOLLOW_2); if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAttributeTypeAccess().getNodeEnumLiteralDeclaration_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    // InternalDotParser.g:725:2: ( ( Edge ) )
                    {
                    // InternalDotParser.g:725:2: ( ( Edge ) )
                    // InternalDotParser.g:726:3: ( Edge )
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAttributeTypeAccess().getEdgeEnumLiteralDeclaration_2()); 
                    }
                    // InternalDotParser.g:727:3: ( Edge )
                    // InternalDotParser.g:727:4: Edge
                    {
                    match(input,Edge,FOLLOW_2); if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAttributeTypeAccess().getEdgeEnumLiteralDeclaration_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttributeType__Alternatives"


    // $ANTLR start "rule__DotGraph__Group__0"
    // InternalDotParser.g:735:1: rule__DotGraph__Group__0 : rule__DotGraph__Group__0__Impl rule__DotGraph__Group__1 ;
    public final void rule__DotGraph__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:739:1: ( rule__DotGraph__Group__0__Impl rule__DotGraph__Group__1 )
            // InternalDotParser.g:740:2: rule__DotGraph__Group__0__Impl rule__DotGraph__Group__1
            {
            pushFollow(FOLLOW_4);
            rule__DotGraph__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__DotGraph__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__0"


    // $ANTLR start "rule__DotGraph__Group__0__Impl"
    // InternalDotParser.g:747:1: rule__DotGraph__Group__0__Impl : ( ( rule__DotGraph__StrictAssignment_0 )? ) ;
    public final void rule__DotGraph__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:751:1: ( ( ( rule__DotGraph__StrictAssignment_0 )? ) )
            // InternalDotParser.g:752:1: ( ( rule__DotGraph__StrictAssignment_0 )? )
            {
            // InternalDotParser.g:752:1: ( ( rule__DotGraph__StrictAssignment_0 )? )
            // InternalDotParser.g:753:2: ( rule__DotGraph__StrictAssignment_0 )?
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getStrictAssignment_0()); 
            }
            // InternalDotParser.g:754:2: ( rule__DotGraph__StrictAssignment_0 )?
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==Strict) ) {
                alt10=1;
            }
            switch (alt10) {
                case 1 :
                    // InternalDotParser.g:754:3: rule__DotGraph__StrictAssignment_0
                    {
                    pushFollow(FOLLOW_2);
                    rule__DotGraph__StrictAssignment_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getStrictAssignment_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__0__Impl"


    // $ANTLR start "rule__DotGraph__Group__1"
    // InternalDotParser.g:762:1: rule__DotGraph__Group__1 : rule__DotGraph__Group__1__Impl rule__DotGraph__Group__2 ;
    public final void rule__DotGraph__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:766:1: ( rule__DotGraph__Group__1__Impl rule__DotGraph__Group__2 )
            // InternalDotParser.g:767:2: rule__DotGraph__Group__1__Impl rule__DotGraph__Group__2
            {
            pushFollow(FOLLOW_5);
            rule__DotGraph__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__DotGraph__Group__2();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__1"


    // $ANTLR start "rule__DotGraph__Group__1__Impl"
    // InternalDotParser.g:774:1: rule__DotGraph__Group__1__Impl : ( ( rule__DotGraph__TypeAssignment_1 ) ) ;
    public final void rule__DotGraph__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:778:1: ( ( ( rule__DotGraph__TypeAssignment_1 ) ) )
            // InternalDotParser.g:779:1: ( ( rule__DotGraph__TypeAssignment_1 ) )
            {
            // InternalDotParser.g:779:1: ( ( rule__DotGraph__TypeAssignment_1 ) )
            // InternalDotParser.g:780:2: ( rule__DotGraph__TypeAssignment_1 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getTypeAssignment_1()); 
            }
            // InternalDotParser.g:781:2: ( rule__DotGraph__TypeAssignment_1 )
            // InternalDotParser.g:781:3: rule__DotGraph__TypeAssignment_1
            {
            pushFollow(FOLLOW_2);
            rule__DotGraph__TypeAssignment_1();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getTypeAssignment_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__1__Impl"


    // $ANTLR start "rule__DotGraph__Group__2"
    // InternalDotParser.g:789:1: rule__DotGraph__Group__2 : rule__DotGraph__Group__2__Impl rule__DotGraph__Group__3 ;
    public final void rule__DotGraph__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:793:1: ( rule__DotGraph__Group__2__Impl rule__DotGraph__Group__3 )
            // InternalDotParser.g:794:2: rule__DotGraph__Group__2__Impl rule__DotGraph__Group__3
            {
            pushFollow(FOLLOW_5);
            rule__DotGraph__Group__2__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__DotGraph__Group__3();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__2"


    // $ANTLR start "rule__DotGraph__Group__2__Impl"
    // InternalDotParser.g:801:1: rule__DotGraph__Group__2__Impl : ( ( rule__DotGraph__NameAssignment_2 )? ) ;
    public final void rule__DotGraph__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:805:1: ( ( ( rule__DotGraph__NameAssignment_2 )? ) )
            // InternalDotParser.g:806:1: ( ( rule__DotGraph__NameAssignment_2 )? )
            {
            // InternalDotParser.g:806:1: ( ( rule__DotGraph__NameAssignment_2 )? )
            // InternalDotParser.g:807:2: ( rule__DotGraph__NameAssignment_2 )?
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getNameAssignment_2()); 
            }
            // InternalDotParser.g:808:2: ( rule__DotGraph__NameAssignment_2 )?
            int alt11=2;
            int LA11_0 = input.LA(1);

            if ( ((LA11_0>=RULE_NUMERAL && LA11_0<=RULE_QUOTED_STRING)||LA11_0==RULE_HTML_STRING) ) {
                alt11=1;
            }
            switch (alt11) {
                case 1 :
                    // InternalDotParser.g:808:3: rule__DotGraph__NameAssignment_2
                    {
                    pushFollow(FOLLOW_2);
                    rule__DotGraph__NameAssignment_2();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getNameAssignment_2()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__2__Impl"


    // $ANTLR start "rule__DotGraph__Group__3"
    // InternalDotParser.g:816:1: rule__DotGraph__Group__3 : rule__DotGraph__Group__3__Impl rule__DotGraph__Group__4 ;
    public final void rule__DotGraph__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:820:1: ( rule__DotGraph__Group__3__Impl rule__DotGraph__Group__4 )
            // InternalDotParser.g:821:2: rule__DotGraph__Group__3__Impl rule__DotGraph__Group__4
            {
            pushFollow(FOLLOW_6);
            rule__DotGraph__Group__3__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__DotGraph__Group__4();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__3"


    // $ANTLR start "rule__DotGraph__Group__3__Impl"
    // InternalDotParser.g:828:1: rule__DotGraph__Group__3__Impl : ( LeftCurlyBracket ) ;
    public final void rule__DotGraph__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:832:1: ( ( LeftCurlyBracket ) )
            // InternalDotParser.g:833:1: ( LeftCurlyBracket )
            {
            // InternalDotParser.g:833:1: ( LeftCurlyBracket )
            // InternalDotParser.g:834:2: LeftCurlyBracket
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getLeftCurlyBracketKeyword_3()); 
            }
            match(input,LeftCurlyBracket,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getLeftCurlyBracketKeyword_3()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__3__Impl"


    // $ANTLR start "rule__DotGraph__Group__4"
    // InternalDotParser.g:843:1: rule__DotGraph__Group__4 : rule__DotGraph__Group__4__Impl rule__DotGraph__Group__5 ;
    public final void rule__DotGraph__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:847:1: ( rule__DotGraph__Group__4__Impl rule__DotGraph__Group__5 )
            // InternalDotParser.g:848:2: rule__DotGraph__Group__4__Impl rule__DotGraph__Group__5
            {
            pushFollow(FOLLOW_6);
            rule__DotGraph__Group__4__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__DotGraph__Group__5();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__4"


    // $ANTLR start "rule__DotGraph__Group__4__Impl"
    // InternalDotParser.g:855:1: rule__DotGraph__Group__4__Impl : ( ( rule__DotGraph__StmtsAssignment_4 )* ) ;
    public final void rule__DotGraph__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:859:1: ( ( ( rule__DotGraph__StmtsAssignment_4 )* ) )
            // InternalDotParser.g:860:1: ( ( rule__DotGraph__StmtsAssignment_4 )* )
            {
            // InternalDotParser.g:860:1: ( ( rule__DotGraph__StmtsAssignment_4 )* )
            // InternalDotParser.g:861:2: ( rule__DotGraph__StmtsAssignment_4 )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getStmtsAssignment_4()); 
            }
            // InternalDotParser.g:862:2: ( rule__DotGraph__StmtsAssignment_4 )*
            loop12:
            do {
                int alt12=2;
                int LA12_0 = input.LA(1);

                if ( (LA12_0==Subgraph||(LA12_0>=Graph && LA12_0<=Node)||LA12_0==LeftCurlyBracket||(LA12_0>=RULE_NUMERAL && LA12_0<=RULE_QUOTED_STRING)||LA12_0==RULE_HTML_STRING) ) {
                    alt12=1;
                }


                switch (alt12) {
            	case 1 :
            	    // InternalDotParser.g:862:3: rule__DotGraph__StmtsAssignment_4
            	    {
            	    pushFollow(FOLLOW_7);
            	    rule__DotGraph__StmtsAssignment_4();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop12;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getStmtsAssignment_4()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__4__Impl"


    // $ANTLR start "rule__DotGraph__Group__5"
    // InternalDotParser.g:870:1: rule__DotGraph__Group__5 : rule__DotGraph__Group__5__Impl ;
    public final void rule__DotGraph__Group__5() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:874:1: ( rule__DotGraph__Group__5__Impl )
            // InternalDotParser.g:875:2: rule__DotGraph__Group__5__Impl
            {
            pushFollow(FOLLOW_2);
            rule__DotGraph__Group__5__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__5"


    // $ANTLR start "rule__DotGraph__Group__5__Impl"
    // InternalDotParser.g:881:1: rule__DotGraph__Group__5__Impl : ( RightCurlyBracket ) ;
    public final void rule__DotGraph__Group__5__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:885:1: ( ( RightCurlyBracket ) )
            // InternalDotParser.g:886:1: ( RightCurlyBracket )
            {
            // InternalDotParser.g:886:1: ( RightCurlyBracket )
            // InternalDotParser.g:887:2: RightCurlyBracket
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getRightCurlyBracketKeyword_5()); 
            }
            match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getRightCurlyBracketKeyword_5()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__Group__5__Impl"


    // $ANTLR start "rule__Stmt__Group__0"
    // InternalDotParser.g:897:1: rule__Stmt__Group__0 : rule__Stmt__Group__0__Impl rule__Stmt__Group__1 ;
    public final void rule__Stmt__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:901:1: ( rule__Stmt__Group__0__Impl rule__Stmt__Group__1 )
            // InternalDotParser.g:902:2: rule__Stmt__Group__0__Impl rule__Stmt__Group__1
            {
            pushFollow(FOLLOW_8);
            rule__Stmt__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Stmt__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Stmt__Group__0"


    // $ANTLR start "rule__Stmt__Group__0__Impl"
    // InternalDotParser.g:909:1: rule__Stmt__Group__0__Impl : ( ( rule__Stmt__Alternatives_0 ) ) ;
    public final void rule__Stmt__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:913:1: ( ( ( rule__Stmt__Alternatives_0 ) ) )
            // InternalDotParser.g:914:1: ( ( rule__Stmt__Alternatives_0 ) )
            {
            // InternalDotParser.g:914:1: ( ( rule__Stmt__Alternatives_0 ) )
            // InternalDotParser.g:915:2: ( rule__Stmt__Alternatives_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStmtAccess().getAlternatives_0()); 
            }
            // InternalDotParser.g:916:2: ( rule__Stmt__Alternatives_0 )
            // InternalDotParser.g:916:3: rule__Stmt__Alternatives_0
            {
            pushFollow(FOLLOW_2);
            rule__Stmt__Alternatives_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getStmtAccess().getAlternatives_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Stmt__Group__0__Impl"


    // $ANTLR start "rule__Stmt__Group__1"
    // InternalDotParser.g:924:1: rule__Stmt__Group__1 : rule__Stmt__Group__1__Impl ;
    public final void rule__Stmt__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:928:1: ( rule__Stmt__Group__1__Impl )
            // InternalDotParser.g:929:2: rule__Stmt__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Stmt__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Stmt__Group__1"


    // $ANTLR start "rule__Stmt__Group__1__Impl"
    // InternalDotParser.g:935:1: rule__Stmt__Group__1__Impl : ( ( Semicolon )? ) ;
    public final void rule__Stmt__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:939:1: ( ( ( Semicolon )? ) )
            // InternalDotParser.g:940:1: ( ( Semicolon )? )
            {
            // InternalDotParser.g:940:1: ( ( Semicolon )? )
            // InternalDotParser.g:941:2: ( Semicolon )?
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStmtAccess().getSemicolonKeyword_1()); 
            }
            // InternalDotParser.g:942:2: ( Semicolon )?
            int alt13=2;
            int LA13_0 = input.LA(1);

            if ( (LA13_0==Semicolon) ) {
                alt13=1;
            }
            switch (alt13) {
                case 1 :
                    // InternalDotParser.g:942:3: Semicolon
                    {
                    match(input,Semicolon,FOLLOW_2); if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getStmtAccess().getSemicolonKeyword_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Stmt__Group__1__Impl"


    // $ANTLR start "rule__EdgeStmtNode__Group__0"
    // InternalDotParser.g:951:1: rule__EdgeStmtNode__Group__0 : rule__EdgeStmtNode__Group__0__Impl rule__EdgeStmtNode__Group__1 ;
    public final void rule__EdgeStmtNode__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:955:1: ( rule__EdgeStmtNode__Group__0__Impl rule__EdgeStmtNode__Group__1 )
            // InternalDotParser.g:956:2: rule__EdgeStmtNode__Group__0__Impl rule__EdgeStmtNode__Group__1
            {
            pushFollow(FOLLOW_9);
            rule__EdgeStmtNode__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__EdgeStmtNode__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeStmtNode__Group__0"


    // $ANTLR start "rule__EdgeStmtNode__Group__0__Impl"
    // InternalDotParser.g:963:1: rule__EdgeStmtNode__Group__0__Impl : ( ( rule__EdgeStmtNode__NodeAssignment_0 ) ) ;
    public final void rule__EdgeStmtNode__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:967:1: ( ( ( rule__EdgeStmtNode__NodeAssignment_0 ) ) )
            // InternalDotParser.g:968:1: ( ( rule__EdgeStmtNode__NodeAssignment_0 ) )
            {
            // InternalDotParser.g:968:1: ( ( rule__EdgeStmtNode__NodeAssignment_0 ) )
            // InternalDotParser.g:969:2: ( rule__EdgeStmtNode__NodeAssignment_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeStmtNodeAccess().getNodeAssignment_0()); 
            }
            // InternalDotParser.g:970:2: ( rule__EdgeStmtNode__NodeAssignment_0 )
            // InternalDotParser.g:970:3: rule__EdgeStmtNode__NodeAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__EdgeStmtNode__NodeAssignment_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeStmtNodeAccess().getNodeAssignment_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeStmtNode__Group__0__Impl"


    // $ANTLR start "rule__EdgeStmtNode__Group__1"
    // InternalDotParser.g:978:1: rule__EdgeStmtNode__Group__1 : rule__EdgeStmtNode__Group__1__Impl rule__EdgeStmtNode__Group__2 ;
    public final void rule__EdgeStmtNode__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:982:1: ( rule__EdgeStmtNode__Group__1__Impl rule__EdgeStmtNode__Group__2 )
            // InternalDotParser.g:983:2: rule__EdgeStmtNode__Group__1__Impl rule__EdgeStmtNode__Group__2
            {
            pushFollow(FOLLOW_10);
            rule__EdgeStmtNode__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__EdgeStmtNode__Group__2();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeStmtNode__Group__1"


    // $ANTLR start "rule__EdgeStmtNode__Group__1__Impl"
    // InternalDotParser.g:990:1: rule__EdgeStmtNode__Group__1__Impl : ( ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 ) ) ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )* ) ) ;
    public final void rule__EdgeStmtNode__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:994:1: ( ( ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 ) ) ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )* ) ) )
            // InternalDotParser.g:995:1: ( ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 ) ) ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )* ) )
            {
            // InternalDotParser.g:995:1: ( ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 ) ) ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )* ) )
            // InternalDotParser.g:996:2: ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 ) ) ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )* )
            {
            // InternalDotParser.g:996:2: ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 ) )
            // InternalDotParser.g:997:3: ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeStmtNodeAccess().getEdgeRHSAssignment_1()); 
            }
            // InternalDotParser.g:998:3: ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )
            // InternalDotParser.g:998:4: rule__EdgeStmtNode__EdgeRHSAssignment_1
            {
            pushFollow(FOLLOW_11);
            rule__EdgeStmtNode__EdgeRHSAssignment_1();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeStmtNodeAccess().getEdgeRHSAssignment_1()); 
            }

            }

            // InternalDotParser.g:1001:2: ( ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )* )
            // InternalDotParser.g:1002:3: ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeStmtNodeAccess().getEdgeRHSAssignment_1()); 
            }
            // InternalDotParser.g:1003:3: ( rule__EdgeStmtNode__EdgeRHSAssignment_1 )*
            loop14:
            do {
                int alt14=2;
                int LA14_0 = input.LA(1);

                if ( ((LA14_0>=HyphenMinusHyphenMinus && LA14_0<=HyphenMinusGreaterThanSign)) ) {
                    alt14=1;
                }


                switch (alt14) {
            	case 1 :
            	    // InternalDotParser.g:1003:4: rule__EdgeStmtNode__EdgeRHSAssignment_1
            	    {
            	    pushFollow(FOLLOW_11);
            	    rule__EdgeStmtNode__EdgeRHSAssignment_1();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop14;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeStmtNodeAccess().getEdgeRHSAssignment_1()); 
            }

            }


            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeStmtNode__Group__1__Impl"


    // $ANTLR start "rule__EdgeStmtNode__Group__2"
    // InternalDotParser.g:1012:1: rule__EdgeStmtNode__Group__2 : rule__EdgeStmtNode__Group__2__Impl ;
    public final void rule__EdgeStmtNode__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1016:1: ( rule__EdgeStmtNode__Group__2__Impl )
            // InternalDotParser.g:1017:2: rule__EdgeStmtNode__Group__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__EdgeStmtNode__Group__2__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeStmtNode__Group__2"


    // $ANTLR start "rule__EdgeStmtNode__Group__2__Impl"
    // InternalDotParser.g:1023:1: rule__EdgeStmtNode__Group__2__Impl : ( ( rule__EdgeStmtNode__AttrListsAssignment_2 )* ) ;
    public final void rule__EdgeStmtNode__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1027:1: ( ( ( rule__EdgeStmtNode__AttrListsAssignment_2 )* ) )
            // InternalDotParser.g:1028:1: ( ( rule__EdgeStmtNode__AttrListsAssignment_2 )* )
            {
            // InternalDotParser.g:1028:1: ( ( rule__EdgeStmtNode__AttrListsAssignment_2 )* )
            // InternalDotParser.g:1029:2: ( rule__EdgeStmtNode__AttrListsAssignment_2 )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeStmtNodeAccess().getAttrListsAssignment_2()); 
            }
            // InternalDotParser.g:1030:2: ( rule__EdgeStmtNode__AttrListsAssignment_2 )*
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( (LA15_0==LeftSquareBracket) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // InternalDotParser.g:1030:3: rule__EdgeStmtNode__AttrListsAssignment_2
            	    {
            	    pushFollow(FOLLOW_12);
            	    rule__EdgeStmtNode__AttrListsAssignment_2();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop15;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeStmtNodeAccess().getAttrListsAssignment_2()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeStmtNode__Group__2__Impl"


    // $ANTLR start "rule__NodeStmt__Group__0"
    // InternalDotParser.g:1039:1: rule__NodeStmt__Group__0 : rule__NodeStmt__Group__0__Impl rule__NodeStmt__Group__1 ;
    public final void rule__NodeStmt__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1043:1: ( rule__NodeStmt__Group__0__Impl rule__NodeStmt__Group__1 )
            // InternalDotParser.g:1044:2: rule__NodeStmt__Group__0__Impl rule__NodeStmt__Group__1
            {
            pushFollow(FOLLOW_10);
            rule__NodeStmt__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__NodeStmt__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeStmt__Group__0"


    // $ANTLR start "rule__NodeStmt__Group__0__Impl"
    // InternalDotParser.g:1051:1: rule__NodeStmt__Group__0__Impl : ( ( rule__NodeStmt__NodeAssignment_0 ) ) ;
    public final void rule__NodeStmt__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1055:1: ( ( ( rule__NodeStmt__NodeAssignment_0 ) ) )
            // InternalDotParser.g:1056:1: ( ( rule__NodeStmt__NodeAssignment_0 ) )
            {
            // InternalDotParser.g:1056:1: ( ( rule__NodeStmt__NodeAssignment_0 ) )
            // InternalDotParser.g:1057:2: ( rule__NodeStmt__NodeAssignment_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeStmtAccess().getNodeAssignment_0()); 
            }
            // InternalDotParser.g:1058:2: ( rule__NodeStmt__NodeAssignment_0 )
            // InternalDotParser.g:1058:3: rule__NodeStmt__NodeAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__NodeStmt__NodeAssignment_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeStmtAccess().getNodeAssignment_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeStmt__Group__0__Impl"


    // $ANTLR start "rule__NodeStmt__Group__1"
    // InternalDotParser.g:1066:1: rule__NodeStmt__Group__1 : rule__NodeStmt__Group__1__Impl ;
    public final void rule__NodeStmt__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1070:1: ( rule__NodeStmt__Group__1__Impl )
            // InternalDotParser.g:1071:2: rule__NodeStmt__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__NodeStmt__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeStmt__Group__1"


    // $ANTLR start "rule__NodeStmt__Group__1__Impl"
    // InternalDotParser.g:1077:1: rule__NodeStmt__Group__1__Impl : ( ( rule__NodeStmt__AttrListsAssignment_1 )* ) ;
    public final void rule__NodeStmt__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1081:1: ( ( ( rule__NodeStmt__AttrListsAssignment_1 )* ) )
            // InternalDotParser.g:1082:1: ( ( rule__NodeStmt__AttrListsAssignment_1 )* )
            {
            // InternalDotParser.g:1082:1: ( ( rule__NodeStmt__AttrListsAssignment_1 )* )
            // InternalDotParser.g:1083:2: ( rule__NodeStmt__AttrListsAssignment_1 )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeStmtAccess().getAttrListsAssignment_1()); 
            }
            // InternalDotParser.g:1084:2: ( rule__NodeStmt__AttrListsAssignment_1 )*
            loop16:
            do {
                int alt16=2;
                int LA16_0 = input.LA(1);

                if ( (LA16_0==LeftSquareBracket) ) {
                    alt16=1;
                }


                switch (alt16) {
            	case 1 :
            	    // InternalDotParser.g:1084:3: rule__NodeStmt__AttrListsAssignment_1
            	    {
            	    pushFollow(FOLLOW_12);
            	    rule__NodeStmt__AttrListsAssignment_1();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop16;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeStmtAccess().getAttrListsAssignment_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeStmt__Group__1__Impl"


    // $ANTLR start "rule__AttrStmt__Group__0"
    // InternalDotParser.g:1093:1: rule__AttrStmt__Group__0 : rule__AttrStmt__Group__0__Impl rule__AttrStmt__Group__1 ;
    public final void rule__AttrStmt__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1097:1: ( rule__AttrStmt__Group__0__Impl rule__AttrStmt__Group__1 )
            // InternalDotParser.g:1098:2: rule__AttrStmt__Group__0__Impl rule__AttrStmt__Group__1
            {
            pushFollow(FOLLOW_10);
            rule__AttrStmt__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__AttrStmt__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrStmt__Group__0"


    // $ANTLR start "rule__AttrStmt__Group__0__Impl"
    // InternalDotParser.g:1105:1: rule__AttrStmt__Group__0__Impl : ( ( rule__AttrStmt__TypeAssignment_0 ) ) ;
    public final void rule__AttrStmt__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1109:1: ( ( ( rule__AttrStmt__TypeAssignment_0 ) ) )
            // InternalDotParser.g:1110:1: ( ( rule__AttrStmt__TypeAssignment_0 ) )
            {
            // InternalDotParser.g:1110:1: ( ( rule__AttrStmt__TypeAssignment_0 ) )
            // InternalDotParser.g:1111:2: ( rule__AttrStmt__TypeAssignment_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrStmtAccess().getTypeAssignment_0()); 
            }
            // InternalDotParser.g:1112:2: ( rule__AttrStmt__TypeAssignment_0 )
            // InternalDotParser.g:1112:3: rule__AttrStmt__TypeAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__AttrStmt__TypeAssignment_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrStmtAccess().getTypeAssignment_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrStmt__Group__0__Impl"


    // $ANTLR start "rule__AttrStmt__Group__1"
    // InternalDotParser.g:1120:1: rule__AttrStmt__Group__1 : rule__AttrStmt__Group__1__Impl ;
    public final void rule__AttrStmt__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1124:1: ( rule__AttrStmt__Group__1__Impl )
            // InternalDotParser.g:1125:2: rule__AttrStmt__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__AttrStmt__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrStmt__Group__1"


    // $ANTLR start "rule__AttrStmt__Group__1__Impl"
    // InternalDotParser.g:1131:1: rule__AttrStmt__Group__1__Impl : ( ( ( rule__AttrStmt__AttrListsAssignment_1 ) ) ( ( rule__AttrStmt__AttrListsAssignment_1 )* ) ) ;
    public final void rule__AttrStmt__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1135:1: ( ( ( ( rule__AttrStmt__AttrListsAssignment_1 ) ) ( ( rule__AttrStmt__AttrListsAssignment_1 )* ) ) )
            // InternalDotParser.g:1136:1: ( ( ( rule__AttrStmt__AttrListsAssignment_1 ) ) ( ( rule__AttrStmt__AttrListsAssignment_1 )* ) )
            {
            // InternalDotParser.g:1136:1: ( ( ( rule__AttrStmt__AttrListsAssignment_1 ) ) ( ( rule__AttrStmt__AttrListsAssignment_1 )* ) )
            // InternalDotParser.g:1137:2: ( ( rule__AttrStmt__AttrListsAssignment_1 ) ) ( ( rule__AttrStmt__AttrListsAssignment_1 )* )
            {
            // InternalDotParser.g:1137:2: ( ( rule__AttrStmt__AttrListsAssignment_1 ) )
            // InternalDotParser.g:1138:3: ( rule__AttrStmt__AttrListsAssignment_1 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrStmtAccess().getAttrListsAssignment_1()); 
            }
            // InternalDotParser.g:1139:3: ( rule__AttrStmt__AttrListsAssignment_1 )
            // InternalDotParser.g:1139:4: rule__AttrStmt__AttrListsAssignment_1
            {
            pushFollow(FOLLOW_12);
            rule__AttrStmt__AttrListsAssignment_1();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrStmtAccess().getAttrListsAssignment_1()); 
            }

            }

            // InternalDotParser.g:1142:2: ( ( rule__AttrStmt__AttrListsAssignment_1 )* )
            // InternalDotParser.g:1143:3: ( rule__AttrStmt__AttrListsAssignment_1 )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrStmtAccess().getAttrListsAssignment_1()); 
            }
            // InternalDotParser.g:1144:3: ( rule__AttrStmt__AttrListsAssignment_1 )*
            loop17:
            do {
                int alt17=2;
                int LA17_0 = input.LA(1);

                if ( (LA17_0==LeftSquareBracket) ) {
                    alt17=1;
                }


                switch (alt17) {
            	case 1 :
            	    // InternalDotParser.g:1144:4: rule__AttrStmt__AttrListsAssignment_1
            	    {
            	    pushFollow(FOLLOW_12);
            	    rule__AttrStmt__AttrListsAssignment_1();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop17;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrStmtAccess().getAttrListsAssignment_1()); 
            }

            }


            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrStmt__Group__1__Impl"


    // $ANTLR start "rule__AttrList__Group__0"
    // InternalDotParser.g:1154:1: rule__AttrList__Group__0 : rule__AttrList__Group__0__Impl rule__AttrList__Group__1 ;
    public final void rule__AttrList__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1158:1: ( rule__AttrList__Group__0__Impl rule__AttrList__Group__1 )
            // InternalDotParser.g:1159:2: rule__AttrList__Group__0__Impl rule__AttrList__Group__1
            {
            pushFollow(FOLLOW_10);
            rule__AttrList__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__AttrList__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group__0"


    // $ANTLR start "rule__AttrList__Group__0__Impl"
    // InternalDotParser.g:1166:1: rule__AttrList__Group__0__Impl : ( () ) ;
    public final void rule__AttrList__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1170:1: ( ( () ) )
            // InternalDotParser.g:1171:1: ( () )
            {
            // InternalDotParser.g:1171:1: ( () )
            // InternalDotParser.g:1172:2: ()
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrListAccess().getAttrListAction_0()); 
            }
            // InternalDotParser.g:1173:2: ()
            // InternalDotParser.g:1173:3: 
            {
            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrListAccess().getAttrListAction_0()); 
            }

            }


            }

        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group__0__Impl"


    // $ANTLR start "rule__AttrList__Group__1"
    // InternalDotParser.g:1181:1: rule__AttrList__Group__1 : rule__AttrList__Group__1__Impl rule__AttrList__Group__2 ;
    public final void rule__AttrList__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1185:1: ( rule__AttrList__Group__1__Impl rule__AttrList__Group__2 )
            // InternalDotParser.g:1186:2: rule__AttrList__Group__1__Impl rule__AttrList__Group__2
            {
            pushFollow(FOLLOW_13);
            rule__AttrList__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__AttrList__Group__2();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group__1"


    // $ANTLR start "rule__AttrList__Group__1__Impl"
    // InternalDotParser.g:1193:1: rule__AttrList__Group__1__Impl : ( LeftSquareBracket ) ;
    public final void rule__AttrList__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1197:1: ( ( LeftSquareBracket ) )
            // InternalDotParser.g:1198:1: ( LeftSquareBracket )
            {
            // InternalDotParser.g:1198:1: ( LeftSquareBracket )
            // InternalDotParser.g:1199:2: LeftSquareBracket
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrListAccess().getLeftSquareBracketKeyword_1()); 
            }
            match(input,LeftSquareBracket,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrListAccess().getLeftSquareBracketKeyword_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group__1__Impl"


    // $ANTLR start "rule__AttrList__Group__2"
    // InternalDotParser.g:1208:1: rule__AttrList__Group__2 : rule__AttrList__Group__2__Impl rule__AttrList__Group__3 ;
    public final void rule__AttrList__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1212:1: ( rule__AttrList__Group__2__Impl rule__AttrList__Group__3 )
            // InternalDotParser.g:1213:2: rule__AttrList__Group__2__Impl rule__AttrList__Group__3
            {
            pushFollow(FOLLOW_13);
            rule__AttrList__Group__2__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__AttrList__Group__3();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group__2"


    // $ANTLR start "rule__AttrList__Group__2__Impl"
    // InternalDotParser.g:1220:1: rule__AttrList__Group__2__Impl : ( ( rule__AttrList__Group_2__0 )* ) ;
    public final void rule__AttrList__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1224:1: ( ( ( rule__AttrList__Group_2__0 )* ) )
            // InternalDotParser.g:1225:1: ( ( rule__AttrList__Group_2__0 )* )
            {
            // InternalDotParser.g:1225:1: ( ( rule__AttrList__Group_2__0 )* )
            // InternalDotParser.g:1226:2: ( rule__AttrList__Group_2__0 )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrListAccess().getGroup_2()); 
            }
            // InternalDotParser.g:1227:2: ( rule__AttrList__Group_2__0 )*
            loop18:
            do {
                int alt18=2;
                int LA18_0 = input.LA(1);

                if ( ((LA18_0>=RULE_NUMERAL && LA18_0<=RULE_QUOTED_STRING)||LA18_0==RULE_HTML_STRING) ) {
                    alt18=1;
                }


                switch (alt18) {
            	case 1 :
            	    // InternalDotParser.g:1227:3: rule__AttrList__Group_2__0
            	    {
            	    pushFollow(FOLLOW_14);
            	    rule__AttrList__Group_2__0();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop18;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrListAccess().getGroup_2()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group__2__Impl"


    // $ANTLR start "rule__AttrList__Group__3"
    // InternalDotParser.g:1235:1: rule__AttrList__Group__3 : rule__AttrList__Group__3__Impl ;
    public final void rule__AttrList__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1239:1: ( rule__AttrList__Group__3__Impl )
            // InternalDotParser.g:1240:2: rule__AttrList__Group__3__Impl
            {
            pushFollow(FOLLOW_2);
            rule__AttrList__Group__3__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group__3"


    // $ANTLR start "rule__AttrList__Group__3__Impl"
    // InternalDotParser.g:1246:1: rule__AttrList__Group__3__Impl : ( RightSquareBracket ) ;
    public final void rule__AttrList__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1250:1: ( ( RightSquareBracket ) )
            // InternalDotParser.g:1251:1: ( RightSquareBracket )
            {
            // InternalDotParser.g:1251:1: ( RightSquareBracket )
            // InternalDotParser.g:1252:2: RightSquareBracket
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrListAccess().getRightSquareBracketKeyword_3()); 
            }
            match(input,RightSquareBracket,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrListAccess().getRightSquareBracketKeyword_3()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group__3__Impl"


    // $ANTLR start "rule__AttrList__Group_2__0"
    // InternalDotParser.g:1262:1: rule__AttrList__Group_2__0 : rule__AttrList__Group_2__0__Impl rule__AttrList__Group_2__1 ;
    public final void rule__AttrList__Group_2__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1266:1: ( rule__AttrList__Group_2__0__Impl rule__AttrList__Group_2__1 )
            // InternalDotParser.g:1267:2: rule__AttrList__Group_2__0__Impl rule__AttrList__Group_2__1
            {
            pushFollow(FOLLOW_15);
            rule__AttrList__Group_2__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__AttrList__Group_2__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group_2__0"


    // $ANTLR start "rule__AttrList__Group_2__0__Impl"
    // InternalDotParser.g:1274:1: rule__AttrList__Group_2__0__Impl : ( ( rule__AttrList__AttributesAssignment_2_0 ) ) ;
    public final void rule__AttrList__Group_2__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1278:1: ( ( ( rule__AttrList__AttributesAssignment_2_0 ) ) )
            // InternalDotParser.g:1279:1: ( ( rule__AttrList__AttributesAssignment_2_0 ) )
            {
            // InternalDotParser.g:1279:1: ( ( rule__AttrList__AttributesAssignment_2_0 ) )
            // InternalDotParser.g:1280:2: ( rule__AttrList__AttributesAssignment_2_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrListAccess().getAttributesAssignment_2_0()); 
            }
            // InternalDotParser.g:1281:2: ( rule__AttrList__AttributesAssignment_2_0 )
            // InternalDotParser.g:1281:3: rule__AttrList__AttributesAssignment_2_0
            {
            pushFollow(FOLLOW_2);
            rule__AttrList__AttributesAssignment_2_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrListAccess().getAttributesAssignment_2_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group_2__0__Impl"


    // $ANTLR start "rule__AttrList__Group_2__1"
    // InternalDotParser.g:1289:1: rule__AttrList__Group_2__1 : rule__AttrList__Group_2__1__Impl ;
    public final void rule__AttrList__Group_2__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1293:1: ( rule__AttrList__Group_2__1__Impl )
            // InternalDotParser.g:1294:2: rule__AttrList__Group_2__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__AttrList__Group_2__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group_2__1"


    // $ANTLR start "rule__AttrList__Group_2__1__Impl"
    // InternalDotParser.g:1300:1: rule__AttrList__Group_2__1__Impl : ( ( rule__AttrList__Alternatives_2_1 )? ) ;
    public final void rule__AttrList__Group_2__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1304:1: ( ( ( rule__AttrList__Alternatives_2_1 )? ) )
            // InternalDotParser.g:1305:1: ( ( rule__AttrList__Alternatives_2_1 )? )
            {
            // InternalDotParser.g:1305:1: ( ( rule__AttrList__Alternatives_2_1 )? )
            // InternalDotParser.g:1306:2: ( rule__AttrList__Alternatives_2_1 )?
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrListAccess().getAlternatives_2_1()); 
            }
            // InternalDotParser.g:1307:2: ( rule__AttrList__Alternatives_2_1 )?
            int alt19=2;
            int LA19_0 = input.LA(1);

            if ( (LA19_0==Comma||LA19_0==Semicolon) ) {
                alt19=1;
            }
            switch (alt19) {
                case 1 :
                    // InternalDotParser.g:1307:3: rule__AttrList__Alternatives_2_1
                    {
                    pushFollow(FOLLOW_2);
                    rule__AttrList__Alternatives_2_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrListAccess().getAlternatives_2_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__Group_2__1__Impl"


    // $ANTLR start "rule__Attribute__Group__0"
    // InternalDotParser.g:1316:1: rule__Attribute__Group__0 : rule__Attribute__Group__0__Impl rule__Attribute__Group__1 ;
    public final void rule__Attribute__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1320:1: ( rule__Attribute__Group__0__Impl rule__Attribute__Group__1 )
            // InternalDotParser.g:1321:2: rule__Attribute__Group__0__Impl rule__Attribute__Group__1
            {
            pushFollow(FOLLOW_16);
            rule__Attribute__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Attribute__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__Group__0"


    // $ANTLR start "rule__Attribute__Group__0__Impl"
    // InternalDotParser.g:1328:1: rule__Attribute__Group__0__Impl : ( ( rule__Attribute__NameAssignment_0 ) ) ;
    public final void rule__Attribute__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1332:1: ( ( ( rule__Attribute__NameAssignment_0 ) ) )
            // InternalDotParser.g:1333:1: ( ( rule__Attribute__NameAssignment_0 ) )
            {
            // InternalDotParser.g:1333:1: ( ( rule__Attribute__NameAssignment_0 ) )
            // InternalDotParser.g:1334:2: ( rule__Attribute__NameAssignment_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttributeAccess().getNameAssignment_0()); 
            }
            // InternalDotParser.g:1335:2: ( rule__Attribute__NameAssignment_0 )
            // InternalDotParser.g:1335:3: rule__Attribute__NameAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__Attribute__NameAssignment_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttributeAccess().getNameAssignment_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__Group__0__Impl"


    // $ANTLR start "rule__Attribute__Group__1"
    // InternalDotParser.g:1343:1: rule__Attribute__Group__1 : rule__Attribute__Group__1__Impl rule__Attribute__Group__2 ;
    public final void rule__Attribute__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1347:1: ( rule__Attribute__Group__1__Impl rule__Attribute__Group__2 )
            // InternalDotParser.g:1348:2: rule__Attribute__Group__1__Impl rule__Attribute__Group__2
            {
            pushFollow(FOLLOW_17);
            rule__Attribute__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Attribute__Group__2();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__Group__1"


    // $ANTLR start "rule__Attribute__Group__1__Impl"
    // InternalDotParser.g:1355:1: rule__Attribute__Group__1__Impl : ( EqualsSign ) ;
    public final void rule__Attribute__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1359:1: ( ( EqualsSign ) )
            // InternalDotParser.g:1360:1: ( EqualsSign )
            {
            // InternalDotParser.g:1360:1: ( EqualsSign )
            // InternalDotParser.g:1361:2: EqualsSign
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttributeAccess().getEqualsSignKeyword_1()); 
            }
            match(input,EqualsSign,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttributeAccess().getEqualsSignKeyword_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__Group__1__Impl"


    // $ANTLR start "rule__Attribute__Group__2"
    // InternalDotParser.g:1370:1: rule__Attribute__Group__2 : rule__Attribute__Group__2__Impl ;
    public final void rule__Attribute__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1374:1: ( rule__Attribute__Group__2__Impl )
            // InternalDotParser.g:1375:2: rule__Attribute__Group__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Attribute__Group__2__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__Group__2"


    // $ANTLR start "rule__Attribute__Group__2__Impl"
    // InternalDotParser.g:1381:1: rule__Attribute__Group__2__Impl : ( ( rule__Attribute__ValueAssignment_2 ) ) ;
    public final void rule__Attribute__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1385:1: ( ( ( rule__Attribute__ValueAssignment_2 ) ) )
            // InternalDotParser.g:1386:1: ( ( rule__Attribute__ValueAssignment_2 ) )
            {
            // InternalDotParser.g:1386:1: ( ( rule__Attribute__ValueAssignment_2 ) )
            // InternalDotParser.g:1387:2: ( rule__Attribute__ValueAssignment_2 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttributeAccess().getValueAssignment_2()); 
            }
            // InternalDotParser.g:1388:2: ( rule__Attribute__ValueAssignment_2 )
            // InternalDotParser.g:1388:3: rule__Attribute__ValueAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__Attribute__ValueAssignment_2();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttributeAccess().getValueAssignment_2()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__Group__2__Impl"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group__0"
    // InternalDotParser.g:1397:1: rule__SubgraphOrEdgeStmtSubgraph__Group__0 : rule__SubgraphOrEdgeStmtSubgraph__Group__0__Impl rule__SubgraphOrEdgeStmtSubgraph__Group__1 ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1401:1: ( rule__SubgraphOrEdgeStmtSubgraph__Group__0__Impl rule__SubgraphOrEdgeStmtSubgraph__Group__1 )
            // InternalDotParser.g:1402:2: rule__SubgraphOrEdgeStmtSubgraph__Group__0__Impl rule__SubgraphOrEdgeStmtSubgraph__Group__1
            {
            pushFollow(FOLLOW_9);
            rule__SubgraphOrEdgeStmtSubgraph__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__SubgraphOrEdgeStmtSubgraph__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group__0"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group__0__Impl"
    // InternalDotParser.g:1409:1: rule__SubgraphOrEdgeStmtSubgraph__Group__0__Impl : ( ruleSubgraph ) ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1413:1: ( ( ruleSubgraph ) )
            // InternalDotParser.g:1414:1: ( ruleSubgraph )
            {
            // InternalDotParser.g:1414:1: ( ruleSubgraph )
            // InternalDotParser.g:1415:2: ruleSubgraph
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getSubgraphParserRuleCall_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleSubgraph();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getSubgraphParserRuleCall_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group__0__Impl"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group__1"
    // InternalDotParser.g:1424:1: rule__SubgraphOrEdgeStmtSubgraph__Group__1 : rule__SubgraphOrEdgeStmtSubgraph__Group__1__Impl ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1428:1: ( rule__SubgraphOrEdgeStmtSubgraph__Group__1__Impl )
            // InternalDotParser.g:1429:2: rule__SubgraphOrEdgeStmtSubgraph__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__SubgraphOrEdgeStmtSubgraph__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group__1"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group__1__Impl"
    // InternalDotParser.g:1435:1: rule__SubgraphOrEdgeStmtSubgraph__Group__1__Impl : ( ( rule__SubgraphOrEdgeStmtSubgraph__Group_1__0 )? ) ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1439:1: ( ( ( rule__SubgraphOrEdgeStmtSubgraph__Group_1__0 )? ) )
            // InternalDotParser.g:1440:1: ( ( rule__SubgraphOrEdgeStmtSubgraph__Group_1__0 )? )
            {
            // InternalDotParser.g:1440:1: ( ( rule__SubgraphOrEdgeStmtSubgraph__Group_1__0 )? )
            // InternalDotParser.g:1441:2: ( rule__SubgraphOrEdgeStmtSubgraph__Group_1__0 )?
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getGroup_1()); 
            }
            // InternalDotParser.g:1442:2: ( rule__SubgraphOrEdgeStmtSubgraph__Group_1__0 )?
            int alt20=2;
            int LA20_0 = input.LA(1);

            if ( ((LA20_0>=HyphenMinusHyphenMinus && LA20_0<=HyphenMinusGreaterThanSign)) ) {
                alt20=1;
            }
            switch (alt20) {
                case 1 :
                    // InternalDotParser.g:1442:3: rule__SubgraphOrEdgeStmtSubgraph__Group_1__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__SubgraphOrEdgeStmtSubgraph__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getGroup_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group__1__Impl"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group_1__0"
    // InternalDotParser.g:1451:1: rule__SubgraphOrEdgeStmtSubgraph__Group_1__0 : rule__SubgraphOrEdgeStmtSubgraph__Group_1__0__Impl rule__SubgraphOrEdgeStmtSubgraph__Group_1__1 ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1455:1: ( rule__SubgraphOrEdgeStmtSubgraph__Group_1__0__Impl rule__SubgraphOrEdgeStmtSubgraph__Group_1__1 )
            // InternalDotParser.g:1456:2: rule__SubgraphOrEdgeStmtSubgraph__Group_1__0__Impl rule__SubgraphOrEdgeStmtSubgraph__Group_1__1
            {
            pushFollow(FOLLOW_9);
            rule__SubgraphOrEdgeStmtSubgraph__Group_1__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__SubgraphOrEdgeStmtSubgraph__Group_1__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group_1__0"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group_1__0__Impl"
    // InternalDotParser.g:1463:1: rule__SubgraphOrEdgeStmtSubgraph__Group_1__0__Impl : ( () ) ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1467:1: ( ( () ) )
            // InternalDotParser.g:1468:1: ( () )
            {
            // InternalDotParser.g:1468:1: ( () )
            // InternalDotParser.g:1469:2: ()
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getEdgeStmtSubgraphSubgraphAction_1_0()); 
            }
            // InternalDotParser.g:1470:2: ()
            // InternalDotParser.g:1470:3: 
            {
            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getEdgeStmtSubgraphSubgraphAction_1_0()); 
            }

            }


            }

        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group_1__0__Impl"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group_1__1"
    // InternalDotParser.g:1478:1: rule__SubgraphOrEdgeStmtSubgraph__Group_1__1 : rule__SubgraphOrEdgeStmtSubgraph__Group_1__1__Impl rule__SubgraphOrEdgeStmtSubgraph__Group_1__2 ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1482:1: ( rule__SubgraphOrEdgeStmtSubgraph__Group_1__1__Impl rule__SubgraphOrEdgeStmtSubgraph__Group_1__2 )
            // InternalDotParser.g:1483:2: rule__SubgraphOrEdgeStmtSubgraph__Group_1__1__Impl rule__SubgraphOrEdgeStmtSubgraph__Group_1__2
            {
            pushFollow(FOLLOW_10);
            rule__SubgraphOrEdgeStmtSubgraph__Group_1__1__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__SubgraphOrEdgeStmtSubgraph__Group_1__2();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group_1__1"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group_1__1__Impl"
    // InternalDotParser.g:1490:1: rule__SubgraphOrEdgeStmtSubgraph__Group_1__1__Impl : ( ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 ) ) ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )* ) ) ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1494:1: ( ( ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 ) ) ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )* ) ) )
            // InternalDotParser.g:1495:1: ( ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 ) ) ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )* ) )
            {
            // InternalDotParser.g:1495:1: ( ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 ) ) ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )* ) )
            // InternalDotParser.g:1496:2: ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 ) ) ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )* )
            {
            // InternalDotParser.g:1496:2: ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 ) )
            // InternalDotParser.g:1497:3: ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getEdgeRHSAssignment_1_1()); 
            }
            // InternalDotParser.g:1498:3: ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )
            // InternalDotParser.g:1498:4: rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1
            {
            pushFollow(FOLLOW_11);
            rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getEdgeRHSAssignment_1_1()); 
            }

            }

            // InternalDotParser.g:1501:2: ( ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )* )
            // InternalDotParser.g:1502:3: ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getEdgeRHSAssignment_1_1()); 
            }
            // InternalDotParser.g:1503:3: ( rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 )*
            loop21:
            do {
                int alt21=2;
                int LA21_0 = input.LA(1);

                if ( ((LA21_0>=HyphenMinusHyphenMinus && LA21_0<=HyphenMinusGreaterThanSign)) ) {
                    alt21=1;
                }


                switch (alt21) {
            	case 1 :
            	    // InternalDotParser.g:1503:4: rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1
            	    {
            	    pushFollow(FOLLOW_11);
            	    rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop21;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getEdgeRHSAssignment_1_1()); 
            }

            }


            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group_1__1__Impl"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group_1__2"
    // InternalDotParser.g:1512:1: rule__SubgraphOrEdgeStmtSubgraph__Group_1__2 : rule__SubgraphOrEdgeStmtSubgraph__Group_1__2__Impl ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group_1__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1516:1: ( rule__SubgraphOrEdgeStmtSubgraph__Group_1__2__Impl )
            // InternalDotParser.g:1517:2: rule__SubgraphOrEdgeStmtSubgraph__Group_1__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__SubgraphOrEdgeStmtSubgraph__Group_1__2__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group_1__2"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__Group_1__2__Impl"
    // InternalDotParser.g:1523:1: rule__SubgraphOrEdgeStmtSubgraph__Group_1__2__Impl : ( ( rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2 )* ) ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__Group_1__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1527:1: ( ( ( rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2 )* ) )
            // InternalDotParser.g:1528:1: ( ( rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2 )* )
            {
            // InternalDotParser.g:1528:1: ( ( rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2 )* )
            // InternalDotParser.g:1529:2: ( rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2 )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getAttrListsAssignment_1_2()); 
            }
            // InternalDotParser.g:1530:2: ( rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2 )*
            loop22:
            do {
                int alt22=2;
                int LA22_0 = input.LA(1);

                if ( (LA22_0==LeftSquareBracket) ) {
                    alt22=1;
                }


                switch (alt22) {
            	case 1 :
            	    // InternalDotParser.g:1530:3: rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2
            	    {
            	    pushFollow(FOLLOW_12);
            	    rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop22;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getAttrListsAssignment_1_2()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__Group_1__2__Impl"


    // $ANTLR start "rule__Subgraph__Group__0"
    // InternalDotParser.g:1539:1: rule__Subgraph__Group__0 : rule__Subgraph__Group__0__Impl rule__Subgraph__Group__1 ;
    public final void rule__Subgraph__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1543:1: ( rule__Subgraph__Group__0__Impl rule__Subgraph__Group__1 )
            // InternalDotParser.g:1544:2: rule__Subgraph__Group__0__Impl rule__Subgraph__Group__1
            {
            pushFollow(FOLLOW_18);
            rule__Subgraph__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Subgraph__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__0"


    // $ANTLR start "rule__Subgraph__Group__0__Impl"
    // InternalDotParser.g:1551:1: rule__Subgraph__Group__0__Impl : ( () ) ;
    public final void rule__Subgraph__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1555:1: ( ( () ) )
            // InternalDotParser.g:1556:1: ( () )
            {
            // InternalDotParser.g:1556:1: ( () )
            // InternalDotParser.g:1557:2: ()
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getSubgraphAction_0()); 
            }
            // InternalDotParser.g:1558:2: ()
            // InternalDotParser.g:1558:3: 
            {
            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getSubgraphAction_0()); 
            }

            }


            }

        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__0__Impl"


    // $ANTLR start "rule__Subgraph__Group__1"
    // InternalDotParser.g:1566:1: rule__Subgraph__Group__1 : rule__Subgraph__Group__1__Impl rule__Subgraph__Group__2 ;
    public final void rule__Subgraph__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1570:1: ( rule__Subgraph__Group__1__Impl rule__Subgraph__Group__2 )
            // InternalDotParser.g:1571:2: rule__Subgraph__Group__1__Impl rule__Subgraph__Group__2
            {
            pushFollow(FOLLOW_18);
            rule__Subgraph__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Subgraph__Group__2();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__1"


    // $ANTLR start "rule__Subgraph__Group__1__Impl"
    // InternalDotParser.g:1578:1: rule__Subgraph__Group__1__Impl : ( ( rule__Subgraph__Group_1__0 )? ) ;
    public final void rule__Subgraph__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1582:1: ( ( ( rule__Subgraph__Group_1__0 )? ) )
            // InternalDotParser.g:1583:1: ( ( rule__Subgraph__Group_1__0 )? )
            {
            // InternalDotParser.g:1583:1: ( ( rule__Subgraph__Group_1__0 )? )
            // InternalDotParser.g:1584:2: ( rule__Subgraph__Group_1__0 )?
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getGroup_1()); 
            }
            // InternalDotParser.g:1585:2: ( rule__Subgraph__Group_1__0 )?
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==Subgraph) ) {
                alt23=1;
            }
            switch (alt23) {
                case 1 :
                    // InternalDotParser.g:1585:3: rule__Subgraph__Group_1__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Subgraph__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getGroup_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__1__Impl"


    // $ANTLR start "rule__Subgraph__Group__2"
    // InternalDotParser.g:1593:1: rule__Subgraph__Group__2 : rule__Subgraph__Group__2__Impl rule__Subgraph__Group__3 ;
    public final void rule__Subgraph__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1597:1: ( rule__Subgraph__Group__2__Impl rule__Subgraph__Group__3 )
            // InternalDotParser.g:1598:2: rule__Subgraph__Group__2__Impl rule__Subgraph__Group__3
            {
            pushFollow(FOLLOW_6);
            rule__Subgraph__Group__2__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Subgraph__Group__3();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__2"


    // $ANTLR start "rule__Subgraph__Group__2__Impl"
    // InternalDotParser.g:1605:1: rule__Subgraph__Group__2__Impl : ( LeftCurlyBracket ) ;
    public final void rule__Subgraph__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1609:1: ( ( LeftCurlyBracket ) )
            // InternalDotParser.g:1610:1: ( LeftCurlyBracket )
            {
            // InternalDotParser.g:1610:1: ( LeftCurlyBracket )
            // InternalDotParser.g:1611:2: LeftCurlyBracket
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getLeftCurlyBracketKeyword_2()); 
            }
            match(input,LeftCurlyBracket,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getLeftCurlyBracketKeyword_2()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__2__Impl"


    // $ANTLR start "rule__Subgraph__Group__3"
    // InternalDotParser.g:1620:1: rule__Subgraph__Group__3 : rule__Subgraph__Group__3__Impl rule__Subgraph__Group__4 ;
    public final void rule__Subgraph__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1624:1: ( rule__Subgraph__Group__3__Impl rule__Subgraph__Group__4 )
            // InternalDotParser.g:1625:2: rule__Subgraph__Group__3__Impl rule__Subgraph__Group__4
            {
            pushFollow(FOLLOW_6);
            rule__Subgraph__Group__3__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Subgraph__Group__4();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__3"


    // $ANTLR start "rule__Subgraph__Group__3__Impl"
    // InternalDotParser.g:1632:1: rule__Subgraph__Group__3__Impl : ( ( rule__Subgraph__StmtsAssignment_3 )* ) ;
    public final void rule__Subgraph__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1636:1: ( ( ( rule__Subgraph__StmtsAssignment_3 )* ) )
            // InternalDotParser.g:1637:1: ( ( rule__Subgraph__StmtsAssignment_3 )* )
            {
            // InternalDotParser.g:1637:1: ( ( rule__Subgraph__StmtsAssignment_3 )* )
            // InternalDotParser.g:1638:2: ( rule__Subgraph__StmtsAssignment_3 )*
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getStmtsAssignment_3()); 
            }
            // InternalDotParser.g:1639:2: ( rule__Subgraph__StmtsAssignment_3 )*
            loop24:
            do {
                int alt24=2;
                int LA24_0 = input.LA(1);

                if ( (LA24_0==Subgraph||(LA24_0>=Graph && LA24_0<=Node)||LA24_0==LeftCurlyBracket||(LA24_0>=RULE_NUMERAL && LA24_0<=RULE_QUOTED_STRING)||LA24_0==RULE_HTML_STRING) ) {
                    alt24=1;
                }


                switch (alt24) {
            	case 1 :
            	    // InternalDotParser.g:1639:3: rule__Subgraph__StmtsAssignment_3
            	    {
            	    pushFollow(FOLLOW_7);
            	    rule__Subgraph__StmtsAssignment_3();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop24;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getStmtsAssignment_3()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__3__Impl"


    // $ANTLR start "rule__Subgraph__Group__4"
    // InternalDotParser.g:1647:1: rule__Subgraph__Group__4 : rule__Subgraph__Group__4__Impl ;
    public final void rule__Subgraph__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1651:1: ( rule__Subgraph__Group__4__Impl )
            // InternalDotParser.g:1652:2: rule__Subgraph__Group__4__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Subgraph__Group__4__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__4"


    // $ANTLR start "rule__Subgraph__Group__4__Impl"
    // InternalDotParser.g:1658:1: rule__Subgraph__Group__4__Impl : ( RightCurlyBracket ) ;
    public final void rule__Subgraph__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1662:1: ( ( RightCurlyBracket ) )
            // InternalDotParser.g:1663:1: ( RightCurlyBracket )
            {
            // InternalDotParser.g:1663:1: ( RightCurlyBracket )
            // InternalDotParser.g:1664:2: RightCurlyBracket
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getRightCurlyBracketKeyword_4()); 
            }
            match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getRightCurlyBracketKeyword_4()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group__4__Impl"


    // $ANTLR start "rule__Subgraph__Group_1__0"
    // InternalDotParser.g:1674:1: rule__Subgraph__Group_1__0 : rule__Subgraph__Group_1__0__Impl rule__Subgraph__Group_1__1 ;
    public final void rule__Subgraph__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1678:1: ( rule__Subgraph__Group_1__0__Impl rule__Subgraph__Group_1__1 )
            // InternalDotParser.g:1679:2: rule__Subgraph__Group_1__0__Impl rule__Subgraph__Group_1__1
            {
            pushFollow(FOLLOW_17);
            rule__Subgraph__Group_1__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Subgraph__Group_1__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group_1__0"


    // $ANTLR start "rule__Subgraph__Group_1__0__Impl"
    // InternalDotParser.g:1686:1: rule__Subgraph__Group_1__0__Impl : ( Subgraph ) ;
    public final void rule__Subgraph__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1690:1: ( ( Subgraph ) )
            // InternalDotParser.g:1691:1: ( Subgraph )
            {
            // InternalDotParser.g:1691:1: ( Subgraph )
            // InternalDotParser.g:1692:2: Subgraph
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getSubgraphKeyword_1_0()); 
            }
            match(input,Subgraph,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getSubgraphKeyword_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group_1__0__Impl"


    // $ANTLR start "rule__Subgraph__Group_1__1"
    // InternalDotParser.g:1701:1: rule__Subgraph__Group_1__1 : rule__Subgraph__Group_1__1__Impl ;
    public final void rule__Subgraph__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1705:1: ( rule__Subgraph__Group_1__1__Impl )
            // InternalDotParser.g:1706:2: rule__Subgraph__Group_1__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Subgraph__Group_1__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group_1__1"


    // $ANTLR start "rule__Subgraph__Group_1__1__Impl"
    // InternalDotParser.g:1712:1: rule__Subgraph__Group_1__1__Impl : ( ( rule__Subgraph__NameAssignment_1_1 )? ) ;
    public final void rule__Subgraph__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1716:1: ( ( ( rule__Subgraph__NameAssignment_1_1 )? ) )
            // InternalDotParser.g:1717:1: ( ( rule__Subgraph__NameAssignment_1_1 )? )
            {
            // InternalDotParser.g:1717:1: ( ( rule__Subgraph__NameAssignment_1_1 )? )
            // InternalDotParser.g:1718:2: ( rule__Subgraph__NameAssignment_1_1 )?
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getNameAssignment_1_1()); 
            }
            // InternalDotParser.g:1719:2: ( rule__Subgraph__NameAssignment_1_1 )?
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( ((LA25_0>=RULE_NUMERAL && LA25_0<=RULE_QUOTED_STRING)||LA25_0==RULE_HTML_STRING) ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    // InternalDotParser.g:1719:3: rule__Subgraph__NameAssignment_1_1
                    {
                    pushFollow(FOLLOW_2);
                    rule__Subgraph__NameAssignment_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getNameAssignment_1_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__Group_1__1__Impl"


    // $ANTLR start "rule__Port__Group__0"
    // InternalDotParser.g:1728:1: rule__Port__Group__0 : rule__Port__Group__0__Impl rule__Port__Group__1 ;
    public final void rule__Port__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1732:1: ( rule__Port__Group__0__Impl rule__Port__Group__1 )
            // InternalDotParser.g:1733:2: rule__Port__Group__0__Impl rule__Port__Group__1
            {
            pushFollow(FOLLOW_17);
            rule__Port__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Port__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group__0"


    // $ANTLR start "rule__Port__Group__0__Impl"
    // InternalDotParser.g:1740:1: rule__Port__Group__0__Impl : ( Colon ) ;
    public final void rule__Port__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1744:1: ( ( Colon ) )
            // InternalDotParser.g:1745:1: ( Colon )
            {
            // InternalDotParser.g:1745:1: ( Colon )
            // InternalDotParser.g:1746:2: Colon
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getColonKeyword_0()); 
            }
            match(input,Colon,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getColonKeyword_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group__0__Impl"


    // $ANTLR start "rule__Port__Group__1"
    // InternalDotParser.g:1755:1: rule__Port__Group__1 : rule__Port__Group__1__Impl ;
    public final void rule__Port__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1759:1: ( rule__Port__Group__1__Impl )
            // InternalDotParser.g:1760:2: rule__Port__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Port__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group__1"


    // $ANTLR start "rule__Port__Group__1__Impl"
    // InternalDotParser.g:1766:1: rule__Port__Group__1__Impl : ( ( rule__Port__Alternatives_1 ) ) ;
    public final void rule__Port__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1770:1: ( ( ( rule__Port__Alternatives_1 ) ) )
            // InternalDotParser.g:1771:1: ( ( rule__Port__Alternatives_1 ) )
            {
            // InternalDotParser.g:1771:1: ( ( rule__Port__Alternatives_1 ) )
            // InternalDotParser.g:1772:2: ( rule__Port__Alternatives_1 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getAlternatives_1()); 
            }
            // InternalDotParser.g:1773:2: ( rule__Port__Alternatives_1 )
            // InternalDotParser.g:1773:3: rule__Port__Alternatives_1
            {
            pushFollow(FOLLOW_2);
            rule__Port__Alternatives_1();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getAlternatives_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group__1__Impl"


    // $ANTLR start "rule__Port__Group_1_2__0"
    // InternalDotParser.g:1782:1: rule__Port__Group_1_2__0 : rule__Port__Group_1_2__0__Impl rule__Port__Group_1_2__1 ;
    public final void rule__Port__Group_1_2__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1786:1: ( rule__Port__Group_1_2__0__Impl rule__Port__Group_1_2__1 )
            // InternalDotParser.g:1787:2: rule__Port__Group_1_2__0__Impl rule__Port__Group_1_2__1
            {
            pushFollow(FOLLOW_19);
            rule__Port__Group_1_2__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Port__Group_1_2__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group_1_2__0"


    // $ANTLR start "rule__Port__Group_1_2__0__Impl"
    // InternalDotParser.g:1794:1: rule__Port__Group_1_2__0__Impl : ( ( rule__Port__NameAssignment_1_2_0 ) ) ;
    public final void rule__Port__Group_1_2__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1798:1: ( ( ( rule__Port__NameAssignment_1_2_0 ) ) )
            // InternalDotParser.g:1799:1: ( ( rule__Port__NameAssignment_1_2_0 ) )
            {
            // InternalDotParser.g:1799:1: ( ( rule__Port__NameAssignment_1_2_0 ) )
            // InternalDotParser.g:1800:2: ( rule__Port__NameAssignment_1_2_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getNameAssignment_1_2_0()); 
            }
            // InternalDotParser.g:1801:2: ( rule__Port__NameAssignment_1_2_0 )
            // InternalDotParser.g:1801:3: rule__Port__NameAssignment_1_2_0
            {
            pushFollow(FOLLOW_2);
            rule__Port__NameAssignment_1_2_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getNameAssignment_1_2_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group_1_2__0__Impl"


    // $ANTLR start "rule__Port__Group_1_2__1"
    // InternalDotParser.g:1809:1: rule__Port__Group_1_2__1 : rule__Port__Group_1_2__1__Impl rule__Port__Group_1_2__2 ;
    public final void rule__Port__Group_1_2__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1813:1: ( rule__Port__Group_1_2__1__Impl rule__Port__Group_1_2__2 )
            // InternalDotParser.g:1814:2: rule__Port__Group_1_2__1__Impl rule__Port__Group_1_2__2
            {
            pushFollow(FOLLOW_20);
            rule__Port__Group_1_2__1__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__Port__Group_1_2__2();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group_1_2__1"


    // $ANTLR start "rule__Port__Group_1_2__1__Impl"
    // InternalDotParser.g:1821:1: rule__Port__Group_1_2__1__Impl : ( Colon ) ;
    public final void rule__Port__Group_1_2__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1825:1: ( ( Colon ) )
            // InternalDotParser.g:1826:1: ( Colon )
            {
            // InternalDotParser.g:1826:1: ( Colon )
            // InternalDotParser.g:1827:2: Colon
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getColonKeyword_1_2_1()); 
            }
            match(input,Colon,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getColonKeyword_1_2_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group_1_2__1__Impl"


    // $ANTLR start "rule__Port__Group_1_2__2"
    // InternalDotParser.g:1836:1: rule__Port__Group_1_2__2 : rule__Port__Group_1_2__2__Impl ;
    public final void rule__Port__Group_1_2__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1840:1: ( rule__Port__Group_1_2__2__Impl )
            // InternalDotParser.g:1841:2: rule__Port__Group_1_2__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Port__Group_1_2__2__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group_1_2__2"


    // $ANTLR start "rule__Port__Group_1_2__2__Impl"
    // InternalDotParser.g:1847:1: rule__Port__Group_1_2__2__Impl : ( ( rule__Port__Compass_ptAssignment_1_2_2 ) ) ;
    public final void rule__Port__Group_1_2__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1851:1: ( ( ( rule__Port__Compass_ptAssignment_1_2_2 ) ) )
            // InternalDotParser.g:1852:1: ( ( rule__Port__Compass_ptAssignment_1_2_2 ) )
            {
            // InternalDotParser.g:1852:1: ( ( rule__Port__Compass_ptAssignment_1_2_2 ) )
            // InternalDotParser.g:1853:2: ( rule__Port__Compass_ptAssignment_1_2_2 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getCompass_ptAssignment_1_2_2()); 
            }
            // InternalDotParser.g:1854:2: ( rule__Port__Compass_ptAssignment_1_2_2 )
            // InternalDotParser.g:1854:3: rule__Port__Compass_ptAssignment_1_2_2
            {
            pushFollow(FOLLOW_2);
            rule__Port__Compass_ptAssignment_1_2_2();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getCompass_ptAssignment_1_2_2()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Group_1_2__2__Impl"


    // $ANTLR start "rule__EdgeRhsNode__Group__0"
    // InternalDotParser.g:1863:1: rule__EdgeRhsNode__Group__0 : rule__EdgeRhsNode__Group__0__Impl rule__EdgeRhsNode__Group__1 ;
    public final void rule__EdgeRhsNode__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1867:1: ( rule__EdgeRhsNode__Group__0__Impl rule__EdgeRhsNode__Group__1 )
            // InternalDotParser.g:1868:2: rule__EdgeRhsNode__Group__0__Impl rule__EdgeRhsNode__Group__1
            {
            pushFollow(FOLLOW_17);
            rule__EdgeRhsNode__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__EdgeRhsNode__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsNode__Group__0"


    // $ANTLR start "rule__EdgeRhsNode__Group__0__Impl"
    // InternalDotParser.g:1875:1: rule__EdgeRhsNode__Group__0__Impl : ( ( rule__EdgeRhsNode__OpAssignment_0 ) ) ;
    public final void rule__EdgeRhsNode__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1879:1: ( ( ( rule__EdgeRhsNode__OpAssignment_0 ) ) )
            // InternalDotParser.g:1880:1: ( ( rule__EdgeRhsNode__OpAssignment_0 ) )
            {
            // InternalDotParser.g:1880:1: ( ( rule__EdgeRhsNode__OpAssignment_0 ) )
            // InternalDotParser.g:1881:2: ( rule__EdgeRhsNode__OpAssignment_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsNodeAccess().getOpAssignment_0()); 
            }
            // InternalDotParser.g:1882:2: ( rule__EdgeRhsNode__OpAssignment_0 )
            // InternalDotParser.g:1882:3: rule__EdgeRhsNode__OpAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__EdgeRhsNode__OpAssignment_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsNodeAccess().getOpAssignment_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsNode__Group__0__Impl"


    // $ANTLR start "rule__EdgeRhsNode__Group__1"
    // InternalDotParser.g:1890:1: rule__EdgeRhsNode__Group__1 : rule__EdgeRhsNode__Group__1__Impl ;
    public final void rule__EdgeRhsNode__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1894:1: ( rule__EdgeRhsNode__Group__1__Impl )
            // InternalDotParser.g:1895:2: rule__EdgeRhsNode__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__EdgeRhsNode__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsNode__Group__1"


    // $ANTLR start "rule__EdgeRhsNode__Group__1__Impl"
    // InternalDotParser.g:1901:1: rule__EdgeRhsNode__Group__1__Impl : ( ( rule__EdgeRhsNode__NodeAssignment_1 ) ) ;
    public final void rule__EdgeRhsNode__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1905:1: ( ( ( rule__EdgeRhsNode__NodeAssignment_1 ) ) )
            // InternalDotParser.g:1906:1: ( ( rule__EdgeRhsNode__NodeAssignment_1 ) )
            {
            // InternalDotParser.g:1906:1: ( ( rule__EdgeRhsNode__NodeAssignment_1 ) )
            // InternalDotParser.g:1907:2: ( rule__EdgeRhsNode__NodeAssignment_1 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsNodeAccess().getNodeAssignment_1()); 
            }
            // InternalDotParser.g:1908:2: ( rule__EdgeRhsNode__NodeAssignment_1 )
            // InternalDotParser.g:1908:3: rule__EdgeRhsNode__NodeAssignment_1
            {
            pushFollow(FOLLOW_2);
            rule__EdgeRhsNode__NodeAssignment_1();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsNodeAccess().getNodeAssignment_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsNode__Group__1__Impl"


    // $ANTLR start "rule__EdgeRhsSubgraph__Group__0"
    // InternalDotParser.g:1917:1: rule__EdgeRhsSubgraph__Group__0 : rule__EdgeRhsSubgraph__Group__0__Impl rule__EdgeRhsSubgraph__Group__1 ;
    public final void rule__EdgeRhsSubgraph__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1921:1: ( rule__EdgeRhsSubgraph__Group__0__Impl rule__EdgeRhsSubgraph__Group__1 )
            // InternalDotParser.g:1922:2: rule__EdgeRhsSubgraph__Group__0__Impl rule__EdgeRhsSubgraph__Group__1
            {
            pushFollow(FOLLOW_18);
            rule__EdgeRhsSubgraph__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__EdgeRhsSubgraph__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsSubgraph__Group__0"


    // $ANTLR start "rule__EdgeRhsSubgraph__Group__0__Impl"
    // InternalDotParser.g:1929:1: rule__EdgeRhsSubgraph__Group__0__Impl : ( ( rule__EdgeRhsSubgraph__OpAssignment_0 ) ) ;
    public final void rule__EdgeRhsSubgraph__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1933:1: ( ( ( rule__EdgeRhsSubgraph__OpAssignment_0 ) ) )
            // InternalDotParser.g:1934:1: ( ( rule__EdgeRhsSubgraph__OpAssignment_0 ) )
            {
            // InternalDotParser.g:1934:1: ( ( rule__EdgeRhsSubgraph__OpAssignment_0 ) )
            // InternalDotParser.g:1935:2: ( rule__EdgeRhsSubgraph__OpAssignment_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsSubgraphAccess().getOpAssignment_0()); 
            }
            // InternalDotParser.g:1936:2: ( rule__EdgeRhsSubgraph__OpAssignment_0 )
            // InternalDotParser.g:1936:3: rule__EdgeRhsSubgraph__OpAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__EdgeRhsSubgraph__OpAssignment_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsSubgraphAccess().getOpAssignment_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsSubgraph__Group__0__Impl"


    // $ANTLR start "rule__EdgeRhsSubgraph__Group__1"
    // InternalDotParser.g:1944:1: rule__EdgeRhsSubgraph__Group__1 : rule__EdgeRhsSubgraph__Group__1__Impl ;
    public final void rule__EdgeRhsSubgraph__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1948:1: ( rule__EdgeRhsSubgraph__Group__1__Impl )
            // InternalDotParser.g:1949:2: rule__EdgeRhsSubgraph__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__EdgeRhsSubgraph__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsSubgraph__Group__1"


    // $ANTLR start "rule__EdgeRhsSubgraph__Group__1__Impl"
    // InternalDotParser.g:1955:1: rule__EdgeRhsSubgraph__Group__1__Impl : ( ( rule__EdgeRhsSubgraph__SubgraphAssignment_1 ) ) ;
    public final void rule__EdgeRhsSubgraph__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1959:1: ( ( ( rule__EdgeRhsSubgraph__SubgraphAssignment_1 ) ) )
            // InternalDotParser.g:1960:1: ( ( rule__EdgeRhsSubgraph__SubgraphAssignment_1 ) )
            {
            // InternalDotParser.g:1960:1: ( ( rule__EdgeRhsSubgraph__SubgraphAssignment_1 ) )
            // InternalDotParser.g:1961:2: ( rule__EdgeRhsSubgraph__SubgraphAssignment_1 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsSubgraphAccess().getSubgraphAssignment_1()); 
            }
            // InternalDotParser.g:1962:2: ( rule__EdgeRhsSubgraph__SubgraphAssignment_1 )
            // InternalDotParser.g:1962:3: rule__EdgeRhsSubgraph__SubgraphAssignment_1
            {
            pushFollow(FOLLOW_2);
            rule__EdgeRhsSubgraph__SubgraphAssignment_1();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsSubgraphAccess().getSubgraphAssignment_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsSubgraph__Group__1__Impl"


    // $ANTLR start "rule__NodeId__Group__0"
    // InternalDotParser.g:1971:1: rule__NodeId__Group__0 : rule__NodeId__Group__0__Impl rule__NodeId__Group__1 ;
    public final void rule__NodeId__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1975:1: ( rule__NodeId__Group__0__Impl rule__NodeId__Group__1 )
            // InternalDotParser.g:1976:2: rule__NodeId__Group__0__Impl rule__NodeId__Group__1
            {
            pushFollow(FOLLOW_19);
            rule__NodeId__Group__0__Impl();

            state._fsp--;
            if (state.failed) return ;
            pushFollow(FOLLOW_2);
            rule__NodeId__Group__1();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeId__Group__0"


    // $ANTLR start "rule__NodeId__Group__0__Impl"
    // InternalDotParser.g:1983:1: rule__NodeId__Group__0__Impl : ( ( rule__NodeId__NameAssignment_0 ) ) ;
    public final void rule__NodeId__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:1987:1: ( ( ( rule__NodeId__NameAssignment_0 ) ) )
            // InternalDotParser.g:1988:1: ( ( rule__NodeId__NameAssignment_0 ) )
            {
            // InternalDotParser.g:1988:1: ( ( rule__NodeId__NameAssignment_0 ) )
            // InternalDotParser.g:1989:2: ( rule__NodeId__NameAssignment_0 )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeIdAccess().getNameAssignment_0()); 
            }
            // InternalDotParser.g:1990:2: ( rule__NodeId__NameAssignment_0 )
            // InternalDotParser.g:1990:3: rule__NodeId__NameAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__NodeId__NameAssignment_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeIdAccess().getNameAssignment_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeId__Group__0__Impl"


    // $ANTLR start "rule__NodeId__Group__1"
    // InternalDotParser.g:1998:1: rule__NodeId__Group__1 : rule__NodeId__Group__1__Impl ;
    public final void rule__NodeId__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2002:1: ( rule__NodeId__Group__1__Impl )
            // InternalDotParser.g:2003:2: rule__NodeId__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__NodeId__Group__1__Impl();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeId__Group__1"


    // $ANTLR start "rule__NodeId__Group__1__Impl"
    // InternalDotParser.g:2009:1: rule__NodeId__Group__1__Impl : ( ( rule__NodeId__PortAssignment_1 )? ) ;
    public final void rule__NodeId__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2013:1: ( ( ( rule__NodeId__PortAssignment_1 )? ) )
            // InternalDotParser.g:2014:1: ( ( rule__NodeId__PortAssignment_1 )? )
            {
            // InternalDotParser.g:2014:1: ( ( rule__NodeId__PortAssignment_1 )? )
            // InternalDotParser.g:2015:2: ( rule__NodeId__PortAssignment_1 )?
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeIdAccess().getPortAssignment_1()); 
            }
            // InternalDotParser.g:2016:2: ( rule__NodeId__PortAssignment_1 )?
            int alt26=2;
            int LA26_0 = input.LA(1);

            if ( (LA26_0==Colon) ) {
                alt26=1;
            }
            switch (alt26) {
                case 1 :
                    // InternalDotParser.g:2016:3: rule__NodeId__PortAssignment_1
                    {
                    pushFollow(FOLLOW_2);
                    rule__NodeId__PortAssignment_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeIdAccess().getPortAssignment_1()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeId__Group__1__Impl"


    // $ANTLR start "rule__DotAst__GraphsAssignment"
    // InternalDotParser.g:2025:1: rule__DotAst__GraphsAssignment : ( ruleDotGraph ) ;
    public final void rule__DotAst__GraphsAssignment() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2029:1: ( ( ruleDotGraph ) )
            // InternalDotParser.g:2030:2: ( ruleDotGraph )
            {
            // InternalDotParser.g:2030:2: ( ruleDotGraph )
            // InternalDotParser.g:2031:3: ruleDotGraph
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotAstAccess().getGraphsDotGraphParserRuleCall_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleDotGraph();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotAstAccess().getGraphsDotGraphParserRuleCall_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotAst__GraphsAssignment"


    // $ANTLR start "rule__DotGraph__StrictAssignment_0"
    // InternalDotParser.g:2040:1: rule__DotGraph__StrictAssignment_0 : ( ( Strict ) ) ;
    public final void rule__DotGraph__StrictAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2044:1: ( ( ( Strict ) ) )
            // InternalDotParser.g:2045:2: ( ( Strict ) )
            {
            // InternalDotParser.g:2045:2: ( ( Strict ) )
            // InternalDotParser.g:2046:3: ( Strict )
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getStrictStrictKeyword_0_0()); 
            }
            // InternalDotParser.g:2047:3: ( Strict )
            // InternalDotParser.g:2048:4: Strict
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getStrictStrictKeyword_0_0()); 
            }
            match(input,Strict,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getStrictStrictKeyword_0_0()); 
            }

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getStrictStrictKeyword_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__StrictAssignment_0"


    // $ANTLR start "rule__DotGraph__TypeAssignment_1"
    // InternalDotParser.g:2059:1: rule__DotGraph__TypeAssignment_1 : ( ruleGraphType ) ;
    public final void rule__DotGraph__TypeAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2063:1: ( ( ruleGraphType ) )
            // InternalDotParser.g:2064:2: ( ruleGraphType )
            {
            // InternalDotParser.g:2064:2: ( ruleGraphType )
            // InternalDotParser.g:2065:3: ruleGraphType
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getTypeGraphTypeEnumRuleCall_1_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleGraphType();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getTypeGraphTypeEnumRuleCall_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__TypeAssignment_1"


    // $ANTLR start "rule__DotGraph__NameAssignment_2"
    // InternalDotParser.g:2074:1: rule__DotGraph__NameAssignment_2 : ( ruleID ) ;
    public final void rule__DotGraph__NameAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2078:1: ( ( ruleID ) )
            // InternalDotParser.g:2079:2: ( ruleID )
            {
            // InternalDotParser.g:2079:2: ( ruleID )
            // InternalDotParser.g:2080:3: ruleID
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getNameIDParserRuleCall_2_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleID();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getNameIDParserRuleCall_2_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__NameAssignment_2"


    // $ANTLR start "rule__DotGraph__StmtsAssignment_4"
    // InternalDotParser.g:2089:1: rule__DotGraph__StmtsAssignment_4 : ( ruleStmt ) ;
    public final void rule__DotGraph__StmtsAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2093:1: ( ( ruleStmt ) )
            // InternalDotParser.g:2094:2: ( ruleStmt )
            {
            // InternalDotParser.g:2094:2: ( ruleStmt )
            // InternalDotParser.g:2095:3: ruleStmt
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDotGraphAccess().getStmtsStmtParserRuleCall_4_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleStmt();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDotGraphAccess().getStmtsStmtParserRuleCall_4_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__DotGraph__StmtsAssignment_4"


    // $ANTLR start "rule__EdgeStmtNode__NodeAssignment_0"
    // InternalDotParser.g:2104:1: rule__EdgeStmtNode__NodeAssignment_0 : ( ruleNodeId ) ;
    public final void rule__EdgeStmtNode__NodeAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2108:1: ( ( ruleNodeId ) )
            // InternalDotParser.g:2109:2: ( ruleNodeId )
            {
            // InternalDotParser.g:2109:2: ( ruleNodeId )
            // InternalDotParser.g:2110:3: ruleNodeId
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeStmtNodeAccess().getNodeNodeIdParserRuleCall_0_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleNodeId();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeStmtNodeAccess().getNodeNodeIdParserRuleCall_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeStmtNode__NodeAssignment_0"


    // $ANTLR start "rule__EdgeStmtNode__EdgeRHSAssignment_1"
    // InternalDotParser.g:2119:1: rule__EdgeStmtNode__EdgeRHSAssignment_1 : ( ruleEdgeRhs ) ;
    public final void rule__EdgeStmtNode__EdgeRHSAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2123:1: ( ( ruleEdgeRhs ) )
            // InternalDotParser.g:2124:2: ( ruleEdgeRhs )
            {
            // InternalDotParser.g:2124:2: ( ruleEdgeRhs )
            // InternalDotParser.g:2125:3: ruleEdgeRhs
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeStmtNodeAccess().getEdgeRHSEdgeRhsParserRuleCall_1_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleEdgeRhs();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeStmtNodeAccess().getEdgeRHSEdgeRhsParserRuleCall_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeStmtNode__EdgeRHSAssignment_1"


    // $ANTLR start "rule__EdgeStmtNode__AttrListsAssignment_2"
    // InternalDotParser.g:2134:1: rule__EdgeStmtNode__AttrListsAssignment_2 : ( ruleAttrList ) ;
    public final void rule__EdgeStmtNode__AttrListsAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2138:1: ( ( ruleAttrList ) )
            // InternalDotParser.g:2139:2: ( ruleAttrList )
            {
            // InternalDotParser.g:2139:2: ( ruleAttrList )
            // InternalDotParser.g:2140:3: ruleAttrList
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeStmtNodeAccess().getAttrListsAttrListParserRuleCall_2_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleAttrList();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeStmtNodeAccess().getAttrListsAttrListParserRuleCall_2_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeStmtNode__AttrListsAssignment_2"


    // $ANTLR start "rule__NodeStmt__NodeAssignment_0"
    // InternalDotParser.g:2149:1: rule__NodeStmt__NodeAssignment_0 : ( ruleNodeId ) ;
    public final void rule__NodeStmt__NodeAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2153:1: ( ( ruleNodeId ) )
            // InternalDotParser.g:2154:2: ( ruleNodeId )
            {
            // InternalDotParser.g:2154:2: ( ruleNodeId )
            // InternalDotParser.g:2155:3: ruleNodeId
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeStmtAccess().getNodeNodeIdParserRuleCall_0_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleNodeId();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeStmtAccess().getNodeNodeIdParserRuleCall_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeStmt__NodeAssignment_0"


    // $ANTLR start "rule__NodeStmt__AttrListsAssignment_1"
    // InternalDotParser.g:2164:1: rule__NodeStmt__AttrListsAssignment_1 : ( ruleAttrList ) ;
    public final void rule__NodeStmt__AttrListsAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2168:1: ( ( ruleAttrList ) )
            // InternalDotParser.g:2169:2: ( ruleAttrList )
            {
            // InternalDotParser.g:2169:2: ( ruleAttrList )
            // InternalDotParser.g:2170:3: ruleAttrList
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeStmtAccess().getAttrListsAttrListParserRuleCall_1_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleAttrList();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeStmtAccess().getAttrListsAttrListParserRuleCall_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeStmt__AttrListsAssignment_1"


    // $ANTLR start "rule__AttrStmt__TypeAssignment_0"
    // InternalDotParser.g:2179:1: rule__AttrStmt__TypeAssignment_0 : ( ruleAttributeType ) ;
    public final void rule__AttrStmt__TypeAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2183:1: ( ( ruleAttributeType ) )
            // InternalDotParser.g:2184:2: ( ruleAttributeType )
            {
            // InternalDotParser.g:2184:2: ( ruleAttributeType )
            // InternalDotParser.g:2185:3: ruleAttributeType
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrStmtAccess().getTypeAttributeTypeEnumRuleCall_0_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleAttributeType();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrStmtAccess().getTypeAttributeTypeEnumRuleCall_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrStmt__TypeAssignment_0"


    // $ANTLR start "rule__AttrStmt__AttrListsAssignment_1"
    // InternalDotParser.g:2194:1: rule__AttrStmt__AttrListsAssignment_1 : ( ruleAttrList ) ;
    public final void rule__AttrStmt__AttrListsAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2198:1: ( ( ruleAttrList ) )
            // InternalDotParser.g:2199:2: ( ruleAttrList )
            {
            // InternalDotParser.g:2199:2: ( ruleAttrList )
            // InternalDotParser.g:2200:3: ruleAttrList
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrStmtAccess().getAttrListsAttrListParserRuleCall_1_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleAttrList();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrStmtAccess().getAttrListsAttrListParserRuleCall_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrStmt__AttrListsAssignment_1"


    // $ANTLR start "rule__AttrList__AttributesAssignment_2_0"
    // InternalDotParser.g:2209:1: rule__AttrList__AttributesAssignment_2_0 : ( ruleAttribute ) ;
    public final void rule__AttrList__AttributesAssignment_2_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2213:1: ( ( ruleAttribute ) )
            // InternalDotParser.g:2214:2: ( ruleAttribute )
            {
            // InternalDotParser.g:2214:2: ( ruleAttribute )
            // InternalDotParser.g:2215:3: ruleAttribute
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttrListAccess().getAttributesAttributeParserRuleCall_2_0_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleAttribute();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttrListAccess().getAttributesAttributeParserRuleCall_2_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__AttrList__AttributesAssignment_2_0"


    // $ANTLR start "rule__Attribute__NameAssignment_0"
    // InternalDotParser.g:2224:1: rule__Attribute__NameAssignment_0 : ( ruleID ) ;
    public final void rule__Attribute__NameAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2228:1: ( ( ruleID ) )
            // InternalDotParser.g:2229:2: ( ruleID )
            {
            // InternalDotParser.g:2229:2: ( ruleID )
            // InternalDotParser.g:2230:3: ruleID
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttributeAccess().getNameIDParserRuleCall_0_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleID();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttributeAccess().getNameIDParserRuleCall_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__NameAssignment_0"


    // $ANTLR start "rule__Attribute__ValueAssignment_2"
    // InternalDotParser.g:2239:1: rule__Attribute__ValueAssignment_2 : ( ruleID ) ;
    public final void rule__Attribute__ValueAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2243:1: ( ( ruleID ) )
            // InternalDotParser.g:2244:2: ( ruleID )
            {
            // InternalDotParser.g:2244:2: ( ruleID )
            // InternalDotParser.g:2245:3: ruleID
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAttributeAccess().getValueIDParserRuleCall_2_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleID();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAttributeAccess().getValueIDParserRuleCall_2_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__ValueAssignment_2"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1"
    // InternalDotParser.g:2254:1: rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1 : ( ruleEdgeRhs ) ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2258:1: ( ( ruleEdgeRhs ) )
            // InternalDotParser.g:2259:2: ( ruleEdgeRhs )
            {
            // InternalDotParser.g:2259:2: ( ruleEdgeRhs )
            // InternalDotParser.g:2260:3: ruleEdgeRhs
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getEdgeRHSEdgeRhsParserRuleCall_1_1_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleEdgeRhs();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getEdgeRHSEdgeRhsParserRuleCall_1_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__EdgeRHSAssignment_1_1"


    // $ANTLR start "rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2"
    // InternalDotParser.g:2269:1: rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2 : ( ruleAttrList ) ;
    public final void rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2273:1: ( ( ruleAttrList ) )
            // InternalDotParser.g:2274:2: ( ruleAttrList )
            {
            // InternalDotParser.g:2274:2: ( ruleAttrList )
            // InternalDotParser.g:2275:3: ruleAttrList
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getAttrListsAttrListParserRuleCall_1_2_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleAttrList();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphOrEdgeStmtSubgraphAccess().getAttrListsAttrListParserRuleCall_1_2_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__SubgraphOrEdgeStmtSubgraph__AttrListsAssignment_1_2"


    // $ANTLR start "rule__Subgraph__NameAssignment_1_1"
    // InternalDotParser.g:2284:1: rule__Subgraph__NameAssignment_1_1 : ( ruleID ) ;
    public final void rule__Subgraph__NameAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2288:1: ( ( ruleID ) )
            // InternalDotParser.g:2289:2: ( ruleID )
            {
            // InternalDotParser.g:2289:2: ( ruleID )
            // InternalDotParser.g:2290:3: ruleID
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getNameIDParserRuleCall_1_1_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleID();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getNameIDParserRuleCall_1_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__NameAssignment_1_1"


    // $ANTLR start "rule__Subgraph__StmtsAssignment_3"
    // InternalDotParser.g:2299:1: rule__Subgraph__StmtsAssignment_3 : ( ruleStmt ) ;
    public final void rule__Subgraph__StmtsAssignment_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2303:1: ( ( ruleStmt ) )
            // InternalDotParser.g:2304:2: ( ruleStmt )
            {
            // InternalDotParser.g:2304:2: ( ruleStmt )
            // InternalDotParser.g:2305:3: ruleStmt
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSubgraphAccess().getStmtsStmtParserRuleCall_3_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleStmt();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSubgraphAccess().getStmtsStmtParserRuleCall_3_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Subgraph__StmtsAssignment_3"


    // $ANTLR start "rule__Port__Compass_ptAssignment_1_0"
    // InternalDotParser.g:2314:1: rule__Port__Compass_ptAssignment_1_0 : ( RULE_COMPASS_PT ) ;
    public final void rule__Port__Compass_ptAssignment_1_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2318:1: ( ( RULE_COMPASS_PT ) )
            // InternalDotParser.g:2319:2: ( RULE_COMPASS_PT )
            {
            // InternalDotParser.g:2319:2: ( RULE_COMPASS_PT )
            // InternalDotParser.g:2320:3: RULE_COMPASS_PT
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getCompass_ptCOMPASS_PTTerminalRuleCall_1_0_0()); 
            }
            match(input,RULE_COMPASS_PT,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getCompass_ptCOMPASS_PTTerminalRuleCall_1_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Compass_ptAssignment_1_0"


    // $ANTLR start "rule__Port__NameAssignment_1_1"
    // InternalDotParser.g:2329:1: rule__Port__NameAssignment_1_1 : ( ruleID ) ;
    public final void rule__Port__NameAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2333:1: ( ( ruleID ) )
            // InternalDotParser.g:2334:2: ( ruleID )
            {
            // InternalDotParser.g:2334:2: ( ruleID )
            // InternalDotParser.g:2335:3: ruleID
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getNameIDParserRuleCall_1_1_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleID();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getNameIDParserRuleCall_1_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__NameAssignment_1_1"


    // $ANTLR start "rule__Port__NameAssignment_1_2_0"
    // InternalDotParser.g:2344:1: rule__Port__NameAssignment_1_2_0 : ( ruleID ) ;
    public final void rule__Port__NameAssignment_1_2_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2348:1: ( ( ruleID ) )
            // InternalDotParser.g:2349:2: ( ruleID )
            {
            // InternalDotParser.g:2349:2: ( ruleID )
            // InternalDotParser.g:2350:3: ruleID
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getNameIDParserRuleCall_1_2_0_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleID();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getNameIDParserRuleCall_1_2_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__NameAssignment_1_2_0"


    // $ANTLR start "rule__Port__Compass_ptAssignment_1_2_2"
    // InternalDotParser.g:2359:1: rule__Port__Compass_ptAssignment_1_2_2 : ( RULE_COMPASS_PT ) ;
    public final void rule__Port__Compass_ptAssignment_1_2_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2363:1: ( ( RULE_COMPASS_PT ) )
            // InternalDotParser.g:2364:2: ( RULE_COMPASS_PT )
            {
            // InternalDotParser.g:2364:2: ( RULE_COMPASS_PT )
            // InternalDotParser.g:2365:3: RULE_COMPASS_PT
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPortAccess().getCompass_ptCOMPASS_PTTerminalRuleCall_1_2_2_0()); 
            }
            match(input,RULE_COMPASS_PT,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPortAccess().getCompass_ptCOMPASS_PTTerminalRuleCall_1_2_2_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Port__Compass_ptAssignment_1_2_2"


    // $ANTLR start "rule__EdgeRhsNode__OpAssignment_0"
    // InternalDotParser.g:2374:1: rule__EdgeRhsNode__OpAssignment_0 : ( ruleEdgeOp ) ;
    public final void rule__EdgeRhsNode__OpAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2378:1: ( ( ruleEdgeOp ) )
            // InternalDotParser.g:2379:2: ( ruleEdgeOp )
            {
            // InternalDotParser.g:2379:2: ( ruleEdgeOp )
            // InternalDotParser.g:2380:3: ruleEdgeOp
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsNodeAccess().getOpEdgeOpEnumRuleCall_0_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleEdgeOp();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsNodeAccess().getOpEdgeOpEnumRuleCall_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsNode__OpAssignment_0"


    // $ANTLR start "rule__EdgeRhsNode__NodeAssignment_1"
    // InternalDotParser.g:2389:1: rule__EdgeRhsNode__NodeAssignment_1 : ( ruleNodeId ) ;
    public final void rule__EdgeRhsNode__NodeAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2393:1: ( ( ruleNodeId ) )
            // InternalDotParser.g:2394:2: ( ruleNodeId )
            {
            // InternalDotParser.g:2394:2: ( ruleNodeId )
            // InternalDotParser.g:2395:3: ruleNodeId
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsNodeAccess().getNodeNodeIdParserRuleCall_1_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleNodeId();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsNodeAccess().getNodeNodeIdParserRuleCall_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsNode__NodeAssignment_1"


    // $ANTLR start "rule__EdgeRhsSubgraph__OpAssignment_0"
    // InternalDotParser.g:2404:1: rule__EdgeRhsSubgraph__OpAssignment_0 : ( ruleEdgeOp ) ;
    public final void rule__EdgeRhsSubgraph__OpAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2408:1: ( ( ruleEdgeOp ) )
            // InternalDotParser.g:2409:2: ( ruleEdgeOp )
            {
            // InternalDotParser.g:2409:2: ( ruleEdgeOp )
            // InternalDotParser.g:2410:3: ruleEdgeOp
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsSubgraphAccess().getOpEdgeOpEnumRuleCall_0_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleEdgeOp();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsSubgraphAccess().getOpEdgeOpEnumRuleCall_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsSubgraph__OpAssignment_0"


    // $ANTLR start "rule__EdgeRhsSubgraph__SubgraphAssignment_1"
    // InternalDotParser.g:2419:1: rule__EdgeRhsSubgraph__SubgraphAssignment_1 : ( ruleSubgraph ) ;
    public final void rule__EdgeRhsSubgraph__SubgraphAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2423:1: ( ( ruleSubgraph ) )
            // InternalDotParser.g:2424:2: ( ruleSubgraph )
            {
            // InternalDotParser.g:2424:2: ( ruleSubgraph )
            // InternalDotParser.g:2425:3: ruleSubgraph
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEdgeRhsSubgraphAccess().getSubgraphSubgraphParserRuleCall_1_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleSubgraph();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEdgeRhsSubgraphAccess().getSubgraphSubgraphParserRuleCall_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__EdgeRhsSubgraph__SubgraphAssignment_1"


    // $ANTLR start "rule__NodeId__NameAssignment_0"
    // InternalDotParser.g:2434:1: rule__NodeId__NameAssignment_0 : ( ruleID ) ;
    public final void rule__NodeId__NameAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2438:1: ( ( ruleID ) )
            // InternalDotParser.g:2439:2: ( ruleID )
            {
            // InternalDotParser.g:2439:2: ( ruleID )
            // InternalDotParser.g:2440:3: ruleID
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeIdAccess().getNameIDParserRuleCall_0_0()); 
            }
            pushFollow(FOLLOW_2);
            ruleID();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeIdAccess().getNameIDParserRuleCall_0_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeId__NameAssignment_0"


    // $ANTLR start "rule__NodeId__PortAssignment_1"
    // InternalDotParser.g:2449:1: rule__NodeId__PortAssignment_1 : ( rulePort ) ;
    public final void rule__NodeId__PortAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotParser.g:2453:1: ( ( rulePort ) )
            // InternalDotParser.g:2454:2: ( rulePort )
            {
            // InternalDotParser.g:2454:2: ( rulePort )
            // InternalDotParser.g:2455:3: rulePort
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNodeIdAccess().getPortPortParserRuleCall_1_0()); 
            }
            pushFollow(FOLLOW_2);
            rulePort();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNodeIdAccess().getPortPortParserRuleCall_1_0()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__NodeId__PortAssignment_1"

    // $ANTLR start synpred7_InternalDotParser
    public final void synpred7_InternalDotParser_fragment() throws RecognitionException {   
        // InternalDotParser.g:584:2: ( ( ( rule__Port__Compass_ptAssignment_1_0 ) ) )
        // InternalDotParser.g:584:2: ( ( rule__Port__Compass_ptAssignment_1_0 ) )
        {
        // InternalDotParser.g:584:2: ( ( rule__Port__Compass_ptAssignment_1_0 ) )
        // InternalDotParser.g:585:3: ( rule__Port__Compass_ptAssignment_1_0 )
        {
        if ( state.backtracking==0 ) {
           before(grammarAccess.getPortAccess().getCompass_ptAssignment_1_0()); 
        }
        // InternalDotParser.g:586:3: ( rule__Port__Compass_ptAssignment_1_0 )
        // InternalDotParser.g:586:4: rule__Port__Compass_ptAssignment_1_0
        {
        pushFollow(FOLLOW_2);
        rule__Port__Compass_ptAssignment_1_0();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }
    }
    // $ANTLR end synpred7_InternalDotParser

    // $ANTLR start synpred8_InternalDotParser
    public final void synpred8_InternalDotParser_fragment() throws RecognitionException {   
        // InternalDotParser.g:590:2: ( ( ( rule__Port__NameAssignment_1_1 ) ) )
        // InternalDotParser.g:590:2: ( ( rule__Port__NameAssignment_1_1 ) )
        {
        // InternalDotParser.g:590:2: ( ( rule__Port__NameAssignment_1_1 ) )
        // InternalDotParser.g:591:3: ( rule__Port__NameAssignment_1_1 )
        {
        if ( state.backtracking==0 ) {
           before(grammarAccess.getPortAccess().getNameAssignment_1_1()); 
        }
        // InternalDotParser.g:592:3: ( rule__Port__NameAssignment_1_1 )
        // InternalDotParser.g:592:4: rule__Port__NameAssignment_1_1
        {
        pushFollow(FOLLOW_2);
        rule__Port__NameAssignment_1_1();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }
    }
    // $ANTLR end synpred8_InternalDotParser

    // Delegated rules

    public final boolean synpred7_InternalDotParser() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred7_InternalDotParser_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred8_InternalDotParser() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred8_InternalDotParser_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


    protected DFA2 dfa2 = new DFA2(this);
    static final String dfa_1s = "\23\uffff";
    static final String dfa_2s = "\1\uffff\5\13\6\uffff\5\13\1\uffff\1\13";
    static final String dfa_3s = "\6\4\2\uffff\1\24\3\uffff\5\4\1\25\1\4";
    static final String dfa_4s = "\6\33\2\uffff\1\33\3\uffff\5\33\1\25\1\33";
    static final String dfa_5s = "\6\uffff\1\3\1\5\1\uffff\1\2\1\4\1\1\7\uffff";
    static final String dfa_6s = "\23\uffff}>";
    static final String[] dfa_7s = {
            "\1\7\2\uffff\3\6\10\uffff\1\7\1\uffff\1\1\1\2\1\3\1\4\3\uffff\1\5",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\10\1\13\1\12\1\13\1\uffff\6\13\3\uffff\1\13",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\10\1\13\1\12\1\13\1\uffff\6\13\3\uffff\1\13",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\10\1\13\1\12\1\13\1\uffff\6\13\3\uffff\1\13",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\10\1\13\1\12\1\13\1\uffff\6\13\3\uffff\1\13",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\10\1\13\1\12\1\13\1\uffff\6\13\3\uffff\1\13",
            "",
            "",
            "\1\15\1\14\1\16\1\17\3\uffff\1\20",
            "",
            "",
            "",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\21\1\13\1\uffff\1\13\1\uffff\6\13\3\uffff\1\13",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\21\1\13\1\uffff\1\13\1\uffff\6\13\3\uffff\1\13",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\21\1\13\1\uffff\1\13\1\uffff\6\13\3\uffff\1\13",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\21\1\13\1\uffff\1\13\1\uffff\6\13\3\uffff\1\13",
            "\1\13\2\uffff\3\13\2\11\1\uffff\1\21\1\13\1\uffff\1\13\1\uffff\6\13\3\uffff\1\13",
            "\1\22",
            "\1\13\2\uffff\3\13\2\11\2\uffff\1\13\1\uffff\1\13\1\uffff\6\13\3\uffff\1\13"
    };

    static final short[] dfa_1 = DFA.unpackEncodedString(dfa_1s);
    static final short[] dfa_2 = DFA.unpackEncodedString(dfa_2s);
    static final char[] dfa_3 = DFA.unpackEncodedStringToUnsignedChars(dfa_3s);
    static final char[] dfa_4 = DFA.unpackEncodedStringToUnsignedChars(dfa_4s);
    static final short[] dfa_5 = DFA.unpackEncodedString(dfa_5s);
    static final short[] dfa_6 = DFA.unpackEncodedString(dfa_6s);
    static final short[][] dfa_7 = unpackEncodedStringArray(dfa_7s);

    class DFA2 extends DFA {

        public DFA2(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 2;
            this.eot = dfa_1;
            this.eof = dfa_2;
            this.min = dfa_3;
            this.max = dfa_4;
            this.accept = dfa_5;
            this.special = dfa_6;
            this.transition = dfa_7;
        }
        public String getDescription() {
            return "519:1: rule__Stmt__Alternatives_0 : ( ( ruleNodeStmt ) | ( ruleEdgeStmtNode ) | ( ruleAttrStmt ) | ( ruleAttribute ) | ( ruleSubgraphOrEdgeStmtSubgraph ) );";
        }
    }
 

    public static final BitSet FOLLOW_1 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_2 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_3 = new BitSet(new long[]{0x00000000000000E2L});
    public static final BitSet FOLLOW_4 = new BitSet(new long[]{0x00000000000000E0L});
    public static final BitSet FOLLOW_5 = new BitSet(new long[]{0x0000000008F40000L});
    public static final BitSet FOLLOW_6 = new BitSet(new long[]{0x0000000008FC0390L});
    public static final BitSet FOLLOW_7 = new BitSet(new long[]{0x0000000008F40392L});
    public static final BitSet FOLLOW_8 = new BitSet(new long[]{0x0000000000004000L});
    public static final BitSet FOLLOW_9 = new BitSet(new long[]{0x0000000000000C00L});
    public static final BitSet FOLLOW_10 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_11 = new BitSet(new long[]{0x0000000000000C02L});
    public static final BitSet FOLLOW_12 = new BitSet(new long[]{0x0000000000010002L});
    public static final BitSet FOLLOW_13 = new BitSet(new long[]{0x0000000008F20000L});
    public static final BitSet FOLLOW_14 = new BitSet(new long[]{0x0000000008F00002L});
    public static final BitSet FOLLOW_15 = new BitSet(new long[]{0x0000000000005000L});
    public static final BitSet FOLLOW_16 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_17 = new BitSet(new long[]{0x0000000008F00000L});
    public static final BitSet FOLLOW_18 = new BitSet(new long[]{0x0000000008F40390L});
    public static final BitSet FOLLOW_19 = new BitSet(new long[]{0x0000000000002000L});
    public static final BitSet FOLLOW_20 = new BitSet(new long[]{0x0000000000200000L});

}