/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;

public class LazyCreationProxyURIConverter {
    @Inject
    private IQualifiedNameConverter nameConverter;
    private Map<String, EClass> types = Maps.newHashMap();
    protected static final String DELIM = "-=-";

    public LazyCreationProxyURIConverter() {
        EClass genClass = GenModelPackage.Literals.GEN_CLASS;
        EClass genDatatype = GenModelPackage.Literals.GEN_DATA_TYPE;
        EClass genEnum = GenModelPackage.Literals.GEN_ENUM;
        EClass jvmGenericType = TypesPackage.Literals.JVM_GENERIC_TYPE;
        EClass jvmEnumerationType = TypesPackage.Literals.JVM_ENUMERATION_TYPE;
        EClass jvmType = TypesPackage.Literals.JVM_TYPE;
        this.types.put(genClass.getName(), genClass);
        this.types.put(genDatatype.getName(), genDatatype);
        this.types.put(genEnum.getName(), genEnum);
        this.types.put(jvmGenericType.getName(), jvmGenericType);
        this.types.put(jvmEnumerationType.getName(), jvmEnumerationType);
        this.types.put(jvmType.getName(), jvmType);
    }

    public void installProxyURI(URI resourceURI, EObject eobject, QualifiedName name) {
        URI proxyURI = this.getProxyURI(resourceURI, eobject, name);
        ((InternalEObject)eobject).eSetProxyURI(proxyURI);
    }

    public URI getProxyURI(URI resourceURI, EObject eObject, QualifiedName name) {
        if (!this.isSupported(eObject)) {
            throw new IllegalArgumentException("eObjects of type " + eObject.eClass().getName() + " are not supported.");
        }
        return resourceURI.appendFragment(this.encodeFragment(eObject.eClass(), name));
    }

    protected boolean isSupported(EObject eObject) {
        return this.types.containsValue(eObject.eClass());
    }

    public Pair<EClass, QualifiedName> decodeProxy(EObject eObject) {
        URI proxyURI = ((InternalEObject)eObject).eProxyURI();
        if (proxyURI != null) {
            return this.decodeProxyURI(proxyURI);
        }
        throw new IllegalArgumentException("Not a proxy: " + eObject);
    }

    public Pair<EClass, QualifiedName> decodeProxyURI(URI proxyURI) {
        Pair<EClass, QualifiedName> fragmentInfo;
        String fragment = proxyURI.fragment();
        if (fragment != null && (fragmentInfo = this.decodeFragment(fragment)) != null) {
            return fragmentInfo;
        }
        throw new IllegalArgumentException("No fragment: " + proxyURI);
    }

    public String encodeFragment(EClass eClass, QualifiedName name) {
        return String.valueOf(eClass.getEPackage() == TypesPackage.eINSTANCE ? "JvmType" : eClass.getName()) + DELIM + name.toString();
    }

    public Pair<EClass, QualifiedName> decodeFragment(String fragment) {
        List segments = Strings.split((String)fragment, (String)DELIM);
        if (segments.size() == 2) {
            String eClassName = (String)segments.get(0);
            QualifiedName name = this.nameConverter.toQualifiedName((String)segments.get(1));
            if (this.types.containsKey(eClassName)) {
                EClass eClass = this.types.get(eClassName);
                return Tuples.create((Object)eClass, (Object)name);
            }
        }
        return null;
    }
}

