/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback;

import com.google.common.eventbus.Subscribe;
import java.util.EventObject;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.SharedDocumentAdapterWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.MirrorManager;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback.TextFallbackCompareInput;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback.TextFallbackCompareInputData;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback.TextFallbackMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.ForwardingCompareInput;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class TextFallbackMergeViewer
extends TextMergeViewer {
    static final String SHOW_PREVIEW = "SHOW_PREVIEW";
    private final ListenerList listenerList = new ListenerList();
    private Object originalInput;
    private Object effectiveInput;
    private SourceViewer ancesorViewer;
    private SourceViewer leftViewer;
    private SourceViewer rightViewer;
    private MirrorManager mirrorManager;
    private boolean ignoreContentProvideChanges = true;
    private ActionContributionItem previewItem;
    private ICompareCommandStack commandStackForNotification;
    private final CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            Object commandStack = event.getSource();
            if (commandStack instanceof ICompareCommandStack) {
                ICompareCommandStack compareCommandStack = (ICompareCommandStack)commandStack;
                TextFallbackMergeViewer.this.updateDirtyState(compareCommandStack);
                TextFallbackMergeViewer.this.updateTitleImage();
            }
            TextFallbackMergeViewer.this.setInput(TextFallbackMergeViewer.this.getOriginalInput());
        }
    };

    public TextFallbackMergeViewer(Composite parent, EMFCompareConfiguration configuration) {
        super(parent, (CompareConfiguration)configuration);
        configuration.getEventBus().register((Object)this);
        this.editingDomainChange(null, this.getCompareConfiguration().getEditingDomain());
        this.mirrorManager = new MirrorManager(configuration);
        this.ignoreContentProvideChanges = false;
        this.setContentProvider((IContentProvider)new TextFallbackMergeViewerContentProvider(this));
        this.ignoreContentProvideChanges = true;
    }

    @Subscribe
    public void handleEditingDomainChange(ICompareEditingDomainChange event) {
        this.editingDomainChange(event.getOldValue(), event.getNewValue());
    }

    private void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        if (newValue != oldValue) {
            if (oldValue != null) {
                oldValue.getCommandStack().removeCommandStackListener(this.commandStackListener);
            }
            if (newValue != null) {
                newValue.getCommandStack().addCommandStackListener(this.commandStackListener);
                this.updateDirtyState(newValue.getCommandStack());
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove((Object)listener);
    }

    private void updateDirtyState(ICompareCommandStack commandStack) {
        this.commandStackForNotification = commandStack;
        Utilities.firePropertyChange((ListenerList)this.listenerList, (Object)((Object)this), (String)"DIRTY_STATE", null, (Object)(commandStack.isLeftSaveNeeded() || commandStack.isRightSaveNeeded() ? 1 : 0));
        this.commandStackForNotification = null;
    }

    protected boolean isLeftDirty() {
        if (this.commandStackForNotification == null) {
            return super.isLeftDirty();
        }
        return this.commandStackForNotification.isLeftSaveNeeded();
    }

    protected void setLeftDirty(boolean dirty) {
        super.setLeftDirty(dirty);
        this.updateHeader();
    }

    protected boolean isRightDirty() {
        if (this.commandStackForNotification == null) {
            return super.isRightDirty();
        }
        return this.commandStackForNotification.isRightSaveNeeded();
    }

    protected void setRightDirty(boolean dirty) {
        super.setRightDirty(dirty);
        this.updateHeader();
    }

    private void updateTitleImage() {
        Composite parent;
        if (this.getInput() instanceof ICompareInput && (parent = this.getControl().getParent()) instanceof CompareViewerSwitchingPane) {
            CompareViewerSwitchingPane switchingPane = (CompareViewerSwitchingPane)parent;
            switchingPane.setImage(((ICompareInput)this.getInput()).getImage());
        }
    }

    protected void createToolItems(ToolBarManager tbm) {
        super.createToolItems(tbm);
        Action previewAction = new Action(){
            {
                this.setChecked(TextFallbackMergeViewer.this.getCompareConfiguration().getBooleanProperty(TextFallbackMergeViewer.SHOW_PREVIEW, true));
                this.setImageDescriptor(EMFCompareIDEUIPlugin.getImageDescriptor("icons/full/toolb16/show_preview.gif"));
                this.updateToolTipText();
            }

            public void run() {
                TextFallbackMergeViewer.this.getCompareConfiguration().setProperty(TextFallbackMergeViewer.SHOW_PREVIEW, this.isChecked());
                TextFallbackMergeViewer.this.setInput(TextFallbackMergeViewer.this.getOriginalInput());
                this.updateToolTipText();
            }

            private void updateToolTipText() {
                if (this.isChecked()) {
                    this.setToolTipText(EMFCompareIDEUIMessages.getString("TextFallbackCompareViewer.hidePreviewLabel"));
                } else {
                    this.setToolTipText(EMFCompareIDEUIMessages.getString("TextFallbackCompareViewer.showPreviewLabel"));
                }
            }
        };
        tbm.appendToGroup("modes", (IAction)previewAction);
        this.previewItem = new ActionContributionItem((IAction)previewAction);
    }

    protected void updateToolItems() {
        this.previewItem.setVisible(this.getEffectiveInput() instanceof TextFallbackCompareInput);
        super.updateToolItems();
    }

    protected EMFCompareConfiguration getCompareConfiguration() {
        return (EMFCompareConfiguration)super.getCompareConfiguration();
    }

    public void setContentProvider(IContentProvider contentProvider) {
        if (!this.ignoreContentProvideChanges) {
            if (this.mirrorManager != null) {
                super.setContentProvider(this.mirrorManager.getContentProvider(contentProvider));
            } else {
                super.setContentProvider(contentProvider);
            }
        }
    }

    public void setInput(Object input) {
        Control control = this.getControl();
        try {
            control.setRedraw(false);
            this.setOriginalInput(null);
            if (input instanceof CompareInputAdapter) {
                this.setEffectiveInput(this.getAdaptedCompareInput((CompareInputAdapter)((Object)input)));
            } else if (input instanceof ForwardingCompareInput) {
                this.setEffectiveInput(((ForwardingCompareInput)((Object)input)).delegate());
            } else {
                this.setEffectiveInput(input);
            }
            super.setInput(this.getEffectiveInput());
            this.setOriginalInput(input);
            if (this.getEffectiveInput() instanceof TextFallbackCompareInput) {
                TextFallbackCompareInput textCompareInput = (TextFallbackCompareInput)((Object)this.getEffectiveInput());
                TextFallbackCompareInputData textInputData = textCompareInput.getTextInputData();
                this.select(this.leftViewer, textInputData.getLeft(), textInputData.getLeftResource());
                this.select(this.rightViewer, textInputData.getRight(), textInputData.getRightResource());
                this.select(this.ancesorViewer, textInputData.getOrigin(), textInputData.getOriginResource());
            }
        }
        finally {
            control.setRedraw(true);
        }
    }

    private ICompareInput getAdaptedCompareInput(CompareInputAdapter input) {
        Object adaptedCompareInput;
        Notifier target = input.getTarget();
        if (target instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)target;
            EObject data = treeNode.getData();
            Comparison comparison = ComparisonUtil.getComparison((EObject)data);
            if (comparison != null) {
                ICompareInput compareInput = (ICompareInput)EcoreUtil.getAdapter((List)comparison.eAdapters(), ICompareInput.class);
                adaptedCompareInput = compareInput instanceof ForwardingCompareInput ? ((ForwardingCompareInput)compareInput).delegate() : compareInput;
                TextFallbackCompareInputData textInputData = new TextFallbackCompareInputData(data);
                if (textInputData.hasTypedElement()) {
                    adaptedCompareInput = new TextFallbackCompareInput(adaptedCompareInput.getKind(), textInputData, this.getCompareConfiguration().getBooleanProperty(SHOW_PREVIEW, true));
                }
            } else {
                adaptedCompareInput = null;
                EMFCompareIDEUIPlugin.getDefault().log(4, "Cannot find a comparison from input " + (Object)((Object)input));
            }
        } else {
            adaptedCompareInput = null;
        }
        return adaptedCompareInput;
    }

    private void select(SourceViewer sourceViewer, EObject eObject, Resource resource) {
        IDocument document = sourceViewer.getDocument();
        int offset = this.getOffset(eObject, resource, document.get());
        if (offset != -1) {
            sourceViewer.setSelectedRange(offset, 0);
            sourceViewer.setSelection(sourceViewer.getSelection(), true);
            Event event = new Event();
            StyledText textWidget = sourceViewer.getTextWidget();
            textWidget.notifyListeners(1, event);
            textWidget.notifyListeners(2, event);
        }
    }

    private int getOffset(EObject eObject, Resource resource, String text) {
        XMLResource xmlResource;
        String id;
        int offset = -1;
        if (resource instanceof XMLResource && eObject != null && (id = (xmlResource = (XMLResource)resource).getID(eObject)) != null && (offset = text.indexOf("xmi:id=\"" + id + '\"')) != -1) {
            while (offset > 0) {
                char c = text.charAt(offset - 1);
                if (c == '\n' || c == '\r') break;
                --offset;
            }
        }
        return offset;
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        SourceViewer sourceViewer = super.createSourceViewer(parent, textOrientation);
        if (this.ancesorViewer == null) {
            this.ancesorViewer = sourceViewer;
        } else if (this.leftViewer == null) {
            this.leftViewer = sourceViewer;
        } else {
            this.rightViewer = sourceViewer;
        }
        return sourceViewer;
    }

    public Object getInput() {
        if (this.getOriginalInput() == null) {
            return super.getInput();
        }
        return this.getOriginalInput();
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        EMFCompareConfiguration configuration = this.getCompareConfiguration();
        this.editingDomainChange(configuration.getEditingDomain(), null);
        configuration.getEventBus().unregister((Object)this);
        configuration.disposeListeners();
        this.setOriginalInput(null);
        this.setEffectiveInput(null);
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.mirrorManager != null && this.mirrorManager.handlePropertyChangeEvent(event)) {
            Object oldInput = this.getInput();
            IMergeViewerContentProvider oldContentProvider = (IMergeViewerContentProvider)this.getContentProvider();
            Runnable leftDocumentConnection = this.connectDocumentProvider(oldContentProvider.getLeftContent(oldInput));
            Runnable rightDocumentConnection = this.connectDocumentProvider(oldContentProvider.getRightContent(oldInput));
            try {
                this.ignoreContentProvideChanges = false;
                this.setContentProvider(this.mirrorManager.getContentProvider((IContentProvider)oldContentProvider));
                this.updateTitleImage();
            }
            finally {
                this.ignoreContentProvideChanges = true;
                if (leftDocumentConnection != null) {
                    leftDocumentConnection.run();
                }
                if (rightDocumentConnection != null) {
                    rightDocumentConnection.run();
                }
            }
            this.updateToolItems();
        } else {
            super.handlePropertyChangeEvent(event);
        }
    }

    private Runnable connectDocumentProvider(Object element) {
        IDocumentProvider documentProvider;
        IEditorInput documentKey;
        ISharedDocumentAdapter sharedDocumentationAdapter;
        if (element != null && (sharedDocumentationAdapter = SharedDocumentAdapterWrapper.getAdapter((Object)element)) != null && (documentKey = sharedDocumentationAdapter.getDocumentKey(element)) != null && (documentProvider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)documentKey)) != null) {
            try {
                sharedDocumentationAdapter.connect(documentProvider, documentKey);
                return new Runnable(){

                    @Override
                    public void run() {
                        sharedDocumentationAdapter.disconnect(documentProvider, documentKey);
                    }
                };
            }
            catch (CoreException e) {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
        }
        return null;
    }

    public String getTitle() {
        return EMFCompareIDEUIMessages.getString("TextFallbackCompareViewer.title");
    }

    public Object getOriginalInput() {
        return this.originalInput;
    }

    private void setOriginalInput(Object originalInput) {
        this.originalInput = originalInput;
    }

    public Object getEffectiveInput() {
        return this.effectiveInput;
    }

    private void setEffectiveInput(Object effectiveInput) {
        this.effectiveInput = effectiveInput;
    }
}

