/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.decorators;

import java.text.DecimalFormat;
import java.text.Format;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.analysis.IJavaCoverageListener;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;

public class CoverageDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    private static final Format SUFFIX_FORMAT = new DecimalFormat(UIMessages.CoverageDecoratorSuffix_label);
    private final IJavaCoverageListener coverageListener = new IJavaCoverageListener(){

        public void coverageChanged() {
            Display display = EclEmmaUIPlugin.getInstance().getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    CoverageDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)CoverageDecorator.this));
                }
            });
        }
    };

    public CoverageDecorator() {
        CoverageTools.addJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
    }

    public void decorate(Object element, IDecoration decoration) {
        ICoverageNode coverage = CoverageTools.getCoverageInfo((Object)element);
        if (coverage == null) {
            return;
        }
        ICounter counter = coverage.getInstructionCounter();
        ImageDescriptor overlay = EclEmmaUIPlugin.getCoverageOverlay(counter.getCoveredRatio());
        decoration.addOverlay(overlay, 0);
        decoration.addSuffix(SUFFIX_FORMAT.format(counter.getCoveredRatio()));
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
        CoverageTools.removeJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
    }
}

