/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.internal.sqlserver.models;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCIndex;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.loaders.SQLCatalogUtils;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.models.SQLServerJdbcTable;

public class SQLServerJdbcIndex
extends JDBCIndex {
    private Boolean loadedExtendedIndexInfo = Boolean.FALSE;
    private boolean padIndex;
    private boolean statisticsNoRecompute;
    private boolean ignoreDupKey;
    private boolean allowRowLocks;
    private boolean allowPageLocks;
    private boolean uniqueConstraint;
    private boolean primaryKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPadIndex() {
        Boolean bl = this.loadedExtendedIndexInfo;
        synchronized (bl) {
            if (!this.loadedExtendedIndexInfo.booleanValue()) {
                this.loadExtendedIndexInfo();
            }
        }
        return this.padIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStatisticsNoRecompute() {
        Boolean bl = this.loadedExtendedIndexInfo;
        synchronized (bl) {
            if (!this.loadedExtendedIndexInfo.booleanValue()) {
                this.loadExtendedIndexInfo();
            }
        }
        return this.statisticsNoRecompute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnoreDupKey() {
        Boolean bl = this.loadedExtendedIndexInfo;
        synchronized (bl) {
            if (!this.loadedExtendedIndexInfo.booleanValue()) {
                this.loadExtendedIndexInfo();
            }
        }
        return this.ignoreDupKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowRowLocks() {
        Boolean bl = this.loadedExtendedIndexInfo;
        synchronized (bl) {
            if (!this.loadedExtendedIndexInfo.booleanValue()) {
                this.loadExtendedIndexInfo();
            }
        }
        return this.allowRowLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowPageLocks() {
        Boolean bl = this.loadedExtendedIndexInfo;
        synchronized (bl) {
            if (!this.loadedExtendedIndexInfo.booleanValue()) {
                this.loadExtendedIndexInfo();
            }
        }
        return this.allowPageLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUniqueConstraint() {
        Boolean bl = this.loadedExtendedIndexInfo;
        synchronized (bl) {
            if (!this.loadedExtendedIndexInfo.booleanValue()) {
                this.loadExtendedIndexInfo();
            }
        }
        return this.uniqueConstraint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrimaryKey() {
        Boolean bl = this.loadedExtendedIndexInfo;
        synchronized (bl) {
            if (!this.loadedExtendedIndexInfo.booleanValue()) {
                this.loadExtendedIndexInfo();
            }
        }
        return this.primaryKey;
    }

    private synchronized void loadExtendedIndexInfo() {
        block7: {
            if (!(this.getTable() instanceof SQLServerJdbcTable)) {
                return;
            }
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("select i.is_padded, s.no_recompute, i.ignore_dup_key, i.allow_row_locks, i.allow_page_locks, i.is_unique_constraint, i.is_primary_key from sys.indexes as i, sys.stats as s where i.object_id = ? and i.name = ? AND i.object_id=s.object_id AND i.name=s.name");
                    stmt.setInt(1, ((SQLServerJdbcTable)this.getTable()).getId());
                    stmt.setString(2, this.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        this.padIndex = rs.getBoolean(1);
                        this.statisticsNoRecompute = rs.getBoolean(2);
                        this.ignoreDupKey = rs.getBoolean(3);
                        this.allowRowLocks = rs.getBoolean(4);
                        this.allowPageLocks = rs.getBoolean(5);
                        this.uniqueConstraint = rs.getBoolean(6);
                        this.primaryKey = rs.getBoolean(7);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLCatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SQLCatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SQLCatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.loadedExtendedIndexInfo = Boolean.TRUE;
    }
}

