/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.dnd.AbstractContainerAreaDropAdapter;
import org.eclipse.cdt.make.internal.ui.dnd.AbstractSelectionDragAdapter;
import org.eclipse.cdt.make.internal.ui.dnd.FileTransferDropTargetListener;
import org.eclipse.cdt.make.internal.ui.dnd.LocalTransferDragSourceListener;
import org.eclipse.cdt.make.internal.ui.dnd.LocalTransferDropTargetListener;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransfer;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransferDragSourceListener;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransferDropTargetListener;
import org.eclipse.cdt.make.internal.ui.dnd.TextTransferDragSourceListener;
import org.eclipse.cdt.make.internal.ui.dnd.TextTransferDropTargetListener;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.make.ui.MakeContentProvider;
import org.eclipse.cdt.make.ui.MakeLabelProvider;
import org.eclipse.cdt.make.ui.TargetSourceContainer;
import org.eclipse.cdt.make.ui.views.AddTargetAction;
import org.eclipse.cdt.make.ui.views.BuildTargetAction;
import org.eclipse.cdt.make.ui.views.CopyTargetAction;
import org.eclipse.cdt.make.ui.views.DeleteTargetAction;
import org.eclipse.cdt.make.ui.views.EditTargetAction;
import org.eclipse.cdt.make.ui.views.FilterEmtpyFoldersAction;
import org.eclipse.cdt.make.ui.views.PasteTargetAction;
import org.eclipse.cdt.make.ui.views.RebuildLastTargetAction;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class MakeView
extends ViewPart {
    private static final String TARGET_BUILD_LAST_COMMAND = "org.eclipse.cdt.make.ui.targetBuildLastCommand";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_CONTAINER = "container";
    private static final String TAG_PATH = "path";
    private static final String TAG_MAKE_TARGET = "makeTarget";
    private static final String TAG_SOURCE_CONTAINER = "sourceContainer";
    private static final String TAG_NAME = "name";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    private static final String TAG_WORKINGSET = "workingSet";
    private Clipboard clipboard;
    private BuildTargetAction buildTargetAction;
    private RebuildLastTargetAction buildLastTargetAction;
    private EditTargetAction editTargetAction;
    private DeleteTargetAction deleteTargetAction;
    private AddTargetAction newTargetAction;
    private CopyTargetAction copyTargetAction;
    private PasteTargetAction pasteTargetAction;
    private TreeViewer fViewer;
    private DrillDownAdapter drillDownAdapter;
    private FilterEmtpyFoldersAction trimEmptyFolderAction;
    private IBindingService bindingService;
    private ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private WorkingSetFilterActionGroup workingSetGroup;
    private IMemento memento;
    private IPropertyChangeListener workingSetListener = ev -> {
        String property = ev.getProperty();
        Object newValue = ev.getNewValue();
        Object oldValue = ev.getOldValue();
        IWorkingSet filterWorkingSet = this.workingSetFilter.getWorkingSet();
        if (property == null) {
            return;
        }
        if ("workingSetRemove".equals(property) && oldValue == filterWorkingSet) {
            this.setWorkingSet(null);
        } else if ("workingSetContentChange".equals(property) && newValue == filterWorkingSet) {
            this.fViewer.refresh();
        }
    };
    IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("changeWorkingSet".equals(property)) {
                Object newValue = event.getNewValue();
                if (newValue instanceof IWorkingSet) {
                    MakeView.this.setWorkingSet((IWorkingSet)newValue);
                } else if (newValue == null) {
                    MakeView.this.setWorkingSet(null);
                }
            }
        }
    };
    private IBindingManagerListener bindingManagerListener = new IBindingManagerListener(){

        public void bindingManagerChanged(BindingManagerEvent event) {
            if (event.isActiveBindingsChanged()) {
                String keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.rename");
                if (keyBinding != null) {
                    MakeView.this.editTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("EditTargetAction.label")) + "\t" + keyBinding);
                }
                if ((keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.copy")) != null) {
                    MakeView.this.copyTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("CopyTargetAction.label")) + "\t" + keyBinding);
                }
                if ((keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.paste")) != null) {
                    MakeView.this.pasteTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("PasteTargetAction.label")) + "\t" + keyBinding);
                }
                if ((keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.delete")) != null) {
                    MakeView.this.deleteTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("DeleteTargetAction.label")) + "\t" + keyBinding);
                }
                if ((keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor(MakeView.TARGET_BUILD_LAST_COMMAND)) != null) {
                    MakeView.this.buildLastTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("BuildLastTargetAction.label")) + "\t" + keyBinding);
                }
            }
        }
    };

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IMakeHelpContextIds.MAKE_VIEW);
        this.fViewer = new TreeViewer(parent, 770);
        this.fViewer.setUseHashlookup(true);
        this.fViewer.setContentProvider((IContentProvider)new MakeContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider());
        this.initFilters(this.fViewer);
        this.initDragAndDrop();
        this.drillDownAdapter = new DrillDownAdapter(this.fViewer);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MakeView.this.handleDoubleClick(event);
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MakeView.this.handleSelectionChanged(event);
            }
        });
        this.fViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof TargetSourceContainer) {
                    return 1;
                }
                if (element instanceof IResource) {
                    return 2;
                }
                return 3;
            }
        });
        this.fViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (this.memento != null) {
            this.restoreStateWorkingSetSelection(this.memento);
        }
        IWorkingSetManager wsmanager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager();
        wsmanager.addPropertyChangeListener(this.workingSetListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.updateActions((IStructuredSelection)this.fViewer.getSelection());
        this.bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (this.bindingService != null) {
            this.bindingService.addBindingManagerListener(this.bindingManagerListener);
        }
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
    }

    private void initDragAndDrop() {
        int opers = 3;
        Transfer[] dragTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), MakeTargetTransfer.getInstance(), TextTransfer.getInstance()};
        AbstractSelectionDragAdapter[] dragListeners = new AbstractSelectionDragAdapter[]{new LocalTransferDragSourceListener((ISelectionProvider)this.fViewer), new MakeTargetTransferDragSourceListener((ISelectionProvider)this.fViewer), new TextTransferDragSourceListener((ISelectionProvider)this.fViewer)};
        DelegatingDragAdapter delegatingDragAdapter = new DelegatingDragAdapter();
        AbstractSelectionDragAdapter[] abstractSelectionDragAdapterArray = dragListeners;
        int n = dragListeners.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractSelectionDragAdapter dragListener = abstractSelectionDragAdapterArray[n2];
            delegatingDragAdapter.addDragSourceListener((TransferDragSourceListener)dragListener);
            ++n2;
        }
        this.fViewer.addDragSupport(opers, dragTransfers, (DragSourceListener)delegatingDragAdapter);
        Transfer[] dropTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), MakeTargetTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()};
        AbstractContainerAreaDropAdapter[] dropListeners = new AbstractContainerAreaDropAdapter[]{new LocalTransferDropTargetListener((Viewer)this.fViewer), new MakeTargetTransferDropTargetListener((Viewer)this.fViewer), new FileTransferDropTargetListener((Viewer)this.fViewer), new TextTransferDropTargetListener((Viewer)this.fViewer)};
        DelegatingDropAdapter delegatingDropAdapter = new DelegatingDropAdapter();
        AbstractContainerAreaDropAdapter[] abstractContainerAreaDropAdapterArray = dropListeners;
        int n3 = dropListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            AbstractContainerAreaDropAdapter dropListener = abstractContainerAreaDropAdapterArray[n4];
            delegatingDropAdapter.addDropTargetListener((TransferDropTargetListener)dropListener);
            ++n4;
        }
        this.fViewer.addDropSupport(opers | 0x10, dropTransfers, (DropTargetListener)delegatingDropAdapter);
    }

    private void makeActions() {
        Shell shell = this.fViewer.getControl().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.buildTargetAction = new BuildTargetAction(shell);
        this.buildLastTargetAction = new RebuildLastTargetAction();
        this.newTargetAction = new AddTargetAction(shell);
        this.copyTargetAction = new CopyTargetAction(shell, this.clipboard, this.pasteTargetAction);
        this.pasteTargetAction = new PasteTargetAction(shell, this.clipboard);
        this.deleteTargetAction = new DeleteTargetAction(shell);
        this.editTargetAction = new EditTargetAction(shell);
        this.trimEmptyFolderAction = new FilterEmtpyFoldersAction(this.fViewer);
        this.workingSetGroup = new WorkingSetFilterActionGroup(shell, this.workingSetUpdater);
        this.workingSetGroup.setWorkingSet(this.getWorkingSet());
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(actionBars.getMenuManager());
        this.fillLocalToolBar(actionBars.getToolBarManager());
        TextActionHandler textActionHandler = new TextActionHandler(actionBars);
        textActionHandler.setCopyAction((IAction)this.copyTargetAction);
        textActionHandler.setPasteAction((IAction)this.pasteTargetAction);
        textActionHandler.setDeleteAction((IAction)this.deleteTargetAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.editTargetAction);
        this.workingSetGroup.fillActionBars(actionBars);
    }

    private void fillLocalToolBar(IToolBarManager toolBar) {
        toolBar.add((IAction)this.newTargetAction);
        toolBar.add((IAction)this.editTargetAction);
        toolBar.add((IAction)this.buildTargetAction);
        toolBar.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(toolBar);
        toolBar.add((IAction)this.trimEmptyFolderAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MakeView.this.fillContextMenu(manager);
                MakeView.this.updateActions((IStructuredSelection)MakeView.this.fViewer.getSelection());
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.newTargetAction);
        manager.add((IAction)this.editTargetAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyTargetAction);
        manager.add((IAction)this.pasteTargetAction);
        manager.add((IAction)this.deleteTargetAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.buildTargetAction);
        manager.add((IAction)this.buildLastTargetAction);
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        this.buildTargetAction.run();
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateActions(sel);
    }

    void updateActions(IStructuredSelection sel) {
        this.newTargetAction.selectionChanged(sel);
        this.buildTargetAction.selectionChanged(sel);
        this.buildLastTargetAction.selectionChanged(sel);
        this.deleteTargetAction.selectionChanged(sel);
        this.editTargetAction.selectionChanged(sel);
        this.copyTargetAction.selectionChanged(sel);
        this.pasteTargetAction.selectionChanged(sel);
        this.workingSetGroup.updateActionBars();
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        if (this.bindingService != null) {
            this.bindingService.removeBindingManagerListener(this.bindingManagerListener);
            this.bindingService = null;
        }
        IWorkingSetManager wsmanager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager();
        if (this.workingSetListener != null) {
            wsmanager.removePropertyChangeListener(this.workingSetListener);
            this.workingSetListener = null;
        }
        super.dispose();
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSetFilter.getWorkingSet();
    }

    void initFilters(TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this.workingSetFilter);
    }

    private void saveState(IMemento memento, Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer c;
            Object element = objectArray[n2];
            if (element instanceof IMakeTarget) {
                IMakeTarget makeTarget = (IMakeTarget)element;
                c = makeTarget.getContainer();
                if (c.getFullPath() != null) {
                    elementMem = memento.createChild(TAG_MAKE_TARGET);
                    elementMem.putString(TAG_PATH, c.getFullPath().toPortableString());
                    elementMem.putString(TAG_NAME, makeTarget.getName());
                }
            } else if (element instanceof TargetSourceContainer) {
                TargetSourceContainer targetSourceContainer = (TargetSourceContainer)element;
                c = targetSourceContainer.getContainer();
                if (c.getFullPath() != null) {
                    elementMem = memento.createChild(TAG_SOURCE_CONTAINER);
                    elementMem.putString(TAG_PATH, c.getFullPath().toPortableString());
                }
            } else if (element instanceof IContainer && (c = (IContainer)element).getLocation() != null) {
                IMemento elementMem = memento.createChild(TAG_CONTAINER);
                elementMem.putString(TAG_PATH, c.getFullPath().toPortableString());
            }
            ++n2;
        }
    }

    private List<Object> restoreStateElements(IMemento memento) {
        IMemento[] containerMementos;
        IMemento[] sourceContainerMementos;
        IResource res;
        IMemento[] makeTargetMementos;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMakeTargetManager makeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        ArrayList<Object> elements = new ArrayList<Object>();
        IMemento[] iMementoArray = makeTargetMementos = memento.getChildren(TAG_MAKE_TARGET);
        int n = makeTargetMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento mem = iMementoArray[n2];
            String path = mem.getString(TAG_PATH);
            String name = mem.getString(TAG_NAME);
            if (path != null && name != null && (res = root.findMember(Path.fromPortableString((String)path))) instanceof IContainer) {
                IContainer container = (IContainer)res;
                try {
                    IMakeTarget makeTarget = makeTargetManager.findTarget(container, name);
                    if (makeTarget != null) {
                        elements.add(makeTarget);
                    }
                }
                catch (CoreException makeTarget) {
                    // empty catch block
                }
            }
            ++n2;
        }
        IMemento[] iMementoArray2 = sourceContainerMementos = memento.getChildren(TAG_SOURCE_CONTAINER);
        int n3 = sourceContainerMementos.length;
        n = 0;
        while (n < n3) {
            IMemento mem = iMementoArray2[n];
            String path = mem.getString(TAG_PATH);
            if (path != null && (res = root.findMember(Path.fromPortableString((String)path))) != null) {
                ICSourceEntry[] srcEntries;
                IProject project = res.getProject();
                ICSourceEntry[] iCSourceEntryArray = srcEntries = MakeView.getSourceEntries(project);
                int n4 = srcEntries.length;
                int n5 = 0;
                while (n5 < n4) {
                    ICSourceEntry srcEntry = iCSourceEntryArray[n5];
                    if (srcEntry.getFullPath().equals((Object)res.getFullPath())) {
                        elements.add(new TargetSourceContainer(srcEntry));
                    }
                    ++n5;
                }
            }
            ++n;
        }
        IMemento[] iMementoArray3 = containerMementos = memento.getChildren(TAG_CONTAINER);
        int n6 = containerMementos.length;
        n3 = 0;
        while (n3 < n6) {
            IResource res2;
            IMemento mem = iMementoArray3[n3];
            String path = mem.getString(TAG_PATH);
            if (path != null && (res2 = root.findMember(Path.fromPortableString((String)path))) != null) {
                elements.add(res2);
            }
            ++n3;
        }
        return elements;
    }

    public void saveState(IMemento memento) {
        String wsname;
        ScrollBar bar;
        Object[] elements;
        if (this.fViewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        Tree tree = this.fViewer.getTree();
        Object[] expandedElements = this.fViewer.getExpandedElements();
        if (expandedElements.length > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED);
            this.saveState(expandedMem, expandedElements);
        }
        if ((elements = ((IStructuredSelection)this.fViewer.getSelection()).toArray()).length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            this.saveState(selectionMem, elements);
        }
        int position = (bar = tree.getVerticalBar()) != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_VERTICAL_POSITION, position);
        bar = tree.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_HORIZONTAL_POSITION, position);
        if (this.workingSetFilter.getWorkingSet() != null && (wsname = this.workingSetFilter.getWorkingSet().getName()) != null) {
            memento.putString(TAG_WORKINGSET, wsname);
        }
    }

    private void restoreState(IMemento memento) {
        Integer position;
        Tree tree;
        ScrollBar bar;
        IMemento selectionMemento;
        IMemento expandedMemento = memento.getChild(TAG_EXPANDED);
        if (expandedMemento != null) {
            this.fViewer.setExpandedElements(this.restoreStateElements(expandedMemento).toArray());
        }
        if ((selectionMemento = memento.getChild(TAG_SELECTION)) != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(this.restoreStateElements(selectionMemento)));
        }
        if ((bar = (tree = this.fViewer.getTree()).getVerticalBar()) != null && (position = memento.getInteger(TAG_VERTICAL_POSITION)) != null) {
            bar.setSelection(position.intValue());
        }
        if ((bar = tree.getHorizontalBar()) != null && (position = memento.getInteger(TAG_HORIZONTAL_POSITION)) != null) {
            bar.setSelection(position.intValue());
        }
    }

    private void restoreStateWorkingSetSelection(IMemento memento) {
        IWorkingSetManager wsmanager;
        IWorkingSet workingSet;
        String wsname = memento.getString(TAG_WORKINGSET);
        if (wsname != null && !wsname.isEmpty() && (workingSet = (wsmanager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager()).getWorkingSet(wsname)) != null) {
            this.workingSetFilter.setWorkingSet(workingSet);
        }
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        Object[] expanded = this.fViewer.getExpandedElements();
        ISelection selection = this.fViewer.getSelection();
        this.workingSetFilter.setWorkingSet(workingSet);
        this.fViewer.refresh();
        this.fViewer.setExpandedElements(expanded);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.fViewer.reveal(structuredSelection.getFirstElement());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    private static ICSourceEntry[] getSourceEntries(IProject project) {
        ICConfigurationDescription cfgDescription;
        ICProjectDescriptionManager mgr = CCorePlugin.getDefault().getProjectDescriptionManager();
        ICProjectDescription prjDescription = mgr.getProjectDescription(project, false);
        if (prjDescription != null && (cfgDescription = prjDescription.getDefaultSettingConfiguration()) != null) {
            ICSourceEntry[] srcEntries = cfgDescription.getResolvedSourceEntries();
            return srcEntries;
        }
        return new ICSourceEntry[0];
    }
}

