/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.dnd;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.dnd.AbstractContainerAreaDropAdapter;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetDndUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;

public class TextTransferDropTargetListener
extends AbstractContainerAreaDropAdapter {
    Viewer fViewer;

    public TextTransferDropTargetListener(Viewer viewer) {
        this.fViewer = viewer;
    }

    public Transfer getTransfer() {
        return TextTransfer.getInstance();
    }

    @Override
    public int dragEnterOperation(int operation) {
        return this.dragOverOperation(operation, null, null);
    }

    @Override
    public int dragOverOperation(int operation, IContainer dropContainer, Object dropTarget) {
        if (operation != 0) {
            return 1;
        }
        return operation;
    }

    @Override
    public void dropToContainer(Object dropObject, IContainer dropContainer, int operation) {
        if (dropObject instanceof String && ((String)dropObject).length() > 0 && dropContainer != null) {
            TextTransferDropTargetListener.createMultilineTargetsUI((String)dropObject, dropContainer, operation, this.fViewer.getControl().getShell());
        }
    }

    private static IMakeTarget[] prepareMakeTargetsFromString(String multilineText, IContainer container) {
        if (container != null) {
            String[] lines = multilineText.split("[\n\r]");
            ArrayList<IMakeTarget> makeTargets = new ArrayList<IMakeTarget>(lines.length);
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                if ((command = command.trim()).length() > 0) {
                    String name = command;
                    String buildCommand = command;
                    String buildTarget = null;
                    String defaultBuildCommand = MakeTargetDndUtil.getProjectBuildCommand(container.getProject());
                    if (command.startsWith(String.valueOf(defaultBuildCommand) + " ")) {
                        buildCommand = defaultBuildCommand;
                        name = buildTarget = command.substring(defaultBuildCommand.length() + 1).trim();
                    }
                    try {
                        makeTargets.add(MakeTargetDndUtil.createMakeTarget(name, buildTarget, buildCommand, container));
                    }
                    catch (CoreException e) {
                        MakeUIPlugin.log(e);
                    }
                }
                ++n2;
            }
            return makeTargets.toArray(new IMakeTarget[makeTargets.size()]);
        }
        return null;
    }

    public static void createMultilineTargetsUI(String multilineText, IContainer dropContainer, int operation, Shell shell) {
        IMakeTarget[] makeTargets = TextTransferDropTargetListener.prepareMakeTargetsFromString(multilineText, dropContainer);
        boolean confirmed = true;
        if (makeTargets.length > 1) {
            String title = MakeUIPlugin.getResourceString("MakeTargetDnD.title.createFromTextConfirm");
            String question = MessageFormat.format(MakeUIPlugin.getResourceString("MakeTargetDnD.message.createFromTextConfirm"), makeTargets.length);
            String topTargets = "";
            int i = 0;
            while (i < makeTargets.length) {
                int HEIGHT_LIMIT = 20;
                int LENGTH_LIMIT = 200;
                if (i > 20) {
                    topTargets = String.valueOf(topTargets) + "...";
                    break;
                }
                String name = makeTargets[i].getName();
                if (name.length() > 200) {
                    name = String.valueOf(name.substring(0, 197)) + "...";
                }
                topTargets = String.valueOf(topTargets) + name + "\n";
                ++i;
            }
            confirmed = MessageDialog.openConfirm((Shell)shell, (String)title, (String)(String.valueOf(question) + topTargets));
        }
        if (confirmed) {
            MakeTargetDndUtil.copyTargets(makeTargets, dropContainer, operation, shell);
        }
    }
}

