/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.compare;

import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.MakefileSourceConfiguration;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefilePartitionScanner;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class MakefileMergeViewer
extends TextMergeViewer {
    private MakefileSourceConfiguration fSourceViewerConfiguration;
    private IPropertyChangeListener fPreferenceChangeListener;
    private IPreferenceStore fPreferenceStore;
    protected boolean fUseSystemColors;

    protected static RGB createColor(IPreferenceStore store, String key) {
        if (!store.contains(key)) {
            return null;
        }
        if (store.isDefault(key)) {
            return PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        return PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
    }

    public MakefileMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(parent, style | 0x2000000, configuration);
        IPreferenceStore store = this.getPreferenceStore();
        this.fUseSystemColors = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        if (!this.fUseSystemColors) {
            RGB bg = MakefileMergeViewer.createColor(store, "AbstractTextEditor.Color.Background");
            this.setBackgroundColor(bg);
            RGB fg = MakefileMergeViewer.createColor(store, "org.eclipse.cdt.make.ui.editor.default");
            this.setForegroundColor(fg);
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            this.fPreferenceStore = MakeUIPlugin.getDefault().getCombinedPreferenceStore();
            this.fPreferenceChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    MakefileMergeViewer.this.handlePropertyChange(event);
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
        return this.fPreferenceStore;
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fPreferenceChangeListener != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            this.fPreferenceChangeListener = null;
        }
        super.handleDispose(event);
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("AbstractTextEditor.Color.Background")) {
            if (!this.fUseSystemColors) {
                RGB bg = MakefileMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(bg);
            }
        } else if (key.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
            this.fUseSystemColors = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
            if (this.fUseSystemColors) {
                this.setBackgroundColor(null);
                this.setForegroundColor(null);
            } else {
                RGB bg = MakefileMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(bg);
                RGB fg = MakefileMergeViewer.createColor(this.fPreferenceStore, "org.eclipse.cdt.make.ui.editor.default");
                this.setForegroundColor(fg);
            }
        } else if (key.equals("org.eclipse.cdt.make.ui.editor.default") && !this.fUseSystemColors) {
            RGB fg = MakefileMergeViewer.createColor(this.fPreferenceStore, "org.eclipse.cdt.make.ui.editor.default");
            this.setForegroundColor(fg);
        }
        if (this.fSourceViewerConfiguration != null && this.fSourceViewerConfiguration.affectsBehavior(event)) {
            this.fSourceViewerConfiguration.adaptToPreferenceChange(event);
            this.invalidateTextPresentation();
        }
    }

    protected String getDocumentPartitioning() {
        return "___makefile_partitioning";
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new MakefilePartitionScanner(), MakefilePartitionScanner.MAKE_PARTITIONS);
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            ((SourceViewer)textViewer).configure(this.getSourceViewerConfiguration());
        }
    }

    public String getTitle() {
        return MakeUIPlugin.getResourceString("MakefileMergeViewer.title");
    }

    protected SourceViewerConfiguration getSourceViewerConfiguration() {
        if (this.fSourceViewerConfiguration == null) {
            this.fSourceViewerConfiguration = new MakefileSourceConfiguration(this.getPreferenceStore(), null);
        }
        return this.fSourceViewerConfiguration;
    }
}

