/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.flatpak.launcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.ICommandLauncherFactory;
import org.eclipse.cdt.core.ICommandLauncherFactory2;
import org.eclipse.cdt.core.ICommandLauncherFactory3;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.flatpak.launcher.FlatpakCommandLauncher;
import org.eclipse.cdt.flatpak.launcher.FlatpakLaunchPlugin;
import org.eclipse.cdt.internal.flatpak.launcher.ui.preferences.FlatpakPreferenceNode;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class FlatpakCommandLauncherFactory
implements ICommandLauncherFactory,
ICommandLauncherFactory2,
ICommandLauncherFactory3 {
    private static Set<String> copiedDirs = null;
    private static Set<String> removedDirs = new HashSet<String>();
    private static Object lockObject = new Object();
    private static final String HEADERS = "HEADERS";
    private static final String COPIED = ".copied";
    private static final String REMOVED = ".removed";
    public static final String FLATPAK_PREFERENCE_PAGES = "flatpakPreferencePages";
    private IProject project;

    public FlatpakCommandLauncherFactory() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize() {
        Object object = lockObject;
        synchronized (object) {
            block44: {
                if (copiedDirs == null) {
                    IPath removedPath;
                    File removedFile;
                    BufferedReader bufferedReader3;
                    Object reader;
                    IPath pluginPath;
                    block42: {
                        copiedDirs = new HashSet<String>();
                        pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.flatpak.launcher")).append(HEADERS);
                        IPath copiedPath = pluginPath.append(COPIED);
                        File copiedFile = copiedPath.toFile();
                        if (copiedFile.exists()) {
                            try {
                                Throwable throwable = null;
                                Object var6_9 = null;
                                try {
                                    reader = new FileReader(copiedFile);
                                    try {
                                        bufferedReader3 = new BufferedReader((Reader)reader);
                                        try {
                                            String dir = bufferedReader3.readLine();
                                            while (dir != null) {
                                                if (!dir.isEmpty()) {
                                                    copiedDirs.add(dir);
                                                }
                                                dir = bufferedReader3.readLine();
                                            }
                                        }
                                        finally {
                                            if (bufferedReader3 != null) {
                                                bufferedReader3.close();
                                            }
                                        }
                                        if (reader == null) break block42;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (reader == null) throw throwable;
                                        ((InputStreamReader)reader).close();
                                        throw throwable;
                                    }
                                    ((InputStreamReader)reader).close();
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                        throw throwable;
                                    }
                                    if (throwable == throwable3) throw throwable;
                                    throwable.addSuppressed(throwable3);
                                    throw throwable;
                                }
                            }
                            catch (IOException e) {
                                FlatpakLaunchPlugin.log(e);
                            }
                        }
                    }
                    if ((removedFile = (removedPath = pluginPath.append(REMOVED)).toFile()).exists()) {
                        try {
                            reader = null;
                            bufferedReader3 = null;
                            try {
                                FileReader reader2 = new FileReader(removedFile);
                                try {
                                    try (BufferedReader bufferedReader2 = new BufferedReader(reader2);){
                                        String dir = bufferedReader2.readLine();
                                        while (dir != null) {
                                            if (!dir.isEmpty()) {
                                                removedDirs.add(dir);
                                            }
                                            dir = bufferedReader2.readLine();
                                        }
                                    }
                                    if (reader2 == null) break block44;
                                }
                                catch (Throwable bufferedReader3) {
                                    if (reader == null) {
                                        reader = bufferedReader3;
                                    } else if (reader != bufferedReader3) {
                                        ((Throwable)reader).addSuppressed(bufferedReader3);
                                    }
                                    if (reader2 == null) throw reader;
                                    reader2.close();
                                    throw reader;
                                }
                                reader2.close();
                            }
                            catch (Throwable bufferedReader3) {
                                if (reader == null) {
                                    reader = bufferedReader3;
                                    throw reader;
                                }
                                if (reader == bufferedReader3) throw reader;
                                ((Throwable)reader).addSuppressed(bufferedReader3);
                                throw reader;
                            }
                        }
                        catch (IOException e) {
                            FlatpakLaunchPlugin.log(e);
                        }
                    }
                }
            }
        }
        if (System.getenv("FLATPAK_SANDBOX_DIR") == null) return;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.flatpak.launcher", FLATPAK_PREFERENCE_PAGES);
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute("id");
            String category = elements[i].getAttribute("category");
            String className = elements[i].getAttribute("class");
            String name = elements[i].getAttribute("name");
            if (category != null && name != null && id != null && className != null) {
                FlatpakPreferenceNode node = new FlatpakPreferenceNode(id, name, null, className);
                PlatformUI.getWorkbench().getPreferenceManager().addTo(category, (IPreferenceNode)node);
            }
            ++i;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDir(String path) throws IOException {
        Object object = lockObject;
        synchronized (object) {
            ArrayList<String> removedEntries = new ArrayList<String>();
            for (String copiedDir : copiedDirs) {
                if (!copiedDir.startsWith(path)) continue;
                removedEntries.add(copiedDir);
            }
            for (String removedEntry : removedEntries) {
                copiedDirs.remove(removedEntry);
                removedDirs.add(removedEntry);
            }
            FlatpakCommandLauncherFactory.updateFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDirs() {
        Object object = lockObject;
        synchronized (object) {
            ArrayList<String> newDirs = new ArrayList<String>(copiedDirs);
            return newDirs;
        }
    }

    public ICommandLauncher getCommandLauncher(IProject project) {
        this.project = project;
        if (System.getenv("FLATPAK_SANDBOX_DIR") != null) {
            return new FlatpakCommandLauncher();
        }
        return null;
    }

    public ICommandLauncher getCommandLauncher(ICConfigurationDescription cfgd) {
        if (System.getenv("FLATPAK_SANDBOX_DIR") != null) {
            return new FlatpakCommandLauncher();
        }
        return null;
    }

    public ICommandLauncher getCommandLauncher(ICBuildConfiguration cfgd) {
        if (System.getenv("FLATPAK_SANDBOX_DIR") != null) {
            return new FlatpakCommandLauncher();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLanguageSettingEntries(IProject project, List<? extends ICLanguageSettingEntry> langEntries) {
        Object object = lockObject;
        synchronized (object) {
            List<? extends ICLanguageSettingEntry> entries = langEntries;
            ArrayList<String> paths = new ArrayList<String>();
            for (ICLanguageSettingEntry iCLanguageSettingEntry : entries) {
                if (!(iCLanguageSettingEntry instanceof ICIncludePathEntry)) continue;
                paths.add(iCLanguageSettingEntry.getValue());
            }
            if (paths.size() > 0) {
                IPath iPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.flatpak.launcher")).append(HEADERS);
                iPath.toFile().mkdir();
                for (String path : paths) {
                    if (path.startsWith(project.getWorkspace().getRoot().getLocation().toString())) continue;
                    try {
                        String[] removedEntries;
                        Process p2;
                        int rc2;
                        Process p1 = ProcessFactory.getFactory().exec(new String[]{"mkdir", "-p", iPath.append(path).toOSString()});
                        int rc1 = this.waitFor(p1);
                        if (rc1 != 0 || (rc2 = this.waitFor(p2 = ProcessFactory.getFactory().exec(new String[]{"cp", "-ru", "path", iPath.append(path).removeLastSegments(1).toOSString()}))) != 0) continue;
                        copiedDirs.add(path);
                        String[] stringArray = removedEntries = removedDirs.toArray(new String[0]);
                        int n = removedEntries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String removedDir = stringArray[n2];
                            if (removedDir.startsWith(path)) {
                                removedDirs.remove(removedDir);
                                copiedDirs.add(removedDir);
                            }
                            ++n2;
                        }
                        FlatpakCommandLauncherFactory.updateFiles();
                    }
                    catch (IOException e) {
                        FlatpakLaunchPlugin.log(e);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void updateFiles() throws IOException {
        Throwable throwable;
        IPath pluginPath;
        block27: {
            pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.flatpak.launcher")).append(HEADERS);
            pluginPath.toFile().mkdir();
            IPath copiedListPath = pluginPath.append(COPIED);
            Throwable throwable2 = null;
            throwable = null;
            try {
                FileWriter writer = new FileWriter(copiedListPath.toFile());
                try {
                    try (BufferedWriter bufferedWriter = new BufferedWriter(writer);){
                        for (String copiedDir : copiedDirs) {
                            bufferedWriter.write(copiedDir);
                            bufferedWriter.newLine();
                        }
                    }
                    if (writer == null) break block27;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    if (writer == null) throw throwable2;
                    writer.close();
                    throw throwable2;
                }
                writer.close();
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                    throw throwable2;
                }
                if (throwable2 == throwable4) throw throwable2;
                throwable2.addSuppressed(throwable4);
                throw throwable2;
            }
        }
        IPath removedListPath = pluginPath.append(REMOVED);
        throwable = null;
        Object var4_8 = null;
        try {
            FileWriter writer = new FileWriter(removedListPath.toFile());
            try {
                try (BufferedWriter bufferedWriter = new BufferedWriter(writer);){
                    for (String removedDir : removedDirs) {
                        bufferedWriter.write(removedDir);
                        bufferedWriter.newLine();
                    }
                }
                if (writer == null) return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            writer.close();
            return;
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            }
            if (throwable == throwable6) throw throwable;
            throwable.addSuppressed(throwable6);
            throw throwable;
        }
    }

    private int waitFor(Process p) {
        int rc = -1;
        boolean finished = false;
        try {
            Thread.sleep(100L);
            while (!finished) {
                rc = p.exitValue();
                finished = true;
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (InterruptedException e) {
            finished = true;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> verifyIncludePaths(ICBuildConfiguration cfgd, List<String> includePaths) {
        Object object = lockObject;
        synchronized (object) {
            if (includePaths.size() > 0) {
                IPath copiedPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.flatpak.launcher")).append(HEADERS);
                copiedPath.toFile().mkdir();
                ArrayList<String> newEntries = new ArrayList<String>();
                for (String path : includePaths) {
                    if (path.startsWith(this.project.getWorkspace().getRoot().getLocation().toString())) continue;
                    if (!copiedDirs.contains(path)) {
                        try {
                            Process p1 = ProcessFactory.getFactory().exec(new String[]{"mkdir", "-p", copiedPath.append(path).toOSString()});
                            int rc1 = this.waitFor(p1);
                            if (rc1 != 0) continue;
                            Process p2 = ProcessFactory.getFactory().exec(new String[]{"cp", "-ru", path, copiedPath.append(path).removeLastSegments(1).toOSString()});
                            int rc2 = this.waitFor(p2);
                            if (rc2 == 0) {
                                String[] removedEntries;
                                copiedDirs.add(path);
                                newEntries.add(copiedPath.append(path).toOSString());
                                String[] stringArray = removedEntries = removedDirs.toArray(new String[0]);
                                int n = removedEntries.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String removedDir = stringArray[n2];
                                    if (removedDir.startsWith(path)) {
                                        removedDirs.remove(removedDir);
                                        copiedDirs.add(removedDir);
                                    }
                                    ++n2;
                                }
                                FlatpakCommandLauncherFactory.updateFiles();
                                continue;
                            }
                            newEntries.add(path);
                        }
                        catch (IOException e) {
                            FlatpakLaunchPlugin.log(e);
                        }
                        continue;
                    }
                    newEntries.add(copiedPath.append(path).toOSString());
                }
                return newEntries;
            }
            return includePaths;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICLanguageSettingEntry> verifyLanguageSettingEntries(IProject project, List<ICLanguageSettingEntry> entries) {
        if (entries == null) {
            return null;
        }
        Object object = lockObject;
        synchronized (object) {
            ArrayList<ICLanguageSettingEntry> newEntries = new ArrayList<ICLanguageSettingEntry>();
            IPath pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.flatpak.launcher"));
            IPath hostDir = pluginPath.append(HEADERS);
            for (ICLanguageSettingEntry entry : entries) {
                if (entry instanceof ICIncludePathEntry) {
                    String path = entry.getName().toString();
                    if (removedDirs.contains(path)) {
                        try {
                            Process p2;
                            int rc2;
                            Process p1 = ProcessFactory.getFactory().exec(new String[]{"mkdir", "-p", hostDir.append(path).toOSString()});
                            int rc1 = this.waitFor(p1);
                            if (rc1 == 0 && (rc2 = this.waitFor(p2 = ProcessFactory.getFactory().exec(new String[]{"cp", "-ru", path, hostDir.append(path).removeLastSegments(1).toOSString()}))) == 0) {
                                String[] removedEntries;
                                copiedDirs.add(path);
                                String[] stringArray = removedEntries = removedDirs.toArray(new String[0]);
                                int n = removedEntries.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String removedDir = stringArray[n2];
                                    if (removedDir.startsWith(path)) {
                                        removedDirs.remove(removedDir);
                                        copiedDirs.add(removedDir);
                                    }
                                    ++n2;
                                }
                                FlatpakCommandLauncherFactory.updateFiles();
                            }
                        }
                        catch (IOException e) {
                            FlatpakLaunchPlugin.log(e);
                        }
                    }
                    if (copiedDirs.contains(path)) {
                        IPath newPath = hostDir.append(entry.getName());
                        CIncludePathEntry newEntry = new CIncludePathEntry(newPath.toString(), entry.getFlags());
                        newEntries.add((ICLanguageSettingEntry)newEntry);
                        continue;
                    }
                    newEntries.add(entry);
                    continue;
                }
                newEntries.add(entry);
            }
            return newEntries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfIncludesChanged(ICBuildConfiguration cfg) {
        Object object = lockObject;
        synchronized (object) {
            return !removedDirs.isEmpty();
        }
    }
}

