/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.ant.internal.ui.datatransfer.EclipseClasspath;
import org.eclipse.ant.internal.ui.datatransfer.ExportUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SourceAnalyzer {
    private SourceAnalyzer() {
    }

    public static void checkCycles(IJavaProject currentProject, EclipseClasspath classpath, Shell shell) {
        StringBuffer message = new StringBuffer();
        TreeMap<String, String> src2dir = new TreeMap<String, String>();
        TreeMap<String, Set<String>> srcdir2classes = new TreeMap<String, Set<String>>();
        SourceAnalyzer.determineSources(currentProject, classpath, src2dir, srcdir2classes);
        Map<String, Set<String>> srcdir2sourcedirs = SourceAnalyzer.determineRequiredSrcDirs(src2dir, srcdir2classes);
        String projectName = currentProject.getProject().getName();
        ArrayList<String> cycle = new ArrayList<String>();
        if (SourceAnalyzer.isCyclic(srcdir2sourcedirs, cycle)) {
            SourceAnalyzer.showCycleWarning(projectName, shell, cycle, message);
            return;
        }
        SourceAnalyzer.checkBuildOrder(classpath, projectName, shell, srcdir2sourcedirs);
    }

    private static void determineSources(IJavaProject currentProject, EclipseClasspath classpath, Map<String, String> src2dir, Map<String, Set<String>> srcdir2classes) {
        int i = 0;
        while (i < classpath.srcDirs.size()) {
            String srcDir = classpath.srcDirs.get(i);
            String classDir = classpath.classDirs.get(i);
            if (!EclipseClasspath.isReference(srcDir)) {
                String link;
                File dir;
                if (srcDir.equals(".")) {
                    dir = currentProject.getResource().getLocation().toFile();
                } else {
                    IFile file = currentProject.getProject().getFile(srcDir);
                    dir = file.getLocation().toFile();
                }
                if (EclipseClasspath.isLinkedResource(srcDir) && !(dir = new File(link = classpath.resolveLinkedResource(srcDir))).isAbsolute()) {
                    dir = new File(ExportUtil.getProjectRoot(currentProject), link);
                }
                for (String srcFile : SourceAnalyzer.findFiles(dir, ".java")) {
                    src2dir.put(srcFile, srcDir);
                    IFile classFile = currentProject.getProject().getFile(String.valueOf(classDir) + '/' + srcFile + ".class");
                    if (!classFile.exists()) continue;
                    Set<String> classes = srcdir2classes.get(srcDir);
                    if (classes == null) {
                        classes = new TreeSet<String>();
                    }
                    classes.addAll(SourceAnalyzer.getRequiredClasses(classFile));
                    srcdir2classes.put(srcDir, classes);
                }
            }
            ++i;
        }
    }

    private static Map<String, Set<String>> determineRequiredSrcDirs(Map<String, String> src2dir, Map<String, Set<String>> srcdir2classes) {
        TreeMap<String, Set<String>> srcdir2sourcedirs = new TreeMap<String, Set<String>>();
        for (String srcDir : srcdir2classes.keySet()) {
            for (String classname : srcdir2classes.get(srcDir)) {
                String classsrc = src2dir.get(classname);
                if (classsrc == null || classsrc.equals(srcDir)) continue;
                TreeSet<String> sourcedirs = (TreeSet<String>)srcdir2sourcedirs.get(srcDir);
                if (sourcedirs == null) {
                    sourcedirs = new TreeSet<String>();
                }
                sourcedirs.add(classsrc);
                srcdir2sourcedirs.put(srcDir, sourcedirs);
            }
        }
        return srcdir2sourcedirs;
    }

    private static void showCycleWarning(String projectName, Shell shell, List<String> cycle, StringBuffer message) {
        String m = MessageFormat.format(DataTransferMessages.SourceAnalyzer_0, projectName);
        message.append(m);
        message.append(ExportUtil.NEWLINE);
        for (String s : cycle) {
            s = EclipseClasspath.getLinkedResourceName(s);
            message.append(s);
            message.append(" -> ");
        }
        message.append(EclipseClasspath.getLinkedResourceName(cycle.get(0)));
        MessageDialog.openWarning((Shell)shell, (String)DataTransferMessages.SourceAnalyzer_1, (String)message.toString());
    }

    private static void checkBuildOrder(EclipseClasspath classpath, String projectName, Shell shell, Map<String, Set<String>> srcdir2sourcedirs) {
        block0: for (String srcdir : srcdir2sourcedirs.keySet()) {
            int classpathIndex = classpath.srcDirs.indexOf(srcdir);
            for (String requiredSrc : srcdir2sourcedirs.get(srcdir)) {
                int i = classpath.srcDirs.indexOf(requiredSrc);
                if (i <= classpathIndex) continue;
                String s = MessageFormat.format(DataTransferMessages.SourceAnalyzer_3, projectName);
                MessageDialog.openWarning((Shell)shell, (String)DataTransferMessages.SourceAnalyzer_2, (String)(String.valueOf(s) + ExportUtil.NEWLINE + requiredSrc + " <-> " + srcdir + ExportUtil.NEWLINE));
                continue block0;
            }
        }
    }

    public static Set<String> getRequiredClasses(IFile file) {
        TreeSet<String> classes = new TreeSet<String>();
        IClassFile classFile = JavaCore.createClassFileFrom((IFile)file);
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((IClassFile)classFile, (int)1);
        if (reader == null) {
            return classes;
        }
        IConstantPool pool = reader.getConstantPool();
        int i = 0;
        while (i < pool.getConstantPoolCount()) {
            if (pool.getEntryKind(i) == 7) {
                IConstantPoolEntry entry = pool.decodeEntry(i);
                String classname = new String(entry.getClassInfoName());
                int index = classname.indexOf(36);
                if (index != -1) {
                    classname = classname.substring(0, index);
                }
                classes.add(classname);
            }
            ++i;
        }
        return classes;
    }

    public static Set<String> findFiles(File dir, String extension) {
        TreeSet<String> visited = new TreeSet<String>();
        SourceAnalyzer.findFiles(dir, dir, extension, visited);
        return visited;
    }

    private static void findFiles(File base, File dir, String extension, Set<String> visited) {
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                SourceAnalyzer.findFiles(base, element, extension, visited);
                ++n2;
            }
        } else if (dir.getAbsolutePath().endsWith(extension)) {
            String filename = ExportUtil.removePrefixAndSuffix(dir.getAbsolutePath(), String.valueOf(base.getAbsolutePath()) + File.separator, extension);
            visited.add(filename.replace('\\', '/'));
        }
    }

    private static boolean isCyclic(Map<String, Set<String>> srcdir2sourcedirs, List<String> cycle) {
        return !SourceAnalyzer.isAcyclic(srcdir2sourcedirs, cycle);
    }

    private static boolean isAcyclic(Map<String, Set<String>> srcdir2sourcedirs, List<String> cycle) {
        ArrayList<String> visited = new ArrayList<String>();
        ArrayList<String> exited = new ArrayList<String>();
        for (String srcdir : srcdir2sourcedirs.keySet()) {
            if (visited.contains(srcdir) || !SourceAnalyzer.circleSearch(srcdir, srcdir2sourcedirs, visited, exited, cycle)) continue;
            return false;
        }
        return true;
    }

    private static boolean circleSearch(String srcdir, Map<String, Set<String>> srcdir2sourcedirs, List<String> visited, List<String> exited, List<String> cycle) {
        boolean res = false;
        visited.add(srcdir);
        cycle.add(srcdir);
        Set<String> sourcedirs = srcdir2sourcedirs.get(srcdir);
        if (sourcedirs != null) {
            for (String src : sourcedirs) {
                if (!visited.contains(src)) {
                    res = SourceAnalyzer.circleSearch(src, srcdir2sourcedirs, visited, exited, cycle);
                } else if (!exited.contains(src)) {
                    res = true;
                }
                if (res) break;
            }
        }
        if (!res) {
            cycle.clear();
        }
        exited.add(srcdir);
        return res;
    }
}

