/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.result;

import org.eclipse.acceleo.internal.ide.ui.views.result.AbstractTraceabilityElement;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.utilities.ASTNode;

public class TraceabilityRegion
extends AbstractTraceabilityElement {
    private int targetFileOffset;
    private int targetFileLength;
    private ASTNode astNode;
    private String label;

    public TraceabilityRegion(int targetFileOffset, int targetFileLength, ASTNode astNode) {
        this.targetFileOffset = targetFileOffset;
        this.targetFileLength = targetFileLength;
        this.astNode = astNode;
        this.label = this.toString();
    }

    public int getTargetFileOffset() {
        return this.targetFileOffset;
    }

    public int getTargetFileLength() {
        return this.targetFileLength;
    }

    public ASTNode getAstNode() {
        return this.astNode;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void enlarge(int length) {
        this.targetFileLength += length;
    }

    public String toString() {
        if (this.astNode != null && !this.astNode.eIsProxy()) {
            ModuleElement eModuleElement;
            String templateName = this.astNode.eResource().getURI().lastSegment();
            String templateDisplay = this.astNode instanceof ModuleElement ? String.valueOf('/') + templateName + '/' + ((ModuleElement)this.astNode).getName() : ((eModuleElement = this.getModuleElement((EObject)this.astNode)) != null ? String.valueOf('/') + templateName + '/' + eModuleElement.getName() + '/' + this.astNode.eClass().getName() : String.valueOf('/') + templateName + '/' + this.astNode.eClass().getName());
            return "[" + this.targetFileOffset + "," + (this.targetFileOffset + this.targetFileLength) + "] by '" + templateDisplay + "'";
        }
        String result = "";
        if (this.astNode != null) {
            result = this.astNode.toString();
        }
        return result;
    }

    private ModuleElement getModuleElement(EObject currentAstNode) {
        EObject current = currentAstNode;
        while (current != null) {
            if (current instanceof ModuleElement) {
                return (ModuleElement)current;
            }
            current = current.eContainer();
        }
        return null;
    }
}

