/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.apache.connector;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.glassfish.jersey.client.ClientRequest;

public interface ApacheConnectionClosingStrategy {
    public void close(ClientRequest var1, HttpUriRequest var2, CloseableHttpResponse var3, InputStream var4) throws IOException;

    public static class GracefulClosingStrategy
    implements ApacheConnectionClosingStrategy {
        static final GracefulClosingStrategy INSTANCE = new GracefulClosingStrategy();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(ClientRequest clientRequest, HttpUriRequest request, CloseableHttpResponse response, InputStream stream) throws IOException {
            if (response.getEntity() != null && response.getEntity().isChunked()) {
                request.abort();
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                response.close();
            }
        }
    }

    public static class ImmediateClosingStrategy
    implements ApacheConnectionClosingStrategy {
        static final ImmediateClosingStrategy INSTANCE = new ImmediateClosingStrategy();

        @Override
        public void close(ClientRequest clientRequest, HttpUriRequest request, CloseableHttpResponse response, InputStream stream) throws IOException {
            response.close();
            stream.close();
        }
    }
}

