/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.tasks;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.tasks.ITaskFinder;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.ui.markers.IMarkerContributor;
import org.eclipse.xtext.ui.tasks.TaskMarkerCreator;
import org.eclipse.xtext.ui.tasks.TaskMarkerTypeProvider;

public class TaskMarkerContributor
implements IMarkerContributor {
    private static final Logger LOG = Logger.getLogger(TaskMarkerContributor.class);
    @Inject
    private TaskMarkerCreator markerCreator;
    @Inject
    private ITaskFinder taskFinder;
    @Inject
    private TaskMarkerTypeProvider typeProvider;

    @Override
    public void updateMarkers(IFile file, Resource resource, IProgressMonitor monitor) {
        try {
            List tasks = this.taskFinder.findTasks(resource);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.deleteMarkers(file, monitor);
            this.createTaskMarkers(file, tasks, monitor);
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createTaskMarkers(IFile file, List<Task> tasks, IProgressMonitor monitor) throws CoreException {
        for (Task task : tasks) {
            this.markerCreator.createMarker(task, (IResource)file, this.typeProvider.getMarkerType(task));
        }
    }

    @Override
    public void deleteMarkers(IFile file, IProgressMonitor monitor) {
        try {
            file.deleteMarkers("org.eclipse.xtext.ui.task", true, 0);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

