/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.templates;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.templates.AbstractTemplateVariableResolver;
import org.eclipse.xtext.ui.editor.templates.Messages;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;

@Singleton
public class CrossReferenceTemplateVariableResolver
extends AbstractTemplateVariableResolver {
    private static final Logger log = Logger.getLogger(CrossReferenceTemplateVariableResolver.class);
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IGlobalScopeProvider globalScopeProvider;

    public CrossReferenceTemplateVariableResolver() {
        super("CrossReference", Messages.CrossReferenceTemplateVariableResolver_1);
    }

    @Override
    public List<String> resolveValues(TemplateVariable variable, XtextTemplateContext castedContext) {
        String abbreviatedCrossReference = (String)variable.getVariableType().getParams().iterator().next();
        int dotIndex = abbreviatedCrossReference.lastIndexOf(46);
        if (dotIndex <= 0) {
            log.error((Object)("CrossReference '" + abbreviatedCrossReference + "' could not be resolved."));
            return Collections.emptyList();
        }
        String[] classReferencePair = new String[]{abbreviatedCrossReference.substring(0, dotIndex), abbreviatedCrossReference.substring(dotIndex + 1)};
        Grammar grammar = this.getGrammar(castedContext);
        if (grammar == null) {
            return Collections.emptyList();
        }
        EReference reference = this.getReference(classReferencePair[0], classReferencePair[1], grammar);
        if (reference == null) {
            log.debug((Object)("CrossReference to class '" + classReferencePair[0] + "' and reference '" + classReferencePair[1] + "' could not be resolved."));
            return Collections.emptyList();
        }
        IScope scope = null;
        EObject currentModel = castedContext.getContentAssistContext().getCurrentModel();
        scope = currentModel == null ? this.globalScopeProvider.getScope((Resource)castedContext.getContentAssistContext().getResource(), reference, null) : castedContext.getScopeProvider().getScope(currentModel, reference);
        Iterable<IEObjectDescription> linkingCandidates = this.queryScope(scope);
        ArrayList<String> names = new ArrayList<String>();
        for (IEObjectDescription eObjectDescription : linkingCandidates) {
            names.add(this.qualifiedNameConverter.toString(eObjectDescription.getName()));
        }
        return names;
    }

    protected Iterable<IEObjectDescription> queryScope(IScope scope) {
        return scope.getAllElements();
    }

    protected EReference getReference(String eClassName, String eReferenceName, Grammar grammar) {
        EClass eClass = (EClass)this.getEClassifierForGrammar(eClassName, grammar);
        if (eClass != null) {
            return (EReference)eClass.getEStructuralFeature(eReferenceName);
        }
        return null;
    }
}

