/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.wsil.Link;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesWSILElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class FavoritesWSILFolderElement
extends FavoritesFolderElement {
    public FavoritesWSILFolderElement(String name, Model model, NodeManager nodeManager) {
        super(name, model, nodeManager);
    }

    @Override
    public void init(FavoritesMainElement favMainElement) {
        Link[] links = favMainElement.loadWSILs();
        int i = 0;
        while (i < links.length) {
            Link link = links[i];
            FavoritesWSILElement favWSILElement = new FavoritesWSILElement(link.getLocation(), this.getModel(), link);
            this.connect((Element)favWSILElement, "relWSILNode", "owner");
            ++i;
        }
    }

    @Override
    public boolean addFavorite(Hashtable table) {
        String wsilURL = (String)table.get("wsilURL");
        if (wsilURL == null) {
            return false;
        }
        FavoritesWSILElement e = this.getFavorite(wsilURL);
        if (e != null) {
            this.removeFavorite(e);
        }
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Link link = favMainElement.addWSILLink(wsilURL);
        boolean saved = favMainElement.saveFavorites();
        if (saved) {
            FavoritesWSILElement favWSILElement = new FavoritesWSILElement(wsilURL, this.getModel(), link);
            this.connect((Element)favWSILElement, "relWSILNode", "owner");
        }
        return saved;
    }

    @Override
    public boolean favoriteExists(Hashtable table) {
        String wsilURL = (String)table.get("wsilURL");
        if (wsilURL == null) {
            return false;
        }
        return this.getFavorite(wsilURL) != null;
    }

    @Override
    public boolean removeFavoriteByNodeID(int nodeID, String pluginMetadataDirectory) {
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (selectedElement instanceof FavoritesWSILElement) {
            return this.removeFavorite((FavoritesWSILElement)selectedElement) && favMainElement.saveFavorites();
        }
        return false;
    }

    private boolean removeFavorite(FavoritesWSILElement element) {
        Link link = element.getLink();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (favMainElement.removeLink(link)) {
            element.disconnectAll();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllFavorites(String pluginMetadataDirectory) {
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesWSILElement favWSILElement = (FavoritesWSILElement)((Object)e.nextElement());
            Link link = favWSILElement.getLink();
            favMainElement.removeLink(link);
        }
        this.disconnectRel("relWSILNode");
        return favMainElement.saveFavorites();
    }

    @Override
    public Enumeration getAllFavorites() {
        return this.getElements("relWSILNode");
    }

    private FavoritesWSILElement getFavorite(String wsilUrl) {
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesWSILElement wsilElement = (FavoritesWSILElement)((Object)e.nextElement());
            if (!wsilUrl.equals(wsilElement.getWsilUrl())) continue;
            return wsilElement;
        }
        return null;
    }
}

