/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.wsil.Link;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIBusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class FavoritesUDDIBusinessFolderElement
extends FavoritesFolderElement {
    public FavoritesUDDIBusinessFolderElement(String name, Model model, NodeManager nodeManager) {
        super(name, model, nodeManager);
    }

    @Override
    public void init(FavoritesMainElement favMainElement) {
        Link[] links = favMainElement.loadUDDIBusinesses();
        int i = 0;
        while (i < links.length) {
            Link link = links[i];
            FavoritesUDDIBusinessElement favUDDIBusinessElement = new FavoritesUDDIBusinessElement(link.getAbstracts()[0].getText(), this.getModel(), link);
            this.connect((Element)favUDDIBusinessElement, "relUDDIBusinessNode", "owner");
            ++i;
        }
    }

    @Override
    public boolean addFavorite(Hashtable table) {
        String businessName = (String)table.get("UDDIBusinessName");
        String inquiryAPI = (String)table.get("UDDIBusinessInquiryAPI");
        String businessKey = (String)table.get("UDDIBusinessKey");
        if (businessName == null || inquiryAPI == null || businessKey == null) {
            return false;
        }
        FavoritesUDDIBusinessElement e = this.getFavorite(inquiryAPI, businessKey);
        if (e != null) {
            this.removeFavorite(e);
        }
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Link link = favMainElement.addUDDIBusiness(businessName, inquiryAPI, businessKey);
        boolean saved = favMainElement.saveFavorites();
        if (saved) {
            FavoritesUDDIBusinessElement favUDDIBusinessElement = new FavoritesUDDIBusinessElement(businessName, this.getModel(), link);
            this.connect((Element)favUDDIBusinessElement, "relUDDIBusinessNode", "owner");
        }
        return saved;
    }

    @Override
    public boolean favoriteExists(Hashtable table) {
        String inquiryAPI = (String)table.get("UDDIBusinessInquiryAPI");
        String businessKey = (String)table.get("UDDIBusinessKey");
        if (inquiryAPI == null || businessKey == null) {
            return false;
        }
        return this.getFavorite(inquiryAPI, businessKey) != null;
    }

    @Override
    public boolean removeFavoriteByNodeID(int nodeID, String pluginMetadataDirectory) {
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (selectedElement instanceof FavoritesUDDIBusinessElement) {
            return this.removeFavorite((FavoritesUDDIBusinessElement)selectedElement) && favMainElement.saveFavorites();
        }
        return false;
    }

    private boolean removeFavorite(FavoritesUDDIBusinessElement element) {
        Link link = element.getLink();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (favMainElement.removeLink(link)) {
            element.disconnectAll();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllFavorites(String pluginMetadataDirectory) {
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesUDDIBusinessElement favUDDIBusinessElement = (FavoritesUDDIBusinessElement)((Object)e.nextElement());
            Link link = favUDDIBusinessElement.getLink();
            favMainElement.removeLink(link);
        }
        this.disconnectRel("relUDDIBusinessNode");
        return favMainElement.saveFavorites();
    }

    @Override
    public Enumeration getAllFavorites() {
        return this.getElements("relUDDIBusinessNode");
    }

    private FavoritesUDDIBusinessElement getFavorite(String inquiryAPI, String businessKey) {
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesUDDIBusinessElement busElement = (FavoritesUDDIBusinessElement)((Object)e.nextElement());
            if (!inquiryAPI.equals(busElement.getInquiryURL()) || !businessKey.equals(busElement.getBusinessKey())) continue;
            return busElement;
        }
        return null;
    }
}

