/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.BreakpointRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.DebuggerStatementRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequestManager;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ExceptionRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ResumeRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ScriptLoadRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.StepRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.SuspendRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadEnterRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadExitRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.VMDeathRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.VMDisconnectRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFBreakpointRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFDeathRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFDebuggerRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFDisconnectRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFExceptionRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFResumeRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFScriptLoadRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFStepRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFSuspendRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFThreadEnterRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFThreadExitRequest;

public class CFEventRequestManager
implements EventRequestManager {
    private List threadexits = Collections.synchronizedList(new ArrayList(4));
    private List threadenters = Collections.synchronizedList(new ArrayList(4));
    private List breakpoints = Collections.synchronizedList(new ArrayList(4));
    private List debuggers = Collections.synchronizedList(new ArrayList(4));
    private List exceptions = Collections.synchronizedList(new ArrayList(4));
    private List loads = Collections.synchronizedList(new ArrayList(4));
    private List steps = Collections.synchronizedList(new ArrayList(4));
    private List suspends = Collections.synchronizedList(new ArrayList(4));
    private List resumes = Collections.synchronizedList(new ArrayList(4));
    private List disconnects = Collections.synchronizedList(new ArrayList(4));
    private List deaths = Collections.synchronizedList(new ArrayList(4));
    private HashMap kind = new HashMap(10);
    private VirtualMachine vm = null;

    public CFEventRequestManager(VirtualMachine vm) {
        this.vm = vm;
        this.kind.put(CFBreakpointRequest.class, this.breakpoints);
        this.kind.put(CFDebuggerRequest.class, this.debuggers);
        this.kind.put(CFExceptionRequest.class, this.exceptions);
        this.kind.put(CFScriptLoadRequest.class, this.loads);
        this.kind.put(CFStepRequest.class, this.steps);
        this.kind.put(CFSuspendRequest.class, this.suspends);
        this.kind.put(CFResumeRequest.class, this.resumes);
        this.kind.put(CFThreadEnterRequest.class, this.threadenters);
        this.kind.put(CFThreadExitRequest.class, this.threadexits);
        this.kind.put(CFDisconnectRequest.class, this.disconnects);
        this.kind.put(CFDeathRequest.class, this.deaths);
    }

    public BreakpointRequest createBreakpointRequest(Location location) {
        CFBreakpointRequest request = new CFBreakpointRequest(this.vm, location);
        this.breakpoints.add(request);
        return request;
    }

    public List breakpointRequests() {
        return Collections.unmodifiableList(this.breakpoints);
    }

    public DebuggerStatementRequest createDebuggerStatementRequest() {
        CFDebuggerRequest request = new CFDebuggerRequest(this.vm);
        this.debuggers.add(request);
        return request;
    }

    public List debuggerStatementRequests() {
        return Collections.unmodifiableList(this.debuggers);
    }

    public ExceptionRequest createExceptionRequest() {
        CFExceptionRequest request = new CFExceptionRequest(this.vm);
        this.exceptions.add(request);
        return request;
    }

    public List exceptionRequests() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public ScriptLoadRequest createScriptLoadRequest() {
        CFScriptLoadRequest request = new CFScriptLoadRequest(this.vm);
        this.loads.add(request);
        return request;
    }

    public List scriptLoadRequests() {
        return Collections.unmodifiableList(this.loads);
    }

    public StepRequest createStepRequest(ThreadReference thread, int step) {
        CFStepRequest request = new CFStepRequest(this.vm, thread, step);
        this.steps.add(request);
        return request;
    }

    public List stepRequests() {
        return Collections.unmodifiableList(this.steps);
    }

    public SuspendRequest createSuspendRequest(ThreadReference thread) {
        CFSuspendRequest request = new CFSuspendRequest(this.vm, thread);
        this.suspends.add(request);
        return request;
    }

    public List suspendRequests() {
        return Collections.unmodifiableList(this.suspends);
    }

    public ResumeRequest createResumeRequest(ThreadReference thread) {
        CFResumeRequest request = new CFResumeRequest(this.vm, thread);
        this.resumes.add(request);
        return request;
    }

    public List resumeRequests() {
        return Collections.unmodifiableList(this.resumes);
    }

    public ThreadEnterRequest createThreadEnterRequest() {
        CFThreadEnterRequest request = new CFThreadEnterRequest(this.vm);
        this.threadenters.add(request);
        return request;
    }

    public List threadEnterRequests() {
        return Collections.unmodifiableList(this.threadenters);
    }

    public ThreadExitRequest createThreadExitRequest() {
        CFThreadExitRequest request = new CFThreadExitRequest(this.vm);
        this.threadexits.add(request);
        return request;
    }

    public List threadExitRequests() {
        return Collections.unmodifiableList(this.threadexits);
    }

    public void deleteEventRequest(EventRequest eventRequest) {
        List requests = (List)this.kind.get(eventRequest.getClass());
        if (requests != null) {
            requests.remove(eventRequest);
            eventRequest.setEnabled(false);
        }
    }

    public void deleteEventRequest(List eventRequests) {
        Iterator iter = eventRequests.iterator();
        while (iter.hasNext()) {
            this.deleteEventRequest((EventRequest)iter.next());
        }
    }

    public VMDeathRequest createVMDeathRequest() {
        CFDeathRequest request = new CFDeathRequest(this.vm);
        this.deaths.add(request);
        return request;
    }

    public List vmDeathRequests() {
        return Collections.unmodifiableList(this.deaths);
    }

    public VMDisconnectRequest createVMDisconnectRequest() {
        CFDisconnectRequest request = new CFDisconnectRequest(this.vm);
        this.disconnects.add(request);
        return request;
    }

    public List vmDisconnectRequests() {
        return Collections.unmodifiableList(this.disconnects);
    }

    public void dispose() {
        Iterator iter = this.kind.keySet().iterator();
        while (iter.hasNext()) {
            List list = (List)this.kind.get(iter.next());
            list.clear();
        }
    }
}

