/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IArrayReference;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ArrayReference
extends Reference
implements IArrayReference {
    public Expression receiver;
    public Expression position;

    public ArrayReference(Expression rec, Expression pos) {
        this.receiver = rec;
        this.position = pos;
        this.sourceStart = rec.sourceStart;
    }

    @Override
    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean compoundAssignment) {
        if (assignment.expression == null) {
            return this.analyseCode(currentScope, flowContext, flowInfo);
        }
        return assignment.expression.analyseCode(currentScope, flowContext, this.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits());
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.receiver.checkNPE(currentScope, flowContext, flowInfo);
        flowInfo = this.receiver.analyseCode(currentScope, flowContext, flowInfo);
        return this.position.analyseCode(currentScope, flowContext, flowInfo);
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        this.receiver.printExpression(0, output).append('[');
        return this.position.printExpression(0, output).append(']');
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        TypeBinding arrayType = this.receiver.resolveType(scope);
        if (arrayType != null) {
            if (arrayType.isArrayType()) {
                TypeBinding elementType;
                this.resolvedType = elementType = ((ArrayBinding)arrayType).elementsType();
            } else if (arrayType instanceof SourceTypeBinding) {
                this.resolvedType = TypeBinding.UNKNOWN;
                if (this.position instanceof StringLiteral) {
                    FieldBinding[] fields = ((SourceTypeBinding)arrayType).fields();
                    char[] positionSource = ((StringLiteral)this.position).source;
                    int idx = 0;
                    while (idx < fields.length) {
                        if (CharOperation.equals(positionSource, fields[idx].name)) {
                            this.resolvedType = fields[idx].type;
                            break;
                        }
                        ++idx;
                    }
                }
            } else {
                this.resolvedType = TypeBinding.UNKNOWN;
            }
        } else {
            this.resolvedType = TypeBinding.UNKNOWN;
        }
        this.position.resolveTypeExpecting(scope, new TypeBinding[]{scope.getJavaLangNumber(), scope.getJavaLangString(), TypeBinding.ANY});
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.receiver.traverse(visitor, scope);
            this.position.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 11;
    }
}

