/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions.pinpoint;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;
import org.eclipse.wst.jsdt.chromium.debug.ui.ChromiumDebugUIPlugin;
import org.eclipse.wst.jsdt.chromium.debug.ui.DialogUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.pinpoint.DialogLogic;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.pinpoint.Messages;

class DialogImpl
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_KEY = "PinPointValueDialog";
    private final Value uiValue;
    private DialogLogic.Handle logic = null;

    DialogImpl(Shell shell, Value uiValue) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.uiValue = uiValue;
    }

    public void create() {
        super.create();
        this.logic.updateAll();
    }

    protected void okPressed() {
        Runnable okRunnable = this.logic.getOkRunnable();
        if (okRunnable == null) {
            return;
        }
        this.logic.saveStateInStore();
        okRunnable.run();
        super.okPressed();
    }

    protected Control createDialogArea(Composite ancestor) {
        this.getShell().setText(Messages.DialogImpl_WINDOW_TITLE);
        this.setTitle(Messages.DialogImpl_WINDOW_SUBTITLE);
        Composite parent = new Composite(ancestor, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        parent.setLayout((Layout)topLayout);
        parent.setLayoutData((Object)new GridData(1808));
        Label propertyExpressionPrompt = new Label(parent, 0);
        propertyExpressionPrompt.setText(Messages.DialogImpl_EXPRESSION_PROMPT);
        Composite propertyExpressionComposite = new Composite(parent, 0);
        GridLayout topLayout2 = new GridLayout();
        topLayout2.numColumns = 2;
        topLayout2.horizontalSpacing = 0;
        propertyExpressionComposite.setLayout((Layout)topLayout2);
        propertyExpressionComposite.setLayoutData((Object)new GridData(768));
        Label globalObjectLabel = new Label(propertyExpressionComposite, 0);
        globalObjectLabel.setText(Messages.DialogImpl_GLOBAL_MARK);
        final Text propertyExpressionEditor = new Text(propertyExpressionComposite, 2052);
        propertyExpressionEditor.setLayoutData((Object)new GridData(768));
        Group checkValueGroup = new Group(parent, 0);
        GridLayout topLayout3 = new GridLayout();
        topLayout3.numColumns = 1;
        checkValueGroup.setLayout((Layout)topLayout3);
        checkValueGroup.setLayoutData((Object)new GridData(1808));
        final Button previewCheckBox = new Button((Composite)checkValueGroup, 32);
        previewCheckBox.setText(Messages.DialogImpl_PROPERTY_PREVIEW);
        final Label previewDisplayText = new Label((Composite)checkValueGroup, 64);
        previewDisplayText.setLayoutData((Object)new GridData(1808));
        previewDisplayText.setText("\n\n\n");
        final Button addWatchCheckBox = new Button(parent, 32);
        addWatchCheckBox.setText(Messages.DialogImpl_ADD_WATCH);
        Elements elements = new Elements(){

            @Override
            public Shell getParentShell() {
                return DialogImpl.this.getParentShell();
            }

            @Override
            public Button getOkButton() {
                return DialogImpl.this.getButton(0);
            }

            @Override
            public void setMessage(String message, int type) {
                DialogImpl.this.setMessage(message, type);
            }

            @Override
            public Text getExpressionText() {
                return propertyExpressionEditor;
            }

            @Override
            public Button getPreviewCheckBox() {
                return previewCheckBox;
            }

            @Override
            public Label getPreviewDisplay() {
                return previewDisplayText;
            }

            @Override
            public Button getAddWatchCheckBox() {
                return addWatchCheckBox;
            }
        };
        IDialogSettings pluginSettings = ChromiumDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSectionVar = pluginSettings.getSection(DIALOG_SETTINGS_KEY);
        if (dialogSectionVar == null) {
            dialogSectionVar = pluginSettings.addNewSection(DIALOG_SETTINGS_KEY);
        }
        final IDialogSettings dialogSection = dialogSectionVar;
        DialogPreferencesStore preferencesStore = new DialogPreferencesStore(){
            private static final String EXPRESSION = "expression";
            private static final String SHOW_PREVIEW = "showPreview";
            private static final String ADD_WATCH_EXPRESSION = "addWatchExpression";
            private static final String defaultExpressionText = ".";

            @Override
            public String getExpressionText() {
                String value = dialogSection.get(EXPRESSION);
                if (value == null) {
                    value = defaultExpressionText;
                }
                return value;
            }

            @Override
            public void setExpressionText(String expressionText) {
                dialogSection.put(EXPRESSION, expressionText);
            }

            @Override
            public boolean getPreviewCheck() {
                return dialogSection.getBoolean(SHOW_PREVIEW);
            }

            @Override
            public void setPreviewCheck(boolean check) {
                dialogSection.put(SHOW_PREVIEW, check);
            }

            @Override
            public boolean getAddWatchExpression() {
                return dialogSection.getBoolean(ADD_WATCH_EXPRESSION);
            }

            @Override
            public void setAddWatchExpression(boolean value) {
                dialogSection.put(ADD_WATCH_EXPRESSION, value);
            }
        };
        this.logic = DialogLogic.buildDialogLogic(elements, preferencesStore, this.uiValue);
        return parent;
    }

    static interface DialogPreferencesStore {
        public String getExpressionText();

        public void setExpressionText(String var1);

        public boolean getPreviewCheck();

        public void setPreviewCheck(boolean var1);

        public boolean getAddWatchExpression();

        public void setAddWatchExpression(boolean var1);
    }

    static interface Elements
    extends DialogUtils.OkButtonElements {
        public Text getExpressionText();

        public Button getPreviewCheckBox();

        public Label getPreviewDisplay();

        public Button getAddWatchCheckBox();

        public Shell getParentShell();
    }
}

