/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ArtifactEditRegistryReader
extends RegistryReader {
    static final String ARTIFACT_EDIT_EXTENSION_POINT = "artifactedit";
    static final String ARTIFACTEDIT = "artifactedit";
    static final String TYPE = "typeID";
    static final String ARTIFACTEDITCLASS = "class";
    private static final ArtifactEditRegistryReader instance = new ArtifactEditRegistryReader();
    private final Map descriptors = new HashMap();
    private final Map instances = new HashMap();

    public static ArtifactEditRegistryReader instance() {
        return instance;
    }

    public ArtifactEditRegistryReader() {
        super("org.eclipse.wst.common.modulecore", "artifactedit");
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ModulecorePlugin.logError(0, exception.getMessage(), exception);
            }

            public void run() throws Exception {
                ArtifactEditRegistryReader.this.readRegistry();
            }
        });
    }

    public boolean readElement(IConfigurationElement element) {
        if ("artifactedit".equals(element.getName())) {
            String type = element.getAttribute(TYPE);
            if (type != null) {
                this.descriptors.put(element.getAttribute(TYPE), new ArtifactEditDescriptor(element));
            } else {
                ModulecorePlugin.logError(0, "No type attribute is specified for org.eclipse.wst.common.modulecore.artifactedit extension in " + element.getDeclaringExtension().getNamespaceIdentifier(), null);
            }
            return true;
        }
        return false;
    }

    public synchronized IArtifactEditFactory getArtifactEdit(String typeID) {
        ArtifactEditDescriptor descriptor = (ArtifactEditDescriptor)this.descriptors.get(typeID);
        IArtifactEditFactory factory = null;
        if (descriptor != null && (factory = (IArtifactEditFactory)this.instances.get(descriptor)) == null) {
            factory = descriptor.createFactory();
            if (factory != null) {
                this.instances.put(descriptor, factory);
            } else {
                this.descriptors.remove(descriptor);
            }
        }
        return factory;
    }

    public IArtifactEditFactory getArtifactEdit(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            for (String typeID : this.descriptors.keySet()) {
                try {
                    IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
                    if (projectFacet == null || !facetedProject.hasProjectFacet(projectFacet)) continue;
                    return this.getArtifactEdit(typeID);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public class ArtifactEditDescriptor {
        private final IConfigurationElement element;
        private final String type;

        public ArtifactEditDescriptor(IConfigurationElement configElement) {
            this.element = configElement;
            this.type = this.element.getAttribute(ArtifactEditRegistryReader.TYPE);
        }

        public IArtifactEditFactory createFactory() {
            final IArtifactEditFactory[] factory = new IArtifactEditFactory[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    ModulecorePlugin.logError(0, exception.getMessage(), exception);
                }

                public void run() throws Exception {
                    factory[0] = (IArtifactEditFactory)ArtifactEditDescriptor.this.element.createExecutableExtension(ArtifactEditRegistryReader.ARTIFACTEDITCLASS);
                }
            });
            return factory[0];
        }

        public String getType() {
            return this.type;
        }
    }
}

