/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.local.showin;

import java.io.File;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ExternalExecutablesUtils {
    public static ImageData loadImage(String path) {
        Assert.isNotNull((Object)path);
        ImageData id = null;
        ImageData biggest = null;
        ImageLoader loader = new ImageLoader();
        ImageData[] data = loader.load(path);
        if (data != null) {
            ImageData[] imageDataArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                ImageData d = imageDataArray[n2];
                if (d.height == 16 && d.width == 16) {
                    if (id == null || id.height != 16 && id.width != 16) {
                        id = d;
                    } else if (d.depth < id.depth && d.depth >= 8) {
                        id = d;
                    }
                } else if (id == null) {
                    id = d;
                    biggest = d;
                } else if (id.height != 16 && d.height < id.height && id.width != 16 && d.width < id.width) {
                    id = d;
                } else if (biggest == null || d.height > biggest.height && d.width > biggest.width) {
                    biggest = d;
                }
                ++n2;
            }
        }
        if (id != null && id.height > 16 && id.width > 16 && biggest != null) {
            id = biggest.scaledTo(16, 16);
        }
        return id;
    }

    public static <T> Optional<T> visitPATH(Function<String, Optional<T>> r) {
        String path = System.getenv("PATH");
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Optional<T> apply = r.apply(token);
                if (!apply.isPresent()) continue;
                return apply;
            }
        }
        return Optional.empty();
    }
}

