/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.interfaces.ILauncherDelegate;
import org.eclipse.tm.terminal.view.ui.nls.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.framework.Bundle;

public class LauncherDelegateManager {
    private boolean initialized = false;
    private final Map<String, Proxy> extensionsMap = new HashMap<String, Proxy>();
    private ExtensionPointComparator comparator = null;

    public static LauncherDelegateManager getInstance() {
        return LazyInstanceHolder.instance;
    }

    LauncherDelegateManager() {
    }

    public ILauncherDelegate[] getLauncherDelegates(boolean unique) {
        ArrayList<ILauncherDelegate> contributions = new ArrayList<ILauncherDelegate>();
        for (Proxy launcherDelegate : this.getExtensions().values()) {
            ILauncherDelegate instance;
            ILauncherDelegate iLauncherDelegate = instance = unique ? launcherDelegate.newInstance() : launcherDelegate.getInstance();
            if (instance == null || contributions.contains(instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new ILauncherDelegate[contributions.size()]);
    }

    public ILauncherDelegate getLauncherDelegate(String id, boolean unique) {
        ILauncherDelegate contribution = null;
        Map<String, Proxy> extensions = this.getExtensions();
        if (extensions.containsKey(id)) {
            Proxy proxy = extensions.get(id);
            contribution = unique ? proxy.newInstance() : proxy.getInstance();
        }
        return contribution;
    }

    public ILauncherDelegate[] getApplicableLauncherDelegates(ISelection selection) {
        ArrayList<ILauncherDelegate> applicable = new ArrayList<ILauncherDelegate>();
        ILauncherDelegate[] iLauncherDelegateArray = this.getLauncherDelegates(false);
        int n = iLauncherDelegateArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isApplicable;
            ILauncherDelegate delegate = iLauncherDelegateArray[n2];
            Expression enablement = delegate.getEnablement();
            boolean bl = isApplicable = enablement == null;
            if (enablement != null) {
                if (selection != null) {
                    IEvaluationContext currentState = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).getCurrentState();
                    EvaluationContext context = new EvaluationContext(currentState, (Object)selection);
                    context.addVariable("selection", (Object)selection);
                    context.setAllowPluginActivation(true);
                    try {
                        isApplicable = enablement.evaluate((IEvaluationContext)context).equals(EvaluationResult.TRUE);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                        UIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                } else {
                    isApplicable = false;
                }
            }
            if (isApplicable) {
                applicable.add(delegate);
            }
            ++n2;
        }
        return applicable.toArray(new ILauncherDelegate[applicable.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Proxy> getExtensions() {
        Map<String, Proxy> map = this.extensionsMap;
        synchronized (map) {
            if (!this.initialized) {
                this.loadExtensions();
                this.initialized = true;
            }
        }
        return this.extensionsMap;
    }

    protected final ExtensionPointComparator getExtensionPointComparator() {
        if (this.comparator == null) {
            this.comparator = new ExtensionPointComparator();
        }
        return this.comparator;
    }

    protected IExtension[] getExtensionsSorted(IExtensionPoint point) {
        Assert.isNotNull((Object)point);
        ArrayList<IExtension> extensions = new ArrayList<IExtension>(Arrays.asList(point.getExtensions()));
        if (extensions.size() > 0) {
            Collections.sort(extensions, this.getExtensionPointComparator());
        }
        return extensions.toArray(new IExtension[extensions.size()]);
    }

    protected void loadExtensions() {
        if (this.initialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.tm.terminal.view.ui.launcherDelegates");
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = this.getExtensionsSorted(point);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    block9: {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if ("delegate".equals(element.getName())) {
                            try {
                                Proxy candidate = new Proxy(element);
                                if (candidate.getId() != null) {
                                    if (!this.extensionsMap.containsKey(candidate.getId())) {
                                        this.extensionsMap.put(candidate.getId(), candidate);
                                        break block9;
                                    }
                                    throw new CoreException((IStatus)new Status(4, UIPlugin.getUniqueIdentifier(), 0, NLS.bind((String)Messages.Extension_error_duplicateExtension, (Object)candidate.getId(), (Object)element.getContributor().getName()), null));
                                }
                                throw new CoreException((IStatus)new Status(4, UIPlugin.getUniqueIdentifier(), 0, NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)"id", (Object)element.getAttribute("label")), null));
                            }
                            catch (CoreException e) {
                                Platform.getLog((Bundle)UIPlugin.getDefault().getBundle()).log((IStatus)new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.Extension_error_invalidExtensionPoint, (Object)element.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e));
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    static class ExtensionPointComparator
    implements Comparator<IExtension> {
        private static final String OWN_PLUGINS_PATTERN = "org.eclipse.tm.terminal.";

        ExtensionPointComparator() {
        }

        @Override
        public int compare(IExtension o1, IExtension o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (o1 == o2) {
                return 0;
            }
            String contributor1 = o1.getContributor().getName();
            String contributor2 = o2.getContributor().getName();
            if (contributor1.startsWith(OWN_PLUGINS_PATTERN) && !contributor2.startsWith(OWN_PLUGINS_PATTERN)) {
                return -1;
            }
            if (!contributor1.startsWith(OWN_PLUGINS_PATTERN) && contributor2.startsWith(OWN_PLUGINS_PATTERN)) {
                return 1;
            }
            if (contributor1.startsWith(OWN_PLUGINS_PATTERN) && contributor2.startsWith(OWN_PLUGINS_PATTERN)) {
                int value = contributor1.compareTo(contributor2);
                if (value == 0 && o1.getUniqueIdentifier() != null && o2.getUniqueIdentifier() != null) {
                    return o1.getUniqueIdentifier().compareTo(o2.getUniqueIdentifier());
                }
                return value;
            }
            int value = contributor1.compareTo(contributor2);
            if (value == 0 && o1.getUniqueIdentifier() != null && o2.getUniqueIdentifier() != null) {
                return o1.getUniqueIdentifier().compareTo(o2.getUniqueIdentifier());
            }
            return value;
        }
    }

    private static class LazyInstanceHolder {
        public static LauncherDelegateManager instance = new LauncherDelegateManager();

        private LazyInstanceHolder() {
        }
    }

    static class Proxy {
        private ILauncherDelegate instance;
        private final IConfigurationElement element;
        private String id;

        public Proxy(IConfigurationElement element) throws CoreException {
            Assert.isNotNull((Object)element);
            this.element = element;
            this.id = element.getAttribute("id");
            if (this.id == null || this.id.trim().length() == 0) {
                throw new CoreException((IStatus)new Status(4, UIPlugin.getUniqueIdentifier(), 0, NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)"id", (Object)element.getContributor().getName()), null));
            }
            this.instance = null;
        }

        public String getId() {
            return this.id;
        }

        public IConfigurationElement getConfigurationElement() {
            return this.element;
        }

        public ILauncherDelegate getInstance() {
            if (this.instance == null) {
                this.instance = this.newInstance();
            }
            return this.instance;
        }

        public ILauncherDelegate newInstance() {
            IConfigurationElement element = this.getConfigurationElement();
            Assert.isNotNull((Object)element);
            if (element.getAttribute("class") != null || element.getChildren("class").length > 0) {
                try {
                    return (ILauncherDelegate)element.createExecutableExtension("class");
                }
                catch (Exception e) {
                    Platform.getLog((Bundle)UIPlugin.getDefault().getBundle()).log((IStatus)new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.Extension_error_invalidExtensionPoint, (Object)element.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e));
                }
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Proxy) {
                return this.getId().equals(((Proxy)obj).getId());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }
}

