/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.console.internal.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tcf.te.runtime.preferences.ScopedEclipsePreferences;
import org.eclipse.tcf.te.tcf.ui.console.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.console.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.console.nls.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private final IPreferenceStore preferenceStore = new PreferenceStore(){

        public boolean needsSaving() {
            return false;
        }
    };
    private BooleanFieldEditor fixedConsoleWidth;
    private IntegerFieldEditor consoleWidth;
    private BooleanFieldEditor limitConsoleOutput;
    private IntegerFieldEditor consoleBufferSize;

    public PreferencesPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IContextHelpIds.MONITOR_CONSOLE_PREFERENCES_PAGE);
        Label label = new Label(composite, 16384);
        label.setText(Messages.PreferencesPage_label);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        IPreferenceStore store = this.getPreferenceStore();
        this.fixedConsoleWidth = new BooleanFieldEditor("te.tcf.ui.console.pref.fixedWidth", Messages.PreferencesPage_fieldEditor_fixedWidth, composite);
        this.addField((FieldEditor)this.fixedConsoleWidth);
        this.consoleWidth = new IntegerFieldEditor("te.tcf.ui.console.pref.width", Messages.PreferencesPage_fieldEditor_width, composite);
        this.consoleWidth.setValidRange(80, 0x7FFFFFFE);
        this.addField((FieldEditor)this.consoleWidth);
        this.consoleWidth.setEnabled(store.getBoolean("te.tcf.ui.console.pref.fixedWidth"), composite);
        this.limitConsoleOutput = new BooleanFieldEditor("te.tcf.ui.console.pref.limitOutput", Messages.PreferencesPage_fieldEditor_limitOutput, composite);
        this.addField((FieldEditor)this.limitConsoleOutput);
        this.consoleBufferSize = new IntegerFieldEditor("te.tcf.ui.console.pref.bufferSize", Messages.PreferencesPage_fieldEditor_bufferSize, composite);
        this.consoleBufferSize.setValidRange(1000, 0x7FFFFFFE);
        this.addField((FieldEditor)this.consoleBufferSize);
        this.consoleBufferSize.setEnabled(store.getBoolean("te.tcf.ui.console.pref.limitOutput"), composite);
        BooleanFieldEditor booleanField = new BooleanFieldEditor("te.tcf.ui.console.pref.showOnOutput", Messages.PreferencesPage_fieldEditor_showOnOutput, composite);
        this.addField((FieldEditor)booleanField);
        label = new Label(composite, 16384);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        label = new Label(composite, 16384);
        label.setText(Messages.PreferencesPage_group_colorSettings);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        ColorFieldEditor colorField = this.createColorFieldEditor("te.tcf.ui.console.pref.color.command", Messages.PreferencesPage_color_command, composite);
        this.addField((FieldEditor)colorField);
        colorField = this.createColorFieldEditor("te.tcf.ui.console.pref.color.commandResponse", Messages.PreferencesPage_color_commandResponse, composite);
        this.addField((FieldEditor)colorField);
        colorField = this.createColorFieldEditor("te.tcf.ui.console.pref.color.event", Messages.PreferencesPage_color_event, composite);
        this.addField((FieldEditor)colorField);
        colorField = this.createColorFieldEditor("te.tcf.ui.console.pref.color.progress", Messages.PreferencesPage_color_progress, composite);
        this.addField((FieldEditor)colorField);
        colorField = this.createColorFieldEditor("te.tcf.ui.console.pref.color.error", Messages.PreferencesPage_color_error, composite);
        this.addField((FieldEditor)colorField);
        Dialog.applyDialogFont((Control)composite);
    }

    private ColorFieldEditor createColorFieldEditor(String slotId, String label, Composite parent) {
        Assert.isNotNull((Object)slotId);
        Assert.isNotNull((Object)label);
        Assert.isNotNull((Object)parent);
        ColorFieldEditor editor = new ColorFieldEditor(slotId, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.consoleWidth != null && this.fixedConsoleWidth != null) {
            this.consoleWidth.setEnabled(this.fixedConsoleWidth.getBooleanValue(), this.getFieldEditorParent());
        }
        if (this.consoleBufferSize != null && this.limitConsoleOutput != null) {
            this.consoleBufferSize.setEnabled(this.limitConsoleOutput.getBooleanValue(), this.getFieldEditorParent());
        }
    }

    protected void initialize() {
        ScopedEclipsePreferences store = UIPlugin.getScopedPreferences();
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.fixedWidth", store.getDefaultBoolean("te.tcf.ui.console.pref.fixedWidth"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.fixedWidth", store.getBoolean("te.tcf.ui.console.pref.fixedWidth"));
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.width", store.getDefaultInt("te.tcf.ui.console.pref.width"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.width", store.getInt("te.tcf.ui.console.pref.width"));
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.limitOutput", store.getDefaultBoolean("te.tcf.ui.console.pref.limitOutput"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.limitOutput", store.getBoolean("te.tcf.ui.console.pref.limitOutput"));
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.bufferSize", store.getDefaultInt("te.tcf.ui.console.pref.bufferSize"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.bufferSize", store.getInt("te.tcf.ui.console.pref.bufferSize"));
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.showOnOutput", store.getDefaultBoolean("te.tcf.ui.console.pref.showOnOutput"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.showOnOutput", store.getBoolean("te.tcf.ui.console.pref.showOnOutput"));
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.color.command", store.getDefaultString("te.tcf.ui.console.pref.color.command"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.color.command", store.getString("te.tcf.ui.console.pref.color.command"));
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.color.commandResponse", store.getDefaultString("te.tcf.ui.console.pref.color.commandResponse"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.color.commandResponse", store.getString("te.tcf.ui.console.pref.color.commandResponse"));
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.color.event", store.getDefaultString("te.tcf.ui.console.pref.color.event"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.color.event", store.getString("te.tcf.ui.console.pref.color.event"));
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.color.progress", store.getDefaultString("te.tcf.ui.console.pref.color.progress"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.color.progress", store.getString("te.tcf.ui.console.pref.color.progress"));
        this.preferenceStore.setDefault("te.tcf.ui.console.pref.color.error", store.getDefaultString("te.tcf.ui.console.pref.color.error"));
        this.preferenceStore.setValue("te.tcf.ui.console.pref.color.error", store.getString("te.tcf.ui.console.pref.color.error"));
        super.initialize();
        this.propertyChange(new PropertyChangeEvent((Object)this, "", null, null));
    }

    public boolean performOk() {
        boolean success = super.performOk();
        ScopedEclipsePreferences store = UIPlugin.getScopedPreferences();
        store.putBoolean("te.tcf.ui.console.pref.fixedWidth", this.preferenceStore.getBoolean("te.tcf.ui.console.pref.fixedWidth"));
        store.putInt("te.tcf.ui.console.pref.width", this.preferenceStore.getInt("te.tcf.ui.console.pref.width"));
        store.putBoolean("te.tcf.ui.console.pref.limitOutput", this.preferenceStore.getBoolean("te.tcf.ui.console.pref.limitOutput"));
        store.putInt("te.tcf.ui.console.pref.bufferSize", this.preferenceStore.getInt("te.tcf.ui.console.pref.bufferSize"));
        store.putBoolean("te.tcf.ui.console.pref.showOnOutput", this.preferenceStore.getBoolean("te.tcf.ui.console.pref.showOnOutput"));
        store.putString("te.tcf.ui.console.pref.color.command", this.preferenceStore.getString("te.tcf.ui.console.pref.color.command"));
        store.putString("te.tcf.ui.console.pref.color.commandResponse", this.preferenceStore.getString("te.tcf.ui.console.pref.color.commandResponse"));
        store.putString("te.tcf.ui.console.pref.color.event", this.preferenceStore.getString("te.tcf.ui.console.pref.color.event"));
        store.putString("te.tcf.ui.console.pref.color.progress", this.preferenceStore.getString("te.tcf.ui.console.pref.color.progress"));
        store.putString("te.tcf.ui.console.pref.color.error", this.preferenceStore.getString("te.tcf.ui.console.pref.color.error"));
        return success;
    }
}

