/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.properties;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeWorkingCopy;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;

public class AdvancedAttributesDialog
extends Dialog {
    IFSTreeNodeWorkingCopy node;

    public AdvancedAttributesDialog(Shell parentShell, IFSTreeNodeWorkingCopy node) {
        super(parentShell);
        this.node = node;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite banner = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        banner.setLayout((Layout)layout);
        Label label = new Label(banner, 0);
        Image bImg = this.getBannerImage();
        label.setImage(bImg);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label = new Label(banner, 0);
        if (this.node.isFile()) {
            label.setText(Messages.AdvancedAttributesDialog_FileBanner);
        } else if (this.node.isDirectory()) {
            label.setText(Messages.AdvancedAttributesDialog_FolderBanner);
        }
        this.createArchiveAndIndexGroup(composite);
        this.createCompressAndEncryptGroup(composite);
        return composite;
    }

    private Image getBannerImage() {
        return UIPlugin.getImage("BannerImage");
    }

    private void createCompressAndEncryptGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.AdvancedAttributesDialog_CompressEncrypt);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createCompress(group);
        this.createEncrypt(group);
    }

    private void createArchiveAndIndexGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.AdvancedAttributesDialog_ArchiveIndex);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createArchive(group);
        this.createIndexField(group);
    }

    private void createIndexField(Group group) {
        String label = this.node.isFile() ? Messages.AdvancedAttributesDialog_IndexFile : (this.node.isDirectory() ? Messages.AdvancedAttributesDialog_IndexFolder : null);
        boolean on = !this.node.getWin32Attr(8192);
        this.createOptionField(group, label, 8192, on);
    }

    private void createArchive(Group group) {
        String label = this.node.isFile() ? Messages.AdvancedAttributesDialog_FileArchive : (this.node.isDirectory() ? Messages.AdvancedAttributesDialog_FolderArchive : null);
        boolean on = this.node.getWin32Attr(32);
        this.createOptionField(group, label, 32, on);
    }

    private void createEncrypt(Group group) {
        String label = Messages.AdvancedAttributesDialog_Encrypt;
        boolean on = this.node.getWin32Attr(16384);
        this.createOptionField(group, label, 16384, on);
    }

    private void createCompress(Group group) {
        String label = Messages.AdvancedAttributesDialog_Compress;
        boolean on = this.node.getWin32Attr(2048);
        this.createOptionField(group, label, 2048, on);
    }

    private void createOptionField(Group group, String label, final int bit, final boolean on) {
        final Button button = new Button((Composite)group, 32);
        button.setText(label);
        button.setSelection(on);
        button.setEnabled(this.node.isAgentOwner());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection() != on) {
                    AdvancedAttributesDialog.this.node.setWin32Attr(bit, on);
                }
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AdvancedAttributesDialog_ShellTitle);
    }

    public IFSTreeNodeWorkingCopy getResult() {
        return this.node;
    }
}

