/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.pages;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.ui.events.AbstractEventListener;
import org.eclipse.tcf.te.ui.trees.TreeControl;

public class FSExplorerEventListener
extends AbstractEventListener {
    final TreeControl treeControl;

    public FSExplorerEventListener(TreeControl treeControl) {
        Assert.isNotNull((Object)treeControl);
        this.treeControl = treeControl;
    }

    public void eventFired(EventObject event) {
        if (event instanceof ChangeEvent) {
            ChangeEvent changeEvent = (ChangeEvent)event;
            Object source = changeEvent.getSource();
            if (this.treeControl.getViewer() != null) {
                if (this.treeControl.getViewer().getControl() == null || this.treeControl.getViewer().getControl().isDisposed()) {
                    EventManager.getInstance().removeEventListener((IEventListener)this);
                    return;
                }
                if (source instanceof IRuntimeModel) {
                    this.treeControl.getViewer().refresh();
                } else if (source instanceof IFSTreeNode) {
                    if ("expanded".equals(changeEvent.getEventId())) {
                        boolean expanded = (Boolean)changeEvent.getNewValue();
                        ((TreeViewer)this.treeControl.getViewer()).setExpandedState(source, expanded);
                    } else {
                        ((TreeViewer)this.treeControl.getViewer()).refresh(source, true);
                    }
                } else if (source instanceof IPeerNode && source == this.getPeerNode() && "ConnectState".equals(changeEvent.getEventId())) {
                    if (changeEvent.getNewValue().equals(11)) {
                        IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)this.getPeerNode());
                        if (model != null) {
                            this.treeControl.getViewer().setInput((Object)model.getRoot());
                        }
                    } else {
                        this.treeControl.getViewer().setInput((Object)this.getPeerNode());
                    }
                    this.treeControl.getViewer().refresh();
                }
            }
        }
    }

    protected IPeerNode getPeerNode() {
        IPeerNode peerNode;
        Object element = this.treeControl.getViewer().getInput();
        IPeerNode iPeerNode = peerNode = element instanceof IPeerNode ? (IPeerNode)element : null;
        if (peerNode == null && element instanceof IAdaptable) {
            peerNode = (IPeerNode)((IAdaptable)element).getAdapter(IPeerNode.class);
        }
        return peerNode;
    }
}

