/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters.FSTreeNodeLoader;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters.NodeStateFilter;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.FSTreeElementLabelProvider;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.FSTreeNodeSearchable;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.ui.interfaces.ILazyLoader;
import org.eclipse.tcf.te.ui.interfaces.ISearchable;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IPersistableElement;

public class FSTreeNodeAdapterFactory
implements IAdapterFactory {
    private static ILabelProvider nodeLabelProvider = new FSTreeElementLabelProvider();
    private Map<IFSTreeNode, NodeStateFilter> filters = Collections.synchronizedMap(new HashMap());

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IFSTreeNode) {
            IFSTreeNode node = (IFSTreeNode)adaptableObject;
            if (adapterType == IActionFilter.class) {
                NodeStateFilter filter = this.filters.get(node);
                if (filter == null) {
                    filter = new NodeStateFilter(node);
                    this.filters.put(node, filter);
                }
                return filter;
            }
            if (adapterType == ILabelProvider.class) {
                return nodeLabelProvider;
            }
            if (adapterType == ILazyLoader.class) {
                return new FSTreeNodeLoader(node);
            }
            if (adapterType == IPeerNodeProvider.class) {
                return new FSTreeNodePeerNodeProvider(node);
            }
            if (adapterType == IPeerNode.class) {
                return new FSTreeNodePeerNodeProvider(node).getPeerNode();
            }
            if (adapterType == ISearchable.class) {
                return new FSTreeNodeSearchable(node);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IActionFilter.class, ILabelProvider.class, IPersistableElement.class, ILazyLoader.class, ISearchable.class, IPeerNodeProvider.class};
    }

    public static class FSTreeNodePeerNodeProvider
    extends PlatformObject
    implements IPeerNodeProvider {
        private final IFSTreeNode node;

        public FSTreeNodePeerNodeProvider(IFSTreeNode node) {
            Assert.isNotNull((Object)node);
            this.node = node;
        }

        public final IFSTreeNode getFSTreeNode() {
            return this.node;
        }

        public final IPeerNode getPeerNode() {
            return this.node.getPeerNode();
        }
    }
}

