/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.extensions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.interfaces.extensions.IExecutableExtension;
import org.eclipse.tcf.te.runtime.nls.Messages;

public class ExecutableExtension
extends PlatformObject
implements IExecutableExtension {
    private String id = null;
    private String label = null;
    private String description = null;

    public void cloneInitializationData(ExecutableExtension other) {
        Assert.isNotNull((Object)other);
        other.id = this.id;
        other.label = this.label;
        other.description = this.description;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (config != null) {
            this.doSetInitializationData(config, propertyName, data);
        }
    }

    public void doSetInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] children;
        Assert.isNotNull((Object)config);
        this.id = config.getAttribute("id");
        if (this.id == null || "".equals(this.id.trim())) {
            throw this.createMissingMandatoryAttributeException("id", config.getContributor().getName());
        }
        this.label = config.getAttribute("label");
        if (this.label == null || "".equals(this.label.trim())) {
            this.label = config.getAttribute("name");
        }
        if ((children = config.getChildren("description")) != null && children.length > 0) {
            IConfigurationElement element = children[0];
            this.description = element.getValue();
        }
    }

    protected CoreException createMissingMandatoryAttributeException(String attributeName, String extensionId) {
        Assert.isNotNull((Object)attributeName);
        Assert.isNotNull((Object)extensionId);
        return new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), 0, NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)attributeName, (Object)extensionId), null));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label != null ? this.label.trim() : "";
    }

    @Override
    public String getDescription() {
        return this.description != null ? this.description.trim() : "";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutableExtension) {
            return this.id.equals(((ExecutableExtension)obj).id);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

