/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.decoration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.AbstractSiriusDecorationDescriptorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.DecorationDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.jface.viewers.IToolTipProvider;
import org.eclipse.sirius.viewpoint.description.DecorationDistributionDirection;
import org.eclipse.sirius.viewpoint.description.Position;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;

public class EditModeDecorationDescriptorProvider
extends AbstractSiriusDecorationDescriptorProvider {
    protected static final String DISABLE_PRINT_FOR_PERMISSION_AUTHORITY_DECORATION = "org.eclipse.sirius.diagam.ui.hidePrintingOfPermissionAuthorityDecoration";
    private static final ImageDescriptor LOCK_BY_OTHER_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_denied.gif");
    private static final ImageDescriptor DELETED_DIAG_ELEM_DECORATOR_IMAGE_DESCRIPTOR = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/deletedDiagElemDecorator.gif");
    private static final String NAME = "editModeDecorator";

    @Override
    public boolean provides(IDiagramElementEditPart editPart) {
        return true;
    }

    @Override
    public List<DecorationDescriptor> createDecorationDescriptors(IDiagramElementEditPart editPart, Session session) {
        DecorationDescriptor decoDesc = new DecorationDescriptor();
        this.addDecorationImage(editPart, decoDesc);
        if (decoDesc.getDecorationAsImage() != null) {
            decoDesc.setName(NAME);
            decoDesc.setPosition(Position.SOUTH_WEST_LITERAL);
            decoDesc.setDistributionDirection(DecorationDistributionDirection.HORIZONTAL);
            decoDesc.setDisplayPriority(DecorationDescriptor.DisplayPriority.HIGH_PRIORITY.getValue());
            decoDesc.setTooltipAsString(this.getToolTip(editPart));
            return Arrays.asList(decoDesc);
        }
        return new ArrayList<DecorationDescriptor>();
    }

    private String getToolTip(IDiagramElementEditPart editPart) {
        try {
            IToolTipProvider tooltipProvider;
            EObject representedObject = editPart.resolveTargetSemanticElement();
            if (representedObject != null && (tooltipProvider = (IToolTipProvider)Platform.getAdapterManager().getAdapter((Object)representedObject, IToolTipProvider.class)) != null) {
                return tooltipProvider.getToolTipText((Object)representedObject);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return null;
    }

    protected boolean isBroken(IDiagramElementEditPart editPart) {
        EObject target = editPart.resolveTargetSemanticElement();
        return this.isBroken(target);
    }

    protected boolean isBroken(EObject eObject) {
        return eObject == null || eObject.eResource() == null;
    }

    @Override
    protected boolean shouldBeDecorated(EditPart editPart) {
        return editPart instanceof IDiagramElementEditPart && super.shouldBeDecorated(editPart);
    }

    protected void addDecorationImage(IDiagramElementEditPart editPart, DecorationDescriptor decoDesc) {
        EObject representedObject;
        Image decorationImage = null;
        Boolean isBroken = null;
        if (this.isDecorableEditPart(editPart) && !(isBroken = Boolean.valueOf(this.isBroken(representedObject = editPart.resolveTargetSemanticElement()))).booleanValue()) {
            decorationImage = this.addDecorationImage(editPart, representedObject, decoDesc);
        }
        if (decorationImage == null && (isBroken != null && isBroken.booleanValue() || isBroken == null && this.isBroken(editPart))) {
            decorationImage = DiagramUIPlugin.getPlugin().getImage(DELETED_DIAG_ELEM_DECORATOR_IMAGE_DESCRIPTOR);
        }
        if (decorationImage != null) {
            decoDesc.setDecorationAsImage(decorationImage);
        }
    }

    protected Image addDecorationImage(IDiagramElementEditPart editPart, EObject representedObject, DecorationDescriptor decoDesc) {
        Image decorationImage = null;
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editPart.getEditingDomain().getResourceSet());
        if (auth != null) {
            if (Boolean.getBoolean(DISABLE_PRINT_FOR_PERMISSION_AUTHORITY_DECORATION)) {
                decoDesc.setPrintable(false);
            }
            decorationImage = this.getLockStatusDecorationImage(auth.getLockStatus(representedObject));
        }
        return decorationImage;
    }

    protected Image getLockStatusDecorationImage(LockStatus lockStatus) {
        if (LockStatus.LOCKED_BY_OTHER.equals((Object)lockStatus)) {
            return DiagramUIPlugin.getPlugin().getImage(LOCK_BY_OTHER_IMAGE_DESCRIPTOR);
        }
        return null;
    }
}

