/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.clipboard;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionContext;
import org.eclipse.gmf.runtime.common.ui.util.CustomData;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.providers.ImageSupportGlobalActionHandler;
import org.eclipse.gmf.runtime.diagram.ui.requests.PasteViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.query.PasteTargetQuery;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.tools.internal.command.builders.PasteCommandBuilder;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.clipboard.SiriusClipboardManager;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.CopyToSiriusClipboardCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.PasteFromSiriusClipboardCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.delete.DeleteWrapperHookExecutorCommand;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.PasteDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class SiriusClipboardGlobalActionHandler
extends ImageSupportGlobalActionHandler {
    private ICommand pasteCommand;

    public boolean canHandle(IGlobalActionContext cntxt) {
        IWorkbenchPart part = cntxt.getActivePart();
        if (!(part instanceof IDiagramWorkbenchPart) || !(cntxt.getSelection() instanceof IStructuredSelection)) {
            return false;
        }
        boolean canHandle = false;
        String actionId = cntxt.getActionId();
        if (actionId.equals(GlobalActionId.COPY)) {
            canHandle = this.canCopy(cntxt);
        } else if (actionId.equals(GlobalActionId.CUT)) {
            canHandle = this.canCut(cntxt);
        } else if (actionId.equals(GlobalActionId.PASTE)) {
            canHandle = this.canPaste(cntxt);
        }
        return canHandle;
    }

    public boolean canPaste(IGlobalActionContext cntxt) {
        boolean canPaste = false;
        this.pasteCommand = null;
        Set<DSemanticDecorator> dSelection = this.extractDSelection(cntxt);
        if (!dSelection.isEmpty() && cntxt.getActivePart() instanceof IDiagramWorkbenchPart) {
            IDiagramWorkbenchPart activePart = (IDiagramWorkbenchPart)cntxt.getActivePart();
            boolean bl = canPaste = SiriusClipboardManager.getInstance().hasPasteData() || this.haveNoteToPaste(cntxt);
            if (canPaste) {
                this.pasteCommand = this.getPasteCommand(cntxt, activePart);
                canPaste = this.pasteCommand != null && this.pasteCommand.canExecute();
            }
        }
        return canPaste;
    }

    private boolean haveNoteToPaste(IGlobalActionContext cntxt) {
        if (super.canPaste(cntxt)) {
            PasteViewRequest pasteReq = this.createPasteViewRequest();
            Method method = null;
            try {
                method = pasteReq.getClass().getMethod("getData", new Class[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (method != null) {
                try {
                    boolean safeData;
                    Object data = method.invoke((Object)pasteReq, new Object[0]);
                    boolean bl = safeData = data != null;
                    if (data instanceof ICustomData[]) {
                        ICustomData[] datas;
                        ICustomData[] iCustomDataArray = datas = (ICustomData[])data;
                        int n = datas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICustomData cusData = iCustomDataArray[n2];
                            boolean bl2 = safeData = safeData && cusData != null;
                            if (safeData && cusData instanceof CustomData) {
                                byte[] noteData = ((CustomData)cusData).getData();
                                safeData = safeData && noteData != null && noteData.length != 0;
                            }
                            ++n2;
                        }
                    }
                    return safeData;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        return false;
    }

    protected boolean canCopy(IGlobalActionContext cntxt) {
        boolean canCopy = false;
        Set<DSemanticDecorator> dselection = this.extractDSelection(cntxt);
        canCopy = !dselection.isEmpty() || this.hasSelectedNotes(cntxt);
        return canCopy;
    }

    public ICommand getCommand(IGlobalActionContext cntxt) {
        ICommand command = null;
        command = GlobalActionId.PASTE.equals(cntxt.getActionId()) && cntxt.getActivePart() instanceof IDiagramWorkbenchPart ? this.getPasteCommand(cntxt, (IDiagramWorkbenchPart)cntxt.getActivePart()) : (GlobalActionId.CUT.equals(cntxt.getActionId()) && cntxt.getActivePart() instanceof IDiagramWorkbenchPart ? this.getCutCommand(cntxt, (IDiagramWorkbenchPart)cntxt.getActivePart()) : super.getCommand(cntxt));
        return command;
    }

    protected ICommand getCopyCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart diagramPart, boolean isUndoable) {
        ICommand gmfCommand = super.getCopyCommand(cntxt, diagramPart, isUndoable);
        Session session = this.getSession(diagramPart);
        if (session != null) {
            TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
            Set<DSemanticDecorator> dSelection = this.extractDSelection(cntxt);
            Set<EObject> semanticSelection = this.extractSemanticSelection(dSelection);
            this.minimizeSelection(semanticSelection);
            UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
            if (gmfCommand != null) {
                cmd = new CompositeTransactionalCommand(domain, gmfCommand.getLabel());
                cmd.compose((IUndoableOperation)gmfCommand);
                cmd.compose((IUndoableOperation)new GMFCommandWrapper(domain, (Command)new CopyToSiriusClipboardCommand(domain, dSelection, semanticSelection)));
            }
            return cmd;
        }
        return gmfCommand;
    }

    protected ICommand getCutCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart diagramPart) {
        Session session;
        Object cutCommand = super.getCutCommand(cntxt, diagramPart);
        if (cutCommand != null && cutCommand.canExecute() && (session = this.getSession(diagramPart)) != null) {
            TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
            Set<DSemanticDecorator> dSelection = this.extractDSelection(cntxt);
            cutCommand = new DeleteWrapperHookExecutorCommand(domain, (Collection<DSemanticDecorator>)dSelection, (ICommand)cutCommand);
        }
        return cutCommand;
    }

    private void minimizeSelection(Set<? extends EObject> selection) {
        for (EObject selected : Sets.newLinkedHashSet(selection)) {
            EObject cont = selected.eContainer();
            while (cont != null) {
                if (selection.contains(cont)) {
                    selection.remove(selected);
                    cont = null;
                    continue;
                }
                cont = cont.eContainer();
            }
        }
    }

    private ICommand getPasteCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart activePart) {
        if (this.pasteCommand != null) {
            return this.pasteCommand;
        }
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        Session session = this.getSession(activePart);
        DDiagram diag = this.getDiagram(activePart);
        Set<DSemanticDecorator> dSelection = this.extractDSelection(cntxt);
        if (session != null && diag != null && !dSelection.isEmpty()) {
            boolean valid = true;
            TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
            CompositeTransactionalCommand cc = new CompositeTransactionalCommand(domain, Messages.SiriusClipboardGlobalActionHandler_pasteCommandLabel);
            valid = this.fillCompositePasteCommand(cc, domain, dSelection, cntxt, activePart);
            this.appendNotePasteCommand(cc, cntxt);
            if (valid) {
                result = cc;
                this.pasteCommand = cc;
            }
        }
        return result;
    }

    private void appendNotePasteCommand(CompositeTransactionalCommand cc, IGlobalActionContext cntxt) {
        if (this.haveNoteToPaste(cntxt)) {
            PasteViewRequest pasteReq = this.createPasteViewRequest();
            for (IGraphicalEditPart part : Iterables.filter((Iterable)((IStructuredSelection)cntxt.getSelection()).toList(), IGraphicalEditPart.class)) {
                org.eclipse.gef.commands.Command paste;
                EditPart targetEP = part.getTargetEditPart((Request)pasteReq);
                if (targetEP == null || (paste = targetEP.getCommand((Request)pasteReq)) == null) continue;
                cc.compose((IUndoableOperation)new CommandProxy(paste));
            }
        }
    }

    private boolean hasSelectedNotes(IGlobalActionContext cntxt) {
        if (cntxt.getSelection() instanceof IStructuredSelection) {
            for (IGraphicalEditPart ideep : Iterables.filter((Iterable)((IStructuredSelection)cntxt.getSelection()).toList(), IGraphicalEditPart.class)) {
                Object model = ideep.getModel();
                if (!(model instanceof Node) || !GMFNotationHelper.isNote((Node)model)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean fillCompositePasteCommand(CompositeTransactionalCommand cc, TransactionalEditingDomain domain, Set<DSemanticDecorator> dSelection, IGlobalActionContext cntxt, IDiagramWorkbenchPart activePart) {
        boolean valid = true;
        Iterator<DSemanticDecorator> dSelIt = dSelection.iterator();
        while (valid && dSelIt.hasNext()) {
            DSemanticDecorator pasteTarget = dSelIt.next();
            valid = this.fillCompositePasteCommand(pasteTarget, cc, domain, cntxt, activePart);
        }
        return valid;
    }

    private boolean fillCompositePasteCommand(DSemanticDecorator pasteTarget, CompositeTransactionalCommand cc, TransactionalEditingDomain domain, IGlobalActionContext cntxt, IDiagramWorkbenchPart activePart) {
        boolean valid = true;
        if (SiriusClipboardManager.getInstance().hasPasteData()) {
            Collection tools = new PasteTargetQuery(pasteTarget).getAvailablePasteTools();
            valid = tools == null || tools.isEmpty() ? this.appendGenericPasteCommand(pasteTarget, cc, domain) : this.appendToolPasteCommands(pasteTarget, cc, domain, activePart, tools);
        }
        this.addLayoutDataCommand(cc, activePart, cntxt);
        return valid;
    }

    private boolean appendToolPasteCommands(DSemanticDecorator pasteTarget, CompositeTransactionalCommand cc, TransactionalEditingDomain domain, IDiagramWorkbenchPart activePart, Collection<PasteDescription> tools) {
        boolean valid = true;
        SiriusClipboardManager.getInstance().setDomainClipboard(domain);
        LinkedHashSet<DSemanticDecorator> dCopies = new LinkedHashSet<DSemanticDecorator>();
        LinkedHashSet<EObject> dTargetcopies = new LinkedHashSet<EObject>();
        LinkedHashSet<EObject> strictSemanticCopies = new LinkedHashSet<EObject>();
        this.fillPasteContext(domain.getClipboard(), dCopies, dTargetcopies, strictSemanticCopies);
        IDiagramCommandFactory factory = this.getDiagramCommandFactory(activePart, domain);
        valid = this.appendStrictSemanticToolPasteCommands(pasteTarget, cc, domain, tools, strictSemanticCopies, factory);
        valid = valid && this.appendStandardToolPasteCommands(pasteTarget, cc, domain, tools, dCopies, factory);
        domain.setClipboard(null);
        return valid;
    }

    private boolean appendStandardToolPasteCommands(DSemanticDecorator pasteTarget, CompositeTransactionalCommand cc, TransactionalEditingDomain domain, Collection<PasteDescription> tools, Collection<DSemanticDecorator> dCopies, IDiagramCommandFactory factory) {
        for (DSemanticDecorator semDecCopy : dCopies) {
            PasteDescription tool = this.getBestPasteTool(pasteTarget, semDecCopy, semDecCopy.getTarget(), tools);
            if (tool != null) {
                cc.compose((IUndoableOperation)new GMFCommandWrapper(domain, factory.buildPasteCommandFromTool(pasteTarget, semDecCopy, tool)));
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean appendStrictSemanticToolPasteCommands(DSemanticDecorator pasteTarget, CompositeTransactionalCommand cc, TransactionalEditingDomain domain, Collection<PasteDescription> tools, Collection<EObject> strictSemanticCopies, IDiagramCommandFactory factory) {
        for (EObject strictSemanticCopy : strictSemanticCopies) {
            PasteDescription tool = this.getBestPasteTool(pasteTarget, null, strictSemanticCopy, tools);
            if (tool != null) {
                cc.compose((IUndoableOperation)new GMFCommandWrapper(domain, factory.buildPasteCommandFromTool(pasteTarget, strictSemanticCopy, tool)));
                continue;
            }
            return false;
        }
        return true;
    }

    private void fillPasteContext(Collection<Object> clipboard, Collection<DSemanticDecorator> dCopies, Collection<EObject> dTargetcopies, Collection<EObject> strictSemanticCopies) {
        if (clipboard == null) {
            return;
        }
        for (EObject obj : Iterables.filter(clipboard, EObject.class)) {
            if (obj instanceof DSemanticDecorator) {
                DSemanticDecorator semDecCopy = (DSemanticDecorator)obj;
                if (semDecCopy.getTarget() == null || !this.isTargetInClipboard(clipboard, semDecCopy)) continue;
                dCopies.add(semDecCopy);
                dTargetcopies.add(semDecCopy.getTarget());
                continue;
            }
            strictSemanticCopies.add(obj);
        }
        Iterables.removeAll(strictSemanticCopies, dTargetcopies);
    }

    private boolean isTargetInClipboard(Collection<Object> clipboard, DSemanticDecorator semDecCopy) {
        EObject target = semDecCopy.getTarget();
        boolean inClipboard = clipboard.contains(target);
        if (!inClipboard) {
            EObject targetContainer = EcoreUtil.getRootContainer((EObject)target);
            inClipboard = clipboard.contains(targetContainer);
        }
        return inClipboard;
    }

    private boolean appendGenericPasteCommand(DSemanticDecorator pasteTarget, CompositeTransactionalCommand cc, TransactionalEditingDomain domain) {
        boolean valid = true;
        if (this.safeDecorator(pasteTarget)) {
            PasteFromSiriusClipboardCommand pasteFromClipboard = new PasteFromSiriusClipboardCommand(domain, pasteTarget.getTarget());
            cc.setLabel(pasteFromClipboard.getLabel());
            cc.compose((IUndoableOperation)new GMFCommandWrapper(domain, (Command)pasteFromClipboard));
        } else {
            valid = false;
        }
        return valid;
    }

    private PasteDescription getBestPasteTool(DSemanticDecorator pasteTarget, DSemanticDecorator semDecCopy, EObject copy, Collection<PasteDescription> tools) {
        LinkedHashSet<PasteDescription> candidates = new LinkedHashSet<PasteDescription>();
        for (PasteDescription tool : tools) {
            if (!PasteCommandBuilder.checkPastePrecondition((PasteDescription)tool, (EObject)copy, (EObject)pasteTarget.getTarget(), (EObject)pasteTarget, (EObject)semDecCopy)) continue;
            candidates.add(tool);
        }
        PasteDescription bestTool = null;
        for (PasteDescription pasteTool : candidates) {
            if (bestTool == null) {
                bestTool = pasteTool;
                continue;
            }
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.SiriusClipboardGlobalActionHandler_severalFoundPasteToolError, pasteTarget.getTarget(), bestTool.getName(), pasteTool.getName()), (Exception)new RuntimeException());
        }
        return bestTool;
    }

    private IDiagramCommandFactory getDiagramCommandFactory(IDiagramWorkbenchPart activePart, TransactionalEditingDomain domain) {
        DDiagramEditor diagramEditor = (DDiagramEditor)activePart.getDiagramGraphicalViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        return cmdFactoryProvider.getCommandFactory(domain);
    }

    private Set<EObject> extractSemanticSelection(Collection<DSemanticDecorator> selection) {
        LinkedHashSet<EObject> selectedSemanticElements = new LinkedHashSet<EObject>();
        for (DSemanticDecorator dec : selection) {
            if (!this.safeDecorator(dec)) continue;
            selectedSemanticElements.add(dec.getTarget());
        }
        return selectedSemanticElements;
    }

    private Set<DSemanticDecorator> extractDSelection(IGlobalActionContext cntxt) {
        LinkedHashSet<DSemanticDecorator> dSelection = new LinkedHashSet<DSemanticDecorator>();
        if (cntxt.getSelection() instanceof IStructuredSelection) {
            for (IGraphicalEditPart ideep : Iterables.filter((Iterable)((IStructuredSelection)cntxt.getSelection()).toList(), IGraphicalEditPart.class)) {
                Object model = ideep.getModel();
                if (!(model instanceof View) || !(((View)model).getElement() instanceof DSemanticDecorator)) continue;
                dSelection.add((DSemanticDecorator)((View)model).getElement());
            }
        }
        return dSelection;
    }

    private boolean safeDecorator(DSemanticDecorator dec) {
        Option edgeMapping;
        boolean safe;
        boolean bl = safe = dec.getTarget() != null;
        if (!(!(dec instanceof DEdge) || (edgeMapping = new IEdgeMappingQuery(((DEdge)dec).getActualMapping()).getEdgeMapping()).some() && ((EdgeMapping)edgeMapping.get()).isUseDomainElement())) {
            safe = false;
        }
        return safe;
    }

    private Session getSession(IDiagramWorkbenchPart diagramPart) {
        Session session = null;
        if (diagramPart != null && diagramPart.getDiagram() != null && diagramPart.getDiagram().getElement() instanceof DDiagram) {
            DSemanticDecorator diagram = (DSemanticDecorator)diagramPart.getDiagram().getElement();
            session = SessionManager.INSTANCE.getSession(diagram.getTarget());
        }
        return session;
    }

    private DDiagram getDiagram(IDiagramWorkbenchPart diagramPart) {
        DDiagram diag = null;
        if (diagramPart != null && diagramPart.getDiagram() != null && diagramPart.getDiagram().getElement() instanceof DDiagram) {
            diag = (DDiagram)diagramPart.getDiagram().getElement();
        }
        return diag;
    }

    private void addLayoutDataCommand(CompositeTransactionalCommand cc, IDiagramWorkbenchPart activePart, IGlobalActionContext cntxt) {
        final Set<DSemanticDecorator> dSelection = this.extractDSelection(cntxt);
        if (dSelection.size() == 1 && cntxt.getSelection() instanceof IStructuredSelection) {
            final Point cursorLocation = this.getCursorLocation(activePart, ((IStructuredSelection)cntxt.getSelection()).iterator().next());
            cc.compose((IUndoableOperation)new AbstractCommand(Messages.SiriusClipboardGlobalActionHandler_addLayoutDataCommandLabel){

                protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    return CommandResult.newOKCommandResult();
                }

                protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    return CommandResult.newOKCommandResult();
                }

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    DDiagram parentDiagram;
                    DSemanticDecorator target = (DSemanticDecorator)dSelection.iterator().next();
                    if (target instanceof DEdge && (parentDiagram = ((DEdge)target).getParentDiagram()) instanceof DSemanticDecorator) {
                        target = (DSemanticDecorator)parentDiagram;
                    }
                    SiriusLayoutDataManager.INSTANCE.addData(new RootLayoutData(target, cursorLocation, new Dimension(-1, -1)));
                    return CommandResult.newOKCommandResult();
                }
            });
        }
    }

    private Point getCursorLocation(IDiagramWorkbenchPart activePart, Object selectedPart) {
        Point loc = null;
        Display current = Display.getCurrent();
        IDiagramGraphicalViewer viewer = activePart.getDiagramGraphicalViewer();
        if (viewer != null && viewer.getControl() instanceof FigureCanvas && current != null) {
            org.eclipse.swt.graphics.Point cursorLocation = current.getCursorLocation();
            FigureCanvas control = (FigureCanvas)viewer.getControl();
            org.eclipse.swt.graphics.Point relativeSWTPoint = control.toControl(cursorLocation);
            Point point = new Point(relativeSWTPoint.x, relativeSWTPoint.y);
            Point after = point.getCopy();
            control.getViewport().translateFromParent((Translatable)after);
            double zoom = ((ScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager().getZoom();
            loc = after.getScaled(1.0 / zoom);
            if (!(selectedPart instanceof IDDiagramEditPart)) {
                IGraphicalEditPart part = (IGraphicalEditPart)selectedPart;
                Point parentLoc = part.getFigure().getBounds().getLocation().getCopy();
                GraphicalHelper.logical2screen((Point)parentLoc, (IGraphicalEditPart)part);
                control.getViewport().translateFromParent((Translatable)parentLoc);
                loc = loc.getTranslated(parentLoc.getNegated());
            }
        }
        return loc;
    }
}

