/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ui.business.internal.view.ShowingViewUtil;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ListItemDeletionEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPropertyHandlerEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractGeneratedDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeListElementItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SiriusTextNonResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusElementTypes;
import org.eclipse.sirius.diagram.ui.tools.api.permission.EditPartAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.viewpoint.LabelStyle;

public class DNodeListElementEditPart
extends AbstractGeneratedDiagramNameEditPart
implements ITextAwareEditPart {
    protected EditPartAuthorityListener authListener = new EditPartAuthorityListener(this);
    public static final int VISUAL_ID = 3010;

    public DNodeListElementEditPart(View view) {
        super(view);
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3) {
            return null;
        }
        return new DragEditPartsTrackerEx((EditPart)this);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("SemanticPolicy");
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeListElementItemSemanticEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new SiriusTextNonResizableEditPolicy());
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
        this.removeEditPolicy("ComponentEditPolicy");
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ListItemDeletionEditPolicy(this.getEditingDomain()));
        this.removeEditPolicy("PropertyHandlerPolicy");
        this.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new SiriusPropertyHandlerEditPolicy());
    }

    @Override
    public void setLabel(IFigure figure) {
        this.unregisterVisuals();
        this.setFigure(figure);
        this.defaultText = this.getLabelTextHelper(figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    @Override
    protected IElementType getParserElementType() {
        return SiriusElementTypes.DNodeListElement_3010;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabelAlignment();
    }

    private void refreshLabelAlignment() {
        DDiagramElement diagElement = this.resolveDiagramElement();
        if (diagElement != null && diagElement.getStyle() instanceof LabelStyle) {
            LabelStyle style = (LabelStyle)diagElement.getStyle();
            DiagramElementEditPartOperation.refreshLabelAlignment(this.getFigure().getParent(), style);
        }
    }

    @Override
    protected void refreshFont() {
        DiagramNameEditPartOperation.refreshFont(this);
    }

    @Override
    protected void refreshFontColor() {
    }

    protected void refreshForegroundColor() {
        DiagramNameEditPartOperation.refreshFont(this);
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        EObject element = this.resolveSemanticElement();
        if (element != null && element.eResource() != null && this.getParent() != null) {
            this.refresh();
        }
        Object feature = notification.getFeature();
        if (DiagramPackage.eINSTANCE.getDDiagramElementContainer_OwnedStyle() == feature) {
            this.refreshVisuals();
        }
        super.handleNotificationEvent(notification);
        if ((notification.getEventType() == 1 || notification.getEventType() == 2 || notification.getEventType() == 3) && this.isActive()) {
            this.refresh();
        }
    }

    protected IFigure createFigure() {
        IFigure label = this.createFigurePrim();
        this.defaultText = this.getLabelTextHelper(label);
        return label;
    }

    protected IFigure createFigurePrim() {
        SiriusWrapLabel safeWrapLabel = new SiriusWrapLabel(){

            public void paint(Graphics graphics) {
                if (DNodeListElementEditPart.this.getModel() instanceof View) {
                    ShowingViewUtil.initGraphicsForVisibleAndInvisibleElements((IFigure)this, graphics, (View)DNodeListElementEditPart.this.getModel());
                    try {
                        CommonEditPartOperation.setGraphicsTraceabilityId(graphics, () -> DNodeListElementEditPart.this.resolveTargetSemanticElement());
                        super.paint(graphics);
                        CommonEditPartOperation.setGraphicsTraceabilityId(graphics, null);
                        graphics.restoreState();
                    }
                    finally {
                        graphics.popState();
                    }
                } else {
                    super.paint(graphics);
                }
            }
        };
        safeWrapLabel.setTextWrap(true);
        return safeWrapLabel;
    }

    @Override
    public void activate() {
        if (!this.isActive()) {
            IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
            auth.addAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
            super.activate();
            DiagramElementEditPartOperation.activate(this);
        }
        this.getEditPartAuthorityListener().refreshEditMode();
    }

    public void enableEditMode() {
        if (!this.getEditPartAuthorityListener().isLocked()) {
            super.enableEditMode();
        }
    }

    @Override
    public void deactivate() {
        DiagramElementEditPartOperation.deactivate(this);
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
        auth.removeAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
        if (this.isActive()) {
            super.deactivate();
        }
    }

    @Override
    public EditPartAuthorityListener getEditPartAuthorityListener() {
        return this.authListener;
    }

    @Override
    protected View getFontStyleOwnerView() {
        return (View)this.getModel();
    }
}

