/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertyType;
import org.eclipse.rse.core.model.IRSEModelObject;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.persistence.dom.IRSEDOMExporter;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.persistence.dom.RSEDOMNode;

public class RSEDOMExporter
implements IRSEDOMExporter {
    private static RSEDOMExporter _instance = new RSEDOMExporter();
    private Map _domMap = new HashMap();

    protected RSEDOMExporter() {
    }

    public static RSEDOMExporter getInstance() {
        return _instance;
    }

    public RSEDOM getRSEDOM(ISystemProfile profile) {
        return (RSEDOM)this._domMap.get(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSEDOM createRSEDOM(ISystemProfile profile, boolean clean) {
        RSEDOM dom = this.getRSEDOM(profile);
        if (dom == null) {
            dom = new RSEDOM(profile);
            this._domMap.put(profile, dom);
            clean = true;
        }
        RSEDOM rSEDOM = dom;
        synchronized (rSEDOM) {
            this.populateRSEDOM(dom, profile, clean);
        }
        return dom;
    }

    public RSEDOM populateRSEDOM(RSEDOM dom, ISystemProfile profile, boolean clean) {
        if (clean) {
            dom.clearChildren();
        }
        if (clean || profile.isDirty() || dom.isDirty()) {
            dom.setName(profile.getName());
            dom.clearAttributes();
            dom.addAttribute("defaultPrivate", this.getBooleanString(profile.isDefaultPrivate()));
            dom.addAttribute("isActive", this.getBooleanString(profile.isActive()));
        }
        ISystemFilterPool[] filterPools = profile.getFilterPools();
        int i = 0;
        while (i < filterPools.length) {
            ISystemFilterPool pool = filterPools[i];
            this.createNode((RSEDOMNode)dom, pool, clean);
            ++i;
        }
        ArrayList<RSEDOMNode> missingNodes = new ArrayList<RSEDOMNode>();
        if (!clean) {
            RSEDOMNode[] oldHostNodes = dom.getChildren("Host");
            int o = 0;
            while (o < oldHostNodes.length) {
                missingNodes.add(oldHostNodes[o]);
                ++o;
            }
        }
        IHost[] hosts = profile.getHosts();
        int j = 0;
        while (j < hosts.length) {
            IHost host = hosts[j];
            RSEDOMNode hnode = this.createNode((RSEDOMNode)dom, host, clean);
            if (!clean) {
                missingNodes.remove(hnode);
            }
            ++j;
        }
        if (!clean) {
            int x = 0;
            while (x < missingNodes.size()) {
                dom.removeChild((RSEDOMNode)missingNodes.get(x));
                ++x;
            }
        }
        this.createPropertySetNodes(dom, profile, clean);
        dom.setDirty(false);
        return dom;
    }

    public RSEDOMNode[] createPropertySetNodes(RSEDOMNode parent, IRSEModelObject modelObject, boolean clean) {
        IPropertySet[] propertySets = modelObject.getPropertySets();
        RSEDOMNode[] result = new RSEDOMNode[propertySets.length];
        int i = 0;
        while (i < propertySets.length) {
            RSEDOMNode propertySetNode;
            IPropertySet set = propertySets[i];
            result[i] = propertySetNode = this.createNode(parent, set, clean);
            ++i;
        }
        return result;
    }

    public RSEDOMNode createNode(RSEDOMNode parent, IPropertySet set, boolean clean) {
        RSEDOMNode propertySetNode = new RSEDOMNode(parent, "PropertySet", set.getName());
        propertySetNode.addAttribute("description", set.getDescription());
        String[] keys = set.getPropertyKeys();
        int k = 0;
        while (k < keys.length) {
            String key = keys[k];
            if (key != null) {
                String value = set.getPropertyValue(key);
                IPropertyType type = set.getPropertyType(key);
                RSEDOMNode propertyNode = new RSEDOMNode(propertySetNode, "Property", key);
                propertyNode.addAttribute("type", type.toString());
                propertyNode.addAttribute("value", value);
            }
            ++k;
        }
        if (set instanceof IRSEModelObject) {
            this.createPropertySetNodes(propertySetNode, (IRSEModelObject)((Object)set), clean);
        }
        return propertySetNode;
    }

    public RSEDOMNode createNode(RSEDOMNode parent, ISystemFilterPool filterPool, boolean clean) {
        RSEDOMNode node = this.findOrCreateNode(parent, "FilterPool", filterPool, clean);
        if (clean || node.isDirty()) {
            node.addAttribute("type", filterPool.getType());
            node.addAttribute("id", filterPool.getId());
            node.addAttribute("supportsNestedFilters", this.getBooleanString(filterPool.supportsNestedFilters()));
            node.addAttribute("deletable", this.getBooleanString(filterPool.isDeletable()));
            node.addAttribute("default", this.getBooleanString(filterPool.isDefault()));
            node.addAttribute("stringsCaseSensitive", this.getBooleanString(filterPool.isSetStringsCaseSensitive()));
            node.addAttribute("supportsDuplicateFilterStrings", this.getBooleanString(filterPool.supportsDuplicateFilterStrings()));
            node.addAttribute("release", Integer.toString(filterPool.getRelease()));
            node.addAttribute("owningParentName", filterPool.getOwningParentName());
            node.addAttribute("nonRenamable", this.getBooleanString(filterPool.isNonRenamable()));
            boolean isSingleFilterStringOnly = false;
            boolean isSingleFilterStringOnlyESet = filterPool.isSetSingleFilterStringOnly();
            isSingleFilterStringOnly = isSingleFilterStringOnlyESet ? filterPool.isSingleFilterStringOnly() : false;
            node.addAttribute("singleFilterStringOnlyESet", this.getBooleanString(isSingleFilterStringOnlyESet));
            node.addAttribute("singleFilterStringOnly", this.getBooleanString(isSingleFilterStringOnly));
        }
        ISystemFilter[] filters = filterPool.getSystemFilters();
        int i = 0;
        while (i < filters.length) {
            this.createNode(node, filters[i], clean);
            ++i;
        }
        this.createPropertySetNodes(node, filterPool, clean);
        node.setDirty(false);
        return node;
    }

    public RSEDOMNode createNode(RSEDOMNode parent, ISystemFilter filter, boolean clean) {
        RSEDOMNode node = this.findOrCreateNode(parent, "Filter", filter, clean);
        if (clean || node.isDirty()) {
            node.addAttribute("id", filter.getName());
            node.addAttribute("supportsNestedFilters", this.getBooleanString(filter.isSupportsNestedFilters()));
            node.addAttribute("relativeOrder", Integer.toString(filter.getRelativeOrder()));
            node.addAttribute("default", this.getBooleanString(filter.isDefault()));
            node.addAttribute("stringsCaseSensitive", this.getBooleanString(filter.isSetStringsCaseSensitive()));
            node.addAttribute("promptable", this.getBooleanString(filter.isPromptable()));
            node.addAttribute("supportsDuplicateFilterStrings", this.getBooleanString(filter.supportsDuplicateFilterStrings()));
            node.addAttribute("nonDeletable", this.getBooleanString(filter.isNonDeletable()));
            node.addAttribute("nonRenamable", this.getBooleanString(filter.isNonRenamable()));
            node.addAttribute("nonChangable", this.getBooleanString(filter.isNonChangable()));
            node.addAttribute("stringsNonChangable", this.getBooleanString(filter.isStringsNonChangable()));
            node.addAttribute("release", Integer.toString(filter.getRelease()));
            node.addAttribute("singleFilterStringOnly", this.getBooleanString(filter.isSetSingleFilterStringOnly()));
            String filterType = filter.getType();
            if (filterType != null) {
                node.addAttribute("filterType", filter.getType());
            }
        }
        ISystemFilter[] nestedFilters = filter.getSystemFilters();
        int i = 0;
        while (i < nestedFilters.length) {
            this.createNode(node, nestedFilters[i], clean);
            ++i;
        }
        ISystemFilterString[] filterStrings = filter.getSystemFilterStrings();
        int j = 0;
        while (j < filterStrings.length) {
            this.createNode(node, filterStrings[j], clean);
            ++j;
        }
        this.createPropertySetNodes(node, filter, clean);
        node.setDirty(false);
        return node;
    }

    public RSEDOMNode createNode(RSEDOMNode parent, ISystemFilterString filterString, boolean clean) {
        RSEDOMNode node = this.findOrCreateNode(parent, "FilterString", filterString, clean);
        if (clean || node.isDirty()) {
            node.addAttribute("string", filterString.getString());
            node.addAttribute("type", filterString.getType());
            node.addAttribute("default", this.getBooleanString(filterString.isDefault()));
        }
        this.createPropertySetNodes(node, filterString, clean);
        return node;
    }

    public RSEDOMNode createNode(RSEDOMNode parent, IHost host, boolean clean) {
        RSEDOMNode node = this.findOrCreateNode(parent, "Host", host, clean);
        if (clean || node.isDirty()) {
            node.addAttribute("type", host.getSystemType().getName());
            node.addAttribute("systemType", host.getSystemType().getId());
            node.addAttribute("offline", this.getBooleanString(host.isOffline()));
            node.addAttribute("promptable", this.getBooleanString(host.isPromptable()));
            node.addAttribute("hostname", host.getHostName());
            node.addAttribute("description", host.getDescription());
        }
        IConnectorService[] connectorServices = host.getConnectorServices();
        int i = 0;
        while (i < connectorServices.length) {
            IConnectorService service = connectorServices[i];
            this.createNode(node, service, clean);
            ++i;
        }
        this.createPropertySetNodes(node, host, clean);
        node.setDirty(false);
        return node;
    }

    public RSEDOMNode createNode(RSEDOMNode parent, IConnectorService connectorService, boolean clean) {
        IServerLauncherProperties serverLauncher;
        RSEDOMNode node = this.findOrCreateNode(parent, "ConnectorService", connectorService, clean);
        if (clean || node.isDirty()) {
            node.addAttribute("group", connectorService.getName());
            node.addAttribute("useSSL", this.getBooleanString(connectorService.isUsingSSL()));
            node.addAttribute("port", Integer.toString(connectorService.getPort()));
        }
        if ((serverLauncher = connectorService.getRemoteServerLauncherProperties()) != null) {
            this.createNode(node, serverLauncher, clean);
        }
        ISubSystem[] subSystems = connectorService.getSubSystems();
        int i = 0;
        while (i < subSystems.length) {
            this.createNode(node, subSystems[i], clean);
            ++i;
        }
        this.createPropertySetNodes(node, connectorService, clean);
        node.setDirty(false);
        return node;
    }

    public RSEDOMNode createNode(RSEDOMNode parent, IServerLauncherProperties serverLauncher, boolean clean) {
        RSEDOMNode node = this.findOrCreateNode(parent, "ServerLauncher", serverLauncher, clean);
        if (!clean) {
            node.isDirty();
        }
        serverLauncher.saveToProperties();
        this.createPropertySetNodes(node, serverLauncher, clean);
        return node;
    }

    public RSEDOMNode createNode(RSEDOMNode parent, ISubSystem subSystem, boolean clean) {
        ISystemFilterPoolReferenceManager refMgr;
        RSEDOMNode node = this.findOrCreateNode(parent, "SubSystem", subSystem, clean);
        if (clean || node.isDirty()) {
            node.addAttribute("hidden", this.getBooleanString(subSystem.isHidden()));
            node.addAttribute("type", subSystem.getSubSystemConfiguration().getId());
        }
        if ((refMgr = subSystem.getFilterPoolReferenceManager()) != null) {
            ISystemFilterPoolReference[] references = refMgr.getSystemFilterPoolReferences();
            int i = 0;
            while (i < references.length) {
                ISystemFilterPoolReference ref = references[i];
                this.createNode(node, ref, clean);
                ++i;
            }
        }
        this.createPropertySetNodes(node, subSystem, clean);
        node.setDirty(false);
        return node;
    }

    public RSEDOMNode createNode(RSEDOMNode parent, ISystemFilterPoolReference filterPoolReference, boolean clean) {
        RSEDOMNode node = this.findOrCreateNode(parent, "FilterPoolReference", filterPoolReference, clean);
        String name = filterPoolReference.getFullName();
        node.setName(name);
        if (clean || node.isDirty()) {
            ISystemFilterPool filterPool = filterPoolReference.getReferencedFilterPool();
            String refId = filterPool != null ? filterPool.getId() : "unknown";
            node.addAttribute("refID", refId);
        }
        this.createPropertySetNodes(node, filterPoolReference, clean);
        node.setDirty(false);
        return node;
    }

    private RSEDOMNode findOrCreateNode(RSEDOMNode parent, String type, IRSEModelObject modelObject, boolean clean) {
        RSEDOMNode node = null;
        String name = modelObject.getName();
        if (!clean && parent != null && (node = parent.getChild(type, name)) != null && modelObject.isDirty()) {
            node.clearAttributes();
            node.setDirty(true);
        }
        if (node == null) {
            node = new RSEDOMNode(parent, type, name);
        }
        return node;
    }

    private String getBooleanString(boolean flag) {
        return flag ? "true" : "false";
    }
}

