/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

import java.util.Vector;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolWrapper;
import org.eclipse.rse.core.filters.ISystemFilterPoolWrapperInformation;
import org.eclipse.rse.internal.core.filters.SystemFilterPoolWrapper;

public class SystemFilterPoolWrapperInformation
implements ISystemFilterPoolWrapperInformation {
    private String promptLabel;
    private String promptTooltip;
    private String verbiageLabel;
    private Vector wrappers;
    private ISystemFilterPoolWrapper[] wrapperArray;
    private ISystemFilterPoolWrapper preSelectWrapper;

    public SystemFilterPoolWrapperInformation(String promptLabel, String promptTooltip, String verbiageLabel) {
        this.promptLabel = promptLabel;
        this.verbiageLabel = verbiageLabel;
        this.promptLabel = promptTooltip;
        this.wrappers = new Vector();
    }

    public void addWrapper(ISystemFilterPoolWrapper wrapper) {
        this.wrappers.add(wrapper);
    }

    public void addWrapper(String displayName, ISystemFilterPool poolToWrap, boolean preSelect) {
        SystemFilterPoolWrapper wrapper = new SystemFilterPoolWrapper(displayName, poolToWrap);
        this.wrappers.add(wrapper);
        if (preSelect) {
            this.preSelectWrapper = wrapper;
        }
    }

    public void setPreSelectWrapper(ISystemFilterPoolWrapper wrapper) {
        this.preSelectWrapper = wrapper;
    }

    public String getPromptLabel() {
        return this.promptLabel;
    }

    public String getPromptTooltip() {
        return this.promptTooltip;
    }

    public String getVerbiageLabel() {
        return this.verbiageLabel;
    }

    public ISystemFilterPoolWrapper[] getWrappers() {
        if (this.wrapperArray == null) {
            this.wrapperArray = new ISystemFilterPoolWrapper[this.wrappers.size()];
            int idx = 0;
            while (idx < this.wrapperArray.length) {
                this.wrapperArray[idx] = (ISystemFilterPoolWrapper)this.wrappers.elementAt(idx);
                ++idx;
            }
        }
        return this.wrapperArray;
    }

    public ISystemFilterPoolWrapper getPreSelectWrapper() {
        if (this.preSelectWrapper == null) {
            if (this.wrappers.size() > 0) {
                return (ISystemFilterPoolWrapper)this.wrappers.elementAt(0);
            }
            return null;
        }
        return this.preSelectWrapper;
    }
}

