/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.core.lookup;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.matcher.AndMatcher;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.workbench.core.exception.WorkbenchCoreLayerException;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchPartLookup;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.Matcher;

public class EditorPartLookup {
    private static EditorPartLookup instance;

    private EditorPartLookup() {
    }

    public static EditorPartLookup getInstance() {
        if (instance == null) {
            instance = new EditorPartLookup();
        }
        return instance;
    }

    public IEditorPart getEditor() {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null) {
            final IEditorReference[] editorReferences = this.getAllEditors();
            if (editorReferences.length == 0) {
                throw new WorkbenchCoreLayerException("There is no open editor at the moment.");
            }
            editorPart = (IEditorPart)Display.syncExec((ResultRunnable)new ResultRunnable<IEditorPart>(){

                public IEditorPart run() {
                    return editorReferences[0].getEditor(false);
                }
            });
        }
        return editorPart;
    }

    public IEditorPart getActiveEditor() {
        IWorkbenchPart workbenchPart = WorkbenchPartLookup.getInstance().getActiveWorkbenchPart();
        IEditorPart editorPart = null;
        editorPart = !(workbenchPart instanceof IEditorPart) ? (IEditorPart)Display.syncExec((ResultRunnable)new ResultRunnable<IEditorPart>(){

            public IEditorPart run() {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
        }) : (IEditorPart)workbenchPart;
        return editorPart;
    }

    public IEditorPart getEditor(Matcher<IEditorPart> ... matchers) {
        EditorPartIsFound found = new EditorPartIsFound(matchers);
        try {
            new WaitUntil((WaitCondition)found);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            throw new WorkbenchCoreLayerException("Unable to find editor matching specified matchers");
        }
        return found.getPart();
    }

    private IEditorPart getEditorInternal(final Matcher<IEditorPart> ... matchers) {
        final IEditorReference[] editorReferences = this.getAllEditors();
        return (IEditorPart)Display.syncExec((ResultRunnable)new ResultRunnable<IEditorPart>(){

            public IEditorPart run() {
                AndMatcher andMatcher = new AndMatcher(matchers);
                IEditorReference[] iEditorReferenceArray = editorReferences;
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart part = editorReference.getEditor(false);
                    if (andMatcher.matches((Object)part)) {
                        return part;
                    }
                    ++n2;
                }
                return null;
            }
        });
    }

    private IEditorReference[] getAllEditors() {
        return (IEditorReference[])Display.syncExec((ResultRunnable)new ResultRunnable<IEditorReference[]>(){

            public IEditorReference[] run() {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                return activeWorkbenchWindow.getActivePage().getEditorReferences();
            }
        });
    }

    private class EditorPartIsFound
    extends AbstractWaitCondition {
        private Matcher<IEditorPart>[] matchers;
        private IEditorPart part;

        public EditorPartIsFound(Matcher<IEditorPart>[] matchers) {
            this.matchers = matchers;
        }

        public boolean test() {
            this.part = EditorPartLookup.getInstance().getEditorInternal(this.matchers);
            return this.part != null;
        }

        public String description() {
            return "editorPart matching " + this.matchers + " is found";
        }

        public IEditorPart getPart() {
            return this.part;
        }
    }
}

