/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.verification;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.editors.IQ7Viewer;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class VerificationViewer {
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ICON = "icon";
    private VerificationType type;
    private IQ7Viewer<Verification> viewer;
    private ImageDescriptor icon;

    public VerificationViewer(IConfigurationElement element) throws CoreException {
        String typeId = this.getVal(element, ATTR_TYPE);
        this.type = VerificationTypeManager.getInstance().getTypeById(typeId);
        if (this.type == null) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.ContextViewer_InvalidTypeErrorMsg, (Object)typeId));
        }
        this.viewer = (IQ7Viewer)element.createExecutableExtension(ATTR_CLASS);
        String iconPath = element.getAttribute(ATTR_ICON);
        if (iconPath != null && iconPath.length() > 0) {
            String plugin = element.getContributor().getName();
            this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)plugin, (String)iconPath);
        }
    }

    public VerificationType getType() {
        return this.type;
    }

    public IQ7Viewer<Verification> getViewer() {
        return this.viewer;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    private String getVal(IConfigurationElement element, String attr) {
        String val = element.getAttribute(attr);
        if (val == null || val.length() == 0) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.VerificationViewer_EmptyErrorMsg, (Object)attr));
        }
        return val;
    }
}

