/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.SuperContext;
import org.eclipse.rcptt.core.scenario.TestSuite;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.context.ContextUIManager;
import org.eclipse.rcptt.ui.context.ContextViewer;
import org.eclipse.rcptt.ui.editors.INamedElementEditor;
import org.eclipse.rcptt.ui.utils.ImageManager;
import org.eclipse.rcptt.ui.verification.VerificationUIManager;
import org.eclipse.rcptt.ui.verification.VerificationViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;

public class ModelUtils {
    private static ImageManager manager = new ImageManager();

    public static String getText(NamedElement element) {
        return element.getName();
    }

    public static Image getImage(NamedElement element) {
        if (element instanceof Scenario) {
            Scenario scenario = (Scenario)element;
            return Images.getImage(Scenarios.isEmpty((Scenario)scenario) ? "icons/scenario_empty.gif" : "icons/scenario.gif");
        }
        if (element instanceof Context) {
            ImageDescriptor image = ModelUtils.getContextImage((Context)element);
            if (image == null) {
                return Images.getImage("icons/context.gif");
            }
            return manager.getImage(image);
        }
        if (element instanceof TestSuite) {
            return Images.getImage("icons/launching/tsuite.gif");
        }
        return null;
    }

    public static String getText(IQ7Element element) {
        if (element instanceof IQ7NamedElement) {
            try {
                String nameByDocument = Q7SearchCore.findNameByDocument((IQ7Element)element);
                if (nameByDocument != null) {
                    return nameByDocument;
                }
                return ((IQ7NamedElement)element).getElementName();
            }
            catch (ModelException modelException) {}
        }
        return element.getName();
    }

    public static Image getImage(IQ7Element element) {
        if (element instanceof ITestCase) {
            ITestCase tc = (ITestCase)element;
            return Images.getImage(Scenarios.isEmpty((ITestCase)tc) ? "icons/scenario_empty.gif" : "icons/scenario.gif");
        }
        if (element instanceof IContext) {
            ImageDescriptor image = ModelUtils.getContextImage((IContext)element);
            if (image == null) {
                return Images.getImage("icons/context.gif");
            }
            return manager.getImage(image);
        }
        if (element instanceof IVerification) {
            ImageDescriptor image = ModelUtils.getVerificationImage((IVerification)element);
            if (image == null) {
                return Images.getImage("icons/verification.gif");
            }
            return manager.getImage(image);
        }
        if (element instanceof ITestSuite) {
            return Images.getImage("icons/launching/tsuite.gif");
        }
        return null;
    }

    public static ImageDescriptor getContextImage(IContext context) {
        String id = Q7SearchCore.findContextTypeByDocument((IContext)context);
        if (id != null) {
            ContextViewer viewer;
            ContextType type = ContextTypeManager.getInstance().getTypeById(id);
            try {
                NamedElement ne = context.getNamedElement();
                if (ne instanceof SuperContext) {
                    return ModelUtils.getSuperContextImage(ne);
                }
            }
            catch (Exception e) {
                RcpttPlugin.log((Throwable)e);
            }
            if (type != null && (viewer = ContextUIManager.getInstance().getViewer(type)) != null) {
                return viewer.getIcon();
            }
        }
        try {
            return ModelUtils.getContextImage((Context)context.getNamedElement());
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)e);
            return null;
        }
    }

    public static ImageDescriptor getVerificationImage(IVerification verification) {
        VerificationViewer viewer;
        VerificationType type;
        String id = Q7SearchCore.findVerificationTypeByDocument((IQ7Element)verification);
        if (id != null && (type = VerificationTypeManager.getInstance().getTypeById(id)) != null && (viewer = VerificationUIManager.getInstance().getViewer(type)) != null) {
            return viewer.getIcon();
        }
        try {
            return ModelUtils.getVerificationImage((Verification)verification.getNamedElement());
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)e);
            return null;
        }
    }

    public static ImageDescriptor getVerificationImage(Verification verification) {
        VerificationViewer viewer;
        VerificationType type = VerificationTypeManager.getInstance().getTypeByVerification(verification);
        if (type != null && (viewer = VerificationUIManager.getInstance().getViewer(type)) != null) {
            return viewer.getIcon();
        }
        return null;
    }

    private static ImageDescriptor getSuperContextImage(NamedElement ne) {
        ImageDescriptor result = null;
        ContextType childTypeType = ContextTypeManager.getInstance().getTypeById(((SuperContext)ne).getChildType());
        if (childTypeType != null) {
            ContextViewer viewer = ContextUIManager.getInstance().getViewer(childTypeType);
            if (viewer != null) {
                result = viewer.getIcon();
            }
            if (result != null) {
                result = Images.getOverlayImageBottomRight(result, "q7_super_context_prefix" + childTypeType.getId(), "icons/overlay/super_ctx.gif");
            }
        }
        if (result == null) {
            result = ModelUtils.getContextImage((Context)ne);
        }
        return result;
    }

    public static ImageDescriptor getContextImage(Context context) {
        ContextViewer viewer;
        ContextType type = ContextTypeManager.getInstance().getTypeByContext(context);
        if (type != null && (viewer = ContextUIManager.getInstance().getViewer(type)) != null) {
            return viewer.getIcon();
        }
        return null;
    }

    public static INamedElementEditor findEditor(IQ7NamedElement element) {
        IFile file = (IFile)element.getResource();
        return ModelUtils.findEditor(file);
    }

    public static INamedElementEditor findEditor(NamedElement element) {
        IFile file = Q7Utils.getLocation((NamedElement)element);
        return ModelUtils.findEditor(file);
    }

    private static INamedElementEditor findEditor(final IFile file) {
        if (file != null) {
            final INamedElementEditor[] editor = new INamedElementEditor[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IEditorReference[] references;
                    FileEditorInput input = new FileEditorInput(file);
                    IWorkbenchWindow window = Q7UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                    if (window == null) {
                        return;
                    }
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IEditorReference[] iEditorReferenceArray = references = page.findEditors((IEditorInput)input, null, 1);
                    int n = references.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference reference = iEditorReferenceArray[n2];
                        IEditorPart part = reference.getEditor(true);
                        if (part instanceof INamedElementEditor) {
                            editor[0] = (INamedElementEditor)part;
                            return;
                        }
                        ++n2;
                    }
                }
            });
            return editor[0];
        }
        return null;
    }

    public static <T> T loadContext(IContext context, Class<T> clazz) {
        block5: {
            ContextType type;
            block4: {
                try {
                    String typeId = Q7SearchCore.findContextTypeByDocument((IContext)context);
                    type = ContextTypeManager.getInstance().getTypeById(typeId);
                    if (type != null) break block4;
                }
                catch (ModelException e) {
                    RcpttPlugin.log((String)("Can't load " + context.getName() + " as " + clazz.getSimpleName()), (Throwable)e);
                    return null;
                }
                return null;
            }
            if (clazz.isAssignableFrom(type.getEClass().getInstanceClass())) break block5;
            return null;
        }
        NamedElement namedElement = context.getNamedElement();
        return clazz.cast(namedElement);
    }

    public static <T> T loadVerification(IVerification verification, Class<T> clazz) {
        block5: {
            VerificationType type;
            block4: {
                try {
                    String typeId = Q7SearchCore.findVerificationTypeByDocument((IQ7Element)verification);
                    type = VerificationTypeManager.getInstance().getTypeById(typeId);
                    if (type != null) break block4;
                }
                catch (ModelException e) {
                    RcpttPlugin.log((String)("Can't load " + verification.getName() + " as " + clazz.getSimpleName()), (Throwable)e);
                    return null;
                }
                return null;
            }
            if (clazz.isAssignableFrom(type.getEClass().getInstanceClass())) break block5;
            return null;
        }
        NamedElement namedElement = verification.getNamedElement();
        return clazz.cast(namedElement);
    }
}

