/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.refactoring.rename.Q7RenameProcessor;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenameNamedElementInputPage
extends UserInputWizardPage {
    private final Q7RenameProcessor fRefactoringProcessor;
    private Text nameText;
    private Text fileName;
    private IQ7NamedElement element;
    private IFile file;

    public RenameNamedElementInputPage(Q7RenameProcessor processor) {
        super("RenameResourceRefactoringInputPage");
        this.fRefactoringProcessor = processor;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        Label label = new Label(composite, 16384);
        label.setText(Messages.RenameNamedElementInputPage_NewNameLabel);
        this.nameText = new Text(composite, 2048);
        GridData data = new GridData(768);
        this.nameText.setLayoutData((Object)data);
        Label fName = new Label(composite, 16384);
        fName.setText(Messages.RenameNamedElementInputPage_FileNameLabel);
        this.fileName = new Text(composite, 2056);
        this.fileName.setEnabled(false);
        GridDataFactory.fillDefaults().applyTo((Control)this.fileName);
        try {
            this.nameText.setText(this.getElement().getElementName());
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        this.fileName.setText(this.getFile().getName());
        this.setPageComplete(false);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameNamedElementInputPage.this.fileName.setText(FileUtil.escapeFileName((String)RenameNamedElementInputPage.this.nameText.getText(), (String)RenameNamedElementInputPage.this.file.getFileExtension()));
                RenameNamedElementInputPage.this.validatePage();
            }
        });
    }

    private IFile getFile() {
        if (this.file == null) {
            this.file = (IFile)this.fRefactoringProcessor.getResource();
        }
        return this.file;
    }

    private IQ7NamedElement getElement() {
        if (this.element == null) {
            this.element = (IQ7NamedElement)RcpttCore.create((IResource)this.getFile());
        }
        return this.element;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.nameText.selectAll();
            this.nameText.forceFocus();
        }
        super.setVisible(visible);
    }

    protected final void validatePage() {
        String text = this.fileName.getText();
        String name = this.nameText.getText();
        RefactoringStatus status = this.fRefactoringProcessor.validateNewElementName(name, text);
        this.setPageComplete(status);
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        this.storeSettings();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        this.storeSettings();
        return super.getNextPage();
    }

    private void storeSettings() {
    }

    private void initializeRefactoring() {
        this.fRefactoringProcessor.setNewElementName(this.nameText.getText());
        this.fRefactoringProcessor.setNewResourceName(this.fileName.getText());
    }
}

