/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.recording;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.recording.CommandSet;
import org.eclipse.rcptt.core.recording.IRecordingMonitor;
import org.eclipse.rcptt.core.recording.NetworkRecorder;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.rcptt.tesla.internal.core.network.DefaultConnectionMonitor;
import org.eclipse.rcptt.ui.recording.WaitForConnectionAndActivateAssertModeJob;
import org.eclipse.rcptt.ui.recording.WidgetPickerWindow;
import org.eclipse.rcptt.ui.utils.TeslaUtils;
import org.eclipse.rcptt.util.ShellUtilsProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WidgetPicker {
    private static WidgetPicker picker;
    private static WidgetPickerWindow window;
    private static Shell lastMainWindow;
    private static volatile String result;
    private static Shell parentShell;
    private final BaseAutLaunch launch;
    private final NetworkRecorder recorder;
    private final VerificationType type;

    public static synchronized String activate(Shell parentShell, BaseAutLaunch launch, VerificationType type) {
        WidgetPicker.parentShell = parentShell;
        result = null;
        if (picker != null) {
            WidgetPicker.deactivate(true);
        } else {
            lastMainWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            lastMainWindow.setMinimized(true);
        }
        picker = new WidgetPicker(launch, type);
        try {
            picker.start();
        }
        catch (IOException ex) {
            Q7UIPlugin.log("Error while activating picker", ex);
        }
        window = new WidgetPickerWindow(lastMainWindow, parentShell, type);
        window.open();
        WidgetPicker.deactivate(false);
        return result;
    }

    private static synchronized void deactivate(boolean activating) {
        if (picker != null) {
            picker.stop();
            picker = null;
        }
        if (window != null && window.getShell() != null) {
            window.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    window.close();
                    window = null;
                }
            });
        }
        if (!activating && lastMainWindow != null) {
            lastMainWindow.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    lastMainWindow.setMinimized(false);
                    if (parentShell != null) {
                        try {
                            ShellUtilsProvider.getShellUtils().forceActive((Object)parentShell);
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                        parentShell.setFocus();
                    } else {
                        try {
                            ShellUtilsProvider.getShellUtils().forceActive((Object)lastMainWindow);
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                        lastMainWindow.setFocus();
                    }
                }
            });
            lastMainWindow = null;
        }
    }

    private WidgetPicker(BaseAutLaunch launch, VerificationType type) {
        this.launch = launch;
        this.type = type;
        this.recorder = new NetworkRecorder(launch.getHost(), launch.getTeslaPort(), new RecordingMonitor()){

            protected boolean isStopRecordRequest(Type command) {
                return true;
            }
        };
    }

    public void start() throws IOException {
        this.recorder.start();
        new WaitForConnectionAndActivateAssertModeJob("Activating assert mode", this.launch, this.recorder, this.type.getWidgets()).schedule();
    }

    public void stop() {
        this.recorder.cancelConnection();
        this.recorder.close();
    }

    private class RecordingMonitor
    extends DefaultConnectionMonitor
    implements IRecordingMonitor {
        private RecordingMonitor() {
        }

        public void tryToConnect() {
        }

        public void connectFailed(Exception exception) {
        }

        public void connected() {
        }

        public void timeout() {
        }

        public long getPause() {
            return super.getPause();
        }

        public long getTimeout() {
            return super.getTimeout();
        }

        public void recordMode() {
        }

        public void assertMode() {
        }

        public void startRecord() {
        }

        public void stopRecord() {
            result = null;
            if (window != null && window.getShell() != null) {
                window.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        window.close();
                    }
                });
            }
        }

        public void replay() {
        }

        public void assertAdded(CommandSet commandSet) {
            if (commandSet == null) {
                return;
            }
            final String selector = TeslaUtils.selectorOf(commandSet);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Display.getDefault().timerExec(150, new Runnable(){

                        @Override
                        public void run() {
                            result = selector;
                            WidgetPicker.deactivate(false);
                        }
                    });
                }
            });
        }
    }
}

