/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.reporting.core.TimeFormatHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StatisticPanel
extends Composite {
    private final Label runsLabel;
    private final Label failuresLabel;
    private final Label stopsLabel;
    private final Label totalTimeLabel;

    public StatisticPanel(Composite parent) {
        super(parent, 64);
        RowLayout layout = new RowLayout();
        layout.wrap = true;
        layout.pack = true;
        layout.spacing = 10;
        this.setLayout((Layout)layout);
        this.runsLabel = this.createLabel(Messages.StatisticPanel_RunsLabel, null);
        this.failuresLabel = this.createLabel(Messages.StatisticPanel_FailuresLabel, Images.getImageDescriptor("icons/launching/error_ovr.gif").createImage());
        this.stopsLabel = this.createLabel(Messages.StatisticPanel_StopsLabel, Images.getImageDescriptor("icons/launching/stop_ovr.gif").createImage());
        this.totalTimeLabel = this.createLabel(Messages.StatisticPanel_TotalTimeLabel, null);
        this.reset();
    }

    private Label createLabel(String name, Image image) {
        Composite c = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(c);
        Label label = new Label(c, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
            GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)label);
        } else {
            GridDataFactory.fillDefaults().exclude(true).applyTo((Control)label);
        }
        label = new Label(c, 0);
        label.setText(name);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)label);
        label = new Label(c, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)label);
        return label;
    }

    public synchronized void reset() {
        this.update(0, 0, 0, 0, 0L);
    }

    public synchronized void update(int total, int finished, int failed, int stopped, long totalTime) {
        this.runsLabel.setText(String.valueOf(finished) + "/" + total);
        this.failuresLabel.setText(String.valueOf(failed));
        this.stopsLabel.setText(String.valueOf(stopped));
        this.totalTimeLabel.setText(TimeFormatHelper.format((long)totalTime));
        this.layout();
        this.redraw();
    }
}

