/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LaunchConfigurationMigration {
    private final Set<String> registeredTypes;
    private final Map<String, String> typeMap = new HashMap<String, String>();
    private static final Function<String, String> replaceKeyPrefixes = new Function<String, String>(){

        public String apply(String input) {
            return LaunchConfigurationMigration.replacePrefix("com.xored.q7.launching", "org.eclipse.rcptt.launching", input);
        }
    };

    public LaunchConfigurationMigration() {
        Function<ILaunchConfigurationType, String> toIdentifier = new Function<ILaunchConfigurationType, String>(){

            public String apply(ILaunchConfigurationType input) {
                return input.getIdentifier();
            }
        };
        ILaunchConfigurationType[] types = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        Iterable ids = Iterables.transform(Arrays.asList(types), (Function)toIdentifier);
        this.registeredTypes = ImmutableSet.copyOf((Iterable)ids);
        LaunchConfigurationMigration.registerMigration("com.xored.q7.launching.scenarios", "org.eclipse.rcptt.launching.scenarios", this.registeredTypes, this.typeMap);
        LaunchConfigurationMigration.registerMigration("com.xored.q7.launching.ext", "org.eclipse.rcptt.launching.ext", this.registeredTypes, this.typeMap);
        LaunchConfigurationMigration.registerMigration("com.xored.q7.launching.remote", "org.eclipse.rcptt.launching.remote", this.registeredTypes, this.typeMap);
        LaunchConfigurationMigration.registerMigration("com.xored.q7.launching.multiaut", "org.eclipse.rcptt.launching.multiaut", this.registeredTypes, this.typeMap);
    }

    private static void registerMigration(String from, String to, Set<String> knownTypes, Map<String, String> typeMap) {
        if (!knownTypes.contains(to)) {
            Q7UIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.rcptt.ui", String.format("Attempt to register launch configuration migration to unknown type %s", to)));
            return;
        }
        typeMap.put(from, to);
    }

    private static String replacePrefix(String prefix, String newPrefix, String target) {
        if (target == null) {
            return null;
        }
        if (target.startsWith(prefix)) {
            return String.valueOf(newPrefix) + target.substring(prefix.length());
        }
        return target;
    }

    public static Document parse(Reader reader) {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            return parser.parse(new InputSource(reader));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getType(Document document) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        try {
            XPathExpression expr = xpath.compile("launchConfiguration/@type");
            return expr.evaluate(document);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isMigrationRequired(Document doc) {
        return this.typeMap.containsKey(LaunchConfigurationMigration.getType(doc));
    }

    public static void write(Document document, Writer writer) {
        if (document == null) {
            throw new NullPointerException();
        }
        try {
            Transformer identity = TransformerFactory.newInstance().newTransformer();
            identity.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean migrate(Document document) throws CoreException {
        String type = LaunchConfigurationMigration.getType(document);
        if (type == null) {
            return false;
        }
        if (this.registeredTypes.contains(type)) {
            return false;
        }
        if (type.equals("com.xored.q7.launching.scenarios")) {
            this.migrateType(document, "org.eclipse.rcptt.launching.scenarios");
            return true;
        }
        if (type.equals("com.xored.q7.launching.ext")) {
            this.migrateType(document, "org.eclipse.rcptt.launching.ext");
            return true;
        }
        if (type.equals("com.xored.q7.launching.remote")) {
            this.migrateType(document, "org.eclipse.rcptt.launching.remote");
            return true;
        }
        return false;
    }

    public static void migrateKeys(Node root, Function<String, String> calcNewKey) throws XPathExpressionException {
        assert (root != null);
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            String newKey;
            String oldKey;
            Node keynode;
            Node node = list.item(i);
            if (node.getNodeName().endsWith("Attribute") && (keynode = node.getAttributes().getNamedItem("key")) != null && (oldKey = keynode.getTextContent()) != null && !oldKey.equals(newKey = (String)calcNewKey.apply((Object)oldKey))) {
                keynode.setTextContent(newKey);
            }
            ++i;
        }
    }

    public void migrateType(Document document, String newTypeId) {
        if (!this.registeredTypes.contains(newTypeId)) {
            throw new IllegalArgumentException("New type id must reference existing launch type");
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("launchConfiguration/@type");
            Node node = (Node)expr.evaluate(document, XPathConstants.NODE);
            node.setTextContent(newTypeId);
            LaunchConfigurationMigration.migrateKeys(document.getDocumentElement(), replaceKeyPrefixes);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }
}

