/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.quickfix;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.rcptt.core.ecl.parser.ast.Command;
import org.eclipse.rcptt.core.ecl.parser.ast.LiteralArg;
import org.eclipse.rcptt.core.internal.validators.ScriptValidator;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.quickfix.QuickFixer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class GetParamCmdQuickFixer
extends QuickFixer {
    private static final String label = "Replace 'get-param' with '$' annotation";
    private static final Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_CUT");

    public GetParamCmdQuickFixer(int start, int end) {
        super(label, img, start, end);
    }

    @Override
    public void quickFix(IDocument doc) {
        int startOffset;
        String content = doc.get();
        Command badCmd = ScriptValidator.findCommand((String)content, (int)(startOffset = this.start));
        if (badCmd == null || badCmd.args.size() > 1 || !(badCmd.lastArg() instanceof LiteralArg)) {
            return;
        }
        LiteralArg arg = (LiteralArg)badCmd.lastArg();
        String value = arg.value.text;
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length());
            value = value.substring(0, value.length() - 1);
        }
        try {
            doc.replace(badCmd.begin, badCmd.length(), "$" + value);
        }
        catch (BadLocationException e) {
            Q7UIPlugin.log(e);
        }
    }
}

