/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.controls.ContextsTable;
import org.eclipse.rcptt.ui.controls.DescriptionComposite;
import org.eclipse.rcptt.ui.controls.SectionWithToolbar;
import org.eclipse.rcptt.ui.controls.VerificationsTable;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.ScenarioProperties;
import org.eclipse.rcptt.ui.editors.ScriptSection;
import org.eclipse.rcptt.ui.editors.TextViewerActions;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.IPropertySource;

public class EditorContent
implements NamedElementEditorActions.INamedElementActions {
    private final EditorHeader header;
    private final IPropertySource scenarioPropertySource;
    private ScriptSection script;
    private EclSourceViewer viewer;
    private Section contextSection;
    private ContextsTable contextTable;
    private Section descriptionSection;
    private ScenarioProperties propertiesSection;
    private ExternalReference externalRef;
    private boolean scenarioEditor;
    private final boolean supportRefs;
    private VerificationsTable verificationsTable;
    private Section verificationsSection;
    private Section propertiesSectionSection;
    private static final String EXT_REF_TOOLTIP = Messages.ScenarioEditorPage_ExternalReferenceToolTip;
    private DescriptionComposite descriptionComposite;
    private Binding externalRefBinding;

    public EditorContent(EditorHeader header, boolean refs, boolean scenario) {
        this.header = header;
        this.scenarioPropertySource = this.createPropertySource();
        this.supportRefs = refs;
        this.scenarioEditor = scenario;
    }

    public ScriptSection getScriptSection() {
        return this.script;
    }

    public Section getVerificationsSection() {
        return this.verificationsSection;
    }

    public IQ7NamedElement getModel() {
        return this.header.getModel();
    }

    public NamedElement getElement() {
        return this.header.getElement();
    }

    public void createSections(Composite parent, final FormToolkit toolkit) {
        this.descriptionComposite = new DescriptionComposite(this.getElement()){

            @Override
            public void createControl(Composite parent) {
                super.createControl(parent);
                if (EditorContent.this.supportRefs) {
                    EditorContent.this.createExternalReference((Composite)this.getControl(), toolkit);
                }
            }
        };
        this.descriptionSection = new SectionWithToolbar(this.descriptionComposite, 0x102 | this.getDescriptionFlags()).create(parent, toolkit);
        if (this.supportRefs) {
            try {
                this.contextTable = new ContextsTable((ITestCase)this.getModel());
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
            }
            this.contextSection = new SectionWithToolbar(this.contextTable, 258).create(parent, toolkit);
        }
        if (this.scenarioEditor) {
            try {
                NamedElement namedElement = this.getModel().getNamedElement();
                if (namedElement instanceof Scenario) {
                    this.propertiesSection = new ScenarioProperties((Scenario)namedElement, toolkit);
                    this.propertiesSectionSection = new SectionWithToolbar(this.propertiesSection, 258).create(parent, toolkit);
                }
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
            }
            this.script = new ScriptSection();
            this.script.create(parent, toolkit);
        }
        if (this.supportRefs) {
            try {
                this.verificationsTable = new VerificationsTable((ITestCase)this.getModel());
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
            }
            this.verificationsSection = new SectionWithToolbar(this.verificationsTable, 258).create(parent, toolkit);
        }
    }

    protected int getDescriptionFlags() {
        return 0;
    }

    public void setViewer(EclSourceViewer viewer) {
        this.viewer = viewer;
    }

    public void setSelectionProvider(IWorkbenchPartSite site) {
        site.setSelectionProvider(new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                if (EditorContent.this.scenarioPropertySource != null) {
                    return new StructuredSelection((Object)EditorContent.this.scenarioPropertySource);
                }
                return StructuredSelection.EMPTY;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        });
    }

    public void showSearchMatch(int scenarioPart, int offset, int length) {
        if (scenarioPart == 0) {
            if (!this.script.getSection().isExpanded()) {
                this.script.getSection().setExpanded(true);
            }
            if (this.viewer != null) {
                this.viewer.getTextWidget().setFocus();
                this.viewer.revealRange(offset, length);
                this.viewer.setSelectedRange(offset, length);
            }
        } else if (scenarioPart == 1) {
            if (!this.descriptionSection.isExpanded()) {
                this.descriptionSection.setExpanded(true);
            }
            this.descriptionComposite.getDescriptionControl().setFocus();
            this.descriptionComposite.getDescriptionControl().setSelection(offset, offset + length);
        } else if (scenarioPart == 2) {
            StyledText tagsControl = this.header.getTagsControl();
            tagsControl.setFocus();
            tagsControl.setSelection(offset, offset + length);
        } else if (scenarioPart == 3 && this.contextSection != null && !this.contextSection.isExpanded()) {
            this.contextSection.setExpanded(true);
        }
    }

    private void createExternalReference(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)composite);
        Hyperlink externalRefLabel = toolkit.createHyperlink(composite, Messages.ScenarioEditorPage_ExternalReferenceLabel, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)externalRefLabel);
        TextViewer textViewer = new TextViewer(composite, 0x804 | toolkit.getBorderStyle() | toolkit.getOrientation());
        toolkit.adapt((Composite)textViewer.getTextWidget());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)textViewer.getTextWidget());
        this.externalRef = new ExternalReference(textViewer, externalRefLabel);
        this.update(this.getModel(), this.getElement());
    }

    private IPropertySource createPropertySource() {
        return (IPropertySource)Platform.getAdapterManager().getAdapter((Object)this.getElement(), IPropertySource.class);
    }

    public void gotoMarker(IMarker marker) {
        try {
            Object lineObj = marker.getAttribute("lineNumber");
            if (lineObj instanceof Integer) {
                int line = (Integer)lineObj;
                if (!this.script.getSection().isExpanded()) {
                    this.script.getSection().setExpanded(true);
                }
                if (this.viewer != null) {
                    this.viewer.getTextWidget().setFocus();
                    IRegion region = this.viewer.getDocument().getLineInformation(line - 1);
                    this.viewer.setSelection((ISelection)new TextSelection(region.getOffset(), region.getLength()), true);
                }
            }
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
        }
    }

    public boolean isInFocus() {
        return this.descriptionComposite.getDescriptionControl().isFocusControl() || this.externalRef != null && this.externalRef.getControl().isFocusControl() || this.contextTable != null && this.contextTable.getControl().isFocusControl() || this.verificationsTable != null && this.verificationsTable.getControl().isFocusControl() || this.header.isInFocus() || this.propertiesSection != null && this.propertiesSection.getControl().isFocusControl();
    }

    public void doSelectAll() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            this.descriptionComposite.getDescriptionControl().selectAll();
        } else if (this.externalRef.getControl().isFocusControl()) {
            this.externalRef.getControl().selectAll();
        } else if (this.contextTable != null && this.contextTable.getControl().isFocusControl()) {
            ((Table)this.contextTable.getControl()).selectAll();
        } else if (this.verificationsTable != null && this.verificationsTable.getControl().isFocusControl()) {
            ((Table)this.verificationsTable.getControl()).selectAll();
        }
    }

    @Override
    public void copy() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            this.descriptionComposite.getActions().copy();
        } else if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            this.externalRef.getActions().copy();
        } else if (this.contextTable != null && this.contextTable.getControl().isFocusControl()) {
            if (this.contextTable.canCopy()) {
                this.contextTable.copy();
            }
        } else if (this.verificationsTable != null && this.verificationsTable.getControl().isFocusControl()) {
            if (this.verificationsTable.canCopy()) {
                this.verificationsTable.copy();
            }
        } else if (this.header.isInFocus()) {
            this.header.copy();
        }
    }

    @Override
    public boolean canCopy() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            return this.descriptionComposite.getActions().canCopy();
        }
        if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            return this.externalRef.getActions().canCopy();
        }
        if (this.contextTable != null && this.contextTable.getControl().isFocusControl()) {
            return this.contextTable.canCopy();
        }
        if (this.verificationsTable != null && this.verificationsTable.getControl().isFocusControl()) {
            return this.verificationsTable.canCopy();
        }
        if (this.header.isInFocus()) {
            return this.header.canCopy();
        }
        return false;
    }

    @Override
    public boolean canPaste() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            return this.descriptionComposite.getActions().canPaste();
        }
        if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            return this.externalRef.getActions().canPaste();
        }
        if (this.contextTable != null && this.contextTable.getControl().isFocusControl()) {
            return this.contextTable.canPaste();
        }
        if (this.verificationsTable != null && this.verificationsTable.getControl().isFocusControl()) {
            return this.verificationsTable.canPaste();
        }
        if (this.header.isInFocus()) {
            return this.header.canPaste();
        }
        return false;
    }

    @Override
    public boolean canCut() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            return this.descriptionComposite.getActions().canCut();
        }
        if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            return this.externalRef.getActions().canCut();
        }
        if (this.contextTable != null && this.contextTable.getControl().isFocusControl()) {
            return this.contextTable.canCut();
        }
        if (this.verificationsTable != null && this.verificationsTable.getControl().isFocusControl()) {
            return this.verificationsTable.canCut();
        }
        if (this.header.isInFocus()) {
            return this.header.canCut();
        }
        return false;
    }

    @Override
    public void paste() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            this.descriptionComposite.getActions().paste();
        } else if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            this.externalRef.getActions().paste();
        } else if (this.contextTable != null && this.contextTable.getControl().isFocusControl()) {
            if (this.contextTable.canPaste()) {
                this.contextTable.paste();
            }
        } else if (this.verificationsTable != null && this.verificationsTable.getControl().isFocusControl()) {
            if (this.verificationsTable.canPaste()) {
                this.verificationsTable.paste();
            }
        } else if (this.header.isInFocus()) {
            this.header.paste();
        }
    }

    @Override
    public void cut() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            this.descriptionComposite.getActions().cut();
        } else if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            this.externalRef.getActions().cut();
        } else if (this.contextTable != null && this.contextTable.getControl().isFocusControl()) {
            if (this.contextTable.canCut()) {
                this.contextTable.cut();
            }
        } else if (this.verificationsTable != null && this.verificationsTable.getControl().isFocusControl()) {
            if (this.verificationsTable.canCut()) {
                this.verificationsTable.cut();
            }
        } else if (this.header.isInFocus()) {
            this.header.cut();
        }
    }

    public void update(IQ7NamedElement model, NamedElement element) {
        if (this.externalRefBinding != null) {
            this.externalRefBinding.dispose();
        }
        if (this.externalRef != null) {
            this.externalRefBinding = this.header.getDataBindingContext().bindValue((IObservableValue)SWTObservables.observeText((Control)this.externalRef.getControl(), (int)24), EMFProperties.value((EStructuralFeature)ScenarioPackage.Literals.SCENARIO__EXTERNAL_REFERENCE).observe((Object)this.getElement()));
        }
        this.descriptionComposite.update(element);
        if (this.contextTable != null) {
            this.contextTable.update((EObject)element);
        }
        if (this.propertiesSection != null) {
            this.propertiesSection.update((Scenario)element);
        }
        if (this.verificationsTable != null) {
            this.verificationsTable.update((EObject)element);
        }
    }

    public void doTextCommand(int fAction) {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            this.descriptionComposite.getDescriptionControl().invokeAction(fAction);
        } else if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            this.externalRef.getControl().invokeAction(fAction);
        }
    }

    public TextViewer getTextViewer() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            return this.descriptionComposite.getDescriptionViewer();
        }
        return null;
    }

    @Override
    public boolean canUndo() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            return this.descriptionComposite.getActions().canUndo();
        }
        if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            return this.externalRef.getActions().canUndo();
        }
        return false;
    }

    @Override
    public boolean canRedo() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            return this.descriptionComposite.getActions().canRedo();
        }
        if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            return this.externalRef.getActions().canRedo();
        }
        return false;
    }

    @Override
    public void undo() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            this.descriptionComposite.getActions().undo();
        } else if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            this.externalRef.getActions().undo();
        }
    }

    @Override
    public void redo() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            this.descriptionComposite.getActions().redo();
        } else if (this.externalRef != null && this.externalRef.getControl().isFocusControl()) {
            this.externalRef.getActions().redo();
        }
    }

    private final class ExternalReference {
        private final TextViewer textViewer;
        private final NamedElementEditorActions.INamedElementActions actions;

        public ExternalReference(TextViewer textViewer, final Hyperlink externalRefLabel) {
            this.textViewer = textViewer;
            externalRefLabel.setToolTipText(EXT_REF_TOOLTIP);
            externalRefLabel.setUnderlined(true);
            externalRefLabel.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    if (!"".equals(EditorContent.this.externalRef.getControl().getText().trim())) {
                        Program.launch((String)EditorContent.this.externalRef.getControl().getText());
                    }
                }
            });
            this.getControl().setToolTipText(EXT_REF_TOOLTIP);
            this.getControl().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    externalRefLabel.setEnabled(!"".equals(ExternalReference.this.getControl().getText().trim()));
                }
            });
            this.actions = new TextViewerActions(textViewer);
        }

        public NamedElementEditorActions.INamedElementActions getActions() {
            return this.actions;
        }

        public StyledText getControl() {
            return this.textViewer.getTextWidget();
        }
    }
}

