/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.Q7ProjectMetadata;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.rcptt.ui.refactoring.rename.Q7RenameResourceWizard;
import org.eclipse.rcptt.ui.refactoring.rename.RenameTagWizard;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.actions.RenameResourceAction;

public class RenameAction
extends RenameResourceAction {
    private IShellProvider provider;

    public RenameAction(IShellProvider provider) {
        super(provider);
        this.provider = provider;
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    public RenameAction(IShellProvider provider, Tree tree) {
        super(provider, tree);
        this.provider = provider;
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    public void run() {
        try {
            if (!this.makeResourceWritable(this.provider.getShell())) {
                return;
            }
        }
        catch (CoreException e) {
            Q7UIPlugin.log(e);
            return;
        }
        if (LaunchUtils.hasLaunchedTestCases()) {
            MessageDialog.openWarning((Shell)this.provider.getShell(), (String)Messages.RenameAction_ErrorDialogTitle, (String)Messages.RenameAction_ErrorDialogMsg);
            return;
        }
        if (!RefactoringSaveHelper.checkDirtyEditors(this.provider.getShell())) {
            return;
        }
        if (this.containsSingleTag(this.getStructuredSelection())) {
            RenameTagWizard wizard = new RenameTagWizard(this.getSelectedTag());
            this.run(wizard, this.provider.getShell());
        } else {
            List resources = this.getSelectedResources();
            if (resources.size() == 1) {
                IResource resource = (IResource)resources.get(0);
                Q7RenameResourceWizard wizard = new Q7RenameResourceWizard(resource);
                this.run(wizard, this.provider.getShell());
            }
        }
    }

    private boolean makeResourceWritable(Shell shell) throws CoreException {
        WriteAccessChecker writeAccessChecker = new WriteAccessChecker(shell);
        Object selection = this.getStructuredSelection().getFirstElement();
        if (selection instanceof Tag) {
            IQ7NamedElement[] elements = (IQ7NamedElement[])((Tag)selection).getRefs().toArray();
            return writeAccessChecker.makeResourceWritable((IQ7Element[])elements);
        }
        return true;
    }

    public void run(RefactoringWizard wizard, Shell parent) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, wizard.getWindowTitle());
        }
        catch (InterruptedException interruptedException) {}
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile && RcpttCore.isQ7ProjectMetadata((IPath)((IFile)o).getFullPath()) || o instanceof Q7ProjectMetadata) {
                return false;
            }
            ++n2;
        }
        if (this.containsSingleTag(selection)) {
            return true;
        }
        return super.updateSelection(selection);
    }

    private boolean containsSingleTag(IStructuredSelection selection) {
        int count = 0;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!(o instanceof Tag)) {
                return false;
            }
            ++count;
            ++n2;
        }
        return count == 1;
    }

    private Tag getSelectedTag() {
        Object[] objectArray = this.getStructuredSelection().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Tag) {
                return (Tag)o;
            }
            ++n2;
        }
        return null;
    }
}

