/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.OneProjectScope;
import org.eclipse.rcptt.ui.dialogs.RemoveAllProjectReferencesDialog;
import org.eclipse.ui.PlatformUI;

public class ProjectContextReferencesUpdateJob
extends Job {
    private IQ7Project project;

    public ProjectContextReferencesUpdateJob(IQ7Project project) {
        super("Update Project Context/Verification references");
        this.project = project;
    }

    public boolean belongsTo(Object family) {
        return super.belongsTo(family);
    }

    private static Collection<IQ7NamedElement> filterOutProjectMetadata(IQ7NamedElement[] elements) {
        return Collections2.filter(Arrays.asList(elements), (Predicate)new Predicate<IQ7NamedElement>(){

            public boolean apply(IQ7NamedElement input) {
                return input.getElementType() != IQ7Element.HandleType.ProjectMetadata;
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            String[] verifications;
            String[] contexts;
            IQ7ProjectMetadata metadata = this.project.getMetadata();
            final HashSet<IQ7NamedElement> elementsToProceed = new HashSet<IQ7NamedElement>();
            OneProjectScope scope = new OneProjectScope(this.project);
            String[] stringArray = contexts = metadata.exists() ? metadata.getContexts() : new String[]{};
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                String el = stringArray[n2];
                IQ7NamedElement[] elements = Q7SearchCore.findContextUsage((String)el, (ISearchScope)scope, (IProgressMonitor)new NullProgressMonitor());
                if (elements != null) {
                    elementsToProceed.addAll(ProjectContextReferencesUpdateJob.filterOutProjectMetadata(elements));
                }
                ++n2;
            }
            String[] stringArray2 = verifications = metadata.getVerifications();
            int n3 = verifications.length;
            n = 0;
            while (n < n3) {
                String el = stringArray2[n];
                IQ7NamedElement[] elements = Q7SearchCore.findVerificationUsage((String)el, (ISearchScope)scope, (IProgressMonitor)new NullProgressMonitor());
                if (elements != null) {
                    elementsToProceed.addAll(ProjectContextReferencesUpdateJob.filterOutProjectMetadata(elements));
                }
                ++n;
            }
            if (elementsToProceed.size() > 0) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RemoveAllProjectReferencesDialog.open(PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell(), ProjectContextReferencesUpdateJob.this.project, new ArrayList<IQ7NamedElement>(elementsToProceed));
                    }
                });
            }
        }
        catch (Exception e) {
            RcpttPlugin.log((Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ProjectContextReferencesUpdateJob other = (ProjectContextReferencesUpdateJob)((Object)obj);
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    public Object getFamily() {
        return this;
    }
}

