/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.tesla.core.protocol.CloseWorkbench;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.IWindowProvider;
import org.eclipse.rcptt.tesla.core.protocol.Nop;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.UISelector;
import org.eclipse.rcptt.tesla.core.protocol.WindowUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;

public abstract class UIPlayer
implements IUIPlayer,
IWindowProvider {
    Selector selector = new Selector();
    private List<Response> failures = new ArrayList<Response>();
    private static ProtocolFactory factory = ProtocolFactory.eINSTANCE;

    public abstract Response executeCommand(Command var1) throws IOException;

    public UIPlayer() {
        this.selector.window = new UISelector<WindowUIElement>(ElementKind.Window, (IUIPlayer)this, WindowUIElement.class);
        this.selector.eclipseWindow = new UISelector<WindowUIElement>(ElementKind.EclipseWindow, (IUIPlayer)this, WindowUIElement.class);
    }

    @Override
    public WindowUIElement window() {
        return this.selector.window.find();
    }

    @Override
    public WindowUIElement window(String pattern) {
        return this.selector.window.find(pattern);
    }

    @Override
    public WindowUIElement window(String pattern, int index) {
        return this.selector.window.find(pattern, index);
    }

    @Override
    public WindowUIElement fromedWindow(String from) {
        return this.selector.window.path("-from", from).find();
    }

    @Override
    public WindowUIElement fromedWindow(String from, int index) {
        return this.selector.window.path("-from", from).find(index);
    }

    @Override
    public WindowUIElement classedWindow(String klass) {
        return this.selector.window.path("-class", klass).find();
    }

    @Override
    public WindowUIElement classedWindow(String klass, int index) {
        return this.selector.window.path("-class", klass).find(index);
    }

    public WindowUIElement eclipseWindow() {
        return this.selector.eclipseWindow.find();
    }

    public WindowUIElement eclipseWindow(int index) {
        return this.selector.eclipseWindow.find(index);
    }

    public List<Response> getFailures() {
        List<Response> oldFailures = this.failures;
        this.failures = new ArrayList<Response>();
        return oldFailures;
    }

    @Override
    public Response safeExecuteCommand(Command command) {
        try {
            Response response = this.executeCommand(command);
            if (response != null && !response.getStatus().equals((Object)ResponseStatus.OK)) {
                this.failures.add(response);
            }
            return response;
        }
        catch (Throwable e) {
            if (e.getMessage() != null && !e.getMessage().contains("socket closed")) {
                TeslaCore.log(e);
            }
            this.handleFailure(e);
            return null;
        }
    }

    protected void handleFailure(Throwable e) {
    }

    public void nop() {
        Nop nop = factory.createNop();
        this.safeExecuteCommand(nop);
        this.clearFailures();
    }

    @Override
    public void shutdown() {
        this.failures.clear();
    }

    public void closeWorkspace() {
        CloseWorkbench closeWorkbench = factory.createCloseWorkbench();
        this.safeExecuteCommand(closeWorkbench);
    }

    public void clearFailures() {
        this.failures.clear();
    }

    static class Selector {
        UISelector<WindowUIElement> window;
        UISelector<WindowUIElement> eclipseWindow;

        Selector() {
        }
    }
}

