/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.network;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.tesla.core.TeslaReplayer;
import org.eclipse.rcptt.tesla.core.TeslaScenarioContainer;
import org.eclipse.rcptt.tesla.core.network.TeslaNetworkPlayer;
import org.eclipse.rcptt.tesla.core.protocol.WaitForRestart;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaMode;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.network.DefaultConnectionMonitor;
import org.eclipse.rcptt.tesla.internal.core.network.IConnectionMonitor;
import org.eclipse.rcptt.tesla.internal.core.network.IProgressInformer;
import org.eclipse.rcptt.tesla.internal.core.network.TeslaNetworkCommunication;

public class TeslaNetworkReplayer
extends TeslaNetworkCommunication {
    private TeslaScenarioContainer container;
    private IProgressInformer informer;
    private IProgressMonitor progressMonitor;

    public TeslaNetworkReplayer(String host, int port, IProgressMonitor progressMonitor, TeslaScenarioContainer container, IProgressInformer informer, IConnectionMonitor connectionMonitor) {
        super(host, port, connectionMonitor);
        this.container = container;
        this.informer = informer;
        this.progressMonitor = progressMonitor;
    }

    public TeslaNetworkReplayer(String host, int port, IProgressMonitor progressMonitor, TeslaScenarioContainer container, IProgressInformer informer) {
        super(host, port);
        this.container = container;
        this.informer = informer;
        this.progressMonitor = progressMonitor;
    }

    @Override
    protected boolean performCommunications() throws IOException {
        this.setMode(TeslaMode.REPLAY, new String[0]);
        final TeslaNetworkPlayer player = new TeslaNetworkPlayer(this.communicationSocket);
        TeslaReplayer replayer = new TeslaReplayer();
        replayer.replayCommands(player, this.container, this.informer, this.progressMonitor, new TeslaReplayer.IReplayPreExecute(){

            @Override
            public boolean preExecute(Command cmd) {
                if (cmd instanceof WaitForRestart) {
                    block12: {
                        while (TeslaNetworkReplayer.this.isConnected() && !TeslaNetworkReplayer.this.progressMonitor.isCanceled()) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            try {
                                player.nop();
                            }
                            catch (Throwable throwable) {}
                        }
                        if (TeslaNetworkReplayer.this.communicationSocket != null) {
                            try {
                                TeslaNetworkReplayer.this.communicationSocket.close();
                            }
                            catch (Throwable throwable) {}
                        }
                        TeslaNetworkReplayer.this.communicationSocket = null;
                        try {
                            TeslaNetworkReplayer.this.doConnect(new DefaultConnectionMonitor());
                            if (TeslaNetworkReplayer.this.communicationSocket != null) {
                                player.updateSocket(TeslaNetworkReplayer.this.communicationSocket);
                                TeslaNetworkReplayer.this.setMode(TeslaMode.REPLAY, new String[0]);
                                break block12;
                            }
                            throw new Exception("Could not establish connection");
                        }
                        catch (Throwable e) {
                            TeslaNetworkReplayer.this.informer.handleError(TeslaNetworkReplayer.this.container, cmd, 0, "Failed to reconnect to AUT after AUT restart", null);
                            TeslaCore.log(e);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        try {
            player.shutdown();
        }
        catch (Throwable throwable) {}
        return true;
    }
}

