/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.UniqueList;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ExpressionSynthesizer;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleHeadAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.AbstractInvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.InvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.NonTopWhenAfterWhereInvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.NonTopWhenOnlyInvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.NonTopWhereBeforeWhenInvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.NonTopWhereOnlyInvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationDirectedScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationDispatchAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationVerdictAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationalTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.TopWhenInvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.TopWhereInvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.DispatchClass2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2DispatchClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2ResultProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.QVTrelationPackage;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomainAssignment;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.TemplateVariable;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.DispatchRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyedValueNode;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationCallNode;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Utility;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.VerdictRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class RelationAnalysis
extends RuleAnalysis {
    private static @NonNull InvocationAnalysisComparator iNVOCATION_ANALYSIS_COMPARATOR = new InvocationAnalysisComparator();
    private final @Nullable RelationDispatchAnalysis dispatchAnalysis;
    private final @Nullable RelationVerdictAnalysis verdictAnalysis;
    private final @NonNull TypedModel targetTypedModel;
    private @Nullable Node thisNode = null;
    private @NonNull Map<@NonNull VariableDeclaration, @NonNull List<@NonNull OCLExpression>> variable2expressions = new HashMap<VariableDeclaration, List<OCLExpression>>();
    private @Nullable Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> incomingWhenInvocation2invocationAnalysis = null;
    private @Nullable Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> incomingWhereInvocation2invocationAnalysis = null;
    private @Nullable Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> outgoingWhenInvocation2invocationAnalysis = null;
    private @Nullable Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> outgoingWhereInvocation2invocationAnalysis = null;
    private @Nullable RelationAnalysis baseRelationAnalysis = null;
    private @Nullable Set<@NonNull VariableDeclaration> realizedOutputVariables = null;
    private @Nullable Set<@NonNull VariableDeclaration> keyedOutputVariables = null;
    private @Nullable Map<@NonNull TemplateVariable, @NonNull TemplateExp> variable2templateExp = null;
    private @Nullable Set<@NonNull VariableDeclaration> topWhenedOutputVariables = null;
    private @Nullable Set<@NonNull VariableDeclaration> nonTopWhenedOutputVariables = null;
    private @Nullable Map<@NonNull Node, @NonNull InvocationAnalysis> invokingNode2invocationAnalysis = null;

    public RelationAnalysis(@NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull TypedModelsConfiguration typedModelsConfiguration, @NonNull RuleRegion ruleRegion) {
        super(transformationAnalysis, ruleRegion);
        this.dispatchAnalysis = this.createDispatchAnalysis(typedModelsConfiguration);
        this.verdictAnalysis = this.createVerdictAnalysis(typedModelsConfiguration);
        this.targetTypedModel = typedModelsConfiguration.getTargetTypedModel();
    }

    protected void addExpression(@NonNull VariableDeclaration variable, @NonNull OCLExpression expression) {
        List<@NonNull OCLExpression> initializers = this.variable2expressions.get(variable);
        if (initializers == null) {
            initializers = new ArrayList<OCLExpression>();
            this.variable2expressions.put(variable, initializers);
        }
        if (!initializers.contains(expression)) {
            initializers.add(expression);
        }
    }

    private void addIncomingInvocationAnalysis(@NonNull RelationCallExp invocation, @NonNull InvocationAnalysis invocationAnalysis) {
        Map<RelationCallExp, InvocationAnalysis> invocationAnalyses;
        boolean isWhen = invocationAnalysis.isWhen();
        Map<RelationCallExp, InvocationAnalysis> map = invocationAnalyses = isWhen ? this.incomingWhenInvocation2invocationAnalysis : this.incomingWhereInvocation2invocationAnalysis;
        assert (invocationAnalyses != null);
        InvocationAnalysis old = invocationAnalyses.put(invocation, invocationAnalysis);
        assert (old == null);
    }

    private void addIncomingWhenInvocation(@NonNull RelationCallExp invocation) {
        Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> incomingWhenInvocation2invocationAnalysis2 = this.incomingWhenInvocation2invocationAnalysis;
        if (incomingWhenInvocation2invocationAnalysis2 == null) {
            this.incomingWhenInvocation2invocationAnalysis = incomingWhenInvocation2invocationAnalysis2 = new HashMap<RelationCallExp, InvocationAnalysis>();
        }
        assert (!incomingWhenInvocation2invocationAnalysis2.containsKey(invocation));
        incomingWhenInvocation2invocationAnalysis2.put(invocation, null);
    }

    private void addIncomingWhereInvocation(@NonNull RelationCallExp invocation) {
        Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> incomingWhereInvocation2invocationAnalysis2 = this.incomingWhereInvocation2invocationAnalysis;
        if (incomingWhereInvocation2invocationAnalysis2 == null) {
            this.incomingWhereInvocation2invocationAnalysis = incomingWhereInvocation2invocationAnalysis2 = new HashMap<RelationCallExp, InvocationAnalysis>();
        }
        assert (!incomingWhereInvocation2invocationAnalysis2.containsKey(invocation));
        incomingWhereInvocation2invocationAnalysis2.put(invocation, null);
    }

    private void addOutgoingInvocationAnalysis(@NonNull RelationCallExp invocation, @NonNull InvocationAnalysis invocationAnalysis) {
        Map<RelationCallExp, InvocationAnalysis> invocationAnalyses;
        boolean isWhen = invocationAnalysis.isWhen();
        Map<RelationCallExp, InvocationAnalysis> map = invocationAnalyses = isWhen ? this.outgoingWhenInvocation2invocationAnalysis : this.outgoingWhereInvocation2invocationAnalysis;
        assert (invocationAnalyses != null);
        InvocationAnalysis old = invocationAnalyses.put(invocation, invocationAnalysis);
        assert (old == null);
    }

    private void addOutgoingWhenInvocation(@NonNull RelationCallExp relationInvocation) {
        Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> outgoingWhenInvocation2invocationAnalysis2 = this.outgoingWhenInvocation2invocationAnalysis;
        if (outgoingWhenInvocation2invocationAnalysis2 == null) {
            outgoingWhenInvocation2invocationAnalysis2 = this.outgoingWhenInvocation2invocationAnalysis = new HashMap<RelationCallExp, InvocationAnalysis>();
        }
        assert (!outgoingWhenInvocation2invocationAnalysis2.containsKey(relationInvocation));
        outgoingWhenInvocation2invocationAnalysis2.put(relationInvocation, null);
    }

    private void addOutgoingWhereInvocation(@NonNull RelationCallExp relationInvocation) {
        Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> outgoingWhereInvocation2invocationAnalysis2 = this.outgoingWhereInvocation2invocationAnalysis;
        if (outgoingWhereInvocation2invocationAnalysis2 == null) {
            outgoingWhereInvocation2invocationAnalysis2 = this.outgoingWhereInvocation2invocationAnalysis = new HashMap<RelationCallExp, InvocationAnalysis>();
        }
        assert (!outgoingWhereInvocation2invocationAnalysis2.containsKey(relationInvocation));
        outgoingWhereInvocation2invocationAnalysis2.put(relationInvocation, null);
    }

    protected void analyzeContainments() {
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (!node.isNew()) continue;
            boolean isContained = false;
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                NavigationEdge navigationEdge;
                Property property;
                Property opposite;
                if (!edge.isNavigation() || (opposite = (property = QVTscheduleUtil.getReferredProperty((NavigationEdge)(navigationEdge = (NavigationEdge)edge))).getOpposite()) == null || !opposite.isIsComposite() || navigationEdge.getEdgeTarget().isNullLiteral()) continue;
                isContained = true;
                break;
            }
            if (!isContained) continue;
            node.setContained(true);
        }
    }

    @Override
    public void analyzeInvocations(@NonNull ProblemHandler problemHandler) {
        for (EObject eObject : new TreeIterable((EObject)this.rule, false)) {
            if (!(eObject instanceof RelationCallExp)) continue;
            RelationCallExp relationInvocation = (RelationCallExp)eObject;
            RelationAnalysis invokedRelationAnalysis = (RelationAnalysis)this.transformationAnalysis.getRuleAnalysis((Rule)QVTrelationUtil.getReferredRelation((RelationCallExp)relationInvocation));
            Pattern pattern = QVTrelationUtil.basicGetContainingPattern((EObject)eObject);
            if (pattern != null && pattern.eContainmentFeature() == QVTrelationPackage.Literals.RELATION__WHERE) {
                invokedRelationAnalysis.addIncomingWhereInvocation(relationInvocation);
                this.addOutgoingWhereInvocation(relationInvocation);
                continue;
            }
            invokedRelationAnalysis.addIncomingWhenInvocation(relationInvocation);
            RelationAnalysis invokedBaseRelationAnalysis = this.getScheduleManager().getRuleAnalysis((Rule)QVTrelationUtil.getBaseRelation((Relation)((Relation)this.rule)));
            if (invokedBaseRelationAnalysis != invokedRelationAnalysis) {
                invokedBaseRelationAnalysis.addIncomingWhenInvocation(relationInvocation);
            }
            this.addOutgoingWhenInvocation(relationInvocation);
        }
    }

    protected void analyzeKeyedOutputVariables(@NonNull RelationDomain relationDomain, @NonNull Set<@NonNull VariableDeclaration> keyedOutputVariables) {
        RelationalTransformationAnalysis transformationAnalysis2 = this.getTransformationAnalysis();
        Set<@NonNull VariableDeclaration> whenedOutputVariables = this.getTopWhenedOutputVariables();
        for (DomainPattern domainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)relationDomain)) {
            TemplateExp templateExpression = QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)domainPattern);
            for (EObject eObject : new TreeIterable((EObject)templateExpression, true)) {
                Key key;
                TemplateExp templateExp;
                TemplateVariable templateVariable;
                if (!(eObject instanceof TemplateExp) || whenedOutputVariables.contains(templateVariable = (TemplateVariable)QVTrelationUtil.getBindsTo((TemplateExp)(templateExp = (TemplateExp)eObject))) || (key = transformationAnalysis2.getKeyForType(QVTrelationUtil.getType((TypedElement)templateVariable))) == null) continue;
                keyedOutputVariables.add((VariableDeclaration)templateVariable);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void analyzeMappingRegion() {
        this.rewriteCastEdges();
        Relation relation = this.getRule();
        boolean hasOverrides = QVTrelationUtil.hasOverrides((Relation)relation);
        Relation baseRelation = QVTrelationUtil.getBaseRelation((Relation)relation);
        boolean isTop = relation.isIsTopLevel();
        @NonNull Iterable tracedHeadNodes = QVTscheduleUtil.getHeadNodes((Region)this.region);
        ArrayList<@NonNull Node> preferredHeadNodes = new ArrayList<Node>();
        if (!Iterables.isEmpty((Iterable)tracedHeadNodes) && (!isTop || hasOverrides && baseRelation != relation)) {
            for (Node headNode : tracedHeadNodes) {
                Element originatingElement = headNode.getOriginatingElement();
                if (this.scheduleManager.isOutputInRule((Rule)relation, originatingElement)) continue;
                preferredHeadNodes.add(headNode);
            }
        } else {
            for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)relation)) {
                if (!this.getScheduleManager().isInputInRule((Rule)relation, (Element)relationDomain)) continue;
                for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((RelationDomain)relationDomain)) {
                    Node rootNode = ((RuleRegion)this.region).getNode((TypedElement)rootVariable);
                    if (rootNode == null) continue;
                    preferredHeadNodes.add(rootNode);
                }
            }
        }
        assert (this.baseRelationAnalysis != null);
        Iterable<@NonNull Node> headNodes = this.baseRelationAnalysis != this ? preferredHeadNodes : RuleHeadAnalysis.computeRuleHeadNodes(this.scheduleManager, (MappingRegion)this.region, preferredHeadNodes);
        @NonNull List headNodesList = QVTscheduleUtil.Internal.getHeadNodesList((Region)this.region);
        headNodesList.clear();
        Iterables.addAll((Collection)headNodesList, headNodes);
        this.analyzeStrictness();
    }

    @Override
    public void analyzeOverrides(@NonNull ProblemHandler problemHandler) {
        Relation relation = this.getRule();
        this.baseRelationAnalysis = this.getScheduleManager().getRuleAnalysis((Rule)QVTrelationUtil.getBaseRelation((Relation)relation));
        for (TypedModel typedModel : this.getScheduleManager().getTypedModelsConfiguration().getOutputOnlyTypedModels()) {
            Domain domain = QVTrelationUtil.basicGetDomain((Rule)relation, (TypedModel)typedModel);
            if (domain == null || !domain.isNotOutput()) continue;
            CompilerUtil.addRuleError(problemHandler, (Rule)relation, "domain ''{0}'' cannot be an output", typedModel.getName());
        }
    }

    protected void analyzeRealizedOutputVariables(@NonNull RelationDomain relationDomain, @NonNull Set<@NonNull VariableDeclaration> realizedOutputVariables) {
        for (DomainPattern domainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)relationDomain)) {
            TemplateExp templateExpression = QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)domainPattern);
            boolean isTopLevel = ((Relation)this.rule).isIsTopLevel();
            boolean hasWhenInvocations = this.hasIncomingWhenInvocations();
            boolean rootIsRealized = isTopLevel || hasWhenInvocations;
            for (EObject eObject : new TreeIterable((EObject)templateExpression, rootIsRealized)) {
                if (eObject instanceof ObjectTemplateExp) {
                    ObjectTemplateExp templateExp = (ObjectTemplateExp)eObject;
                    TemplateVariable templateVariable = (TemplateVariable)QVTrelationUtil.getBindsTo((TemplateExp)templateExp);
                    realizedOutputVariables.add((VariableDeclaration)templateVariable);
                    continue;
                }
                boolean cfr_ignored_0 = eObject instanceof CollectionTemplateExp;
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void analyzeStrictness() {
        ArrayList<InvocationAnalysis> invocationAnalyses;
        ArrayList<@NonNull InvocationAnalysis> outgoingInvocationAnalyses = null;
        if (this.outgoingWhenInvocation2invocationAnalysis != null) {
            invocationAnalyses = new ArrayList<InvocationAnalysis>(this.outgoingWhenInvocation2invocationAnalysis.values());
            Collections.sort(invocationAnalyses, iNVOCATION_ANALYSIS_COMPARATOR);
            for (InvocationAnalysis invocationAnalysis : invocationAnalyses) {
                assert (invocationAnalysis != null);
                if (invocationAnalysis.isTop() || !invocationAnalysis.isRealized()) continue;
                if (outgoingInvocationAnalyses == null) {
                    outgoingInvocationAnalyses = new ArrayList<InvocationAnalysis>();
                }
                outgoingInvocationAnalyses.add(invocationAnalysis);
            }
        }
        if (this.outgoingWhereInvocation2invocationAnalysis != null) {
            invocationAnalyses = new ArrayList<InvocationAnalysis>(this.outgoingWhereInvocation2invocationAnalysis.values());
            Collections.sort(invocationAnalyses, iNVOCATION_ANALYSIS_COMPARATOR);
            for (InvocationAnalysis invocationAnalysis : invocationAnalyses) {
                assert (invocationAnalysis != null);
                if (invocationAnalysis.isTop() || !invocationAnalysis.isRealized()) continue;
                if (outgoingInvocationAnalyses == null) {
                    outgoingInvocationAnalyses = new ArrayList();
                }
                outgoingInvocationAnalyses.add(invocationAnalysis);
            }
        }
        if (outgoingInvocationAnalyses != null) {
            ReachabilityForest reachabilityForest = null;
            block2: for (InvocationAnalysis invocationAnalysis : outgoingInvocationAnalyses) {
                int incomingWhereInvocationCount;
                RelationAnalysis invokedRelationAnalysis = invocationAnalysis.getInvokedRelationAnalysis();
                int incomingWhenInvocationCount = invokedRelationAnalysis.getIncomingWhenInvocationCount();
                int incomingWhenInvocationAnalysisCount = incomingWhenInvocationCount + (incomingWhereInvocationCount = invokedRelationAnalysis.getIncomingWhereInvocationCount());
                if (incomingWhenInvocationAnalysisCount > 1) {
                    invocationAnalysis.setStrict(true);
                    break;
                }
                for (Node argumentNode : invocationAnalysis.getArgumentNodes()) {
                    Integer cost;
                    if (argumentNode.isDataType()) {
                        invocationAnalysis.setStrict(true);
                        continue block2;
                    }
                    if (reachabilityForest == null) {
                        @NonNull Iterable rootNodes = QVTscheduleUtil.getHeadNodes((Region)this.region);
                        ArrayList<@NonNull NavigationEdge> navigableEdges = new ArrayList<NavigationEdge>();
                        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
                            Property oppositeProperty;
                            NavigationEdge navigationEdge;
                            Property property;
                            if (!edge.isNavigation() || (property = QVTscheduleUtil.getReferredProperty((NavigationEdge)(navigationEdge = (NavigationEdge)edge))).isIsMany() || (oppositeProperty = property.getOpposite()) == null || oppositeProperty.isIsMany()) continue;
                            navigableEdges.add(navigationEdge);
                        }
                        reachabilityForest = new ReachabilityForest(null, rootNodes, navigableEdges);
                    }
                    if ((cost = reachabilityForest.basicGetCost(argumentNode)) != null) continue;
                    invocationAnalysis.setStrict(true);
                    continue block2;
                }
            }
        }
    }

    @Override
    public void analyzeSourceModel(@NonNull ProblemHandler problemHandler) {
        QVTrelationDirectedScheduleManager scheduleManager = this.getScheduleManager();
        Relation relation = this.getRule();
        this.variable2templateExp = this.analyzeVariable2TemplateExp();
        this.topWhenedOutputVariables = new HashSet<VariableDeclaration>();
        HashSet<@NonNull VariableDeclaration> topWhenedOutputVariables2 = this.topWhenedOutputVariables;
        this.nonTopWhenedOutputVariables = new HashSet<VariableDeclaration>();
        HashSet<@NonNull VariableDeclaration> nonTopWhenedOutputVariables2 = this.nonTopWhenedOutputVariables;
        this.analyzeWhenedOutputVariables(topWhenedOutputVariables2, nonTopWhenedOutputVariables2);
        this.keyedOutputVariables = new HashSet<VariableDeclaration>();
        HashSet<@NonNull VariableDeclaration> keyedOutputVariables = this.keyedOutputVariables;
        this.realizedOutputVariables = new HashSet<VariableDeclaration>();
        HashSet<@NonNull VariableDeclaration> realizedOutputVariables = this.realizedOutputVariables;
        for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)relation)) {
            if (!scheduleManager.isOutputInRule((Rule)relation, (Element)relationDomain)) continue;
            this.analyzeKeyedOutputVariables(relationDomain, keyedOutputVariables);
            this.analyzeRealizedOutputVariables(relationDomain, realizedOutputVariables);
        }
    }

    protected @NonNull Map<@NonNull TemplateVariable, @NonNull TemplateExp> analyzeVariable2TemplateExp() {
        Relation relation = this.getRule();
        HashMap<@NonNull TemplateVariable, @NonNull TemplateExp> variable2templateExp = new HashMap<TemplateVariable, TemplateExp>();
        for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)relation)) {
            for (DomainPattern domainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)relationDomain)) {
                for (EObject eObject : new TreeIterable((EObject)domainPattern, true)) {
                    if (!(eObject instanceof TemplateExp)) continue;
                    TemplateExp templateExp = (TemplateExp)eObject;
                    TemplateVariable templateVariable = (TemplateVariable)QVTrelationUtil.getBindsTo((TemplateExp)templateExp);
                    TemplateExp oldTemplateExp = variable2templateExp.put(templateVariable, templateExp);
                    assert (oldTemplateExp == null);
                }
            }
        }
        return variable2templateExp;
    }

    protected void analyzeWhenedOutputVariables(@NonNull Set<@NonNull VariableDeclaration> topWhenedOutputVariables, @NonNull Set<@NonNull VariableDeclaration> nonTopWhenedOutputVariables) {
        QVTrelationDirectedScheduleManager scheduleManager = this.getScheduleManager();
        Relation relation = this.getRule();
        Pattern whenPattern = relation.getWhen();
        if (whenPattern != null) {
            for (Predicate whenPredicate : QVTrelationUtil.getOwnedPredicates((Pattern)whenPattern)) {
                for (EObject eObject : new TreeIterable((EObject)QVTrelationUtil.getOwnedConditionExpression((Predicate)whenPredicate), true)) {
                    VariableExp variableExp;
                    EObject eContainer;
                    if (!(eObject instanceof VariableExp) || !((eContainer = (variableExp = (VariableExp)eObject).eContainer()) instanceof RelationCallExp)) continue;
                    RelationCallExp invocation = (RelationCallExp)eContainer;
                    int argumentIndex = invocation.getArgument().indexOf((Object)variableExp);
                    assert (argumentIndex >= 0);
                    RelationDomain domain = QVTrelationUtil.getRelationCallExpArgumentDomain((RelationCallExp)invocation, (int)argumentIndex);
                    if (!scheduleManager.isOutputInRule((Rule)QVTrelationUtil.getReferredRelation((RelationCallExp)invocation), (Element)domain)) continue;
                    if (invocation.getReferredRelation().isIsTopLevel()) {
                        topWhenedOutputVariables.add(QVTrelationUtil.getReferredVariable((VariableExp)variableExp));
                        continue;
                    }
                    nonTopWhenedOutputVariables.add(QVTrelationUtil.getReferredVariable((VariableExp)variableExp));
                }
            }
        }
    }

    public @Nullable Iterable<@Nullable InvocationAnalysis> basicGetOutgoingWhenInvocationAnalyses() {
        return this.outgoingWhenInvocation2invocationAnalysis != null ? this.outgoingWhenInvocation2invocationAnalysis.values() : null;
    }

    public @Nullable Iterable<@Nullable InvocationAnalysis> basicGetOutgoingWhereInvocationAnalyses() {
        return this.outgoingWhereInvocation2invocationAnalysis != null ? this.outgoingWhereInvocation2invocationAnalysis.values() : null;
    }

    @Override
    public @Nullable Relation2TraceGroup basicGetRule2TraceGroup() {
        return (Relation2TraceGroup)super.basicGetRule2TraceGroup();
    }

    protected @Nullable TemplateExp basicGetTemplateExp(@NonNull VariableDeclaration variable) {
        return (TemplateExp)((Map)ClassUtil.nonNullState(this.variable2templateExp)).get(variable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Set<@NonNull Node> computeTraceAndTraceComputationNodes() {
        @NonNull UniqueList traceAndTraceComputationNodes = new UniqueList();
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (node.getClassDatum().getReferredTypedModel().isIsTrace()) {
                traceAndTraceComputationNodes.add(node);
                for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                    Node targetNode;
                    if (!outgoingEdge.isSuccess() || !traceAndTraceComputationNodes.add(targetNode = QVTscheduleUtil.getTargetNode((Edge)outgoingEdge))) continue;
                    this.computeTraceAndTraceComputationNodes((Set<Node>)traceAndTraceComputationNodes, targetNode);
                }
            }
            if (!node.isSuccess() || !traceAndTraceComputationNodes.add(node)) continue;
            this.computeTraceAndTraceComputationNodes((Set<Node>)traceAndTraceComputationNodes, node);
        }
        return traceAndTraceComputationNodes;
    }

    private void computeTraceAndTraceComputationNodes(@NonNull Set<@NonNull Node> traceAndTraceComputationNodes, @NonNull Node node) {
        for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
            Node targetNode;
            if (!outgoingEdge.isComputation() || !traceAndTraceComputationNodes.add(targetNode = QVTscheduleUtil.getTargetNode((Edge)outgoingEdge))) continue;
            this.computeTraceAndTraceComputationNodes(traceAndTraceComputationNodes, targetNode);
        }
        for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            Node sourceNode;
            if (!incomingEdge.isComputation() || !traceAndTraceComputationNodes.add(sourceNode = QVTscheduleUtil.getTargetNode((Edge)incomingEdge))) continue;
            this.computeTraceAndTraceComputationNodes(traceAndTraceComputationNodes, sourceNode);
        }
    }

    protected @Nullable RelationDispatchAnalysis createDispatchAnalysis(@NonNull TypedModelsConfiguration typedModelsConfiguration) {
        Relation relation = this.getRule();
        if (!QVTrelationUtil.hasOverrides((Relation)relation)) {
            return null;
        }
        if (QVTrelationUtil.getBaseRelation((Relation)relation) != relation) {
            return null;
        }
        DispatchRegion dispatchRegion = QVTscheduleFactory.eINSTANCE.createDispatchRegion();
        dispatchRegion.setOwningScheduleModel(this.scheduleManager.getScheduleModel());
        dispatchRegion.setReferredRule((Rule)relation);
        dispatchRegion.setReferredRuleRegion((RuleRegion)this.getRegion());
        dispatchRegion.setName(this.getNameGenerator().createMappingName(relation, "dispatch", typedModelsConfiguration));
        return new RelationDispatchAnalysis(this, dispatchRegion);
    }

    protected @NonNull InvocationAnalysis createOutgoingInvocationAnalysis(@NonNull RelationAnalysis invokedRelationAnalysis, @NonNull RelationCallExp relationCallExp, boolean isWhen, @NonNull Utility utility, @NonNull Map<@NonNull VariableDeclaration, @NonNull Node> rootVariable2argumentNode) {
        AbstractInvocationAnalysis invocationAnalysis;
        RelationAnalysis invokedBaseRelationAnalysis = invokedRelationAnalysis.getBaseRelationAnalysis();
        if (invokedBaseRelationAnalysis.getRule().isIsTopLevel()) {
            invocationAnalysis = isWhen ? new TopWhenInvocationAnalysis(this, invokedRelationAnalysis, utility, rootVariable2argumentNode) : new TopWhereInvocationAnalysis(this, invokedRelationAnalysis, utility, rootVariable2argumentNode);
        } else {
            boolean hasWhenAndWhereInvocations;
            boolean hasWhenInvocations = invokedRelationAnalysis.hasIncomingWhenInvocations();
            boolean hasWhereInvocations = invokedRelationAnalysis.hasIncomingWhereInvocations();
            boolean bl = hasWhenAndWhereInvocations = hasWhenInvocations && hasWhereInvocations;
            invocationAnalysis = isWhen ? (hasWhenAndWhereInvocations ? new NonTopWhenAfterWhereInvocationAnalysis(this, invokedRelationAnalysis, utility, rootVariable2argumentNode) : new NonTopWhenOnlyInvocationAnalysis(this, invokedRelationAnalysis, utility, rootVariable2argumentNode)) : (hasWhenAndWhereInvocations ? new NonTopWhereBeforeWhenInvocationAnalysis(this, invokedRelationAnalysis, utility.getNullableUtility(), rootVariable2argumentNode) : new NonTopWhereOnlyInvocationAnalysis(this, invokedRelationAnalysis, utility.getNullableUtility(), rootVariable2argumentNode));
        }
        this.addOutgoingInvocationAnalysis(relationCallExp, invocationAnalysis);
        invokedRelationAnalysis.addIncomingInvocationAnalysis(relationCallExp, invocationAnalysis);
        if (invokedBaseRelationAnalysis != invokedRelationAnalysis) {
            invokedBaseRelationAnalysis.addIncomingInvocationAnalysis(relationCallExp, invocationAnalysis);
        }
        return invocationAnalysis;
    }

    protected @Nullable RelationVerdictAnalysis createVerdictAnalysis(@NonNull TypedModelsConfiguration typedModelsConfiguration) {
        Relation relation = this.getRule();
        if (!QVTrelationUtil.hasOverrides((Relation)relation)) {
            return null;
        }
        if (QVTrelationUtil.getBaseRelation((Relation)relation) != relation) {
            return null;
        }
        VerdictRegion verdictRegion = QVTscheduleFactory.eINSTANCE.createVerdictRegion();
        verdictRegion.setOwningScheduleModel(this.scheduleManager.getScheduleModel());
        verdictRegion.setReferredRule((Rule)relation);
        verdictRegion.setReferredRuleRegion((RuleRegion)this.getRegion());
        verdictRegion.setName(this.getNameGenerator().createMappingName(relation, "verdict", typedModelsConfiguration));
        return new RelationVerdictAnalysis(this, verdictRegion);
    }

    @Override
    public void gatherRuleRegions(@NonNull List<@NonNull RuleRegion> ruleRegions) {
        super.gatherRuleRegions(ruleRegions);
        if (this.dispatchAnalysis != null) {
            this.dispatchAnalysis.gatherRuleRegions(ruleRegions);
        }
        if (this.verdictAnalysis != null) {
            this.verdictAnalysis.gatherRuleRegions(ruleRegions);
        }
    }

    private @NonNull RelationAnalysis getBaseRelationAnalysis() {
        return (RelationAnalysis)((Object)ClassUtil.nonNullState((Object)((Object)this.baseRelationAnalysis)));
    }

    public int getIncomingWhenInvocationCount() {
        return this.incomingWhenInvocation2invocationAnalysis != null ? this.incomingWhenInvocation2invocationAnalysis.size() : 0;
    }

    public int getIncomingWhereInvocationCount() {
        return this.incomingWhereInvocation2invocationAnalysis != null ? this.incomingWhereInvocation2invocationAnalysis.size() : 0;
    }

    @Override
    public @NonNull InvocationAnalysis getInvocationAnalysis(@NonNull Node invokingNode) {
        assert (this.invokingNode2invocationAnalysis != null);
        return (InvocationAnalysis)ClassUtil.nonNullState((Object)this.invokingNode2invocationAnalysis.get(invokingNode));
    }

    protected @NonNull Set<@NonNull VariableDeclaration> getKeyedOutputVariables() {
        return (Set)ClassUtil.nonNullState(this.keyedOutputVariables);
    }

    @Override
    public @NonNull QVTrelationNameGenerator getNameGenerator() {
        return (QVTrelationNameGenerator)super.getNameGenerator();
    }

    private @NonNull Utility getOptionalMatchAtRootUtility(@NonNull VariableDeclaration variableDeclaration) {
        boolean anyRequired = false;
        boolean isRootVariable = false;
        for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((Relation)this.getRule())) {
            if (rootVariable == variableDeclaration) {
                isRootVariable = true;
            }
            if (!rootVariable.isIsRequired()) continue;
            anyRequired = true;
        }
        if (!isRootVariable) {
            return Utility.getRequiredUtility((TypedElement)variableDeclaration);
        }
        if (anyRequired) {
            return Utility.getRequiredUtility((TypedElement)variableDeclaration);
        }
        return Utility.NON_NULL_MATCHED;
    }

    public @NonNull InvocationAnalysis getOutgoingInvocationAnalysis(@NonNull RelationAnalysis invokedRelationAnalysis, @NonNull RelationCallExp invocation, boolean isWhen, @NonNull Utility utility, @NonNull Map<@NonNull VariableDeclaration, @NonNull Node> rootVariable2argumentNode) {
        InvocationAnalysis invocationAnalysis;
        Map<RelationCallExp, InvocationAnalysis> outgoingInvocationAnalyses;
        Map<RelationCallExp, InvocationAnalysis> map = outgoingInvocationAnalyses = isWhen ? this.outgoingWhenInvocation2invocationAnalysis : this.outgoingWhereInvocation2invocationAnalysis;
        if (outgoingInvocationAnalyses != null && (invocationAnalysis = outgoingInvocationAnalyses.get(invocation)) != null) {
            return invocationAnalysis;
        }
        return this.createOutgoingInvocationAnalysis(invokedRelationAnalysis, invocation, isWhen, utility, rootVariable2argumentNode);
    }

    protected @NonNull Set<@NonNull VariableDeclaration> getRealizedOutputVariables() {
        return (Set)ClassUtil.nonNullState(this.realizedOutputVariables);
    }

    @Override
    public @NonNull Node getReferenceNode(@NonNull VariableDeclaration variableDeclaration) {
        Node node = ((RuleRegion)this.region).getNode((TypedElement)variableDeclaration);
        if (node == null) {
            if (variableDeclaration instanceof SharedVariable) {
                node = this.getReferenceNodeForSharedVariable((SharedVariable)variableDeclaration, null);
            }
            if (node == null && (node = this.createOldNode(Utility.getRequiredUtility((TypedElement)variableDeclaration), variableDeclaration)).isThis()) {
                this.setThisNode(node);
            }
        }
        assert (node != null) : "No variable2simpleNode entry for " + variableDeclaration;
        assert (node == ((RuleRegion)this.region).getNode((TypedElement)variableDeclaration));
        return node;
    }

    private @Nullable Node getReferenceNodeForSharedVariable(@NonNull SharedVariable variable, @Nullable OCLExpression predicatedInit) {
        ClassDatum variableClassDatum;
        OCLExpression bestInitExpression = variable.getOwnedInit();
        if (bestInitExpression == null) {
            if (predicatedInit != null) {
                bestInitExpression = predicatedInit;
            } else {
                return null;
            }
        }
        ExpressionSynthesizer expressionSynthesizer2 = this.rootExpressionSynthesizer.getRequiredExpressionSynthesizer(variable.isIsRequired());
        Node bestInitNode = (Node)bestInitExpression.accept((Visitor)expressionSynthesizer2);
        assert (bestInitNode != null);
        if (variable.isIsRequired()) assert (bestInitNode.isRequired());
        ClassDatum initClassDatum = QVTscheduleUtil.getClassDatum((Node)bestInitNode);
        if (!QVTscheduleUtil.conformsTo((ClassDatum)initClassDatum, (ClassDatum)(variableClassDatum = this.scheduleManager.getClassDatum((TypedElement)variable)))) {
            VariableNode castNode = this.createOldNode(Utility.getRequiredUtility((TypedElement)variable), (VariableDeclaration)variable);
            expressionSynthesizer2.createCastEdge(bestInitNode, variableClassDatum, (Node)castNode);
            bestInitNode = castNode;
        }
        bestInitNode.setOriginatingVariable((VariableDeclaration)variable);
        ((RuleRegion)this.region).addVariableNode((VariableDeclaration)variable, bestInitNode);
        return bestInitNode;
    }

    public @NonNull Relation getRule() {
        return (Relation)super.getRule();
    }

    @Override
    public @NonNull Relation2TraceGroup getRule2TraceGroup() {
        return (Relation2TraceGroup)super.getRule2TraceGroup();
    }

    @Override
    public @NonNull QVTrelationDirectedScheduleManager getScheduleManager() {
        return (QVTrelationDirectedScheduleManager)this.scheduleManager;
    }

    public @NonNull TypedModel getTargetTypedModel() {
        return this.targetTypedModel;
    }

    public @NonNull TypedModel getTraceTypedModel() {
        return this.scheduleManager.getTraceTypedModel();
    }

    @Override
    public @NonNull RelationalTransformationAnalysis getTransformationAnalysis() {
        return (RelationalTransformationAnalysis)this.transformationAnalysis;
    }

    @Override
    public @NonNull RelationalTransformation2TracePackage getTransformation2TracePackage() {
        return (RelationalTransformation2TracePackage)super.getTransformation2TracePackage();
    }

    protected @NonNull Set<@NonNull VariableDeclaration> getNonTopWhenedOutputVariables() {
        return (Set)ClassUtil.nonNullState(this.nonTopWhenedOutputVariables);
    }

    protected @NonNull Set<@NonNull VariableDeclaration> getTopWhenedOutputVariables() {
        return (Set)ClassUtil.nonNullState(this.topWhenedOutputVariables);
    }

    public boolean hasIncomingWhenInvocations() {
        assert (this.baseRelationAnalysis != null);
        if (this.baseRelationAnalysis != this) {
            return this.baseRelationAnalysis.hasIncomingWhenInvocations();
        }
        return this.incomingWhenInvocation2invocationAnalysis != null && !this.incomingWhenInvocation2invocationAnalysis.isEmpty();
    }

    public boolean hasIncomingWhereInvocations() {
        assert (this.baseRelationAnalysis != null);
        if (this.baseRelationAnalysis != this) {
            return this.baseRelationAnalysis.hasIncomingWhereInvocations();
        }
        return this.incomingWhereInvocation2invocationAnalysis != null && !this.incomingWhereInvocation2invocationAnalysis.isEmpty();
    }

    public boolean isKeyedRealization(@NonNull VariableDeclaration variableDeclaration) {
        return this.getKeyedOutputVariables().contains(variableDeclaration);
    }

    @Override
    public boolean isPropertyAssignment(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        return false;
    }

    private void setThisNode(@NonNull Node node) {
        assert (this.thisNode == null);
        this.thisNode = node;
    }

    public void synthesizeCollectionTemplate(@NonNull CollectionTemplateExp collectionTemplateExp) {
        boolean isOutput = this.scheduleManager.isOutputInRule(QVTrelationUtil.getContainingRule((EObject)collectionTemplateExp), (Element)collectionTemplateExp);
        if (isOutput) {
            this.synthesizeOutputCollectionTemplate(collectionTemplateExp);
        } else if (!this.synthesizeSingleInputCollectionTemplate(collectionTemplateExp)) {
            this.synthesizeMultipleInputCollectionTemplate(collectionTemplateExp);
        }
    }

    public void synthesizeDefaultValue(@NonNull RelationDomainAssignment relationDomainAssignment) {
        VariableDeclaration variable = QVTrelationUtil.getVariable((RelationDomainAssignment)relationDomainAssignment);
        OCLExpression valueExp = QVTrelationUtil.getValueExp((RelationDomainAssignment)relationDomainAssignment);
        Node variableNode = ((RuleRegion)this.region).getNode((TypedElement)variable);
        if (variableNode != null) {
            CompilerUtil.addRegionWarning(this.getProblemHandler(), this.region, "Conflicting default assignment " + relationDomainAssignment, new Object[0]);
        } else if (!(variable instanceof SharedVariable)) {
            CompilerUtil.addRegionError(this.getProblemHandler(), this.region, "Non-SharedVariable for " + relationDomainAssignment, new Object[0]);
        } else if (variable instanceof Variable && ((Variable)variable).getOwnedInit() != null) {
            CompilerUtil.addRegionError(this.getProblemHandler(), this.region, "Default assignment for initialized variable: " + relationDomainAssignment, new Object[0]);
        } else {
            variableNode = this.getReferenceNodeForSharedVariable((SharedVariable)variable, valueExp);
        }
    }

    protected @NonNull Node synthesizeDispatchNode(@NonNull Node traceNode) {
        Relation relation = this.getRule();
        Relation2DispatchClass relation2dispatchClass = this.getRule2TraceGroup().getBaseRelation2TraceGroup().getRule2DispatchClass();
        ClassDatum classDatum = this.scheduleManager.getClassDatum(this.getTraceTypedModel(), (Type)relation2dispatchClass.getMiddleClass());
        Node dispatchNode = this.createPredicatedNode(Utility.DISPATCH, "dispatcher", classDatum);
        Property doProperty = relation2dispatchClass.getDispatchClass2TraceProperty(relation).getTraceProperty();
        this.createNavigationEdge(Utility.NON_NULL_MATCHED, dispatchNode, doProperty, traceNode, false);
        Property resultProperty = relation2dispatchClass.getResultProperty();
        this.createRealizedNavigationEdge(Utility.NON_NULL_MATCHED, dispatchNode, resultProperty, traceNode, false);
        Property dispatchSuccessProperty = relation2dispatchClass.getDispatchSuccessProperty();
        this.createRealizedSuccess(Utility.NON_NULL_MATCHED, dispatchNode, dispatchSuccessProperty, true);
        Node headNode = traceNode.isPredicated() ? traceNode : dispatchNode;
        ((RuleRegion)this.region).getHeadNodes().clear();
        ((RuleRegion)this.region).getHeadNodes().add(headNode);
        headNode.setHead();
        if (this.thisNode != null) {
            ((RuleRegion)this.region).getHeadNodes().add(this.thisNode);
        }
        return dispatchNode;
    }

    protected boolean synthesizeEqualsPredicate(@NonNull OCLExpression predicateExpression) {
        if (!(predicateExpression instanceof OperationCallExp)) {
            return false;
        }
        OperationCallExp operationCallExp = (OperationCallExp)predicateExpression;
        Operation operation = QVTrelationUtil.getReferredOperation((CallExp)operationCallExp);
        OperationId oclAnyEqualsId = this.scheduleManager.getStandardLibraryHelper().getOclAnyEqualsId();
        if (!PivotUtil.isSameOperation((OperationId)operation.getOperationId(), (OperationId)oclAnyEqualsId)) {
            return false;
        }
        OCLExpression leftExpression = QVTrelationUtil.getOwnedSource((CallExp)operationCallExp);
        OCLExpression rightExpression = QVTrelationUtil.getOwnedArgument((OperationCallExp)operationCallExp, (int)0);
        if (leftExpression instanceof VariableExp) {
            VariableDeclaration leftVariable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)leftExpression));
            return this.synthesizeVariableEqualsPredicate(leftVariable, rightExpression);
        }
        if (rightExpression instanceof VariableExp) {
            VariableDeclaration rightVariable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)rightExpression));
            return this.synthesizeVariableEqualsPredicate(rightVariable, leftExpression);
        }
        if (leftExpression instanceof NavigationCallExp) {
            return this.synthesizeNavigationCallEqualsPredicate((NavigationCallExp)leftExpression, rightExpression);
        }
        if (rightExpression instanceof NavigationCallExp) {
            return this.synthesizeNavigationCallEqualsPredicate((NavigationCallExp)rightExpression, leftExpression);
        }
        return false;
    }

    protected void synthesizeIncomingNonTopInvocation(@NonNull Node traceNode) {
        Relation relation = this.getRule();
        if (!relation.isIsTopLevel()) {
            if (QVTrelationUtil.hasOverrides((Relation)relation)) {
                Relation baseRelation = QVTrelationUtil.getBaseRelation((Relation)relation);
                Relation2TraceGroup baseRelation2traceGroup = this.getRule2TraceGroup().getBaseRelation2TraceGroup();
                Relation2MiddleType baseRelation2invocationInterface = baseRelation2traceGroup.getRule2InvocationInterface();
                Class baseInvocationClass = baseRelation2invocationInterface.getMiddleClass();
                ClassDatum classDatum = this.scheduleManager.getClassDatum(this.scheduleManager.getTraceTypedModel(), (Type)baseInvocationClass);
                Node invocationNode = this.createPredicatedNode(Utility.NON_NULL_MATCHED, "dispatcher", classDatum);
                ((RuleRegion)this.region).getHeadNodes().add(invocationNode);
                invocationNode.setHead();
                Relation2ResultProperty relation2resultProperty = baseRelation2invocationInterface.basicGetRelation2ResultProperty();
                if (relation2resultProperty != null) {
                    Property resultProperty = relation2resultProperty.getTraceProperty();
                    this.rootExpressionSynthesizer.createRealizedNavigationEdge(invocationNode, resultProperty, traceNode, false);
                }
                for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((Relation)relation)) {
                    Node rootNode = ((RuleRegion)this.region).getNode((TypedElement)rootVariable);
                    assert (rootNode != null);
                    VariableDeclaration baseRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)baseRelation, (VariableDeclaration)rootVariable);
                    Property traceProperty = baseRelation2invocationInterface.getTraceProperty(baseRootVariable);
                    this.rootExpressionSynthesizer.createNavigationEdge(invocationNode, traceProperty, rootNode, false);
                }
            } else {
                ((RuleRegion)this.region).getHeadNodes().add(traceNode);
            }
        }
    }

    protected void synthesizeInterfaceAssignments(@NonNull Relation2TraceGroup relation2traceGroup, @NonNull Node traceNode) {
    }

    public OCLExpression synthesizeKeyTemplate(@NonNull VariableDeclaration templateVariable, @NonNull Map<@NonNull Property, @NonNull Node> property2node) {
        Node keyNode = ((RuleRegion)this.region).getNode((TypedElement)templateVariable);
        assert (keyNode != null);
        ClassDatum classDatum = ((KeyedValueNode)keyNode).getClassDatumValue();
        assert (classDatum != null);
        for (Property property : property2node.keySet()) {
            Node node = property2node.get(property);
            assert (node != null);
            PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(classDatum, property, node.getClassDatum());
            this.createKeyPartEdge(keyNode.getUtility(), node, propertyDatum, keyNode);
        }
        return null;
    }

    public @NonNull Node synthesizeKeyTemplatePart(@NonNull PropertyTemplateItem propertyTemplateItem) {
        OCLExpression targetExpression = QVTrelationUtil.getOwnedValue((PropertyTemplateItem)propertyTemplateItem);
        Node partNode = (Node)targetExpression.accept((Visitor)this.rootExpressionSynthesizer);
        assert (partNode != null);
        return partNode;
    }

    protected void synthesizeMultipleInputCollectionTemplate(@NonNull CollectionTemplateExp collectionTemplateExp) {
        Node residueNode = (Node)collectionTemplateExp.accept((Visitor)this.rootExpressionSynthesizer);
        assert (residueNode != null);
        Operation collectionExcludingOperation = this.scheduleManager.getStandardLibraryHelper().getCollectionExcludingOperation();
        Node memberNode = null;
        for (OCLExpression member : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)collectionTemplateExp)) {
            if (memberNode != null) {
                Node selfNode = residueNode;
                assert (selfNode != null);
                residueNode = this.createOperationCallNode(Utility.NON_NULL_MATCHED, null, collectionExcludingOperation, (TypedElement)collectionTemplateExp, residueNode, memberNode);
                this.createOperationSelfEdge(selfNode.getUtility(), selfNode, QVTrelationUtil.getType((TypedElement)collectionExcludingOperation), residueNode);
                this.createOperationParameterEdge(memberNode.getUtility(), memberNode, QVTrelationUtil.getOwnedParameter((Operation)collectionExcludingOperation, (int)0), -1, residueNode);
            }
            memberNode = (Node)member.accept((Visitor)this.rootExpressionSynthesizer);
            assert (memberNode != null);
            this.createPredicateEdge(Utility.NON_NULL_MATCHED, residueNode, memberNode, true);
        }
        Variable rest = collectionTemplateExp.getRest();
        if (rest != null && !rest.isIsImplicit()) {
            if (memberNode != null) {
                Node selfNode = residueNode;
                assert (selfNode != null);
                residueNode = this.createOperationCallNode(Utility.NON_NULL_MATCHED, null, collectionExcludingOperation, (TypedElement)collectionTemplateExp, residueNode, memberNode);
                this.createOperationSelfEdge(selfNode.getUtility(), selfNode, QVTrelationUtil.getType((TypedElement)collectionExcludingOperation), residueNode);
                this.createOperationParameterEdge(memberNode.getUtility(), memberNode, QVTrelationUtil.getOwnedParameter((Operation)collectionExcludingOperation, (int)0), -1, residueNode);
            }
            Node restNode = (Node)rest.accept((Visitor)this.rootExpressionSynthesizer);
            assert (restNode != null);
            this.createEqualsEdge(Utility.NON_NULL_MATCHED, residueNode, restNode);
        }
        if (rest == null) {
            Operation collectionIsEmptyOperation = this.scheduleManager.getStandardLibraryHelper().getCollectionIsEmptyOperation();
            OperationCallNode isEmptyNode = this.createOperationCallNode(Utility.NON_NULL_MATCHED, null, collectionIsEmptyOperation, (TypedElement)collectionTemplateExp, residueNode);
            this.createPredicatedStepNode(Utility.NON_NULL_MATCHED, (Node)isEmptyNode);
        }
    }

    protected boolean synthesizeNavigationCallEqualsPredicate(@NonNull NavigationCallExp navExpression, @NonNull OCLExpression valueExpression) {
        Node valueNode = (Node)valueExpression.accept((Visitor)this.rootExpressionSynthesizer);
        assert (valueNode != null);
        OCLExpression sourceExpression = QVTbaseUtil.getOwnedSource((CallExp)navExpression);
        Node sourceNode = (Node)sourceExpression.accept((Visitor)this.rootExpressionSynthesizer);
        assert (sourceNode != null);
        Property source2targetProperty = QVTbaseUtil.getReferredProperty((NavigationCallExp)navExpression);
        this.rootExpressionSynthesizer.createNavigationEdge(sourceNode, source2targetProperty, valueNode, false);
        return true;
    }

    public @NonNull OCLExpression synthesizeObjectTemplatePart(@NonNull PropertyTemplateItem propertyTemplateItem) {
        ObjectTemplateExp sourceObjectTemplateExp = QVTrelationUtil.getOwningObjectTemplateExp((PropertyTemplateItem)propertyTemplateItem);
        Variable sourceVariable = QVTrelationUtil.getBindsTo((TemplateExp)sourceObjectTemplateExp);
        Node sourceNode = ((RuleRegion)this.region).getNode((TypedElement)sourceVariable);
        assert (sourceNode != null);
        Property source2targetProperty = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)propertyTemplateItem);
        OCLExpression targetExpression = QVTrelationUtil.getOwnedValue((PropertyTemplateItem)propertyTemplateItem);
        if (targetExpression instanceof CollectionTemplateExp) {
            Variable targetVariable = QVTrelationUtil.getBindsTo((TemplateExp)((CollectionTemplateExp)targetExpression));
            Node targetNode = ((RuleRegion)this.region).getNode((TypedElement)targetVariable);
            if (targetNode != null) {
                boolean isPartial = this.scheduleManager.computeIsPartial(targetNode, source2targetProperty);
                if (this.scheduleManager.isOutputInRule(QVTrelationUtil.getContainingRule((EObject)propertyTemplateItem), (Element)sourceVariable)) {
                    this.rootExpressionSynthesizer.createRealizedNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial);
                } else {
                    this.rootExpressionSynthesizer.createNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial);
                }
            }
        } else {
            Node targetNode = this.rootExpressionSynthesizer.getRequiredExpressionSynthesizer(source2targetProperty.isIsRequired()).synthesize((Visitable)targetExpression);
            boolean isPartial = this.scheduleManager.computeIsPartial(targetNode, source2targetProperty);
            if (this.scheduleManager.isOutputInRule(QVTbaseUtil.getContainingRule((EObject)sourceVariable), (Element)sourceVariable)) {
                this.rootExpressionSynthesizer.createRealizedNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial);
            } else {
                this.rootExpressionSynthesizer.createNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial);
            }
        }
        return targetExpression;
    }

    protected void synthesizeOutgoingWhenInvocations(@NonNull Node traceNode) {
        Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> outgoingWhenInvocation2invocationAnalysis2 = this.outgoingWhenInvocation2invocationAnalysis;
        if (outgoingWhenInvocation2invocationAnalysis2 != null) {
            ArrayList<@Nullable InvocationAnalysis> invocationAnalyses = new ArrayList<InvocationAnalysis>(outgoingWhenInvocation2invocationAnalysis2.values());
            Collections.sort(invocationAnalyses, iNVOCATION_ANALYSIS_COMPARATOR);
            for (InvocationAnalysis invocationAnalysis : invocationAnalyses) {
                assert (invocationAnalysis != null);
                Node invokingNode = invocationAnalysis.synthesizeInvocationNodes(traceNode);
                Map<@NonNull Node, @NonNull InvocationAnalysis> invokingNode2invocationAnalysis2 = this.invokingNode2invocationAnalysis;
                if (invokingNode2invocationAnalysis2 == null) {
                    this.invokingNode2invocationAnalysis = invokingNode2invocationAnalysis2 = new HashMap<Node, InvocationAnalysis>();
                }
                InvocationAnalysis oldInvocationAnalysis = invokingNode2invocationAnalysis2.put(invokingNode, invocationAnalysis);
                assert (oldInvocationAnalysis == null);
            }
        }
    }

    protected void synthesizeOutgoingWhereInvocations(@NonNull Node traceNode) {
        Map<@NonNull RelationCallExp, @Nullable InvocationAnalysis> outgoingWhereInvocation2invocationAnalysis2 = this.outgoingWhereInvocation2invocationAnalysis;
        if (outgoingWhereInvocation2invocationAnalysis2 != null) {
            ArrayList<@Nullable InvocationAnalysis> invocationAnalyses = new ArrayList<InvocationAnalysis>(outgoingWhereInvocation2invocationAnalysis2.values());
            Collections.sort(invocationAnalyses, iNVOCATION_ANALYSIS_COMPARATOR);
            for (InvocationAnalysis invocationAnalysis : invocationAnalyses) {
                assert (invocationAnalysis != null);
                invocationAnalysis.synthesizeInvocationNodes(traceNode);
            }
        }
    }

    protected void synthesizeOutputCollectionTemplate(@NonNull CollectionTemplateExp collectionTemplateExp) {
        EObject eContainer = collectionTemplateExp.eContainer();
        if (eContainer instanceof PropertyTemplateItem) {
            PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)eContainer;
            Property source2target = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)propertyTemplateItem);
            ObjectTemplateExp objectTemplateExp = QVTrelationUtil.getOwningObjectTemplateExp((PropertyTemplateItem)propertyTemplateItem);
            Node sourceNode = (Node)objectTemplateExp.accept((Visitor)this.rootExpressionSynthesizer);
            assert (sourceNode != null);
            for (OCLExpression member : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)collectionTemplateExp)) {
                Node memberNode = (Node)member.accept((Visitor)this.rootExpressionSynthesizer);
                assert (memberNode != null);
                this.rootExpressionSynthesizer.createRealizedNavigationEdge(sourceNode, source2target, memberNode, true);
            }
        } else {
            Node collectionNode = (Node)collectionTemplateExp.accept((Visitor)this.rootExpressionSynthesizer);
            assert (collectionNode != null);
            for (OCLExpression member : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)collectionTemplateExp)) {
                Node memberNode = (Node)member.accept((Visitor)this.rootExpressionSynthesizer);
                assert (memberNode != null);
                this.createRealizedIncludesEdge(memberNode.getUtility(), collectionNode, memberNode);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void synthesizeOverridingGuards(@Nullable Node dispatchNode, @NonNull Node traceNode) {
        Relation relation = this.getRule();
        QVTrelationDirectedScheduleManager scheduleManager2 = this.getScheduleManager();
        TypedModel traceTypedModel = scheduleManager2.getTraceTypedModel();
        @NonNull Iterable overridingRelations = QVTrelationUtil.getOverrides((Relation)relation);
        if (!Iterables.isEmpty((Iterable)overridingRelations)) {
            for (Relation overridingRelation : overridingRelations) {
                RelationAnalysis overridingRelationAnalysis = scheduleManager2.getRuleAnalysis((Rule)overridingRelation);
                RelationAnalysis overriddenRelationAnalysis = overridingRelationAnalysis.getBaseRelationAnalysis();
                boolean isWhere = overriddenRelationAnalysis.hasIncomingWhereInvocations();
                Relation2TraceGroup overridingrelation2traceGroup = overridingRelationAnalysis.getRule2TraceGroup();
                Relation2MiddleType overridingRelation2TraceInterface = overridingrelation2traceGroup.getRule2TraceInterface();
                Relation2TraceClass overridingRelation2TraceClass = overridingrelation2traceGroup.getRule2TraceClass();
                ClassDatum overridingClassDatum = scheduleManager2.getClassDatum(traceTypedModel, (Type)overridingRelation2TraceInterface.getMiddleClass());
                Node guardNode = this.createPredicatedNode(Utility.NON_NULL_MATCHED, "not_" + overridingRelation.getName(), overridingClassDatum);
                Property globalSuccessProperty = overridingRelation2TraceClass.getGlobalSuccessProperty();
                this.createPredicatedSuccess(Utility.NON_NULL_MATCHED, guardNode, globalSuccessProperty, false);
                if (dispatchNode != null) {
                    Relation2DispatchClass relation2dispatchClass = overriddenRelationAnalysis.getRule2TraceGroup().getRule2DispatchClass();
                    DispatchClass2TraceProperty dispatchClass2TraceProperty = relation2dispatchClass.getDispatchClass2TraceProperty(overridingRelation);
                    Property guardProperty = dispatchClass2TraceProperty.getTraceProperty();
                    this.createNavigationEdge(Utility.NON_NULL_MATCHED, dispatchNode, guardProperty, guardNode, false);
                }
                if (!isWhere) continue;
                for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((Relation)relation)) {
                    Node rootVariableNode = this.getReferenceNode(rootVariable);
                    VariableDeclaration overridingRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)overridingRelation, (VariableDeclaration)rootVariable);
                    Property invocationProperty = overridingRelation2TraceInterface.getTraceProperty(overridingRootVariable);
                    boolean isPartial = this.scheduleManager.computeIsPartial(rootVariableNode, invocationProperty);
                    this.createNavigationEdge(rootVariableNode.getUtility(), guardNode, invocationProperty, rootVariableNode, isPartial);
                }
            }
        }
    }

    protected void synthesizePredicate(@NonNull OCLExpression predicateExpression) {
        QVTrelationDirectedScheduleManager scheduleManager = this.getScheduleManager();
        Domain asDomain = QVTrelationUtil.basicGetContainingDomain((EObject)predicateExpression);
        if (asDomain != null && scheduleManager.isOutputInRule(QVTrelationUtil.getContainingRule((EObject)asDomain), (Element)asDomain)) {
            return;
        }
        if (this.synthesizeEqualsPredicate(predicateExpression)) {
            return;
        }
        Node resultNode = (Node)predicateExpression.accept((Visitor)this.rootExpressionSynthesizer.getExpressionSynthesizer(Utility.NON_NULL_MATCHED));
        if (resultNode != null && !(resultNode instanceof BooleanLiteralNode)) {
            BooleanLiteralNode trueNode = this.createBooleanLiteralNode(resultNode.getUtility(), true);
            this.createPredicateEdge(resultNode.getUtility(), resultNode, (Node)trueNode, false);
        }
    }

    protected boolean synthesizeSingleInputCollectionTemplate(@NonNull CollectionTemplateExp collectionTemplateExp) {
        Variable rest = collectionTemplateExp.getRest();
        if (rest == null || !rest.isIsImplicit()) {
            return false;
        }
        EList members = collectionTemplateExp.getMember();
        if (members.size() > 1) {
            return false;
        }
        EObject eContainer = collectionTemplateExp.eContainer();
        if (!(eContainer instanceof PropertyTemplateItem)) {
            return false;
        }
        PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)eContainer;
        Property source2target = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)propertyTemplateItem);
        ObjectTemplateExp objectTemplateExp = QVTrelationUtil.getOwningObjectTemplateExp((PropertyTemplateItem)propertyTemplateItem);
        Node sourceNode = (Node)objectTemplateExp.accept((Visitor)this.rootExpressionSynthesizer);
        assert (sourceNode != null);
        Node memberNode = (Node)((OCLExpression)members.get(0)).accept((Visitor)this.rootExpressionSynthesizer);
        assert (memberNode != null);
        this.rootExpressionSynthesizer.createNavigationEdge(sourceNode, source2target, memberNode, true);
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void synthesizeTraceEdges(@NonNull Node traceNode, @Nullable Node dispatchNode) {
        Relation relation = this.getRule();
        if (dispatchNode != null) {
            Relation2TraceGroup baseRelation2traceGroup = this.getRule2TraceGroup().getBaseRelation2TraceGroup();
            Relation2DispatchClass rule2dispatchClass = baseRelation2traceGroup.getRule2DispatchClass();
            Relation baseRelation = baseRelation2traceGroup.getRule();
            for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)relation)) {
                Boolean isInput = this.getScheduleManager().isInputInRule((Rule)relation, (Element)relationDomain) || this.hasIncomingWhereInvocations();
                for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((RelationDomain)relationDomain)) {
                    VariableDeclaration baseRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)baseRelation, (VariableDeclaration)rootVariable);
                    VariableDeclaration2TraceProperty overriddenVariableDeclaration2traceProperty = rule2dispatchClass.getVariableDeclaration2TraceProperty(baseRootVariable);
                    Property traceProperty = overriddenVariableDeclaration2traceProperty.getTraceProperty();
                    Node targetNode = ((RuleRegion)this.region).getNode((TypedElement)rootVariable);
                    assert (targetNode != null);
                    boolean isPartial = this.scheduleManager.computeIsPartial(dispatchNode, traceProperty);
                    if (isInput.booleanValue()) {
                        this.createNavigationEdge(targetNode.getUtility(), dispatchNode, traceProperty, targetNode, isPartial);
                        continue;
                    }
                    this.createRealizedNavigationEdge(targetNode.getUtility(), dispatchNode, traceProperty, targetNode, isPartial);
                }
            }
            boolean hasPredicatedTrace = traceNode.isPredicated();
            assert (hasPredicatedTrace);
            @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)relation);
            Relation2TraceClass rule2traceClass = this.getRule2TraceGroup().getRule2TraceClass();
            for (VariableDeclaration2TraceProperty variableDeclaration2traceProperty : rule2traceClass.getVariableDeclaration2TraceProperties()) {
                Property traceProperty = variableDeclaration2traceProperty.getTraceProperty();
                VariableDeclaration tracedVariable = variableDeclaration2traceProperty.getOverridingVariable();
                Node targetNode = ((RuleRegion)this.region).getNode((TypedElement)tracedVariable);
                assert (targetNode != null);
                if (rootVariables.contains(tracedVariable)) continue;
                boolean isPartial = this.scheduleManager.computeIsPartial(targetNode, traceProperty);
                this.createRealizedNavigationEdge(targetNode.getUtility(), traceNode, traceProperty, targetNode, isPartial);
            }
        } else {
            boolean hasPredicatedTrace = traceNode.isPredicated();
            @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)relation);
            Iterable variableDeclaration2TraceProperties = null;
            if (!QVTrelationUtil.isAbstract((Relation)relation)) {
                Relation2TraceClass rule2traceClass = this.getRule2TraceGroup().getRule2TraceClass();
                variableDeclaration2TraceProperties = rule2traceClass.getVariableDeclaration2TraceProperties();
            } else {
                Relation2DispatchClass rule2dispatchClass = this.getRule2TraceGroup().getRule2DispatchClass();
                variableDeclaration2TraceProperties = rule2dispatchClass.getVariableDeclaration2TraceProperties();
            }
            for (VariableDeclaration2TraceProperty variableDeclaration2traceProperty : variableDeclaration2TraceProperties) {
                Property traceProperty = variableDeclaration2traceProperty.getTraceProperty();
                VariableDeclaration tracedVariable = variableDeclaration2traceProperty.getOverridingVariable();
                Node targetNode = ((RuleRegion)this.region).getNode((TypedElement)tracedVariable);
                assert (targetNode != null);
                boolean isPartial = this.scheduleManager.computeIsPartial(traceNode, traceProperty);
                if (hasPredicatedTrace && rootVariables.contains(tracedVariable)) {
                    this.createNavigationEdge(Utility.getRequiredUtility((TypedElement)traceProperty), traceNode, traceProperty, targetNode, isPartial);
                    continue;
                }
                this.createRealizedNavigationEdge(Utility.getRequiredUtility((TypedElement)traceProperty), traceNode, traceProperty, targetNode, isPartial);
            }
        }
    }

    public void synthesizeTraceElements(@NonNull Relation2TraceGroup relation2traceGroup) {
        Relation relation;
        if (this.dispatchAnalysis != null) {
            this.dispatchAnalysis.synthesizeElements();
        }
        if (this.verdictAnalysis != null) {
            this.verdictAnalysis.synthesizeElements();
        }
        if (!(relation = this.getRule()).isIsAbstract()) {
            Relation2TraceClass rule2traceClass = relation2traceGroup.getRule2TraceClass();
            Variable traceVariable = QVTrelationUtil.getTraceVariable((Relation)relation);
            traceVariable.setType((Type)rule2traceClass.getMiddleClass());
            Node traceNode = this.synthesizeTraceNode();
            Node dispatchNode = QVTrelationUtil.hasOverrides((Relation)relation) ? this.synthesizeDispatchNode(traceNode) : null;
            this.synthesizeTraceEdges(traceNode, dispatchNode);
            this.synthesizeOutgoingWhenInvocations(traceNode);
            this.synthesizeOutgoingWhereInvocations(traceNode);
            this.synthesizeOverridingGuards(dispatchNode, traceNode);
            this.synthesizeTraceGlobalSuccessAssignment(relation2traceGroup, traceNode);
            this.synthesizeInterfaceAssignments(relation2traceGroup, traceNode);
        } else if (!relation.isIsTopLevel()) {
            Relation2MiddleType rule2traceInterface = relation2traceGroup.getRule2TraceInterface();
            Variable traceVariable = QVTrelationUtil.getTraceVariable((Relation)relation);
            traceVariable.setType((Type)rule2traceInterface.getMiddleClass());
            Node traceNode = this.synthesizeTraceNode();
            this.synthesizeTraceEdges(traceNode, null);
        }
    }

    protected void synthesizeTraceGlobalSuccessAssignment(@NonNull Relation2TraceGroup relation2traceGroup, @NonNull Node traceNode) {
        Element2MiddleProperty relation2globalSuccessProperty = relation2traceGroup.basicGetRelation2GlobalSuccessProperty();
        if (relation2globalSuccessProperty != null) {
            this.createRealizedSuccess(Utility.NON_NULL_MATCHED, traceNode, relation2globalSuccessProperty.getTraceProperty(), null);
        }
    }

    protected @NonNull Node synthesizeTraceNode() {
        VariableNode traceNode;
        Relation relation = this.getRule();
        Variable traceVariable = QVTrelationUtil.getTraceVariable((Relation)relation);
        boolean hasOverrides = QVTrelationUtil.hasOverrides((Relation)relation);
        if (hasOverrides) {
            traceNode = this.createOldNode(Utility.TRACE, (VariableDeclaration)traceVariable);
        } else if (!relation.isIsTopLevel()) {
            traceNode = this.createOldNode(Utility.TRACE, (VariableDeclaration)traceVariable);
            ((RuleRegion)this.region).getHeadNodes().clear();
            ((RuleRegion)this.region).getHeadNodes().add(traceNode);
            traceNode.setHead();
            if (this.thisNode != null) {
                ((RuleRegion)this.region).getHeadNodes().add(this.thisNode);
            }
        } else {
            boolean hasPredicatedTrace = this.incomingWhereInvocation2invocationAnalysis != null && !hasOverrides;
            VariableNode variableNode = traceNode = hasPredicatedTrace ? this.createOldNode(Utility.TRACE, (VariableDeclaration)traceVariable) : this.createRealizedStepNode(Utility.TRACE, (VariableDeclaration)traceVariable);
            if (!this.getRule().isIsTopLevel()) {
                ((RuleRegion)this.region).getHeadNodes().clear();
            }
        }
        return traceNode;
    }

    public void synthesizeVariableDeclaration(@NonNull VariableDeclaration variableDeclaration) {
        TemplateExp templateExp = this.basicGetTemplateExp(variableDeclaration);
        if (QVTrelationUtil.isTraceClassVariable((VariableDeclaration)variableDeclaration)) {
            return;
        }
        if (variableDeclaration instanceof Variable && ((Variable)variableDeclaration).isIsImplicit() && templateExp == null) {
            return;
        }
        if (this.getKeyedOutputVariables().contains(variableDeclaration)) {
            this.createKeyedNode(Utility.NON_NULL_MATCHED, QVTrelationUtil.getName((NamedElement)variableDeclaration), variableDeclaration);
        } else if (this.getTopWhenedOutputVariables().contains(variableDeclaration)) {
            this.createOldNode(Utility.getRequiredUtility((TypedElement)variableDeclaration), variableDeclaration);
        } else if (this.getNonTopWhenedOutputVariables().contains(variableDeclaration)) {
            this.createOldNode(Utility.getRequiredUtility((TypedElement)variableDeclaration), variableDeclaration);
        } else if (this.hasIncomingWhereInvocations() && Iterables.contains((Iterable)QVTrelationUtil.getRootVariables((Relation)this.getRule()), (Object)variableDeclaration)) {
            this.createOldNode(Utility.getRequiredUtility((TypedElement)variableDeclaration), variableDeclaration);
        } else if (this.getRealizedOutputVariables().contains(variableDeclaration)) {
            Utility utility = this.getOptionalMatchAtRootUtility(variableDeclaration);
            this.createRealizedStepNode(utility, variableDeclaration);
        } else if (variableDeclaration instanceof TemplateVariable) {
            assert (templateExp != null);
            if (templateExp instanceof CollectionTemplateExp) {
                return;
            }
            Utility utility = this.getOptionalMatchAtRootUtility(variableDeclaration);
            this.createOldNode(utility, variableDeclaration);
        } else if (variableDeclaration instanceof SharedVariable) {
            SharedVariable sharedVariable = (SharedVariable)variableDeclaration;
            sharedVariable.getOwnedInit();
        } else {
            Utility utility = this.getOptionalMatchAtRootUtility(variableDeclaration);
            this.createOldNode(utility, variableDeclaration);
        }
    }

    protected boolean synthesizeVariableEqualsPredicate(@NonNull VariableDeclaration variable, @NonNull OCLExpression valueExp) {
        Node variableNode = ((RuleRegion)this.region).getNode((TypedElement)variable);
        if (variableNode == null) {
            if (variable instanceof SharedVariable) {
                variableNode = this.getReferenceNodeForSharedVariable((SharedVariable)variable, valueExp);
            }
            if (variableNode != null) {
                return true;
            }
        }
        variableNode = (Node)variable.accept((Visitor)this.rootExpressionSynthesizer);
        Node expressionNode = (Node)valueExp.accept((Visitor)this.rootExpressionSynthesizer);
        assert (variableNode != null && expressionNode != null);
        this.createEqualsEdge(Utility.NON_NULL_MATCHED, expressionNode, variableNode);
        return true;
    }

    public static class InvocationAnalysisComparator
    implements Comparator<InvocationAnalysis> {
        @Override
        public int compare(@Nullable InvocationAnalysis o1, @Nullable InvocationAnalysis o2) {
            String n2;
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            String n1 = o1.getInvokedRelationAnalysis().getName();
            int diff = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)(n2 = o2.getInvokedRelationAnalysis().getName())));
            if (diff != 0) {
                return diff;
            }
            return 0;
        }
    }
}

