/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.wizards.types.Messages;
import org.eclipse.php.internal.ui.wizards.types.NewPHPElementData;
import org.eclipse.php.internal.ui.wizards.types.NewPHPInterfacePage;
import org.eclipse.php.internal.ui.wizards.types.NewPHPTypePage;
import org.eclipse.php.internal.ui.wizards.types.NewPHPTypeWizard;
import org.eclipse.php.internal.ui.wizards.types.PHPElementTemplate;
import org.eclipse.php.internal.ui.wizards.types.PHPInterfaceTemplate;
import org.eclipse.ui.INewWizard;

public class NewPHPInterfaceWizard
extends NewPHPTypeWizard
implements INewWizard {
    public NewPHPInterfaceWizard() {
        this.setWindowTitle(Messages.NewPHPInterfaceWizard_0);
        this.setDefaultPageImageDescriptor(PHPUiPlugin.getImageDescriptor("icons/full/wizban/newint_wiz.png"));
        this.setNeedsProgressMonitor(true);
    }

    public NewPHPInterfaceWizard(NewPHPTypePage page) {
        this();
        this.page = page;
        this.addPage((IWizardPage)page);
    }

    public void addPages() {
        if (this.page == null) {
            this.page = new NewPHPInterfacePage();
            this.addPage((IWizardPage)this.page);
            this.page.init(this.getSelection());
        }
    }

    public boolean performFinish() {
        String contents;
        if (this.page.isInExistingPHPFile()) {
            this.existingPHPFile = DLTKCore.createSourceModuleFrom((IFile)this.page.getExistingFile());
        }
        InterfacePostFinishValidator validator = new InterfacePostFinishValidator();
        ((NewPHPTypeWizard.PostFinishValidator)validator).packAndValidate();
        String containerName = this.page.getSourceText();
        String fileName = this.page.getNewFileName();
        PHPInterfaceTemplate templateEngine = new PHPInterfaceTemplate();
        try {
            templateEngine.resolveTemplate();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        NewPHPElementData data = this.populatePHPElementData();
        this.compilationResult = contents = ((PHPElementTemplate)templateEngine).processTemplate(data);
        if (!this.page.isInExistingPHPFile()) {
            this.createNewPHPFile(containerName, fileName, contents);
        } else {
            this.injectCodeIntoExistingFile();
        }
        if (validator.hasWarnings()) {
            this.getShell().getDisplay().asyncExec(() -> this.showWarningsDialog(validator.getWarnings()));
        }
        this.page.saveGeneratedGroupValues();
        return true;
    }

    private NewPHPElementData populatePHPElementData() {
        NewPHPInterfacePage page = (NewPHPInterfacePage)this.page;
        NewPHPElementData data = new NewPHPElementData();
        data.isGeneratePHPDoc = page.isCheckboxCreationChecked("PHPDoc Blocks");
        List<IType> interfacesList = page.getInterfaces();
        IType[] interfaces = new IType[interfacesList.size()];
        interfacesList.toArray(interfaces);
        data.interfaces = interfaces;
        data.className = page.getElementName();
        data.namespace = page.getNamespace();
        List<String> existingImports = this.getExistingImports();
        data.existingImports = existingImports.toArray(new String[0]);
        ArrayList<String> imports = new ArrayList<String>();
        IType[] iTypeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            this.addImport(imports, type, existingImports);
            ++n2;
        }
        data.imports = imports.toArray(new String[0]);
        data.isExistingFile = page.isInExistingPHPFile();
        if (data.isExistingFile) {
            data.isInFirstBlock = page.isInFirstPHPBlock();
            data.hasFirstBlock = true;
        }
        data.isExistingFile = page.isInExistingPHPFile();
        data.requiredToAdd = this.getRequires();
        return data;
    }

    class InterfacePostFinishValidator
    extends NewPHPTypeWizard.PostFinishValidator {
        InterfacePostFinishValidator() {
            super(NewPHPInterfaceWizard.this);
        }

        @Override
        public void packAndValidate() {
            super.packAndValidate();
            this.handleInterfaces();
        }

        private void handleInterfaces() {
            for (IType currentInterface : NewPHPInterfaceWizard.this.page.getInterfaces()) {
                if (currentInterface == null) continue;
                NewPHPInterfaceWizard.this.extractReqruiresInclude(currentInterface);
            }
        }
    }
}

